/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import ucar.nc2.constants.CF;

public enum GribStatType {
    Average,
    Accumulation,
    Maximum,
    Minimum,
    DifferenceFromEnd,
    RootMeanSquare,
    StandardDeviation,
    Covariance,
    DifferenceFromStart,
    Ratio,
    Variance;


    public static GribStatType getStatTypeFromGrib2(int grib2StatCode) {
        switch (grib2StatCode) {
            case 0: {
                return Average;
            }
            case 1: {
                return Accumulation;
            }
            case 2: {
                return Maximum;
            }
            case 3: {
                return Minimum;
            }
            case 4: {
                return DifferenceFromEnd;
            }
            case 5: {
                return RootMeanSquare;
            }
            case 6: {
                return StandardDeviation;
            }
            case 7: {
                return Covariance;
            }
            case 8: {
                return DifferenceFromStart;
            }
            case 9: {
                return Ratio;
            }
        }
        return null;
    }

    public static int getStatTypeNumber(String name) {
        if (name.startsWith("Average")) {
            return 0;
        }
        if (name.startsWith("Accumulation")) {
            return 1;
        }
        if (name.startsWith("Maximum")) {
            return 2;
        }
        if (name.startsWith("Minimum")) {
            return 3;
        }
        if (name.startsWith("Difference (Value at the end")) {
            return 4;
        }
        if (name.startsWith("Root")) {
            return 5;
        }
        if (name.startsWith("Standard")) {
            return 6;
        }
        if (name.startsWith("Covariance")) {
            return 7;
        }
        if (name.startsWith("Difference (Value at the start")) {
            return 8;
        }
        if (name.startsWith("Ratio")) {
            return 9;
        }
        if (name.startsWith("Variance")) {
            return 10;
        }
        return -1;
    }

    public static CF.CellMethods getCFCellMethod(GribStatType stat) {
        switch (stat) {
            case Average: {
                return CF.CellMethods.mean;
            }
            case Accumulation: {
                return CF.CellMethods.sum;
            }
            case Covariance: {
                return CF.CellMethods.variance;
            }
            case Minimum: {
                return CF.CellMethods.minimum;
            }
            case Maximum: {
                return CF.CellMethods.maximum;
            }
            case StandardDeviation: {
                return CF.CellMethods.standard_deviation;
            }
            case Variance: {
                return CF.CellMethods.variance;
            }
        }
        return null;
    }
}

