/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.http.HTTPRandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class Grib2Iosp
extends GribIosp {
    private static final Logger logger = LoggerFactory.getLogger(Grib2Iosp.class);
    private Grib2Customizer cust;

    public static String makeVariableNameFromTable(Grib2Customizer tables, GribCollectionImmutable gribCollection, GribCollectionImmutable.VariableIndex vindex, boolean useGenType) {
        String statName;
        String intvName;
        String s;
        Formatter f = new Formatter();
        GribTables.Parameter param = tables.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
        if (param == null) {
            f.format("VAR%d-%d-%d_FROM_%d-%d-%d", vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter(), gribCollection.getCenter(), gribCollection.getSubcenter(), vindex.getTableVersion());
        } else {
            f.format("%s", GribUtils.makeNameFromDescription(param.getName()));
        }
        if (vindex.getGenProcessType() == 6 || vindex.getGenProcessType() == 7) {
            f.format("_error", new Object[0]);
        } else if (useGenType && vindex.getGenProcessType() >= 0) {
            String genType = tables.getGeneratingProcessTypeName(vindex.getGenProcessType());
            s = StringUtil2.substitute((String)genType, (String)" ", (String)"_");
            f.format("_%s", s);
        }
        if (vindex.getLevelType() != -9999) {
            f.format("_%s", tables.getLevelNameShort(vindex.getLevelType()));
            if (vindex.isLayer()) {
                f.format("_layer", new Object[0]);
            }
        }
        if ((intvName = vindex.getIntvName()) != null && !intvName.isEmpty()) {
            f.format("_%s", intvName);
        }
        if (vindex.getIntvType() >= 0 && (statName = tables.getStatisticNameShort(vindex.getIntvType())) != null) {
            f.format("_%s", statName);
        }
        if (vindex.getEnsDerivedType() >= 0) {
            f.format("_%s", tables.getProbabilityNameShort(vindex.getEnsDerivedType()));
        } else if (vindex.getProbabilityName() != null && vindex.getProbabilityName().length() > 0) {
            s = StringUtil2.substitute((String)vindex.getProbabilityName(), (String)".", (String)"p");
            f.format("_probability_%s", s);
        } else if (vindex.isEnsemble()) {
            f.format("_ens", new Object[0]);
        }
        return f.toString();
    }

    public static String makeVariableLongName(Grib2Customizer cust, GribCollectionImmutable.VariableIndex vindex, boolean useGenType) {
        GribTables.Parameter gp;
        boolean isProb;
        Formatter f = new Formatter();
        boolean bl = isProb = vindex.getProbabilityName() != null && vindex.getProbabilityName().length() > 0;
        if (isProb) {
            f.format("Probability ", new Object[0]);
        }
        if ((gp = cust.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter())) == null) {
            f.format("Unknown Parameter %d-%d-%d", vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
        } else {
            f.format("%s", gp.getName());
        }
        if (vindex.getIntvType() >= 0 && vindex.getIntvName() != null && !vindex.getIntvName().isEmpty()) {
            String intvName = cust.getStatisticNameShort(vindex.getIntvType());
            if (intvName == null || intvName.equalsIgnoreCase("Missing")) {
                intvName = cust.getStatisticNameShort(vindex.getIntvType());
            }
            if (intvName == null) {
                f.format(" (%s)", vindex.getIntvName());
            } else {
                f.format(" (%s %s)", vindex.getIntvName(), intvName);
            }
        } else if (vindex.getIntvType() >= 0) {
            String intvName = cust.getStatisticNameShort(vindex.getIntvType());
            f.format(" (%s)", intvName);
        }
        if (vindex.getEnsDerivedType() >= 0) {
            f.format(" (%s)", cust.getTableValue("4.7", vindex.getEnsDerivedType()));
        } else if (isProb) {
            f.format(" %s %s", vindex.getProbabilityName(), Grib2Iosp.getVindexUnits(cust, vindex));
        }
        if (vindex.getGenProcessType() == 6 || vindex.getGenProcessType() == 7) {
            f.format(" error", new Object[0]);
        } else if (useGenType && vindex.getGenProcessType() >= 0) {
            f.format(" %s", cust.getGeneratingProcessTypeName(vindex.getGenProcessType()));
        }
        if (vindex.getLevelType() != -9999) {
            f.format(" @ %s", cust.getTableValue("4.5", vindex.getLevelType()));
            if (vindex.isLayer()) {
                f.format(" layer", new Object[0]);
            }
        }
        return f.toString();
    }

    @Override
    protected String makeVariableNameFromRecord(GribCollectionImmutable.VariableIndex vindex) {
        String intvName;
        Formatter f = new Formatter();
        f.format("VAR_%d-%d-%d", vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
        if (vindex.getGenProcessType() == 6 || vindex.getGenProcessType() == 7) {
            f.format("_error", new Object[0]);
        }
        if (vindex.getLevelType() != -9999) {
            f.format("_L%d", vindex.getLevelType());
            if (vindex.isLayer()) {
                f.format("_layer", new Object[0]);
            }
        }
        if ((intvName = vindex.getIntvName()) != null && !intvName.isEmpty()) {
            if (intvName.equals("Mixed_intervals")) {
                f.format("_Imixed", new Object[0]);
            } else {
                f.format("_I%s", intvName);
            }
        }
        if (vindex.getIntvType() >= 0) {
            f.format("_S%s", vindex.getIntvType());
        }
        if (vindex.getEnsDerivedType() >= 0) {
            f.format("_D%d", vindex.getEnsDerivedType());
        } else if (vindex.getProbabilityName() != null && vindex.getProbabilityName().length() > 0) {
            String s = StringUtil2.substitute((String)vindex.getProbabilityName(), (String)".", (String)"p");
            f.format("_Prob_%s", s);
        }
        return f.toString();
    }

    @Override
    protected String makeVariableName(GribCollectionImmutable.VariableIndex vindex) {
        return Grib2Iosp.makeVariableNameFromTable(this.cust, this.gribCollection, vindex, this.gribCollection.config.gribConfig.useGenType);
    }

    @Override
    protected String makeVariableLongName(GribCollectionImmutable.VariableIndex vindex) {
        return Grib2Iosp.makeVariableLongName(this.cust, vindex, this.gribCollection.config.gribConfig.useGenType);
    }

    @Override
    protected String makeVariableUnits(GribCollectionImmutable.VariableIndex vindex) {
        return Grib2Iosp.makeVariableUnits(this.cust, vindex);
    }

    public static String makeVariableUnits(Grib2Customizer tables, GribCollectionImmutable.VariableIndex vindex) {
        if (vindex.getProbabilityName() != null && vindex.getProbabilityName().length() > 0) {
            return "%";
        }
        return Grib2Iosp.getVindexUnits(tables, vindex);
    }

    private static String getVindexUnits(Grib2Customizer tables, GribCollectionImmutable.VariableIndex vindex) {
        GribTables.Parameter gp = tables.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
        String val = gp == null ? "" : gp.getUnit();
        return val == null ? "" : val;
    }

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        if (raf instanceof HTTPRandomAccessFile) {
            if (raf.length() > (long)raf.getBufferSize()) {
                return false;
            }
        } else {
            GribCdmIndex.GribCollectionType type = GribCdmIndex.getType(raf);
            if (type == GribCdmIndex.GribCollectionType.GRIB2) {
                return true;
            }
            if (type == GribCdmIndex.GribCollectionType.Partition2) {
                return true;
            }
        }
        return Grib2RecordScanner.isValidFile(raf);
    }

    public String getFileTypeId() {
        return DataFormatType.GRIB2.getDescription();
    }

    public String getFileTypeDescription() {
        return "GRIB2 Collection";
    }

    public Grib2Iosp() {
        super(false, logger);
    }

    public Grib2Iosp(GribCollectionImmutable.GroupGC gHcs, GribCollectionImmutable.Type gtype) {
        super(false, logger);
        this.gHcs = gHcs;
        this.owned = true;
        this.gtype = gtype;
    }

    public Grib2Iosp(GribCollectionImmutable gc) {
        super(false, logger);
        this.gribCollection = gc;
        this.owned = true;
    }

    @Override
    protected GribTables createCustomizer() {
        this.cust = Grib2Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal(), this.gribCollection.getGenProcessId());
        return this.cust;
    }

    @Override
    protected String getVerticalCoordDesc(int vc_code) {
        return this.cust.getTableValue("4.5", vc_code);
    }

    @Override
    protected GribTables.Parameter getParameter(GribCollectionImmutable.VariableIndex vindex) {
        return this.cust.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
    }

    @Override
    protected void addVariableAttributes(Variable v, GribCollectionImmutable.VariableIndex vindex) {
        String ldesc;
        GribTables.Parameter entry;
        String cat;
        v.addAttribute(new Attribute("Grib_Variable_Id", this.makeVariableNameFromRecord(vindex)));
        int[] param = new int[]{vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter()};
        v.addAttribute(new Attribute("Grib2_Parameter", Array.factory((Object)param)));
        String disc = this.cust.getTableValue("0.0", vindex.getDiscipline());
        if (disc != null) {
            v.addAttribute(new Attribute("Grib2_Parameter_Discipline", disc));
        }
        if ((cat = this.cust.getCategory(vindex.getDiscipline(), vindex.getCategory())) != null) {
            v.addAttribute(new Attribute("Grib2_Parameter_Category", cat));
        }
        if ((entry = this.cust.getParameter(vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter())) != null) {
            v.addAttribute(new Attribute("Grib2_Parameter_Name", entry.getName()));
        }
        if (vindex.getLevelType() != 255) {
            v.addAttribute(new Attribute("Grib2_Level_Type", (Number)vindex.getLevelType()));
        }
        if ((ldesc = this.cust.getLevelName(vindex.getLevelType())) != null) {
            v.addAttribute(new Attribute("Grib2_Level_Desc", ldesc));
        }
        if (vindex.getEnsDerivedType() >= 0) {
            v.addAttribute(new Attribute("Grib2_Ensemble_Derived_Type", (Number)vindex.getEnsDerivedType()));
        } else if (vindex.getProbabilityName() != null && vindex.getProbabilityName().length() > 0) {
            v.addAttribute(new Attribute("Grib2_Probability_Type", (Number)vindex.getProbType()));
            v.addAttribute(new Attribute("Grib2_Probability_Name", vindex.getProbabilityName()));
        }
        if (vindex.getGenProcessType() >= 0) {
            String genProcessTypeName = this.cust.getGeneratingProcessTypeName(vindex.getGenProcessType());
            if (genProcessTypeName != null) {
                v.addAttribute(new Attribute("Grib2_Generating_Process_Type", genProcessTypeName));
            } else {
                v.addAttribute(new Attribute("Grib2_Generating_Process_Type", (Number)vindex.getGenProcessType()));
            }
        }
    }

    @Override
    protected void show(RandomAccessFile rafData, long pos) throws IOException {
        Grib2Record gr = Grib2RecordScanner.findRecordByDrspos(rafData, pos);
        if (gr != null) {
            Formatter f = new Formatter();
            f.format("File=%s%n", rafData.getLocation());
            f.format("  Parameter=%s%n", this.cust.getVariableName(gr));
            f.format("  ReferenceDate=%s%n", gr.getReferenceDate());
            f.format("  ForecastDate=%s%n", this.cust.getForecastDate(gr));
            TimeCoord.TinvDate tinv = this.cust.getForecastTimeInterval(gr);
            if (tinv != null) {
                f.format("  TimeInterval=%s%n", tinv);
            }
            f.format("  ", new Object[0]);
            gr.getPDS().show(f);
            System.out.printf("%nGrib2Record.readData at drsPos %d = %s%n", pos, f.toString());
        }
    }

    @Override
    protected float[] readData(RandomAccessFile rafData, GribIosp.DataRecord dr) throws IOException {
        GdsHorizCoordSys hcs = dr.hcs;
        int scanMode = dr.scanMode == 9999 ? hcs.scanMode : dr.scanMode;
        return Grib2Record.readData(rafData, dr.dataPos, dr.bmsPos, hcs.gdsNumberPoints, scanMode, hcs.nxRaw, hcs.nyRaw, hcs.nptsInLine);
    }

    @Override
    public Object getLastRecordRead() {
        return Grib2Record.lastRecordRead;
    }

    @Override
    public void clearLastRecordRead() {
        Grib2Record.lastRecordRead = null;
    }

    @Override
    public Object getGribCustomizer() {
        return this.cust;
    }
}

