/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.QuasiRegular;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthEllipsoid;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.proj4.LambertConformalConicEllipse;
import ucar.unidata.geoloc.projection.proj4.StereographicAzimuthalProjection;

public abstract class Grib1Gds {
    private static final Logger log = LoggerFactory.getLogger(Grib1Gds.class);
    public static final double maxReletiveErrorPos = 0.01;
    private static final float scale3 = 0.001f;
    protected final byte[] data;
    protected int[] nptsInLine;
    public int template;
    protected int nx;
    protected int ny;
    public int scanMode;
    public int resolution;
    protected int lastOctet;
    protected int hashCode = 0;

    public static Grib1Gds factory(int template, byte[] data) {
        switch (template) {
            case 0: {
                return new LatLon(data, 0);
            }
            case 1: {
                return new Mercator(data, 1);
            }
            case 3: {
                return new LambertConformal(data, 3);
            }
            case 4: {
                return new GaussianLatLon(data, 4);
            }
            case 5: {
                return new PolarStereographic(data, 5);
            }
            case 10: {
                return new RotatedLatLon(data, 10);
            }
            case 50: {
                return new SphericalHarmonicCoefficients(data, 50);
            }
        }
        throw new UnsupportedOperationException("Unsupported GDS type = " + template);
    }

    protected Grib1Gds(int template) {
        this.template = template;
        this.data = null;
    }

    public Grib1Gds(byte[] data, int template) {
        this.data = data;
        this.template = template;
        this.nx = this.getOctet2(7);
        this.ny = this.getOctet2(9);
    }

    public byte[] getRawBytes() {
        return this.data;
    }

    public int getNpts() {
        if (this.nptsInLine != null) {
            int npts = 0;
            for (int pts : this.nptsInLine) {
                npts += pts;
            }
            return npts;
        }
        return this.nx * this.ny;
    }

    public int[] getNptsInLine() {
        return this.nptsInLine;
    }

    void setNptsInLine(int[] nptsInLine) {
        this.nptsInLine = nptsInLine;
    }

    protected int getOctet(int index) {
        if (index > this.data.length) {
            return -9999;
        }
        return this.data[index - 1] & 0xFF;
    }

    protected int getOctet2(int start) {
        return GribNumbers.int2(this.getOctet(start), this.getOctet(start + 1));
    }

    protected int getOctet3(int start) {
        return GribNumbers.int3(this.getOctet(start), this.getOctet(start + 1), this.getOctet(start + 2));
    }

    protected int getOctet4(int start) {
        return GribNumbers.int4(this.getOctet(start), this.getOctet(start + 1), this.getOctet(start + 2), this.getOctet(start + 3));
    }

    private static boolean getDirectionIncrementsGiven(int resolution) {
        return (resolution & GribNumbers.bitmask[0]) != 0;
    }

    private static boolean getEarthShapeIsSpherical(int resolution) {
        return (resolution & GribNumbers.bitmask[1]) == 0;
    }

    private static boolean getUVisReletive(int resolution) {
        return (resolution & GribNumbers.bitmask[1]) != 0;
    }

    protected Earth getEarth() {
        if (Grib1Gds.getEarthShapeIsSpherical(this.resolution)) {
            return new Earth(6367470.0);
        }
        return EarthEllipsoid.IAU;
    }

    public int getEarthShape() {
        return Grib1Gds.getEarthShapeIsSpherical(this.resolution) ? 0 : 1;
    }

    public boolean getUVisReletive() {
        return Grib1Gds.getUVisReletive(this.resolution);
    }

    public int getResolution() {
        return this.resolution;
    }

    public boolean isLatLon() {
        return false;
    }

    public int getScanMode() {
        return this.scanMode;
    }

    public int getNxRaw() {
        return this.nx;
    }

    public int getNyRaw() {
        return this.ny;
    }

    public int getNx() {
        if (this.nptsInLine == null || this.nx > 0) {
            return this.nx;
        }
        return QuasiRegular.getMax(this.nptsInLine);
    }

    public int getNy() {
        if (this.nptsInLine == null || this.ny > 0) {
            return this.ny;
        }
        return QuasiRegular.getMax(this.nptsInLine);
    }

    public float getDx() {
        return this.getDxRaw();
    }

    public float getDy() {
        return this.getDyRaw();
    }

    public abstract float getDxRaw();

    public abstract float getDyRaw();

    public abstract GdsHorizCoordSys makeHorizCoordSys();

    public abstract void testHorizCoordSys(Formatter var1);

    public String getNameShort() {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf("$");
        return className.substring(pos + 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Grib1Gds{");
        sb.append(" template=").append(this.template);
        sb.append(", nx=").append(this.nx);
        sb.append(", ny=").append(this.ny);
        sb.append(", scanMode=").append(this.scanMode);
        sb.append(", resolution=").append(this.resolution);
        sb.append(", lastOctet=").append(this.lastOctet);
        if (this.nptsInLine == null) {
            sb.append(", nptsInLine=null");
        } else {
            sb.append(", nptsInLine (").append(this.nptsInLine.length);
            sb.append(")=").append(Arrays.toString(this.nptsInLine));
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib1Gds Grib1Gds2 = (Grib1Gds)o;
        if (this.nx != Grib1Gds2.nx) {
            return false;
        }
        if (this.ny != Grib1Gds2.ny) {
            return false;
        }
        return this.template == Grib1Gds2.template;
    }

    public int hashCode() {
        int result = this.template;
        result = 31 * result + this.nx;
        result = 31 * result + this.ny;
        return result;
    }

    public static class SphericalHarmonicCoefficients
    extends Grib1Gds {
        int j = this.getOctet2(7);
        int k = this.getOctet2(9);
        int m = this.getOctet2(11);
        int type = this.getOctet(13);
        int mode = this.getOctet(14);

        SphericalHarmonicCoefficients(byte[] data, int template) {
            super(data, template);
        }

        @Override
        public float getDxRaw() {
            return 0.0f;
        }

        @Override
        public float getDyRaw() {
            return 0.0f;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            return null;
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("j", this.j).add("k", this.k).add("m", this.m).add("type", this.type).add("mode", this.mode).toString();
        }
    }

    public static class RotatedLatLon
    extends LatLon {
        public float angleRotation;
        public float latSouthPole = (float)this.getOctet3(33) * 0.001f;
        public float lonSouthPole = (float)this.getOctet3(36) * 0.001f;

        RotatedLatLon(byte[] data, int template) {
            super(data, template);
            this.angleRotation = (float)this.getOctet4(39) * 0.001f;
            this.lastOctet = 43;
        }

        public String getName() {
            return "Rotated latitude/longitude";
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nRotLatLon");
            sb.append("{angleRotation=").append(this.angleRotation);
            sb.append(", latSouthPole=").append(this.latSouthPole);
            sb.append(", lonSouthPole=").append(this.lonSouthPole);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RotatedLatLon other = (RotatedLatLon)o;
            return Misc.closeEnough((float)this.angleRotation, (float)other.angleRotation);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                this.hashCode = result = 31 * result + (this.angleRotation != 0.0f ? Float.floatToIntBits(this.angleRotation) : 0);
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            ucar.unidata.geoloc.projection.RotatedLatLon proj = new ucar.unidata.geoloc.projection.RotatedLatLon((double)this.latSouthPole, (double)this.lonSouthPole, (double)this.angleRotation);
            return new GdsHorizCoordSys(this.getNameShort(), this.template, 0, this.scanMode, (ProjectionImpl)proj, this.lo1, this.deltaLon, this.la1, this.deltaLat, this.nx, this.ny, null);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            LatLonPoint startLL = cs.proj.projToLatLon((ProjectionPoint)new ProjectionPointImpl((double)this.lo1, (double)this.la1));
            LatLonPoint endLL = cs.proj.projToLatLon((ProjectionPoint)new ProjectionPointImpl((double)this.lo2, (double)this.la2));
            f.format("%s testProjection%n", this.getClass().getName());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)cs.proj.latLonToProj(endLL, new ProjectionPointImpl());
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            double endx = cs.startx + (double)(this.nx - 1) * cs.dx;
            double endy = cs.starty + (double)(this.ny - 1) * cs.dy;
            f.format("   should end at x= (%f,%f)%n", endx, endy);
        }
    }

    public static class Mercator
    extends Grib1Gds {
        public float la1 = (float)this.getOctet3(11) * 0.001f;
        public float lo1 = (float)this.getOctet3(14) * 0.001f;
        public float la2;
        public float lo2;
        public float latin;
        public float dX;
        public float dY;

        Mercator(byte[] data, int template) {
            super(data, template);
            this.resolution = this.getOctet(17);
            this.la2 = (float)this.getOctet3(18) * 0.001f;
            this.lo2 = (float)this.getOctet3(21) * 0.001f;
            this.latin = (float)this.getOctet3(24) * 0.001f;
            this.scanMode = this.getOctet(28);
            this.dX = (float)this.getOctet3(29) * 0.001f;
            this.dY = (float)this.getOctet3(32) * 0.001f;
            this.lastOctet = 42;
        }

        @Override
        public float getDxRaw() {
            return this.dX;
        }

        @Override
        public float getDyRaw() {
            return this.dY;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nMercator{ ");
            sb.append("la1=").append(this.la1);
            sb.append(", lo1=").append(this.lo1);
            sb.append(", la2=").append(this.la2);
            sb.append(", lo2=").append(this.lo2);
            sb.append(", latin=").append(this.latin);
            sb.append(", dX=").append(this.dX);
            sb.append(", dY=").append(this.dY);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Mercator that = (Mercator)o;
            if (!Misc.closeEnoughAbs((double)this.la1, (double)that.la1, (double)(0.01 * (double)this.dY))) {
                return false;
            }
            if (!Misc.closeEnoughAbs((double)this.lo1, (double)that.lo1, (double)(0.01 * (double)this.dX))) {
                return false;
            }
            if (!Misc.closeEnough((float)this.latin, (float)that.latin)) {
                return false;
            }
            if (!Misc.closeEnough((float)this.dY, (float)that.dY)) {
                return false;
            }
            return Misc.closeEnough((float)this.dX, (float)that.dX);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int useLat = (int)((double)this.la1 / (0.01 * (double)this.dY));
                int useLon = (int)((double)this.lo1 / (0.01 * (double)this.dX));
                int useLad = (int)((double)this.latin / 1.0E-6);
                int useDeltaLon = (int)((double)this.dX / 1.0E-6);
                int useDeltaLat = (int)((double)this.dY / 1.0E-6);
                int result = super.hashCode();
                result = 31 * result + useLat;
                result = 31 * result + useLon;
                result = 31 * result + useLad;
                result = 31 * result + useDeltaLon;
                this.hashCode = result = 31 * result + useDeltaLat;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            Earth earth = this.getEarth();
            ucar.unidata.geoloc.projection.Mercator proj = new ucar.unidata.geoloc.projection.Mercator((double)this.lo1, (double)this.latin, 0.0, 0.0, earth.getEquatorRadius() * 0.001);
            ProjectionPoint startP = proj.latLonToProj((LatLonPoint)new LatLonPointImpl((double)this.la1, (double)this.lo1));
            double startx = startP.getX();
            double starty = startP.getY();
            return new GdsHorizCoordSys(this.getNameShort(), this.template, 0, this.scanMode, (ProjectionImpl)proj, startx, this.getDx(), starty, this.getDy(), this.getNx(), this.getNy(), null);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            double Lo2 = this.lo2;
            if (Lo2 < (double)this.lo1) {
                Lo2 += 360.0;
            }
            LatLonPointImpl startLL = new LatLonPointImpl((double)this.la1, (double)this.lo1);
            LatLonPointImpl endLL = new LatLonPointImpl((double)this.la2, Lo2);
            f.format("%s testProjection%n", this.getClass().getName());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)cs.proj.latLonToProj((LatLonPoint)endLL, new ProjectionPointImpl());
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            f.format("   should end at x= (%f,%f)%n", endx, endy);
        }
    }

    public static class LambertConformal
    extends Grib1Gds {
        public float la1 = (float)this.getOctet3(11) * 0.001f;
        public float lo1 = (float)this.getOctet3(14) * 0.001f;
        public float lov;
        public float lad;
        public float dX;
        public float dY;
        public float latin1;
        public float latin2;
        public float latSouthPole;
        public float lonSouthPole;
        public int projCenterFlag;

        LambertConformal(byte[] data, int template) {
            super(data, template);
            this.resolution = this.getOctet(17);
            this.lov = (float)this.getOctet3(18) * 0.001f;
            this.dX = (float)this.getOctet3(21) * 0.001f;
            this.dY = (float)this.getOctet3(24) * 0.001f;
            this.projCenterFlag = this.getOctet(27);
            this.scanMode = this.getOctet(28);
            this.latin1 = (float)this.getOctet3(29) * 0.001f;
            this.latin2 = (float)this.getOctet3(32) * 0.001f;
            this.latSouthPole = (float)this.getOctet3(35) * 0.001f;
            this.lonSouthPole = (float)this.getOctet3(38) * 0.001f;
            this.lastOctet = 42;
        }

        @Override
        public float getDxRaw() {
            return this.dX;
        }

        @Override
        public float getDyRaw() {
            return this.dY;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nLambertConformal{");
            sb.append("la1=").append(this.la1);
            sb.append(", lo1=").append(this.lo1);
            sb.append(", lov=").append(this.lov);
            sb.append(", lad=").append(this.lad);
            sb.append(", dX=").append(this.dX);
            sb.append(", dY=").append(this.dY);
            sb.append(", latin1=").append(this.latin1);
            sb.append(", latin2=").append(this.latin2);
            sb.append(", latSouthPole=").append(this.latSouthPole);
            sb.append(", lonSouthPole=").append(this.lonSouthPole);
            sb.append(", projCenterFlag=").append(this.projCenterFlag);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambertConformal that = (LambertConformal)o;
            if (!Misc.closeEnoughAbs((double)this.la1, (double)that.la1, (double)(0.01 * (double)this.dY))) {
                return false;
            }
            if (!Misc.closeEnoughAbs((double)this.lo1, (double)that.lo1, (double)(0.01 * (double)this.dX))) {
                return false;
            }
            if (!Misc.closeEnough((float)this.lad, (float)that.lad)) {
                return false;
            }
            if (!Misc.closeEnough((float)this.lov, (float)that.lov)) {
                return false;
            }
            if (!Misc.closeEnough((float)this.dY, (float)that.dY)) {
                return false;
            }
            if (!Misc.closeEnough((float)this.dX, (float)that.dX)) {
                return false;
            }
            if (!Misc.closeEnough((float)this.latin1, (float)that.latin1)) {
                return false;
            }
            return Misc.closeEnough((float)this.latin2, (float)that.latin2);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int useLat = (int)((double)this.la1 / (0.01 * (double)this.dY));
                int useLon = (int)((double)this.lo1 / (0.01 * (double)this.dX));
                int useLad = (int)((double)this.lad / 1.0E-6);
                int useLov = (int)((double)this.lov / 1.0E-6);
                int useDeltaLon = (int)((double)this.dX / 1.0E-6);
                int useDeltaLat = (int)((double)this.dY / 1.0E-6);
                int useLatin1 = (int)((double)this.latin1 / 1.0E-6);
                int useLatin2 = (int)((double)this.latin2 / 1.0E-6);
                int result = super.hashCode();
                result = 31 * result + useLat;
                result = 31 * result + useLon;
                result = 31 * result + useLad;
                result = 31 * result + useLov;
                result = 31 * result + useDeltaLon;
                result = 31 * result + useDeltaLat;
                result = 31 * result + useLatin1;
                result = 31 * result + useLatin2;
                this.hashCode = result = 31 * result + this.projCenterFlag;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            Object proj = null;
            Earth earth = this.getEarth();
            proj = earth.isSpherical() ? new ucar.unidata.geoloc.projection.LambertConformal((double)this.latin1, (double)this.lov, (double)this.latin1, (double)this.latin2, 0.0, 0.0, earth.getEquatorRadius() * 0.001) : new LambertConformalConicEllipse((double)this.latin1, (double)this.lov, (double)this.latin1, (double)this.latin2, 0.0, 0.0, earth);
            LatLonPointImpl startLL = new LatLonPointImpl((double)this.la1, (double)this.lo1);
            ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj((LatLonPoint)startLL);
            return new GdsHorizCoordSys(this.getNameShort(), this.template, 0, this.scanMode, (ProjectionImpl)proj, start.getX(), this.getDx(), start.getY(), this.getDy(), this.getNx(), this.getNy(), null);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            f.format("%s testProjection %s%n", this.getClass().getName(), cs.proj.getClass().getName());
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            ProjectionPointImpl endPP = new ProjectionPointImpl(endx, endy);
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            LatLonPointImpl startLL = new LatLonPointImpl((double)this.la1, (double)this.lo1);
            LatLonPoint endLL = cs.proj.projToLatLon((ProjectionPoint)endPP, new LatLonPointImpl());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
        }
    }

    public static class PolarStereographic
    extends Grib1Gds {
        public float la1;
        public float lo1;
        public float lov;
        public float dX;
        public float dY;
        public int projCenterFlag;
        private float lad = 60.0f;

        protected PolarStereographic(int template) {
            super(template);
        }

        PolarStereographic(byte[] data, int template) {
            super(data, template);
            this.la1 = (float)this.getOctet3(11) * 0.001f;
            this.lo1 = (float)this.getOctet3(14) * 0.001f;
            this.resolution = this.getOctet(17);
            this.lov = (float)this.getOctet3(18) * 0.001f;
            this.dX = (float)this.getOctet3(21) * 0.001f;
            this.dY = (float)this.getOctet3(24) * 0.001f;
            this.projCenterFlag = this.getOctet(27);
            this.scanMode = this.getOctet(28);
            this.lastOctet = 28;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nPolarStereographic{");
            sb.append("la1=").append(this.la1);
            sb.append(", lo1=").append(this.lo1);
            sb.append(", lov=").append(this.lov);
            sb.append(", dX=").append(this.dX);
            sb.append(", dY=").append(this.dY);
            sb.append(", projCenterFlag=").append(this.projCenterFlag);
            sb.append(", lad=").append(this.lad);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PolarStereographic that = (PolarStereographic)o;
            if (!Misc.closeEnoughAbs((double)this.la1, (double)that.la1, (double)(0.01 * (double)this.dY))) {
                return false;
            }
            if (!Misc.closeEnoughAbs((double)this.lo1, (double)that.lo1, (double)(0.01 * (double)this.dX))) {
                return false;
            }
            if (!Misc.closeEnough((float)this.lov, (float)that.lov)) {
                return false;
            }
            if (!Misc.closeEnough((float)this.dY, (float)that.dY)) {
                return false;
            }
            if (!Misc.closeEnough((float)this.dX, (float)that.dX)) {
                return false;
            }
            return this.projCenterFlag == that.projCenterFlag;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int useLat = (int)((double)this.la1 / (0.01 * (double)this.dY));
                int useLon = (int)((double)this.lo1 / (0.01 * (double)this.dX));
                int useLov = (int)((double)this.lov / 1.0E-6);
                int useDeltaLon = (int)((double)this.dX / 1.0E-6);
                int useDeltaLat = (int)((double)this.dY / 1.0E-6);
                int result = super.hashCode();
                result = 31 * result + useLat;
                result = 31 * result + useLon;
                result = 31 * result + useLov;
                result = 31 * result + useDeltaLon;
                result = 31 * result + useDeltaLat;
                this.hashCode = result = 31 * result + this.projCenterFlag;
            }
            return this.hashCode;
        }

        @Override
        public float getDxRaw() {
            return this.dX;
        }

        @Override
        public float getDyRaw() {
            return this.dY;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            boolean northPole = (this.projCenterFlag & 0x80) == 0;
            double latOrigin = northPole ? 90.0 : -90.0;
            double scale = Double.isNaN(this.lad) ? 0.9330127018922193 : (1.0 + Math.sin(Math.toRadians(Math.abs(this.lad)))) / 2.0;
            Earth earth = this.getEarth();
            Object proj = earth.isSpherical() ? new Stereographic(latOrigin, (double)this.lov, scale) : new StereographicAzimuthalProjection(latOrigin, (double)this.lov, scale, (double)this.lad, 0.0, 0.0, earth);
            ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj((LatLonPoint)new LatLonPointImpl((double)this.la1, (double)this.lo1));
            return new GdsHorizCoordSys(this.getNameShort(), this.template, 0, this.scanMode, (ProjectionImpl)proj, start.getX(), this.getDx(), start.getY(), this.getDy(), this.getNx(), this.getNy(), null);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            f.format("%s testProjection %s%n", this.getClass().getName(), cs.proj.getClass().getName());
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            ProjectionPointImpl endPP = new ProjectionPointImpl(endx, endy);
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            LatLonPointImpl startLL = new LatLonPointImpl((double)this.la1, (double)this.lo1);
            LatLonPoint endLL = cs.proj.projToLatLon((ProjectionPoint)endPP, new LatLonPointImpl());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
        }
    }

    public static class GaussianLatLon
    extends LatLon {
        int nparellels = this.getOctet2(26);
        public float latSouthPole;
        public float lonSouthPole;
        public float rotAngle;
        public float latPole;
        public float lonPole;
        public float stretchFactor;

        GaussianLatLon(byte[] data, int template) {
            super(data, template);
            if (data.length > 32) {
                this.latSouthPole = (float)this.getOctet3(33) * 0.001f;
                this.lonSouthPole = (float)this.getOctet3(36) * 0.001f;
                this.rotAngle = (float)this.getOctet4(39) * 0.001f;
                this.latPole = (float)this.getOctet3(43) * 0.001f;
                this.lonPole = (float)this.getOctet3(46) * 0.001f;
                this.stretchFactor = (float)this.getOctet4(49) * 0.001f;
            }
            this.lastOctet = 52;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            GdsHorizCoordSys hc = super.makeHorizCoordSys();
            hc.setGaussianLats(this.nparellels, this.la1, this.la2);
            return hc;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GaussianLatLon that = (GaussianLatLon)o;
            return this.nparellels == that.nparellels;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.nparellels;
            return result;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nGaussianLatLon");
            sb.append("{nparellels=").append(this.nparellels);
            sb.append(", latSouthPole=").append(this.latSouthPole);
            sb.append(", lonSouthPole=").append(this.lonSouthPole);
            sb.append(", rotAngle=").append(this.rotAngle);
            sb.append(", latPole=").append(this.latPole);
            sb.append(", lonPole=").append(this.lonPole);
            sb.append(", stretchFactor=").append(this.stretchFactor);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class LatLon
    extends Grib1Gds {
        public float la1;
        public float lo1;
        public float la2;
        public float lo2;
        public float deltaLon;
        public float deltaLat;

        protected LatLon(int template) {
            super(template);
        }

        LatLon(byte[] data, int template) {
            super(data, template);
            this.la1 = (float)this.getOctet3(11) * 0.001f;
            this.lo1 = (float)this.getOctet3(14) * 0.001f;
            this.resolution = this.getOctet(17);
            this.la2 = (float)this.getOctet3(18) * 0.001f;
            this.lo2 = (float)this.getOctet3(21) * 0.001f;
            if (this.lo2 < this.lo1) {
                this.lo2 += 360.0f;
            }
            this.deltaLon = this.getOctet2(24);
            float calcDelta = (this.lo2 - this.lo1) / (float)(this.nx - 1);
            this.deltaLon = this.deltaLon != -9999.0f ? (this.deltaLon *= 0.001f) : calcDelta;
            if (!Misc.closeEnough((float)this.deltaLon, (float)calcDelta)) {
                log.debug("deltaLon != calcDeltaLon");
                this.deltaLon = calcDelta;
            }
            this.deltaLat = this.getOctet2(26);
            calcDelta = (this.la2 - this.la1) / (float)(this.ny - 1);
            if (this.deltaLat != -9999.0f) {
                this.deltaLat *= 0.001f;
                if (this.la2 < this.la1) {
                    this.deltaLat = (float)((double)this.deltaLat * -1.0);
                }
            } else {
                this.deltaLat = calcDelta;
            }
            if (!Misc.closeEnough((float)this.deltaLat, (float)calcDelta)) {
                log.debug("deltaLat != calcDeltaLat");
                this.deltaLat = calcDelta;
            }
            this.scanMode = (byte)this.getOctet(28);
            this.lastOctet = 28;
        }

        @Override
        public void setNptsInLine(int[] nptsInLine) {
            super.setNptsInLine(nptsInLine);
            int n = QuasiRegular.getMax(nptsInLine);
            if (this.nx < 0) {
                this.deltaLon = (this.lo2 - this.lo1) / (float)(n - 1);
            }
            if (this.ny < 0) {
                this.deltaLat = (this.la2 - this.la1) / (float)(n - 1);
            }
        }

        @Override
        public boolean isLatLon() {
            return true;
        }

        @Override
        public float getDx() {
            if (this.nptsInLine == null || this.deltaLon != -9999.0f) {
                return this.deltaLon;
            }
            return (this.lo2 - this.lo1) / (float)(this.getNx() - 1);
        }

        @Override
        public float getDy() {
            if (this.nptsInLine == null || this.deltaLat != -9999.0f) {
                return this.deltaLat;
            }
            return (this.la2 - this.la1) / (float)(this.getNy() - 1);
        }

        @Override
        public float getDxRaw() {
            return this.deltaLon;
        }

        @Override
        public float getDyRaw() {
            return this.deltaLat;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LatLon other = (LatLon)o;
            if (!Misc.closeEnoughAbs((double)this.la1, (double)other.la1, (double)(0.01 * (double)this.deltaLat))) {
                return false;
            }
            if (!Misc.closeEnoughAbs((double)this.lo1, (double)other.lo1, (double)(0.01 * (double)this.deltaLon))) {
                return false;
            }
            if (!Misc.closeEnough((float)this.deltaLat, (float)other.deltaLat)) {
                return false;
            }
            return Misc.closeEnough((float)this.deltaLon, (float)other.deltaLon);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int useLat = (int)((double)this.la1 / (0.01 * (double)this.deltaLat));
                int useLon = (int)((double)this.lo1 / (0.01 * (double)this.deltaLon));
                int useDeltaLon = (int)((double)this.deltaLon / 1.0E-6);
                int useDeltaLat = (int)((double)this.deltaLat / 1.0E-6);
                int result = super.hashCode();
                result = 31 * result + useLat;
                result = 31 * result + useLon;
                result = 31 * result + useDeltaLon;
                this.hashCode = result = 31 * result + useDeltaLat;
            }
            return this.hashCode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\nLatLon{ la1=").append(this.la1);
            sb.append(", lo1=").append(this.lo1);
            sb.append(", la2=").append(this.la2);
            sb.append(", lo2=").append(this.lo2);
            sb.append(", deltaLon=").append(this.deltaLon);
            sb.append(", deltaLat=").append(this.deltaLat);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            LatLonProjection proj = new LatLonProjection(this.getEarth());
            double startx = this.lo1;
            double starty = this.la1;
            return new GdsHorizCoordSys(this.getNameShort(), this.template, 0, this.scanMode, (ProjectionImpl)proj, startx, this.getDx(), starty, this.getDy(), this.getNx(), this.getNy(), null);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            double Lo2 = this.lo2;
            if (Lo2 < (double)this.lo1) {
                Lo2 += 360.0;
            }
            LatLonPointImpl startLL = new LatLonPointImpl((double)this.la1, (double)this.lo1);
            LatLonPointImpl endLL = new LatLonPointImpl((double)this.la2, Lo2);
            f.format("%s testProjection%n", this.getClass().getName());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)cs.proj.latLonToProj((LatLonPoint)endLL, new ProjectionPointImpl());
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            f.format("   should end at x= (%f,%f)%n", endx, endy);
        }
    }
}

