/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.grib.collection.Grib2CollectionBuilderFromIndex;
import ucar.nc2.grib.collection.Grib2Partition;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.PartitionCollectionMutable;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

public class Grib2PartitionBuilderFromIndex
extends Grib2CollectionBuilderFromIndex {
    private PartitionCollectionMutable pc;

    public static Grib2Partition createTimePartitionFromIndex(String name, RandomAccessFile raf, FeatureCollectionConfig config, Logger logger) throws IOException {
        Grib2PartitionBuilderFromIndex builder = new Grib2PartitionBuilderFromIndex(name, config, logger);
        if (builder.readIndex(raf)) {
            return new Grib2Partition(builder.pc);
        }
        return null;
    }

    public static PartitionCollectionMutable openMutablePCFromIndex(String name, RandomAccessFile raf, FeatureCollectionConfig config, Logger logger) throws IOException {
        Grib2PartitionBuilderFromIndex builder = new Grib2PartitionBuilderFromIndex(name, config, logger);
        if (builder.readIndex(raf)) {
            return builder.pc;
        }
        return null;
    }

    private Grib2PartitionBuilderFromIndex(String name, FeatureCollectionConfig config, Logger logger) {
        super(name, config, logger);
        this.pc = new PartitionCollectionMutable(name, null, config, false, logger);
        this.gc = this.pc;
    }

    @Override
    public String getMagicStart() {
        return "Grib2Partition2Index";
    }

    @Override
    protected boolean readExtensions(GribCollectionProto.GribCollection proto) {
        this.pc.isPartitionOfPartitions = proto.getIsPartitionOfPartitions();
        List<Integer> list = proto.getRun2PartList();
        this.pc.run2part = new int[list.size()];
        int count = 0;
        for (int partno : list) {
            this.pc.run2part[count++] = partno;
        }
        List<GribCollectionProto.Partition> partList = proto.getPartitionsList();
        for (GribCollectionProto.Partition partProto : partList) {
            this.makePartition(partProto);
        }
        return partList.size() > 0;
    }

    @Override
    protected GribCollectionMutable.VariableIndex readVariableExtensions(GribCollectionMutable.GroupGC group, GribCollectionProto.Variable proto, GribCollectionMutable.VariableIndex vi) {
        List<GribCollectionProto.PartitionVariable> pvList = proto.getPartVariableList();
        PartitionCollectionMutable.VariableIndexPartitioned vip = this.pc.makeVariableIndexPartitioned(group, vi, pvList.size());
        vip.setPartitions(pvList);
        vip.ndups = vi.ndups;
        vip.nrecords = vi.nrecords;
        vip.nmissing = vi.nmissing;
        return vip;
    }

    private PartitionCollectionMutable.Partition makePartition(GribCollectionProto.Partition proto) {
        long partitionDateMillisecs = proto.getPartitionDate();
        CalendarDate partitionDate = partitionDateMillisecs > 0L ? CalendarDate.of((long)partitionDateMillisecs) : null;
        return this.pc.addPartition(proto.getName(), proto.getFilename(), proto.getLastModified(), proto.getLength(), null, partitionDate);
    }
}

