/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;

@Immutable
public class Grib1ParamLevel {
    private final Grib1Customizer cust;
    private final int levelType;
    private final float value1;
    private final float value2;

    public Grib1ParamLevel(Grib1Customizer cust, int levelType, float value1, float value2) {
        this.cust = cust;
        this.levelType = levelType;
        this.value1 = value1;
        this.value2 = value2;
    }

    public Grib1ParamLevel(Grib1Customizer cust, Grib1SectionProductDefinition pds) {
        this.cust = cust;
        this.levelType = pds.getLevelType();
        int pds11 = pds.getLevelValue1();
        int pds12 = pds.getLevelValue2();
        int pds1112 = pds11 << 8 | pds12;
        switch (this.levelType) {
            default: {
                this.value1 = pds11;
                this.value2 = pds12;
                break;
            }
            case 20: {
                this.value1 = (float)((double)pds1112 * 0.01);
                this.value2 = 255.0f;
                break;
            }
            case 100: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 101: {
                this.value1 = pds11 * 10;
                this.value2 = pds12 * 10;
                break;
            }
            case 103: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 104: {
                this.value1 = pds11 * 100;
                this.value2 = pds12 * 100;
                break;
            }
            case 105: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 106: {
                this.value1 = pds11 * 100;
                this.value2 = pds12 * 100;
                break;
            }
            case 107: {
                this.value1 = (float)((double)pds1112 * 1.0E-4);
                this.value2 = 255.0f;
                break;
            }
            case 108: {
                this.value1 = (float)((double)pds11 * 0.01);
                this.value2 = (float)((double)pds12 * 0.01);
                break;
            }
            case 109: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 110: {
                this.value1 = pds11;
                this.value2 = pds12;
                break;
            }
            case 111: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 112: {
                this.value1 = pds11;
                this.value2 = pds12;
                break;
            }
            case 113: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 114: {
                this.value1 = 475 - pds11;
                this.value2 = 475 - pds12;
                break;
            }
            case 115: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 116: {
                this.value1 = pds11;
                this.value2 = pds12;
                break;
            }
            case 117: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 119: {
                this.value1 = (float)((double)pds1112 * 1.0E-4);
                this.value2 = 255.0f;
                break;
            }
            case 120: {
                this.value1 = (float)((double)pds11 * 0.01);
                this.value2 = (float)((double)pds12 * 0.01);
                break;
            }
            case 121: {
                this.value1 = 1100 - pds11;
                this.value2 = 1100 - pds12;
                break;
            }
            case 125: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 126: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 128: {
                this.value1 = (float)(1.1 - (double)pds11 * 0.001);
                this.value2 = (float)(1.1 - (double)pds12 * 0.001);
                break;
            }
            case 141: {
                this.value1 = pds11;
                this.value2 = 1100 - pds12;
                break;
            }
            case 160: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
            }
        }
    }

    public int getLevelType() {
        return this.levelType;
    }

    public float getValue1() {
        return this.value1;
    }

    public float getValue2() {
        return this.value2;
    }

    public String getNameShort() {
        return this.cust.getLevelNameShort(this.levelType);
    }

    public String getDescription() {
        return this.cust.getLevelDescription(this.levelType);
    }
}

