/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.GribTables;
import ucar.nc2.util.Misc;

@Immutable
public class VertCoord {
    private String name;
    private final List<Level> coords;
    private final VertUnit unit;
    private final boolean isLayer;

    public static void assignVertNames(List<VertCoord> vertCoords, GribTables tables) {
        ArrayList<VertCoord> temp = new ArrayList<VertCoord>(vertCoords);
        for (VertCoord vc : temp) {
            String shortName = tables.getLevelNameShort(vc.getCode());
            if (vc.isLayer()) {
                shortName = shortName + "_layer";
            }
            vc.setName(shortName);
        }
        Collections.sort(temp, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        String lastName = null;
        int count = 0;
        for (VertCoord vc : temp) {
            String name = vc.getName();
            if (lastName == null || !lastName.equals(name)) {
                count = 0;
            } else {
                vc.setName(name + ++count);
            }
            lastName = name;
        }
    }

    public VertCoord(List<Level> coords, VertUnit unit, boolean isLayer) {
        this.coords = coords;
        this.unit = unit;
        this.isLayer = isLayer;
    }

    public boolean isVertDimensionUsed() {
        return this.coords.size() != 1 || this.unit.isVerticalCoordinate();
    }

    public boolean isLayer() {
        return this.isLayer;
    }

    public boolean isPositiveUp() {
        return this.unit.isPositiveUp();
    }

    public List<Level> getCoords() {
        return this.coords;
    }

    public int getCode() {
        return this.unit.getCode();
    }

    public String getUnits() {
        return this.unit.getUnits();
    }

    public int getSize() {
        return this.coords.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public boolean equalsData(VertCoord other) {
        if (this.unit.getCode() != other.unit.getCode()) {
            return false;
        }
        if (this.isLayer != other.isLayer) {
            return false;
        }
        if (this.coords.size() != other.coords.size()) {
            return false;
        }
        for (int i = 0; i < this.coords.size(); ++i) {
            if (this.coords.get(i).closeEnough(other.coords.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Formatter out = new Formatter();
        out.format("(3D=%s) code=%d = ", this.isVertDimensionUsed(), this.getCode());
        for (Level lev : this.coords) {
            out.format("%s, ", lev.toString(this.isLayer));
        }
        out.format("units='%s' isLayer=%s", this.getUnits(), this.isLayer);
        return out.toString();
    }

    public String showCoords() {
        Formatter out = new Formatter();
        for (Level lev : this.coords) {
            out.format("%s, ", lev.toString(this.isLayer));
        }
        return out.toString();
    }

    public static int findCoord(List<VertCoord> vertCoords, VertCoord want) {
        if (want == null) {
            return -1;
        }
        for (int i = 0; i < vertCoords.size(); ++i) {
            if (!want.equalsData(vertCoords.get(i))) continue;
            return i;
        }
        vertCoords.add(want);
        return vertCoords.size() - 1;
    }

    @Immutable
    public static interface VertUnit {
        public int getCode();

        public String getUnits();

        public String getDesc();

        public String getDatum();

        public boolean isLayer();

        public boolean isPositiveUp();

        public boolean isVerticalCoordinate();
    }

    @Immutable
    public static class Level
    implements Comparable<Level> {
        final double value1;
        final double value2;
        final double mid;
        final boolean isLayer;

        public Level(double value1) {
            this.value1 = value1;
            this.value2 = -9999.0;
            this.mid = value1;
            this.isLayer = false;
        }

        public Level(double value1, double value2) {
            this.value1 = value1;
            this.value2 = value2;
            this.mid = Double.compare(value2, 0.0) == 0 || GribNumbers.isUndefined(value2) ? value1 : (value1 + value2) / 2.0;
            this.isLayer = true;
        }

        public double getValue1() {
            return this.value1;
        }

        public double getValue2() {
            return this.value2;
        }

        public boolean isLayer() {
            return this.isLayer;
        }

        @Override
        public int compareTo(Level o) {
            if (this.mid < o.mid) {
                return -1;
            }
            if (this.mid > o.mid) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Level level = (Level)o;
            if (Double.compare(level.value1, this.value1) != 0) {
                return false;
            }
            if (Double.compare(level.value2, this.value2) != 0) {
                return false;
            }
            return this.isLayer == level.isLayer;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.value1);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.value2);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.isLayer ? 1 : 0);
            return result;
        }

        public boolean closeEnough(Level other) {
            return Misc.closeEnough((double)this.value1, (double)other.value1) && Misc.closeEnough((double)this.value2, (double)other.value2);
        }

        public String toString() {
            Formatter out = new Formatter();
            if (this.isLayer) {
                out.format("(%f,%f)", this.value1, this.value2);
            } else {
                out.format("%f", this.value1);
            }
            return out.toString();
        }

        public String toString(boolean isLayer) {
            Formatter out = new Formatter();
            if (isLayer) {
                out.format("(%f,%f)", this.value1, this.value2);
            } else {
                out.format("%f", this.value1);
            }
            return out.toString();
        }
    }
}

