/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class EcmwfLocalConcepts {
    private static String SHORTNAME_ID = "shortName";
    private static String DESCRIPTION_ID = "description";
    private static String UNIT_ID = "units";
    private static String TABLE_VERSION_ID = "table2Version";
    private static String PARAM_NUM_ID = "indicatorOfParameter";
    private static Charset ENCODING = StandardCharsets.UTF_8;
    private HashMap<String, HashMap<String, HashMap<String, String>>> localConcepts = new HashMap();
    private String ecmwfLocalConceptsLoc;

    public EcmwfLocalConcepts() {
        String sep = File.separator;
        String classPath = EcmwfLocalConcepts.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String split = "thredds" + sep + "grib";
        String sourcesPath = classPath.split(split)[0];
        if (classPath.equals(sourcesPath)) {
            split = "grib" + sep + "build";
            sourcesPath = classPath.split(split)[0];
            sourcesPath = classPath.split("/grib")[0];
        }
        this.ecmwfLocalConceptsLoc = sourcesPath + sep + "grib" + sep + "src" + sep + "main" + sep + "sources" + sep + "ecmwfGribApi" + sep;
        try {
            this.parseLocalConcept(this.ecmwfLocalConceptsLoc + "shortName.def", SHORTNAME_ID);
            this.parseLocalConcept(this.ecmwfLocalConceptsLoc + "name.def", DESCRIPTION_ID);
            this.parseLocalConcept(this.ecmwfLocalConceptsLoc + "units.def", UNIT_ID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseLocalConcept(String filename, String conceptName) throws IOException {
        try (FileInputStream is = new FileInputStream(filename);){
            this.addLocalConcept(is, conceptName);
        }
    }

    private void addLocalConcept(InputStream is, String conceptName) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, ENCODING));){
            String line = br.readLine();
            while (!line.startsWith("#")) {
                line = br.readLine();
            }
            while (true) {
                HashMap<String, String> items = new HashMap<String, String>();
                line = br.readLine();
                if (line == null) {
                    break;
                }
                if (line.length() == 0 || line.startsWith("#") || !(line = this.cleanLine(line)).contains("{")) continue;
                String paramName = line.split("=")[0].trim();
                line = br.readLine();
                if (line == null) {
                    break;
                }
                line = this.cleanLine(line);
                while (line.contains("=")) {
                    String[] kvp = line.split("=");
                    items.put(kvp[0].trim(), kvp[1].trim());
                    line = br.readLine();
                    if (line == null) break;
                    line = this.cleanLine(line);
                }
                String tableVersion = (String)items.get(TABLE_VERSION_ID);
                String parameterNumber = (String)items.get(PARAM_NUM_ID);
                this.storeConcept(tableVersion, parameterNumber, conceptName, paramName);
            }
        }
    }

    private String cleanLine(String lineIn) {
        String lineOut = "";
        lineOut = lineIn.replaceAll("'", "");
        lineOut = lineOut.replaceAll("\t", "");
        lineOut = lineOut.replaceAll(";", "");
        return lineOut.trim();
    }

    private void storeConcept(String tableVersion, String parameterNumber, String key, String value) {
        HashMap<Object, Object> tmpTable;
        if (this.localConcepts.containsKey(tableVersion)) {
            tmpTable = this.localConcepts.get(tableVersion);
            if (tmpTable.containsKey(parameterNumber)) {
                HashMap tmpParam = (HashMap)tmpTable.get(parameterNumber);
                if (!tmpParam.containsKey(key)) {
                    tmpParam.put(key, value);
                } else {
                    System.out.println("already has key value pair: " + key + ":" + value);
                }
            } else {
                HashMap<String, String> tmpParam = new HashMap<String, String>(4);
                tmpParam.put(key, value);
                tmpTable.put(parameterNumber, tmpParam);
            }
        } else {
            tmpTable = new HashMap();
            HashMap<String, String> tmpParam = new HashMap<String, String>(4);
            tmpParam.put(key, value);
            tmpTable.put(parameterNumber, tmpParam);
        }
        this.localConcepts.put(tableVersion, tmpTable);
    }

    private void writeGrib1Tables() throws IOException, ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        Calendar cal = Calendar.getInstance();
        String writeDate = dateFormat.format(cal.getTime());
        ArrayList<String> tableNums = new ArrayList<String>();
        Path dir = Paths.get(this.ecmwfLocalConceptsLoc.replace("sources/", "resources/resources/grib1/"), new String[0]);
        for (String tableNum : this.localConcepts.keySet()) {
            tableNums.add(tableNum);
            String fileName = "2.98." + tableNum + ".table";
            System.out.println("Writing: " + fileName);
            Path newFile = dir.resolve(fileName);
            Files.deleteIfExists(newFile);
            Files.createFile(newFile, new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(newFile, ENCODING, new OpenOption[0]);
            Throwable throwable = null;
            try {
                writer.write("# Generated by " + this.getClass().getCanonicalName() + " on " + writeDate);
                writer.newLine();
                for (String paramNum : this.localConcepts.get(tableNum).keySet()) {
                    HashMap<String, String> paramInfo = this.localConcepts.get(tableNum).get(paramNum);
                    String shortName = paramInfo.get(SHORTNAME_ID);
                    String description = paramInfo.get(DESCRIPTION_ID);
                    String units = paramInfo.get(UNIT_ID);
                    String grib1Info = paramNum + " " + shortName + " [" + description + "] (" + units + ")";
                    writer.write(grib1Info);
                    writer.newLine();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
        this.writeLookupTableFile(tableNums, dir, writeDate);
    }

    private void writeLookupTableFile(List<String> tableNums, Path dir, String writeDate) throws IOException {
        System.out.println("Writing: lookupTables.txt");
        Collections.sort(tableNums);
        Path lookupTableReg = dir.resolve("lookupTables.txt");
        Files.deleteIfExists(lookupTableReg);
        Files.createFile(lookupTableReg, new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(lookupTableReg, ENCODING, new OpenOption[0]);){
            writer.write("# Generated by " + this.getClass().getCanonicalName() + " on " + writeDate);
            writer.newLine();
            for (String tn : tableNums) {
                String tableName = "2.98." + tn + ".table";
                String reg = "98:\t-1:\t" + tn + ":\t" + tableName;
                writer.write(reg);
                writer.newLine();
            }
        }
    }

    private void showLocalConcepts() {
        for (String tableNum : this.localConcepts.keySet()) {
            for (String paramNum : this.localConcepts.get(tableNum).keySet()) {
                for (String key : this.localConcepts.get(tableNum).get(paramNum).keySet()) {
                    System.out.println(key + ":" + this.localConcepts.get(tableNum).get(paramNum).get(key));
                }
            }
        }
    }

    public static void main(String[] args) {
        EcmwfLocalConcepts ec = new EcmwfLocalConcepts();
        try {
            ec.writeGrib1Tables();
            System.out.println("Finished!");
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
    }
}

