/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib1SectionBitMap {
    private static final Logger logger = LoggerFactory.getLogger(Grib1SectionBitMap.class);
    private final long startingPosition;

    public Grib1SectionBitMap(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        int length = GribNumbers.int3(raf);
        raf.seek(this.startingPosition + (long)length);
    }

    public Grib1SectionBitMap(long startingPosition) {
        this.startingPosition = startingPosition;
    }

    public long getStartingPosition() {
        return this.startingPosition;
    }

    public byte[] getBitmap(RandomAccessFile raf) throws IOException {
        if (this.startingPosition <= 0L) {
            throw new IllegalStateException("Grib1 Bit map has bad starting position");
        }
        raf.seek(this.startingPosition);
        int length = GribNumbers.uint3(raf);
        raf.read();
        short bm = raf.readShort();
        if (bm != 0) {
            logger.warn("Grib1 Bit map section pre-defined (provided by center) bitmap number = {}", (Object)bm);
            return null;
        }
        if (length <= 6 || (double)length > 1.0E7) {
            return null;
        }
        int n = length - 6;
        byte[] data = new byte[n];
        raf.readFully(data);
        return data;
    }

    int getLength(RandomAccessFile raf) throws IOException {
        raf.seek(this.startingPosition);
        return GribNumbers.uint3(raf);
    }
}

