/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.SparseArray;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerHelper;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.Grib2Iosp;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribHorizCoordSystem;
import ucar.nc2.grib.grib1.Grib1Variable;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public abstract class GribCollectionImmutable
implements Closeable,
FileCacheable {
    private static final Logger logger = LoggerFactory.getLogger(GribCollectionImmutable.class);
    public static int countGC;
    protected final String name;
    protected final File directory;
    protected final FeatureCollectionConfig config;
    public final boolean isGrib1;
    protected final Info info;
    protected final List<Dataset> datasets;
    protected final CoordinateRuntime masterRuntime;
    protected final CalendarDateRange dateRange;
    protected final Map<Integer, MFile> fileMap;
    protected final GribTables cust;
    protected final String indexFilename;
    protected FileCacheIF objCache = null;

    GribCollectionImmutable(GribCollectionMutable gc) {
        ++countGC;
        this.config = gc.config;
        this.name = gc.name;
        this.directory = gc.directory;
        this.isGrib1 = gc.isGrib1;
        this.info = new Info(gc);
        ArrayList<Dataset> work = new ArrayList<Dataset>(gc.datasets.size());
        for (GribCollectionMutable.Dataset gcDataset : gc.datasets) {
            work.add(new Dataset(gcDataset.gctype, gcDataset.groups));
        }
        this.datasets = Collections.unmodifiableList(work);
        this.masterRuntime = gc.masterRuntime;
        this.fileMap = gc.fileMap;
        this.cust = gc.cust;
        this.dateRange = gc.dateRange;
        if (gc.indexFilename != null) {
            this.indexFilename = gc.indexFilename;
        } else {
            File indexFile = GribCdmIndex.makeIndexFile(this.name, this.directory);
            File indexFileInCache = GribIndexCache.getExistingFileOrCache(indexFile.getPath());
            if (indexFileInCache == null) {
                throw new IllegalStateException(indexFile.getPath() + " does not exist, nor in cache");
            }
            this.indexFilename = indexFileInCache.getPath();
        }
    }

    protected VariableIndex makeVariableIndex(GroupGC group, GribCollectionMutable.VariableIndex mutableVar) {
        return new VariableIndex(group, mutableVar);
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public Dataset getDataset(int idx) {
        return this.datasets.get(idx);
    }

    public Dataset getDatasetCanonical() {
        for (Dataset ds : this.datasets) {
            if (ds.gctype == Type.Best) continue;
            return ds;
        }
        throw new IllegalStateException("GC.getDatasetCanonical failed on=" + this.name);
    }

    public String getName() {
        return this.name;
    }

    public File getDirectory() {
        return this.directory;
    }

    public CoordinateRuntime getMasterRuntime() {
        return this.masterRuntime;
    }

    public CalendarDate getMasterFirstDate() {
        return this.masterRuntime.getFirstDate();
    }

    public int getVersion() {
        return this.info.version;
    }

    public int getCenter() {
        return this.info.center;
    }

    public int getSubcenter() {
        return this.info.subcenter;
    }

    public int getMaster() {
        return this.info.master;
    }

    public int getLocal() {
        return this.info.local;
    }

    public int getGenProcessType() {
        return this.info.genProcessType;
    }

    public int getGenProcessId() {
        return this.info.genProcessId;
    }

    public int getBackProcessId() {
        return this.info.backProcessId;
    }

    public AttributeContainerHelper getGlobalAttributes() {
        AttributeContainerHelper result = new AttributeContainerHelper(this.name);
        String val = CommonCodeTable.getCenterName((int)this.getCenter(), (int)2);
        result.addAttribute(new Attribute("Originating_or_generating_Center", val == null ? Integer.toString(this.getCenter()) : val));
        val = this.cust.getSubCenterName(this.getCenter(), this.getSubcenter());
        result.addAttribute(new Attribute("Originating_or_generating_Subcenter", val == null ? Integer.toString(this.getSubcenter()) : val));
        result.addAttribute(new Attribute("GRIB_table_version", this.getMaster() + "," + this.getLocal()));
        this.addGlobalAttributes((AttributeContainer)result);
        result.addAttribute(new Attribute("Conventions", "CF-1.6"));
        result.addAttribute(new Attribute("history", "Read using CDM IOSP GribCollection v3"));
        result.addAttribute(new Attribute("featureType", FeatureType.GRID.name()));
        return result;
    }

    public abstract void addGlobalAttributes(AttributeContainer var1);

    public abstract void addVariableAttributes(AttributeContainer var1, VariableIndex var2);

    protected abstract String makeVariableId(VariableIndex var1);

    @Override
    public synchronized void close() throws IOException {
        if (this.objCache != null && this.objCache.release((FileCacheable)this)) {
            return;
        }
    }

    public void release() throws IOException {
    }

    public void reacquire() throws IOException {
    }

    public String getLocation() {
        return this.indexFilename;
    }

    public long getLastModified() {
        File indexFile = new File(this.indexFilename);
        return indexFile.lastModified();
    }

    public synchronized void setFileCache(FileCacheIF fileCache) {
        this.objCache = fileCache;
    }

    public void showStatus(Formatter f) {
        this.showIndexFile(f);
        f.format("Class (%s)%n", this.getClass().getName());
        f.format("%s%n%n", this.info.toString());
        f.format("masterRuntime: size=%d%n", this.masterRuntime.getSize());
        if (this.masterRuntime.getSize() < 20) {
            this.masterRuntime.showCoords(f);
        }
        for (Dataset ds : this.datasets) {
            f.format("%nDataset %s%n", new Object[]{ds.getType()});
            for (GroupGC g : ds.groups) {
                int nrecords = 0;
                int ndups = 0;
                int nmissing = 0;
                f.format(" Group %s%n", g.horizCoordSys.getId());
                for (VariableIndex v : g.variList) {
                    f.format("  %s%n", v.toStringFrom());
                    nrecords += v.nrecords;
                    ndups += v.ndups;
                    nmissing += v.nmissing;
                }
                f.format(" Group total nrecords=%d", nrecords);
                f.format(", ndups=%d", ndups);
                f.format(", nmiss=%d%n", nmissing);
                int nruntimes = 0;
                int ntimes = 0;
                int ntimes2D = 0;
                int ntimeIntvs = 0;
                for (Coordinate coord : g.getCoordinates()) {
                    if (coord.getType() == Coordinate.Type.runtime) {
                        ++nruntimes;
                    }
                    if (coord.getType() == Coordinate.Type.time) {
                        ++ntimes;
                    }
                    if (coord.getType() == Coordinate.Type.timeIntv) {
                        ++ntimeIntvs;
                    }
                    if (coord.getType() != Coordinate.Type.time2D) continue;
                    ++ntimes2D;
                }
                f.format(" Group nruntimes=%d ntimes=%d ntimeIntvs=%d ntimes2D=%d%n", nruntimes, ntimes, ntimeIntvs, ntimes2D);
            }
        }
        if (this.fileMap == null) {
            f.format("%nFiles empty%n", new Object[0]);
        } else {
            f.format("%nFiles count = %d%n", this.fileMap.size());
            Iterator<Object> iterator = this.fileMap.keySet().iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                f.format("  %d: %s%n", index, this.fileMap.get(index));
            }
            f.format("%n", new Object[0]);
        }
    }

    public void showStatusSummary(Formatter f, String type) {
        Dataset ds = this.getDatasetCanonical();
        if (ds == null) {
            return;
        }
        if (type.equalsIgnoreCase("csv")) {
            for (GroupGC g : ds.groups) {
                int nrecords = 0;
                int ndups = 0;
                int nmissing = 0;
                for (VariableIndex v : g.variList) {
                    nrecords += v.nrecords;
                    ndups += v.ndups;
                    nmissing += v.nmissing;
                }
                if (nrecords == 0) {
                    nrecords = 1;
                }
                f.format("%s, %s, %s, %s, %d, %d, %f, %d, %f%n", new Object[]{this.name, this.config.type, ds.getType(), g.getDescription(), nrecords, ndups, Float.valueOf((float)ndups / (float)nrecords), nmissing, Float.valueOf((float)nmissing / (float)nrecords)});
            }
        } else {
            for (GroupGC g : ds.groups) {
                int nrecords = 0;
                int ndups = 0;
                int nmissing = 0;
                for (VariableIndex v : g.variList) {
                    nrecords += v.nrecords;
                    ndups += v.ndups;
                    nmissing += v.nmissing;
                }
                f.format(" Group %s (%s) total nrecords=%d", new Object[]{g.getDescription(), ds.getType(), nrecords});
                if (nrecords == 0) {
                    nrecords = 1;
                }
                f.format(", ndups=%d (%f)", ndups, Float.valueOf((float)ndups / (float)nrecords));
                f.format(", nmiss=%d (%f)%n", nmissing, Float.valueOf((float)nmissing / (float)nrecords));
            }
        }
    }

    public void showIndexFile(Formatter f) {
        if (this.indexFilename == null) {
            return;
        }
        f.format("indexFile=%s%n", this.indexFilename);
        try {
            Path indexFile = Paths.get(this.indexFilename, new String[0]);
            BasicFileAttributes attr = Files.readAttributes(indexFile, BasicFileAttributes.class, new LinkOption[0]);
            f.format("  size=%d lastModifiedTime=%s lastAccessTime=%s creationTime=%s%n", attr.size(), attr.lastModifiedTime(), attr.lastAccessTime(), attr.creationTime());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        f.format("%n", new Object[0]);
    }

    public void showIndex(Formatter f) {
        this.showIndexFile(f);
        f.format("Class (%s)%n", this.getClass().getName());
        f.format(" version %d%n", this.info.version);
        f.format("%s%n%n", this.toString());
        f.format("%s%n%n", this.info.toString());
        f.format("masterRuntime: size=%d%n", this.masterRuntime.getSize());
        if (this.masterRuntime.getSize() < 200) {
            this.masterRuntime.showCoords(f);
        }
        for (Dataset ds : this.datasets) {
            f.format("%nDataset %s%n", new Object[]{ds.getType()});
            for (GroupGC g : ds.groups) {
                f.format(" Group %s%n", g.horizCoordSys.getId());
                for (VariableIndex v : g.variList) {
                    f.format("  %s%n", v.toStringFrom());
                }
            }
        }
        f.format("%n", new Object[0]);
        if (this.fileMap == null) {
            f.format("Files empty%n", new Object[0]);
        } else {
            f.format("Files count = %d%n", this.fileMap.size());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GribCollectionImmutable{");
        sb.append("\n name='").append(this.name).append('\'');
        sb.append("\n directory=").append(this.directory);
        sb.append("\n config=").append(this.config);
        sb.append("\n isGrib1=").append(this.isGrib1);
        sb.append("\n dateRange=").append(this.dateRange);
        sb.append("\n}");
        return sb.toString();
    }

    public long getIndexFileSize() {
        File indexFile = new File(this.indexFilename);
        return indexFile.length();
    }

    public MFile getFile(int fileno) {
        return this.fileMap.get(fileno);
    }

    public String getFilename(int fileno) {
        return this.fileMap.get(fileno).getPath();
    }

    public String getFirstFilename() {
        return null;
    }

    public Collection<MFile> getFiles() {
        return this.fileMap.values();
    }

    public MFile findMFileByName(String filename) {
        for (MFile file : this.fileMap.values()) {
            if (!file.getName().equals(filename)) continue;
            return file;
        }
        return null;
    }

    public RandomAccessFile getDataRaf(int fileno) throws IOException {
        MFile mfile = this.fileMap.get(fileno);
        String filename = mfile.getPath();
        File dataFile = new File(filename);
        if (!dataFile.exists()) {
            dataFile = this.fileMap.size() == 1 ? new File(this.directory, this.name) : new File(this.directory, dataFile.getName());
        }
        if (!dataFile.exists()) {
            throw new FileNotFoundException("data file not found = " + dataFile.getPath());
        }
        RandomAccessFile want = RandomAccessFile.acquire((String)dataFile.getPath());
        want.order(0);
        return want;
    }

    public String getDataRafFilename(int fileno) throws IOException {
        MFile mfile = this.fileMap.get(fileno);
        return mfile.getPath();
    }

    public abstract NetcdfDataset getNetcdfDataset(Dataset var1, GroupGC var2, String var3, FeatureCollectionConfig var4, Formatter var5, Logger var6) throws IOException;

    public abstract GridDataset getGridDataset(Dataset var1, GroupGC var2, String var3, FeatureCollectionConfig var4, Formatter var5, Logger var6) throws IOException;

    public abstract CoverageCollection getGridCoverage(Dataset var1, GroupGC var2, String var3, FeatureCollectionConfig var4, Formatter var5, Logger var6) throws IOException;

    @Immutable
    public static class Record {
        public final int fileno;
        public final long pos;
        public final int bmsOffset;
        public final int drsOffset;

        public Record(int fileno, long pos, int bmsOffset, int drsOffset) {
            this.fileno = fileno;
            this.pos = pos;
            this.bmsOffset = bmsOffset;
            this.drsOffset = drsOffset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GribCollection.Record{");
            sb.append("fileno=").append(this.fileno);
            sb.append(", startPos=").append(this.pos);
            sb.append(", bmsOffset=").append(this.bmsOffset);
            sb.append(", drsOffset=").append(this.drsOffset);
            sb.append('}');
            return sb.toString();
        }
    }

    @Immutable
    public class VariableIndex {
        final GroupGC group;
        final Info info;
        final Object gribVariable;
        final List<Integer> coordIndex;
        final long recordsPos;
        final int recordsLen;
        final int ndups;
        final int nrecords;
        final int nmissing;
        private SparseArray<Record> sa;

        protected VariableIndex(GroupGC g, GribCollectionMutable.VariableIndex gcVar) {
            this.group = g;
            this.info = new Info(gcVar);
            this.gribVariable = gcVar.gribVariable;
            this.coordIndex = gcVar.coordIndex;
            this.recordsPos = gcVar.recordsPos;
            this.recordsLen = gcVar.recordsLen;
            this.ndups = gcVar.ndups;
            this.nrecords = gcVar.nrecords;
            this.nmissing = gcVar.nmissing;
        }

        public synchronized void readRecords() throws IOException {
            if (this.sa != null) {
                return;
            }
            if (this.recordsLen == 0) {
                return;
            }
            byte[] b = new byte[this.recordsLen];
            try (RandomAccessFile indexRaf = RandomAccessFile.acquire((String)GribCollectionImmutable.this.indexFilename);){
                indexRaf.seek(this.recordsPos);
                indexRaf.readFully(b);
                GribCollectionProto.SparseArray proto = GribCollectionProto.SparseArray.parseFrom(b);
                int nsizes = proto.getSizeCount();
                int[] size = new int[nsizes];
                for (int i = 0; i < nsizes; ++i) {
                    size[i] = proto.getSize(i);
                }
                int ntrack = proto.getTrackCount();
                int[] track = new int[ntrack];
                for (int i = 0; i < ntrack; ++i) {
                    track[i] = proto.getTrack(i);
                }
                int n = proto.getRecordsCount();
                ArrayList<Record> records = new ArrayList<Record>(n);
                for (int i = 0; i < n; ++i) {
                    GribCollectionProto.Record pr = proto.getRecords(i);
                    records.add(new Record(pr.getFileno(), pr.getStartPos(), pr.getBmsOffset(), pr.getDrsOffset()));
                }
                int ndups = proto.getNdups();
                this.sa = new SparseArray(size, track, records, ndups);
            }
            catch (InvalidProtocolBufferException e) {
                logger.error(" file={} recordsLen={} recordPos={}", new Object[]{GribCollectionImmutable.this.indexFilename, this.recordsLen, this.recordsPos});
                throw e;
            }
        }

        public synchronized Record getRecordAt(int sourceIndex) {
            return this.sa.getContent(sourceIndex);
        }

        public synchronized Record getRecordAt(int[] sourceIndex) {
            return this.sa.getContent(sourceIndex);
        }

        public synchronized Record getRecordAt(SubsetParams coords) {
            int[] want = new int[this.getRank()];
            int count = 0;
            int runIdx = -1;
            for (Coordinate coord : this.getCoordinates()) {
                int idx = -1;
                switch (coord.getType()) {
                    case runtime: {
                        CalendarDate runtimeCooord = coords.getRunTime();
                        runIdx = idx = coord.getIndex(runtimeCooord);
                        break;
                    }
                    case timeIntv: {
                        double[] timeIntv = coords.getTimeOffsetIntv();
                        idx = coord.getIndex(new TimeCoord.Tinv((int)timeIntv[0], (int)timeIntv[1]));
                        break;
                    }
                    case time: {
                        Double timeOffset = coords.getTimeOffset();
                        int coordInt = timeOffset.intValue();
                        idx = coord.getIndex(coordInt);
                        break;
                    }
                    case time2D: {
                        int coordInt;
                        double[] timeIntv = coords.getTimeOffsetIntv();
                        if (timeIntv != null) {
                            TimeCoord.Tinv coordTinv = new TimeCoord.Tinv((int)timeIntv[0], (int)timeIntv[1]);
                            idx = ((CoordinateTime2D)coord).findTimeIndexFromVal(runIdx, coordTinv);
                            break;
                        }
                        Double timeCoord = coords.getTimeOffset();
                        if (timeCoord != null) {
                            coordInt = timeCoord.intValue();
                            idx = ((CoordinateTime2D)coord).findTimeIndexFromVal(runIdx, coordInt);
                            break;
                        }
                        CoordinateTime2D coord2D = (CoordinateTime2D)coord;
                        if (coord2D.getNtimes() == 1) {
                            idx = 0;
                            break;
                        }
                        throw new IllegalStateException("time2D must have timeOffset ot timeOffsetIntv coordinare");
                    }
                    case vert: {
                        double[] vertIntv = coords.getVertCoordIntv();
                        if (vertIntv != null) {
                            VertCoord.Level coordVert = new VertCoord.Level(vertIntv[0], vertIntv[1]);
                            idx = coord.getIndex(coordVert);
                            break;
                        }
                        Double vertCoord = coords.getVertCoord();
                        if (vertCoord == null) break;
                        VertCoord.Level coordVert = new VertCoord.Level(vertCoord);
                        idx = coord.getIndex(coordVert);
                        break;
                    }
                    case ens: {
                        Double ensVal = coords.getEnsCoord();
                        idx = ((CoordinateEns)coord).getIndexByMember(ensVal);
                        break;
                    }
                    default: {
                        logger.warn("GribCollectionImmutable: missing CoordVal for {}%n", (Object)coord.getName());
                    }
                }
                if (idx < 0) {
                    logger.debug("Cant find index for value in axis {} in variable {}", (Object)coord.getName(), (Object)GribCollectionImmutable.this.name);
                    return null;
                }
                want[count++] = idx;
            }
            return this.sa.getContent(want);
        }

        public List<Coordinate> getCoordinates() {
            ArrayList<Coordinate> result = new ArrayList<Coordinate>(this.coordIndex.size());
            for (int idx : this.coordIndex) {
                result.add(this.group.coords.get(idx));
            }
            return result;
        }

        public Coordinate getCoordinate(Coordinate.Type want) {
            for (int idx : this.coordIndex) {
                if (this.group.coords.get(idx).getType() != want) continue;
                return this.group.coords.get(idx);
            }
            return null;
        }

        public CoordinateTimeAbstract getCoordinateTime() {
            for (int idx : this.coordIndex) {
                if (!(this.group.coords.get(idx) instanceof CoordinateTimeAbstract)) continue;
                return (CoordinateTimeAbstract)this.group.coords.get(idx);
            }
            return null;
        }

        public Coordinate getCoordinate(int index) {
            int grpIndex = this.coordIndex.get(index);
            return this.group.coords.get(grpIndex);
        }

        public Iterable<Integer> getCoordinateIndex() {
            return this.coordIndex;
        }

        public SparseArray<Record> getSparseArray() {
            return this.sa;
        }

        public int getNRecords() {
            return this.sa == null ? -1 : this.sa.countNotMissing();
        }

        public int getTableVersion() {
            return this.info.tableVersion;
        }

        public int getDiscipline() {
            return this.info.discipline;
        }

        public int getCategory() {
            return this.info.category;
        }

        public int getParameter() {
            return this.info.parameter;
        }

        public int getLevelType() {
            return this.info.levelType;
        }

        public int getIntvType() {
            return this.info.intvType;
        }

        public int getSpatialStatisticalProcessType() {
            return this.info.spatialStatType;
        }

        public int getEnsDerivedType() {
            return this.info.ensDerivedType;
        }

        public int getProbType() {
            return this.info.probType;
        }

        public String getIntvName() {
            return this.info.intvName;
        }

        public String getProbabilityName() {
            return this.info.probabilityName;
        }

        public boolean isLayer() {
            return this.info.isLayer;
        }

        public boolean isEnsemble() {
            return this.info.isEnsemble;
        }

        public int getGenProcessType() {
            return this.info.genProcessType;
        }

        public int getNdups() {
            return this.ndups;
        }

        public GroupGC getGroup() {
            return this.group;
        }

        public int getNmissing() {
            return this.nmissing;
        }

        public int getNrecords() {
            return this.nrecords;
        }

        public int getSize() {
            int size = 1;
            for (int idx : this.coordIndex) {
                Coordinate c = this.group.coords.get(idx);
                int csize = c instanceof CoordinateTime2D ? ((CoordinateTime2D)c).getNtimes() : c.getSize();
                size *= csize;
            }
            return size;
        }

        public int getRank() {
            return this.coordIndex.size();
        }

        public String toStringFrom() {
            Formatter sb = new Formatter();
            sb.format("Variable {%d-%d-%d", this.info.discipline, this.info.category, this.info.parameter);
            sb.format(", levelType=%d", this.info.levelType);
            sb.format(", intvType=%d", this.info.intvType);
            sb.format(", nrecords=%d", this.nrecords);
            sb.format(", ndups=%d", this.ndups);
            sb.format(", nmiss=%d}", this.nmissing);
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariableIndex that = (VariableIndex)o;
            return this.gribVariable.equals(that.gribVariable);
        }

        public int hashCode() {
            return this.gribVariable.hashCode();
        }

        public String makeVariableName() {
            if (GribCollectionImmutable.this.isGrib1) {
                return ((Grib1Variable)this.gribVariable).makeVariableName(GribCollectionImmutable.this.config.gribConfig);
            }
            return Grib2Iosp.makeVariableNameFromTable((Grib2Customizer)GribCollectionImmutable.this.cust, GribCollectionImmutable.this, this, GribCollectionImmutable.this.config.gribConfig.useGenType);
        }

        public String makeVariableUnits() {
            if (GribCollectionImmutable.this.isGrib1) {
                return Grib1Iosp.makeVariableUnits((Grib1Customizer)GribCollectionImmutable.this.cust, GribCollectionImmutable.this, this);
            }
            return Grib2Iosp.makeVariableUnits((Grib2Customizer)GribCollectionImmutable.this.cust, this);
        }

        public String makeVariableDescription() {
            if (GribCollectionImmutable.this.isGrib1) {
                return Grib1Iosp.makeVariableLongName((Grib1Customizer)GribCollectionImmutable.this.cust, GribCollectionImmutable.this.getCenter(), GribCollectionImmutable.this.getSubcenter(), this.getTableVersion(), this.getParameter(), this.getLevelType(), this.isLayer(), this.getIntvType(), this.getIntvName(), this.getProbabilityName());
            }
            return Grib2Iosp.makeVariableLongName((Grib2Customizer)GribCollectionImmutable.this.cust, this, GribCollectionImmutable.this.config.gribConfig.useGenType);
        }

        public GribTables.Parameter getGribParameter() {
            if (GribCollectionImmutable.this.isGrib1) {
                return ((Grib1Customizer)GribCollectionImmutable.this.cust).getParameter(GribCollectionImmutable.this.getCenter(), GribCollectionImmutable.this.getSubcenter(), GribCollectionImmutable.this.getVersion(), this.getParameter());
            }
            return ((Grib2Customizer)GribCollectionImmutable.this.cust).getParameter(this.getDiscipline(), this.getCategory(), this.getParameter());
        }

        public GribStatType getStatType() {
            return GribCollectionImmutable.this.cust.getStatType(this.getIntvType());
        }

        @Immutable
        public final class Info {
            final int tableVersion;
            final int discipline;
            final int category;
            final int parameter;
            final int levelType;
            final int intvType;
            final int ensDerivedType;
            final int probType;
            final String intvName;
            final String probabilityName;
            final boolean isLayer;
            final boolean isEnsemble;
            final int genProcessType;
            final int spatialStatType;

            public Info(GribCollectionMutable.VariableIndex gcVar) {
                this.tableVersion = gcVar.tableVersion;
                this.discipline = gcVar.discipline;
                this.category = gcVar.category;
                this.parameter = gcVar.parameter;
                this.levelType = gcVar.levelType;
                this.intvType = gcVar.intvType;
                this.ensDerivedType = gcVar.ensDerivedType;
                this.probType = gcVar.probType;
                this.intvName = gcVar.getTimeIntvName();
                this.probabilityName = gcVar.probabilityName;
                this.isLayer = gcVar.isLayer;
                this.isEnsemble = gcVar.isEnsemble;
                this.genProcessType = gcVar.genProcessType;
                this.spatialStatType = gcVar.spatialStatType;
            }
        }
    }

    @Immutable
    public class GroupGC {
        final Dataset ds;
        public final GribHorizCoordSystem horizCoordSys;
        final List<VariableIndex> variList;
        final List<Coordinate> coords;
        final int[] filenose;
        private final Map<VariableIndex, VariableIndex> varMap;

        public GroupGC(Dataset ds, GribCollectionMutable.GroupGC gc) {
            this.ds = ds;
            this.horizCoordSys = gc.horizCoordSys;
            this.coords = gc.coords;
            this.filenose = gc.filenose;
            this.varMap = new HashMap<VariableIndex, VariableIndex>(gc.variList.size() * 2);
            List<GribCollectionMutable.VariableIndex> gcVars = gc.variList;
            ArrayList<VariableIndex> work = new ArrayList<VariableIndex>(gcVars.size());
            for (GribCollectionMutable.VariableIndex gcVar : gcVars) {
                VariableIndex vi = GribCollectionImmutable.this.makeVariableIndex(this, gcVar);
                work.add(vi);
                this.varMap.put(vi, vi);
            }
            this.variList = Collections.unmodifiableList(work);
        }

        public Type getType() {
            return this.ds.gctype;
        }

        public String getId() {
            return this.horizCoordSys.getId();
        }

        public Object getGdsHash() {
            return this.horizCoordSys.getGdsHash();
        }

        public GribCollectionImmutable getGribCollection() {
            return GribCollectionImmutable.this;
        }

        public String getDescription() {
            return this.horizCoordSys.getDescription();
        }

        public GribHorizCoordSystem getGribHorizCoordSys() {
            return this.horizCoordSys;
        }

        public GdsHorizCoordSys getGdsHorizCoordSys() {
            return this.horizCoordSys.getHcs();
        }

        public VariableIndex findVariableByHash(VariableIndex vi) {
            return this.varMap.get(vi);
        }

        public Optional<Coordinate> findCoordinate(String name) {
            return this.coords.stream().filter(x -> x.getName().equals(name)).findFirst();
        }

        public List<VariableIndex> getVariables() {
            return this.variList;
        }

        public List<Coordinate> getCoordinates() {
            return this.coords;
        }

        public int getNruntimes() {
            return GribCollectionImmutable.this.masterRuntime.getSize();
        }

        public int getNFiles() {
            if (this.filenose == null) {
                return 0;
            }
            return this.filenose.length;
        }

        public List<MFile> getFiles() {
            ArrayList<MFile> result = new ArrayList<MFile>();
            if (this.filenose == null) {
                return result;
            }
            for (int fileno : this.filenose) {
                result.add(GribCollectionImmutable.this.fileMap.get(fileno));
            }
            Collections.sort(result);
            return result;
        }

        public CalendarDateRange makeCalendarDateRange() {
            CalendarDateRange result = null;
            for (Coordinate coord : this.coords) {
                switch (coord.getType()) {
                    case time: 
                    case timeIntv: 
                    case time2D: {
                        CoordinateTimeAbstract time = (CoordinateTimeAbstract)coord;
                        CalendarDateRange range = time.makeCalendarDateRange(null);
                        result = result == null ? range : result.extend(range);
                    }
                }
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GroupGC{");
            sb.append(GribCollectionImmutable.this.getName());
            sb.append(" gctype=").append((Object)this.ds.gctype);
            sb.append('}');
            return sb.toString();
        }

        public void show(Formatter f) {
            f.format("Group %s (%d) type=%s%n", new Object[]{this.horizCoordSys.getId(), this.horizCoordSys.getGdsHash().hashCode(), this.ds.gctype});
            f.format(" nfiles %d%n", this.filenose == null ? 0 : this.filenose.length);
            f.format(" hcs = %s%n", this.horizCoordSys.getHcs());
        }
    }

    @Immutable
    public class Dataset {
        final Type gctype;
        final List<GroupGC> groups;

        public Dataset(Type gctype, List<GribCollectionMutable.GroupGC> groups) {
            this.gctype = gctype;
            ArrayList<GroupGC> work = new ArrayList<GroupGC>(groups.size());
            for (GribCollectionMutable.GroupGC gcGroup : groups) {
                work.add(new GroupGC(this, gcGroup));
            }
            this.groups = Collections.unmodifiableList(work);
        }

        public Iterable<GroupGC> getGroups() {
            return this.groups;
        }

        public int getGroupsSize() {
            return this.groups.size();
        }

        public Type getType() {
            return this.gctype;
        }

        public GroupGC getGroup(int index) {
            return this.groups.get(index);
        }

        public GroupGC findGroupById(String id) {
            for (GroupGC g : this.getGroups()) {
                if (!g.getId().equals(id)) continue;
                return g;
            }
            return null;
        }
    }

    public static class Info {
        final int version;
        final int center;
        final int subcenter;
        final int master;
        final int local;
        final int genProcessType;
        final int genProcessId;
        final int backProcessId;

        public Info(int version, int center, int subcenter, int master, int local, int genProcessType, int genProcessId, int backProcessId) {
            this.version = version;
            this.center = center;
            this.subcenter = subcenter;
            this.master = master;
            this.local = local;
            this.genProcessType = genProcessType;
            this.genProcessId = genProcessId;
            this.backProcessId = backProcessId;
        }

        public Info(GribCollectionMutable gc) {
            this.version = gc.version;
            this.center = gc.center;
            this.subcenter = gc.subcenter;
            this.master = gc.master;
            this.local = gc.local;
            this.genProcessType = gc.genProcessType;
            this.genProcessId = gc.genProcessId;
            this.backProcessId = gc.backProcessId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Info{");
            sb.append("version=").append(this.version);
            sb.append(", center=").append(this.center);
            sb.append(", subcenter=").append(this.subcenter);
            sb.append(", master=").append(this.master);
            sb.append(", local=").append(this.local);
            sb.append(", genProcessType=").append(this.genProcessType);
            sb.append(", genProcessId=").append(this.genProcessId);
            sb.append(", backProcessId=").append(this.backProcessId);
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum Type {
        SRC,
        MRC,
        MRUTC,
        TwoD,
        Best,
        BestComplete,
        MRUTP;


        public boolean isSingleRuntime() {
            return this == SRC;
        }

        public boolean isUniqueTime() {
            return this == MRUTC || this == MRUTP || this == SRC;
        }

        public boolean isTwoD() {
            return this == MRC || this == TwoD;
        }
    }
}

