/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilderImpl;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.util.Counters;
import ucar.nc2.util.Indent;

@Immutable
public class CoordinateVert
implements Coordinate {
    private final List<VertCoord.Level> levelSorted;
    private final int code;
    private String name;
    private final VertCoord.VertUnit vunit;
    private final boolean isLayer;

    public CoordinateVert(int code, VertCoord.VertUnit vunit, List<VertCoord.Level> levelSorted) {
        this.levelSorted = Collections.unmodifiableList(levelSorted);
        this.code = code;
        this.vunit = vunit;
        this.isLayer = levelSorted.get(0).isLayer();
    }

    public List<VertCoord.Level> getLevelSorted() {
        return this.levelSorted;
    }

    @Override
    public List<? extends Object> getValues() {
        return this.levelSorted;
    }

    @Override
    public int getIndex(Object val) {
        return this.levelSorted.indexOf(val);
    }

    @Override
    public Object getValue(int idx) {
        if (idx >= this.levelSorted.size()) {
            return null;
        }
        return this.levelSorted.get(idx);
    }

    @Override
    public int getSize() {
        return this.levelSorted.size();
    }

    @Override
    public int getNCoords() {
        return this.getSize();
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.vert;
    }

    @Override
    public int estMemorySize() {
        return 160 + this.getSize() * 44;
    }

    @Override
    public String getUnit() {
        return this.vunit == null ? null : this.vunit.getUnits();
    }

    public VertCoord.VertUnit getVertUnit() {
        return this.vunit;
    }

    public boolean isLayer() {
        return this.isLayer;
    }

    public boolean isPositiveUp() {
        return this.vunit.isPositiveUp();
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("Cant modify");
        }
        this.name = name;
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s%s: ", new Object[]{indent, this.getType()});
        for (VertCoord.Level level : this.levelSorted) {
            info.format(" %s", level);
        }
        info.format(" (%d)%n", this.levelSorted.size());
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("Levels: (%s)%n", this.getUnit());
        for (VertCoord.Level level : this.levelSorted) {
            info.format("   %s%n", level);
        }
    }

    @Override
    public Counters calcDistributions() {
        Counters counters = new Counters();
        counters.add("resol");
        if (this.isLayer) {
            counters.add("intv");
            for (int i = 0; i < this.levelSorted.size(); ++i) {
                double intv = this.levelSorted.get(i).getValue2() - this.levelSorted.get(i).getValue1();
                counters.count("intv", (Comparable)Double.valueOf(intv));
                if (i >= this.levelSorted.size() - 1) continue;
                double resol = this.levelSorted.get(i + 1).getValue1() - this.levelSorted.get(i).getValue1();
                counters.count("resol", (Comparable)Double.valueOf(resol));
            }
        } else {
            for (int i = 0; i < this.levelSorted.size() - 1; ++i) {
                double diff = this.levelSorted.get(i + 1).getValue1() - this.levelSorted.get(i).getValue1();
                counters.count("resol", (Comparable)Double.valueOf(diff));
            }
        }
        return counters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateVert that = (CoordinateVert)o;
        if (this.code != that.code) {
            return false;
        }
        return this.levelSorted.equals(that.levelSorted);
    }

    public int hashCode() {
        int result = this.levelSorted.hashCode();
        result = 31 * result + this.code;
        return result;
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record> {
        int code;
        Grib1Customizer cust;

        public Builder1(Grib1Customizer cust, int code) {
            this.cust = cust;
            this.code = code;
        }

        @Override
        public Object extract(Grib1Record gr) {
            Grib1SectionProductDefinition pds = gr.getPDSsection();
            boolean isLayer = this.cust.isLayer(pds.getLevelType());
            Grib1ParamLevel plevel = this.cust.getParamLevel(pds);
            if (isLayer) {
                return new VertCoord.Level(plevel.getValue1(), plevel.getValue2());
            }
            return new VertCoord.Level(plevel.getValue1());
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<VertCoord.Level> levelSorted = new ArrayList<VertCoord.Level>(values.size());
            for (Object val : values) {
                levelSorted.add((VertCoord.Level)val);
            }
            Collections.sort(levelSorted);
            return new CoordinateVert(this.code, this.cust.getVertUnit(this.code), levelSorted);
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record> {
        int code;
        VertCoord.VertUnit vunit;

        public Builder2(int code, VertCoord.VertUnit vunit) {
            this.code = code;
            this.vunit = vunit;
        }

        @Override
        public Object extract(Grib2Record gr) {
            Grib2Pds pds = gr.getPDS();
            if (Grib2Utils.isLayer(pds)) {
                return new VertCoord.Level(pds.getLevelValue1(), pds.getLevelValue2());
            }
            return new VertCoord.Level(pds.getLevelValue1());
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<VertCoord.Level> levelSorted = new ArrayList<VertCoord.Level>(values.size());
            for (Object val : values) {
                levelSorted.add((VertCoord.Level)val);
            }
            Collections.sort(levelSorted);
            return new CoordinateVert(this.code, this.vunit, levelSorted);
        }
    }
}

