/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.collection.Grib2Iosp;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.http.HTTPRandomAccessFile;

public class Grib1Iosp
extends GribIosp {
    private static final Logger logger = LoggerFactory.getLogger(Grib2Iosp.class);
    private Grib1Customizer cust;

    @Override
    public String makeVariableName(GribCollectionImmutable.VariableIndex v) {
        return this.makeVariableNameFromTables(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), v.getTableVersion(), v.getParameter(), v.getLevelType(), v.isLayer(), v.getIntvType(), v.getIntvName());
    }

    public static String makeVariableName(Grib1Customizer cust, FeatureCollectionConfig.GribConfig gribConfig, Grib1SectionProductDefinition pds) {
        return Grib1Iosp.makeVariableNameFromTables(cust, gribConfig, pds.getCenter(), pds.getSubCenter(), pds.getTableVersion(), pds.getParameterNumber(), pds.getLevelType(), cust.isLayer(pds.getLevelType()), pds.getTimeRangeIndicator(), null);
    }

    private String makeVariableNameFromTables(int center, int subcenter, int version, int paramNo, int levelType, boolean isLayer, int intvType, String intvName) {
        return Grib1Iosp.makeVariableNameFromTables(this.cust, this.config.gribConfig, center, subcenter, version, paramNo, levelType, isLayer, intvType, intvName);
    }

    private static String makeVariableNameFromTables(Grib1Customizer cust, FeatureCollectionConfig.GribConfig gribConfig, int center, int subcenter, int version, int paramNo, int levelType, boolean isLayer, int timeRangeIndicator, String intvName) {
        try (Formatter f = new Formatter();){
            Grib1Parameter param = cust.getParameter(center, subcenter, version, paramNo);
            if (param == null) {
                f.format("VAR%d-%d-%d-%d", center, subcenter, version, paramNo);
            } else if (param.useName()) {
                f.format("%s", param.getName());
            } else {
                f.format("%s", GribUtils.makeNameFromDescription(param.getDescription()));
            }
            if (gribConfig.useTableVersion) {
                f.format("_TableVersion%d", version);
            }
            if (gribConfig.useCenter) {
                f.format("_Center%d", center);
            }
            if (levelType != -9999) {
                f.format("_%s", cust.getLevelNameShort(levelType));
                if (isLayer) {
                    f.format("_layer", new Object[0]);
                }
            }
            if (timeRangeIndicator >= 0) {
                GribStatType stat = cust.getStatType(timeRangeIndicator);
                if (stat != null) {
                    if (intvName != null) {
                        f.format("_%s", intvName);
                    }
                    f.format("_%s", stat.name());
                } else if (intvName != null) {
                    f.format("_%s", intvName);
                }
            }
            String string = f.toString();
            return string;
        }
    }

    @Override
    public String makeVariableLongName(GribCollectionImmutable.VariableIndex v) {
        return this.makeVariableLongName(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), v.getTableVersion(), v.getParameter(), v.getLevelType(), v.isLayer(), v.getIntvType(), v.getIntvName(), v.getProbabilityName());
    }

    private String makeVariableLongName(int center, int subcenter, int version, int paramNo, int levelType, boolean isLayer, int intvType, String intvName, String probabilityName) {
        return Grib1Iosp.makeVariableLongName(this.cust, center, subcenter, version, paramNo, levelType, isLayer, intvType, intvName, probabilityName);
    }

    static String makeVariableLongName(Grib1Customizer cust, int center, int subcenter, int version, int paramNo, int levelType, boolean isLayer, int intvType, String intvName, String probabilityName) {
        try (Formatter f = new Formatter();){
            Grib1Parameter param;
            boolean isProb;
            boolean bl = isProb = probabilityName != null && probabilityName.length() > 0;
            if (isProb) {
                f.format("Probability ", new Object[0]);
            }
            if ((param = cust.getParameter(center, subcenter, version, paramNo)) == null) {
                f.format("Unknown Parameter %d-%d-%d-%d", center, subcenter, version, paramNo);
            } else {
                f.format("%s", param.getDescription());
            }
            if (intvType >= 0) {
                GribStatType stat = cust.getStatType(intvType);
                if (stat != null) {
                    f.format(" (%s %s)", intvName, stat.name());
                } else if (intvName != null && intvName.length() > 0) {
                    f.format(" (%s)", intvName);
                }
            }
            if (levelType != -9999) {
                f.format(" @ %s", cust.getLevelDescription(levelType));
                if (isLayer) {
                    f.format(" layer", new Object[0]);
                }
            }
            String string = f.toString();
            return string;
        }
    }

    @Override
    protected String makeVariableUnits(GribCollectionImmutable.VariableIndex vindex) {
        return this.makeVariableUnits(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), vindex.getTableVersion(), vindex.getParameter());
    }

    private String makeVariableUnits(int center, int subcenter, int version, int paramNo) {
        Grib1Parameter param = this.cust.getParameter(center, subcenter, version, paramNo);
        String val = param == null ? "" : param.getUnit();
        return val == null ? "" : val;
    }

    static String makeVariableUnits(Grib1Customizer cust, GribCollectionImmutable gribCollection, GribCollectionImmutable.VariableIndex vindex) {
        Grib1Parameter param = cust.getParameter(gribCollection.getCenter(), gribCollection.getSubcenter(), vindex.getTableVersion(), vindex.getParameter());
        String val = param == null ? "" : param.getUnit();
        return val == null ? "" : val;
    }

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        if (raf instanceof HTTPRandomAccessFile) {
            if (raf.length() > (long)raf.getBufferSize()) {
                return false;
            }
        } else {
            GribCdmIndex.GribCollectionType type = GribCdmIndex.getType(raf);
            if (type == GribCdmIndex.GribCollectionType.GRIB1) {
                return true;
            }
            if (type == GribCdmIndex.GribCollectionType.Partition1) {
                return true;
            }
        }
        return Grib1RecordScanner.isValidFile(raf);
    }

    public String getFileTypeId() {
        return DataFormatType.GRIB1.getDescription();
    }

    public String getFileTypeDescription() {
        return "GRIB1 Collection";
    }

    public Grib1Iosp() {
        super(true, logger);
    }

    public Grib1Iosp(GribCollectionImmutable.GroupGC gHcs, GribCollectionImmutable.Type gtype) {
        super(true, logger);
        this.gHcs = gHcs;
        this.owned = true;
        this.gtype = gtype;
    }

    public Grib1Iosp(GribCollectionImmutable gc) {
        super(true, logger);
        this.gribCollection = gc;
        this.owned = true;
    }

    @Override
    protected GribTables createCustomizer() throws IOException {
        Grib1ParamTables tables = this.config.gribConfig.paramTable != null ? Grib1ParamTables.factory(this.config.gribConfig.paramTable) : Grib1ParamTables.factory(this.config.gribConfig.paramTablePath, this.config.gribConfig.lookupTablePath);
        this.cust = Grib1Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), tables);
        return this.cust;
    }

    @Override
    protected String getVerticalCoordDesc(int vc_code) {
        return this.cust.getLevelDescription(vc_code);
    }

    @Override
    protected GribTables.Parameter getParameter(GribCollectionImmutable.VariableIndex vindex) {
        return this.cust.getParameter(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getVersion(), vindex.getParameter());
    }

    @Override
    public Object getLastRecordRead() {
        return Grib1Record.lastRecordRead;
    }

    @Override
    public void clearLastRecordRead() {
        Grib1Record.lastRecordRead = null;
    }

    @Override
    public Object getGribCustomizer() {
        return this.cust;
    }
}

