/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.MFile;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GcMFile;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribHorizCoordSystem;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateEns;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.coord.CoordinateVert;
import ucar.nc2.grib.coord.EnsCoordValue;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.grib.coord.VertCoordValue;
import ucar.nc2.stream.NcStream;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.io.RandomAccessFile;

abstract class GribCollectionBuilderFromIndex {
    protected static final boolean debug = false;
    private static final boolean stackTrace = true;
    protected GribCollectionMutable gc;
    protected final Logger logger;
    protected final FeatureCollectionConfig config;
    protected GribTables tables;
    private final Set<String> hcsNames = new HashSet<String>(5);

    protected abstract GribHorizCoordSystem readGds(GribCollectionProto.Gds var1);

    protected abstract GribTables makeCustomizer() throws IOException;

    protected abstract String getLevelNameShort(int var1);

    protected abstract int getVersion();

    protected abstract int getMinVersion();

    GribCollectionBuilderFromIndex(GribCollectionMutable gc, FeatureCollectionConfig config, Logger logger) {
        this.logger = logger;
        this.config = config;
        this.gc = gc;
    }

    protected abstract String getMagicStart();

    protected boolean readIndex(RandomAccessFile raf) {
        this.gc.setIndexRaf(raf);
        try {
            int i;
            raf.order(0);
            raf.seek(0L);
            if (!NcStream.readAndTest((RandomAccessFile)raf, (byte[])this.getMagicStart().getBytes(CDM.utf8Charset))) {
                raf.seek(0L);
                NcStream.readAndTest((RandomAccessFile)raf, (byte[])this.getMagicStart().getBytes(CDM.utf8Charset));
                this.logger.warn("GribCollectionBuilderFromIndex {}: invalid index raf={}", (Object)this.gc.getName(), (Object)raf.getLocation());
                throw new IllegalStateException();
            }
            this.gc.version = raf.readInt();
            if (this.gc.version < this.getVersion()) {
                this.logger.debug("GribCollectionBuilderFromIndex {}: index found version={}, current version= {} on file {}", new Object[]{this.gc.getName(), this.gc.version, 3, raf.getLocation()});
                if (this.gc.version < this.getMinVersion()) {
                    return false;
                }
            }
            long skip = raf.readLong();
            raf.skipBytes(skip);
            this.logger.debug("GribCollectionBuilderFromIndex %s (%s) records len = %d%n", new Object[]{raf.getLocation(), this.getMagicStart(), skip});
            int size = NcStream.readVInt((RandomAccessFile)raf);
            if (size < 0 || size > 300000000) {
                this.logger.warn("GribCollectionBuilderFromIndex {}: invalid index size", (Object)this.gc.getName(), (Object)raf.getLocation());
                throw new IllegalStateException();
            }
            this.logger.debug("GribCollectionBuilderFromIndex proto len = %d%n", (Object)size);
            byte[] m = new byte[size];
            raf.readFully(m);
            GribCollectionProto.GribCollection proto = GribCollectionProto.GribCollection.parseFrom(m);
            this.gc.center = proto.getCenter();
            this.gc.subcenter = proto.getSubcenter();
            this.gc.master = proto.getMaster();
            this.gc.local = proto.getLocal();
            this.gc.genProcessType = proto.getGenProcessType();
            this.gc.genProcessId = proto.getGenProcessId();
            this.gc.backProcessId = proto.getBackProcessId();
            this.gc.cust = this.tables = this.makeCustomizer();
            if (!this.gc.name.equals(proto.getName())) {
                this.logger.info("GribCollectionBuilderFromIndex raf {}: has different name= '{}' than stored in ncx= '{}' ", new Object[]{raf.getLocation(), this.gc.getName(), proto.getName()});
            }
            this.gc.directory = this.gc.setOrgDirectory(proto.getTopDir());
            this.gc.indexVersion = proto.getVersion();
            this.gc.setCalendarDateRange(proto.getStartTime(), proto.getEndTime());
            int fsize = 0;
            int n = proto.getMfilesCount();
            HashMap<Integer, MFile> fileMap = new HashMap<Integer, MFile>(2 * n);
            for (i = 0; i < n; ++i) {
                GribCollectionProto.MFile mf = proto.getMfiles(i);
                fileMap.put(mf.getIndex(), new GcMFile(this.gc.directory, mf.getFilename(), mf.getLastModified(), mf.getLength(), mf.getIndex()));
                fsize += mf.getFilename().length();
            }
            this.gc.setFileMap(fileMap);
            this.logger.debug("GribCollectionBuilderFromIndex files len = %d%n", (Object)fsize);
            this.gc.masterRuntime = (CoordinateRuntime)this.readCoord(proto.getMasterRuntime());
            this.gc.datasets = new ArrayList<GribCollectionMutable.Dataset>(proto.getDatasetCount());
            for (i = 0; i < proto.getDatasetCount(); ++i) {
                this.readDataset(proto.getDataset(i));
            }
            return this.readExtensions(proto);
        }
        catch (Throwable t) {
            this.logger.warn("Error reading index " + raf.getLocation(), t);
            t.printStackTrace();
            return false;
        }
    }

    protected boolean readExtensions(GribCollectionProto.GribCollection proto) {
        return true;
    }

    protected GribCollectionMutable.VariableIndex readVariableExtensions(GribCollectionMutable.GroupGC group, GribCollectionProto.Variable pv, GribCollectionMutable.VariableIndex vi) {
        group.addVariable(vi);
        return vi;
    }

    private GribCollectionMutable.Dataset readDataset(GribCollectionProto.Dataset p) {
        GribCollectionImmutable.Type type = GribCollectionImmutable.Type.valueOf(p.getType().toString());
        GribCollectionMutable.Dataset ds = this.gc.makeDataset(type);
        ArrayList<GribCollectionMutable.GroupGC> groups = new ArrayList<GribCollectionMutable.GroupGC>(p.getGroupsCount());
        for (int i = 0; i < p.getGroupsCount(); ++i) {
            groups.add(this.readGroup(p.getGroups(i)));
        }
        ds.groups = Collections.unmodifiableList(groups);
        return ds;
    }

    protected GribCollectionMutable.GroupGC readGroup(GribCollectionProto.Group p) {
        int i;
        GribCollectionMutable.GroupGC group = this.gc.makeGroup();
        group.horizCoordSys = this.readGds(p.getGds());
        group.coords = new ArrayList<Coordinate>();
        for (i = 0; i < p.getCoordsCount(); ++i) {
            group.coords.add(this.readCoord(p.getCoords(i)));
        }
        group.filenose = new int[p.getFilenoCount()];
        for (i = 0; i < p.getFilenoCount(); ++i) {
            group.filenose[i] = p.getFileno(i);
        }
        for (i = 0; i < p.getVariablesCount(); ++i) {
            this.readVariable(group, p.getVariables(i));
        }
        int reftimeCoord = 0;
        int timeCoord = 0;
        int ensCoord = 0;
        ArrayList<CoordinateVert> vertCoords = new ArrayList<CoordinateVert>();
        ArrayList<CoordinateTime2D> time2DCoords = new ArrayList<CoordinateTime2D>();
        HashMap<CoordinateRuntime, CoordinateRuntime> runtimes = new HashMap<CoordinateRuntime, CoordinateRuntime>();
        for (Coordinate coord : group.coords) {
            Coordinate.Type type = coord.getType();
            switch (type) {
                case runtime: {
                    CoordinateRuntime reftime = (CoordinateRuntime)coord;
                    if (reftimeCoord > 0) {
                        reftime.setName("reftime" + reftimeCoord);
                    }
                    ++reftimeCoord;
                    runtimes.put(reftime, reftime);
                    break;
                }
                case time: {
                    CoordinateTime tc = (CoordinateTime)coord;
                    if (timeCoord > 0) {
                        tc.setName("time" + timeCoord);
                    }
                    ++timeCoord;
                    break;
                }
                case timeIntv: {
                    CoordinateTimeIntv tci = (CoordinateTimeIntv)coord;
                    if (timeCoord > 0) {
                        tci.setName("time" + timeCoord);
                    }
                    ++timeCoord;
                    break;
                }
                case time2D: {
                    CoordinateTime2D t2d = (CoordinateTime2D)coord;
                    if (timeCoord > 0) {
                        t2d.setName("time" + timeCoord);
                    }
                    ++timeCoord;
                    time2DCoords.add(t2d);
                    break;
                }
                case vert: {
                    vertCoords.add((CoordinateVert)coord);
                    break;
                }
                case ens: {
                    CoordinateEns ce = (CoordinateEns)coord;
                    if (ensCoord > 0) {
                        ce.setName("ens" + ensCoord);
                    }
                    ++ensCoord;
                }
            }
        }
        this.assignVertNames(vertCoords);
        this.assignRuntimeNames(runtimes, time2DCoords, group.getId() + "-" + (group.isTwoD ? "TwoD" : "Best"));
        return group;
    }

    public void assignVertNames(List<CoordinateVert> vertCoords) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2 * vertCoords.size());
        for (CoordinateVert vc : vertCoords) {
            Integer countName;
            String shortName = this.getLevelNameShort(vc.getCode()).toLowerCase();
            if (vc.isLayer()) {
                shortName = shortName + "_layer";
            }
            if ((countName = (Integer)map.get(shortName)) == null) {
                map.put(shortName, 0);
            } else {
                Integer n = countName;
                Integer n2 = countName = Integer.valueOf(countName + 1);
                map.put(shortName, countName);
                shortName = shortName + countName;
            }
            vc.setName(shortName);
        }
    }

    public void assignRuntimeNames(Map<CoordinateRuntime, CoordinateRuntime> runtimes, List<CoordinateTime2D> time2DCoords, String groupId) {
        for (CoordinateTime2D t2d : time2DCoords) {
            CoordinateRuntime runtime2D = t2d.getRuntimeCoordinate();
            CoordinateRuntime runtime = runtimes.get(runtime2D);
            if (runtime == null) {
                this.logger.warn("HEY assignRuntimeNames failed on %s group %s%n", (Object)t2d.getName(), (Object)groupId);
                continue;
            }
            runtime2D.setName(runtime.getName());
        }
    }

    private Coordinate readCoord(GribCollectionProto.Coord pc) {
        Coordinate.Type type = GribCollectionBuilderFromIndex.convertAxisType(pc.getAxisType());
        int code = pc.getCode();
        String unit = pc.getUnit();
        if (unit.length() == 0) {
            unit = null;
        }
        switch (type) {
            case runtime: {
                if (unit == null) {
                    throw new IllegalStateException("Null units");
                }
                CalendarDateUnit cdUnit = CalendarDateUnit.of(null, (String)unit);
                return new CoordinateRuntime(pc.getMsecsList(), cdUnit.getCalendarPeriod());
            }
            case time: {
                ArrayList<Integer> offs = new ArrayList<Integer>(pc.getValuesCount());
                for (float val : pc.getValuesList()) {
                    offs.add((int)val);
                }
                CalendarDate refDate = CalendarDate.of((long)pc.getMsecs(0));
                if (unit == null) {
                    throw new IllegalStateException("Null units");
                }
                CalendarPeriod timeUnit = CalendarPeriod.of((String)unit);
                return new CoordinateTime(code, timeUnit, refDate, offs, this.readTime2Runtime(pc));
            }
            case timeIntv: {
                ArrayList<TimeCoordIntvValue> tinvs = new ArrayList<TimeCoordIntvValue>(pc.getValuesCount());
                for (int i = 0; i < pc.getValuesCount(); ++i) {
                    int val1 = (int)pc.getValues(i);
                    int val2 = (int)pc.getBound(i);
                    tinvs.add(new TimeCoordIntvValue(val1, val2));
                }
                CalendarDate refDate = CalendarDate.of((long)pc.getMsecs(0));
                if (unit == null) {
                    throw new IllegalStateException("Null units");
                }
                CalendarPeriod timeUnit2 = CalendarPeriod.of((String)unit);
                return new CoordinateTimeIntv(code, timeUnit2, refDate, tinvs, this.readTime2Runtime(pc));
            }
            case time2D: {
                if (unit == null) {
                    throw new IllegalStateException("Null units");
                }
                CalendarPeriod timeUnit3 = CalendarPeriod.of((String)unit);
                CoordinateRuntime runtime = new CoordinateRuntime(pc.getMsecsList(), timeUnit3);
                ArrayList<Coordinate> times = new ArrayList<Coordinate>(pc.getTimesCount());
                for (GribCollectionProto.Coord coordp : pc.getTimesList()) {
                    times.add(this.readCoord(coordp));
                }
                boolean isOrthogonal = pc.getIsOrthogonal();
                boolean isRegular = pc.getIsRegular();
                if (isOrthogonal) {
                    return new CoordinateTime2D(code, timeUnit3, null, runtime, (CoordinateTimeAbstract)times.get(0), null, this.readTime2Runtime(pc));
                }
                if (isRegular) {
                    return new CoordinateTime2D(code, timeUnit3, null, runtime, times, null, this.readTime2Runtime(pc));
                }
                return new CoordinateTime2D(code, timeUnit3, null, runtime, times, this.readTime2Runtime(pc));
            }
            case vert: {
                boolean isLayer = pc.getValuesCount() == pc.getBoundCount();
                ArrayList<VertCoordValue> levels = new ArrayList<VertCoordValue>(pc.getValuesCount());
                for (int i = 0; i < pc.getValuesCount(); ++i) {
                    if (isLayer) {
                        levels.add(new VertCoordValue(pc.getValues(i), pc.getBound(i)));
                        continue;
                    }
                    levels.add(new VertCoordValue(pc.getValues(i)));
                }
                return new CoordinateVert(code, this.tables.getVertUnit(code), levels);
            }
            case ens: {
                ArrayList<EnsCoordValue> ecoords = new ArrayList<EnsCoordValue>(pc.getValuesCount());
                for (int i = 0; i < pc.getValuesCount(); ++i) {
                    double val1 = pc.getValues(i);
                    double val2 = pc.getBound(i);
                    ecoords.add(new EnsCoordValue((int)val1, (int)val2));
                }
                return new CoordinateEns(code, ecoords);
            }
        }
        throw new IllegalStateException("Unknown Coordinate type = " + (Object)((Object)type));
    }

    @Nullable
    private int[] readTime2Runtime(GribCollectionProto.Coord pc) {
        if (pc.getTime2RuntimeCount() > 0) {
            int[] time2runtime = new int[pc.getTime2RuntimeCount()];
            for (int i = 0; i < pc.getTime2RuntimeCount(); ++i) {
                time2runtime[i] = pc.getTime2Runtime(i);
            }
            return time2runtime;
        }
        return null;
    }

    private GribCollectionMutable.VariableIndex readVariable(GribCollectionMutable.GroupGC group, GribCollectionProto.Variable pv) {
        int discipline = pv.getDiscipline();
        byte[] rawPds = pv.getPds().toByteArray();
        int nids = pv.getIdsCount();
        int center = nids > 0 ? pv.getIds(0) : 0;
        int subcenter = nids > 1 ? pv.getIds(1) : 0;
        long recordsPos = pv.getRecordsPos();
        int recordsLen = pv.getRecordsLen();
        List<Integer> index = pv.getCoordIdxList();
        GribCollectionMutable.VariableIndex result = this.gc.makeVariableIndex(group, this.tables, discipline, center, subcenter, rawPds, index, recordsPos, recordsLen);
        result.ndups = pv.getNdups();
        result.nrecords = pv.getNrecords();
        result.nmissing = pv.getMissing();
        return this.readVariableExtensions(group, pv, result);
    }

    private static Coordinate.Type convertAxisType(GribCollectionProto.GribAxisType type) {
        switch (type) {
            case runtime: {
                return Coordinate.Type.runtime;
            }
            case time: {
                return Coordinate.Type.time;
            }
            case time2D: {
                return Coordinate.Type.time2D;
            }
            case timeIntv: {
                return Coordinate.Type.timeIntv;
            }
            case ens: {
                return Coordinate.Type.ens;
            }
            case vert: {
                return Coordinate.Type.vert;
            }
        }
        throw new IllegalStateException("illegal axis type " + (Object)((Object)type));
    }

    String makeHorizCoordSysName(GdsHorizCoordSys hcs) {
        String base;
        String tryit = base = hcs.makeId();
        int count = 1;
        while (this.hcsNames.contains(tryit)) {
            tryit = base + "-" + ++count;
        }
        this.hcsNames.add(tryit);
        return tryit;
    }
}

