/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.PartitionManager;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribCollectionWriter;
import ucar.nc2.grib.collection.PartitionCollectionMutable;
import ucar.nc2.grib.coord.CalendarDateFactory;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateEns;
import ucar.nc2.grib.coord.CoordinatePartitionUnionizer;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateSharer;
import ucar.nc2.grib.coord.CoordinateSharerBest;
import ucar.nc2.grib.coord.CoordinateTime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.coord.CoordinateVert;
import ucar.nc2.stream.NcStream;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

abstract class GribPartitionBuilder {
    private final PartitionManager partitionManager;
    protected final String name;
    protected final Logger logger;
    protected PartitionCollectionMutable result;
    private GribCollectionWriter writer;

    GribPartitionBuilder(String name, PartitionManager tpc, Logger logger) {
        this.name = name;
        this.partitionManager = tpc;
        this.logger = logger;
    }

    boolean updateNeeded(CollectionUpdateType ff) throws IOException {
        if (ff == CollectionUpdateType.never) {
            return false;
        }
        if (ff == CollectionUpdateType.always) {
            return true;
        }
        File collectionIndexFile = GribIndexCache.getExistingFileOrCache(this.partitionManager.getIndexFilename(".ncx4"));
        if (collectionIndexFile == null) {
            return true;
        }
        if (ff == CollectionUpdateType.nocheck) {
            return false;
        }
        return this.needsUpdate(ff, collectionIndexFile);
    }

    private boolean needsUpdate(CollectionUpdateType ff, File collectionIndexFile) throws IOException {
        long collectionLastModified = collectionIndexFile.lastModified();
        HashSet<String> newFileSet = new HashSet<String>();
        for (MCollection dcm : this.partitionManager.makePartitions(CollectionUpdateType.test)) {
            String partitionIndexFilename = StringUtil2.replace((String)dcm.getIndexFilename(".ncx4"), (char)'\\', (String)"/");
            File partitionIndexFile = GribIndexCache.getExistingFileOrCache(partitionIndexFilename);
            if (partitionIndexFile == null) {
                return true;
            }
            if (collectionLastModified < partitionIndexFile.lastModified()) {
                return true;
            }
            newFileSet.add(partitionIndexFilename);
        }
        if (ff == CollectionUpdateType.testIndexOnly) {
            return false;
        }
        GribCdmIndex reader = new GribCdmIndex(this.logger);
        ArrayList<MFile> oldFiles = new ArrayList<MFile>();
        reader.readMFiles(collectionIndexFile.toPath(), oldFiles);
        HashSet<String> oldFileSet = new HashSet<String>();
        for (MFile oldFile : oldFiles) {
            if (!newFileSet.contains(oldFile.getPath())) {
                return true;
            }
            oldFileSet.add(oldFile.getPath());
        }
        for (String newFilename : newFileSet) {
            if (oldFileSet.contains(newFilename)) continue;
            return true;
        }
        return false;
    }

    boolean createPartitionedIndex(CollectionUpdateType forcePartition, Formatter errlog) throws IOException {
        if (errlog == null) {
            errlog = new Formatter();
        }
        for (MCollection dcmp : this.partitionManager.makePartitions(forcePartition)) {
            dcmp.putAuxInfo("fcConfig", this.partitionManager.getAuxInfo("fcConfig"));
            this.result.addPartition(dcmp);
        }
        this.result.sortPartitions();
        int n = this.result.getPartitionSize();
        if (n == 0) {
            errlog.format("ERR Nothing in this partition = %s%n", this.result.showLocation());
            throw new IllegalStateException("Nothing in this partition =" + this.result.showLocation());
        }
        int idx = this.partitionManager.getProtoIndex(n);
        PartitionCollectionMutable.Partition canon = this.result.getPartition(idx);
        this.logger.debug("     Using canonical partition {}", (Object)canon.getDcm().getCollectionName());
        try (GribCollectionMutable gc = canon.makeGribCollection();){
            if (gc == null) {
                throw new IllegalStateException("canon.makeGribCollection failed on =" + this.result.showLocation() + " " + canon.getName() + "; errs=" + errlog);
            }
            this.result.copyInfo(gc);
            this.result.isPartitionOfPartitions = gc instanceof PartitionCollectionMutable;
            this.result.dateRange = gc.dateRange;
        }
        GribCollectionMutable.Dataset ds2D = this.makeDataset2D(errlog);
        if (ds2D == null) {
            errlog.format(" ERR makeDataset2D failed, index not written on %s%n", this.result.showLocation());
            throw new IllegalStateException("makeDataset2D failed, index not written on =" + this.result.showLocation() + "; errs=" + errlog);
        }
        if (ds2D.gctype == GribCollectionImmutable.Type.TwoD) {
            this.makeDatasetBest(ds2D, false);
        }
        return this.writeIndex(this.result, errlog);
    }

    @Nullable
    private GribCollectionMutable.Dataset makeDataset2D(Formatter f) throws IOException {
        FeatureCollectionConfig config = (FeatureCollectionConfig)this.partitionManager.getAuxInfo("fcConfig");
        FeatureCollectionConfig.GribIntvFilter intvMap = config != null ? config.gribConfig.intvFilter : null;
        GribCollectionMutable.Dataset ds2D = this.result.makeDataset(GribCollectionImmutable.Type.TwoD);
        int npart = this.result.getPartitionSize();
        ArrayList<CoordinateRuntime> masterRuntimes = new ArrayList<CoordinateRuntime>();
        HashMap<Object, GroupPartitions> groupMap = new HashMap<Object, GroupPartitions>(40);
        CoordinateRuntime.Builder2 runtimeAllBuilder = new CoordinateRuntime.Builder2(null);
        int countPartition = 0;
        CalendarDateRange dateRangeAll = null;
        boolean rangeOverlaps = false;
        for (PartitionCollectionMutable.Partition tpp : this.result.getPartitions()) {
            GribCollectionMutable gc = tpp.makeGribCollection();
            Throwable throwable = null;
            try {
                if (gc == null) continue;
                CoordinateRuntime partRuntime = gc.masterRuntime;
                runtimeAllBuilder.addAll(partRuntime);
                masterRuntimes.add(partRuntime);
                GribCollectionMutable.Dataset ds2dp = gc.getDatasetCanonical();
                if (dateRangeAll == null) {
                    dateRangeAll = gc.dateRange;
                } else if (!rangeOverlaps) {
                    rangeOverlaps = dateRangeAll.intersects(gc.dateRange);
                    dateRangeAll = dateRangeAll.extend(gc.dateRange);
                }
                int groupIdx = 0;
                for (GribCollectionMutable.GroupGC g : ds2dp.groups) {
                    GroupPartitions gs = (GroupPartitions)groupMap.get(g.getGdsHash());
                    if (gs == null) {
                        gs = new GroupPartitions(ds2D.addGroupCopy(g), npart);
                        groupMap.put(g.getGdsHash(), gs);
                    }
                    gs.componentGroups[countPartition] = g;
                    gs.componentGroupIndex[countPartition] = groupIdx++;
                }
            }
            catch (Throwable partRuntime) {
                throwable = partRuntime;
                throw partRuntime;
            }
            finally {
                if (gc == null) continue;
                if (throwable != null) {
                    try {
                        gc.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                gc.close();
                continue;
            }
            ++countPartition;
        }
        ArrayList groupPartitions = new ArrayList(groupMap.values());
        this.result.masterRuntime = (CoordinateRuntime)runtimeAllBuilder.finish();
        if (this.result.isPartitionOfPartitions) {
            CoordinateTimeAbstract.cdf = new CalendarDateFactory(this.result.masterRuntime);
        }
        ds2D.gctype = !rangeOverlaps ? GribCollectionImmutable.Type.MRUTP : GribCollectionImmutable.Type.TwoD;
        this.result.run2part = new int[this.result.masterRuntime.getSize()];
        int partIdx = 0;
        for (CoordinateRuntime partRuntime : masterRuntimes) {
            for (Object val : partRuntime.getValues()) {
                int idx = this.result.masterRuntime.getIndex(val);
                this.result.run2part[idx] = partIdx;
            }
            ++partIdx;
        }
        for (GroupPartitions gp : groupPartitions) {
            GribCollectionMutable.GroupGC resultGroup = gp.resultGroup;
            gp.makeVariableIndexPartitioned();
            String gname = resultGroup.getId();
            for (int partno = 0; partno < npart; ++partno) {
                GribCollectionMutable.GroupGC group = gp.componentGroups[partno];
                if (group == null) {
                    f.format(" INFO canonical group %s not in partition %s%n", gname, this.result.getPartition(partno).getName());
                    continue;
                }
                int groupIdx = gp.componentGroupIndex[partno];
                for (int varIdx = 0; varIdx < group.variList.size(); ++varIdx) {
                    GribCollectionMutable.VariableIndex vi = group.variList.get(varIdx);
                    PartitionCollectionMutable.VariableIndexPartitioned vip = (PartitionCollectionMutable.VariableIndexPartitioned)resultGroup.findVariableByHash(vi);
                    vip.addPartition(partno, groupIdx, varIdx, vi.ndups, vi.nrecords, vi.nmissing, vi);
                }
            }
            boolean isDense = false;
            CoordinateSharer sharify = new CoordinateSharer(isDense, this.logger);
            for (GribCollectionMutable.VariableIndex viResult : resultGroup.variList) {
                PartitionCollectionMutable.VariableIndexPartitioned vip = (PartitionCollectionMutable.VariableIndexPartitioned)viResult;
                vip.finish();
                CoordinatePartitionUnionizer unionizer = new CoordinatePartitionUnionizer(viResult, intvMap, this.logger);
                for (int partno = 0; partno < npart; ++partno) {
                    GribCollectionMutable.VariableIndex vi;
                    GribCollectionMutable.GroupGC group = gp.componentGroups[partno];
                    if (group == null || (vi = group.findVariableByHash(viResult)) == null) continue;
                    try {
                        PartitionCollectionMutable.Partition part = ds2D.gctype.isUniqueTime() ? null : this.result.getPartition(partno);
                        unionizer.addCoords(vi.getCoordinates(), part);
                        continue;
                    }
                    catch (IllegalStateException e) {
                        this.logger.error(e.getMessage() + " on dataset " + this.name);
                        return null;
                    }
                }
                viResult.coords = unionizer.finish();
                sharify.addCoords(viResult.coords);
            }
            sharify.finish();
            resultGroup.coords = sharify.getUnionCoords();
            ArrayList<CoordinateTime2D> time2DCoords = new ArrayList<CoordinateTime2D>();
            HashMap<CoordinateRuntime, CoordinateRuntime> runtimes = new HashMap<CoordinateRuntime, CoordinateRuntime>();
            for (Coordinate coord : resultGroup.coords) {
                Coordinate.Type type = coord.getType();
                switch (type) {
                    case runtime: {
                        CoordinateRuntime reftime = (CoordinateRuntime)coord;
                        runtimes.put(reftime, reftime);
                        break;
                    }
                    case time2D: {
                        CoordinateTime2D t2d = (CoordinateTime2D)coord;
                        time2DCoords.add(t2d);
                    }
                }
            }
            for (CoordinateTime2D t2d : time2DCoords) {
                CoordinateRuntime runtime2D = t2d.getRuntimeCoordinate();
                CoordinateRuntime runtime = (CoordinateRuntime)runtimes.get(runtime2D);
                if (runtime != null) continue;
                this.logger.warn("HEY assignRuntimeNames failed on {} group {}", (Object)t2d.getName(), (Object)resultGroup.getId());
            }
            for (GribCollectionMutable.VariableIndex viResult : resultGroup.variList) {
                viResult.coordIndex = sharify.reindex2shared(viResult.coords);
                viResult.coords = null;
            }
        }
        CoordinateTimeAbstract.cdf = null;
        return ds2D;
    }

    private void makeDatasetBest(GribCollectionMutable.Dataset ds2D, boolean isComplete) {
        GribCollectionMutable.Dataset dsBest = this.result.makeDataset(isComplete ? GribCollectionImmutable.Type.BestComplete : GribCollectionImmutable.Type.Best);
        int npart = this.result.getPartitionSize();
        for (GribCollectionMutable.GroupGC group2D : ds2D.groups) {
            GribCollectionMutable.GroupGC groupB = dsBest.addGroupCopy(group2D);
            groupB.isTwoD = false;
            HashMap<Coordinate, CoordinateTimeAbstract> map2DtoBest = new HashMap<Coordinate, CoordinateTimeAbstract>();
            CoordinateSharerBest sharer = new CoordinateSharerBest();
            for (Coordinate coord : group2D.coords) {
                if (coord instanceof CoordinateRuntime) continue;
                if (coord instanceof CoordinateTime2D) {
                    CoordinateTimeAbstract best = ((CoordinateTime2D)coord).makeBestTimeCoordinate(this.result.masterRuntime);
                    if (!isComplete) {
                        best = best.makeBestFromComplete();
                    }
                    sharer.addCoordinate(best);
                    map2DtoBest.put(coord, best);
                    continue;
                }
                sharer.addCoordinate(coord);
            }
            groupB.coords = sharer.finish();
            for (GribCollectionMutable.VariableIndex vi2d : group2D.variList) {
                PartitionCollectionMutable.VariableIndexPartitioned vip = this.result.makeVariableIndexPartitioned(groupB, vi2d, npart);
                vip.finish();
                ArrayList<Coordinate> newCoords = new ArrayList<Coordinate>();
                for (Integer groupIndex : vi2d.coordIndex) {
                    Coordinate coord2D = group2D.coords.get(groupIndex);
                    if (coord2D instanceof CoordinateRuntime) continue;
                    if (coord2D instanceof CoordinateTime2D) {
                        newCoords.add((Coordinate)map2DtoBest.get(coord2D));
                        continue;
                    }
                    newCoords.add(coord2D);
                }
                vip.coordIndex = sharer.reindex(newCoords);
            }
        }
    }

    protected abstract String getMagicStart();

    protected abstract int getVersion();

    protected boolean writeIndex(PartitionCollectionMutable pc, Formatter f) throws IOException {
        File idxFile = GribIndexCache.getFileOrCache(this.partitionManager.getIndexFilename(".ncx4"));
        if (idxFile.exists()) {
            RandomAccessFile.eject((String)idxFile.getPath());
            if (!idxFile.delete()) {
                this.logger.error("gc2tp cant delete " + idxFile.getPath());
            }
        }
        this.writer = new GribCollectionWriter(null, null);
        try (RandomAccessFile raf = new RandomAccessFile(idxFile.getPath(), "rw");){
            raf.order(0);
            raf.write(this.getMagicStart().getBytes(CDM.utf8Charset));
            raf.writeInt(this.getVersion());
            raf.writeLong(0L);
            GribCollectionProto.GribCollection.Builder indexBuilder = GribCollectionProto.GribCollection.newBuilder();
            indexBuilder.setName(pc.getName());
            Path topDir = pc.directory.toPath();
            String pathS = StringUtil2.replace((String)topDir.toString(), (char)'\\', (String)"/");
            indexBuilder.setTopDir(pathS);
            int count = 0;
            for (PartitionCollectionMutable.Partition part : pc.partitions) {
                GribCollectionProto.MFile.Builder b = GribCollectionProto.MFile.newBuilder();
                String pathRS = this.makeReletiveFilename(pc, part);
                b.setFilename(pathRS);
                b.setLastModified(part.getLastModified());
                b.setLength(part.fileSize);
                b.setIndex(count++);
                indexBuilder.addMfiles(b.build());
            }
            indexBuilder.setCenter(pc.center);
            indexBuilder.setSubcenter(pc.subcenter);
            indexBuilder.setMaster(pc.master);
            indexBuilder.setLocal(pc.local);
            indexBuilder.setGenProcessId(pc.genProcessId);
            indexBuilder.setGenProcessType(pc.genProcessType);
            indexBuilder.setBackProcessId(pc.backProcessId);
            indexBuilder.setStartTime(pc.dateRange.getStart().getMillis());
            indexBuilder.setEndTime(pc.dateRange.getEnd().getMillis());
            indexBuilder.setMasterRuntime(this.writer.writeCoordProto(pc.masterRuntime));
            for (GribCollectionMutable.Dataset ds : pc.datasets) {
                indexBuilder.addDataset(this.writeDatasetProto(pc, ds));
            }
            if (pc.run2part != null) {
                for (Iterator<PartitionCollectionMutable.Partition> part : (Iterator<PartitionCollectionMutable.Partition>)pc.run2part) {
                    indexBuilder.addRun2Part((int)part);
                }
            }
            for (PartitionCollectionMutable.Partition part : pc.partitions) {
                indexBuilder.addPartitions(this.writePartitionProto(pc, part));
            }
            indexBuilder.setIsPartitionOfPartitions(pc.isPartitionOfPartitions);
            GribCollectionProto.GribCollection index = indexBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt((RandomAccessFile)raf, (int)b.length);
            raf.write(b);
            f.format("Grib2PartitionIndex= %d bytes file size =  %d bytes%n%n", b.length, raf.length());
        }
        return true;
    }

    private String makeReletiveFilename(PartitionCollectionMutable pc, PartitionCollectionMutable.Partition part) {
        Path topDir = pc.directory.toPath();
        Path partPath = new File(part.getDirectory(), part.getFilename()).toPath();
        Path pathRelative = topDir.relativize(partPath);
        return StringUtil2.replace((String)pathRelative.toString(), (char)'\\', (String)"/");
    }

    private GribCollectionProto.Dataset writeDatasetProto(PartitionCollectionMutable pc, GribCollectionMutable.Dataset ds) throws IOException {
        GribCollectionProto.Dataset.Builder b = GribCollectionProto.Dataset.newBuilder();
        GribCollectionProto.Dataset.Type type = GribCollectionProto.Dataset.Type.valueOf(ds.gctype.toString());
        b.setType(type);
        for (GribCollectionMutable.GroupGC group : ds.groups) {
            b.addGroups(this.writeGroupProto(pc, group));
        }
        return b.build();
    }

    private GribCollectionProto.Group writeGroupProto(PartitionCollectionMutable pc, GribCollectionMutable.GroupGC g) throws IOException {
        GribCollectionProto.Group.Builder b = GribCollectionProto.Group.newBuilder();
        b.setGds(GribCollectionWriter.writeGdsProto(g.horizCoordSys.getRawGds(), g.horizCoordSys.getPredefinedGridDefinition()));
        for (GribCollectionMutable.VariableIndex vb : g.variList) {
            b.addVariables(this.writeVariableProto((PartitionCollectionMutable.VariableIndexPartitioned)vb));
        }
        for (Coordinate coord : g.coords) {
            switch (coord.getType()) {
                case runtime: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateRuntime)coord));
                    break;
                }
                case time: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateTime)coord));
                    break;
                }
                case timeIntv: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateTimeIntv)coord));
                    break;
                }
                case time2D: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateTime2D)coord));
                    break;
                }
                case vert: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateVert)coord));
                    break;
                }
                case ens: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateEns)coord));
                }
            }
        }
        if (g.filenose != null) {
            Object object = g.filenose;
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Integer fileno = (int)object[i];
                b.addFileno(fileno);
            }
        }
        return b.build();
    }

    private GribCollectionProto.Variable writeVariableProto(PartitionCollectionMutable.VariableIndexPartitioned vp) {
        GribCollectionProto.Variable.Builder b = GribCollectionProto.Variable.newBuilder();
        b.setDiscipline(vp.discipline);
        b.setPds(ByteString.copyFrom((byte[])vp.rawPds));
        b.addIds(vp.center);
        b.addIds(vp.subcenter);
        b.setRecordsPos(vp.recordsPos);
        b.setRecordsLen(vp.recordsLen);
        Iterator iterator = vp.coordIndex.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            b.addCoordIdx(idx);
        }
        b.setNdups(vp.ndups);
        b.setNrecords(vp.nrecords);
        b.setMissing(vp.nmissing);
        if (vp.nparts > 0 && vp.partnoSA != null) {
            for (int i = 0; i < vp.nparts; ++i) {
                b.addPartVariable(this.writePartitionVariableProto(vp.partnoSA.get(i), vp.groupnoSA.get(i), vp.varnoSA.get(i), vp.nrecords, vp.ndups, vp.nmissing));
            }
        }
        return b.build();
    }

    private GribCollectionProto.PartitionVariable writePartitionVariableProto(int partno, int groupno, int varno, int nrecords, int ndups, int nmissing) {
        GribCollectionProto.PartitionVariable.Builder pb = GribCollectionProto.PartitionVariable.newBuilder();
        pb.setPartno(partno);
        pb.setGroupno(groupno);
        pb.setVarno(varno);
        pb.setNdups(ndups);
        pb.setNrecords(nrecords);
        pb.setMissing(nmissing);
        return pb.build();
    }

    private GribCollectionProto.Partition writePartitionProto(PartitionCollectionMutable pc, PartitionCollectionMutable.Partition p) {
        GribCollectionProto.Partition.Builder b = GribCollectionProto.Partition.newBuilder();
        String pathRS = this.makeReletiveFilename(pc, p);
        b.setFilename(pathRS);
        b.setName(p.name);
        b.setLastModified(p.lastModified);
        b.setLength(p.fileSize);
        if (p.partitionDate != null) {
            b.setPartitionDate(p.partitionDate.getMillis());
        }
        return b.build();
    }

    private class GroupPartitions {
        final GribCollectionMutable.GroupGC resultGroup;
        final GribCollectionMutable.GroupGC[] componentGroups;
        final int[] componentGroupIndex;
        final int npart;

        GroupPartitions(GribCollectionMutable.GroupGC resultGroup, int npart) {
            this.resultGroup = resultGroup;
            this.npart = npart;
            this.componentGroups = new GribCollectionMutable.GroupGC[npart];
            this.componentGroupIndex = new int[npart];
        }

        void makeVariableIndexPartitioned() {
            HashMap<GribCollectionMutable.VariableIndex, GribCollectionMutable.VariableIndex> varMap = new HashMap<GribCollectionMutable.VariableIndex, GribCollectionMutable.VariableIndex>(2 * this.resultGroup.variList.size());
            for (GribCollectionMutable.GroupGC group : this.componentGroups) {
                if (group == null) continue;
                for (GribCollectionMutable.VariableIndex vi : group.variList) {
                    varMap.put(vi, vi);
                }
            }
            for (GribCollectionMutable.VariableIndex vi : varMap.values()) {
                GribPartitionBuilder.this.result.makeVariableIndexPartitioned(this.resultGroup, vi, this.npart);
            }
        }
    }
}

