/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateND;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTime2DUnionizer;

public class CoordinateSharer<T> {
    boolean isRuntimeUnion = false;
    Logger logger;
    Set<Coordinate> runtimeSet = new HashSet<Coordinate>();
    Set<Coordinate> timeSet = new HashSet<Coordinate>();
    Set<Coordinate> timeIntvSet = new HashSet<Coordinate>();
    Set<Coordinate> vertSet = new HashSet<Coordinate>();
    Set<Coordinate> ensSet = new HashSet<Coordinate>();
    Set<Coordinate> time2DSet = new HashSet<Coordinate>();
    List<Coordinate> unionCoords = new ArrayList<Coordinate>();
    Map<Coordinate, Integer> coordMap;
    CoordinateRuntime.Builder2 runtimeAllBuilder;
    CoordinateTime2DUnionizer time2DUnionizer;
    CoordinateTime2DUnionizer timeIntv2DUnionizer;
    CoordinateRuntime runtimeAll;
    CoordinateTime2D time2Dall;
    CoordinateTime2D timeIntv2Dall;
    private Map<Coordinate, CoordinateTime2D> swap = new HashMap<Coordinate, CoordinateTime2D>();
    private static final double smooshTolerence = 0.1;
    private List<RuntimeSmoosher> runtimes = new ArrayList<RuntimeSmoosher>();

    public CoordinateSharer(boolean isRuntimeUnion, Logger logger) {
        this.logger = logger;
    }

    public void addCoords(List<Coordinate> coords) {
        CoordinateRuntime runtime = null;
        for (Coordinate coord : coords) {
            switch (coord.getType()) {
                case runtime: {
                    runtime = (CoordinateRuntime)coord;
                    if (this.isRuntimeUnion) {
                        if (this.runtimeAllBuilder == null) {
                            this.runtimeAllBuilder = new CoordinateRuntime.Builder2(runtime.getTimeUnits());
                        }
                        this.runtimeAllBuilder.addAll(coord);
                        break;
                    }
                    this.runtimeSet.add(coord);
                    break;
                }
                case time: {
                    this.timeSet.add(coord);
                    break;
                }
                case timeIntv: {
                    this.timeIntvSet.add(coord);
                    break;
                }
                case time2D: {
                    CoordinateTime2D time2D = (CoordinateTime2D)coord;
                    if (this.isRuntimeUnion) {
                        if (time2D.isTimeInterval()) {
                            if (this.timeIntv2DUnionizer == null) {
                                this.timeIntv2DUnionizer = new CoordinateTime2DUnionizer(time2D.isTimeInterval(), time2D.getTimeUnit(), coord.getCode(), true, this.logger);
                            }
                            this.timeIntv2DUnionizer.addAll(time2D);
                        } else {
                            if (this.time2DUnionizer == null) {
                                this.time2DUnionizer = new CoordinateTime2DUnionizer(time2D.isTimeInterval(), time2D.getTimeUnit(), coord.getCode(), true, this.logger);
                            }
                            this.time2DUnionizer.addAll(time2D);
                        }
                    } else {
                        this.time2DSet.add(coord);
                    }
                    CoordinateRuntime runtimeFrom2D = time2D.getRuntimeCoordinate();
                    if (runtimeFrom2D.equals(runtime)) break;
                    this.logger.warn("CoordinateSharer runtimes differ");
                    break;
                }
                case vert: {
                    this.vertSet.add(coord);
                    break;
                }
                case ens: {
                    this.ensSet.add(coord);
                }
            }
        }
    }

    public void finish() {
        if (this.isRuntimeUnion) {
            this.runtimeAll = (CoordinateRuntime)this.runtimeAllBuilder.finish();
            this.unionCoords.add(this.runtimeAll);
            if (this.time2DUnionizer != null) {
                this.time2DUnionizer.setRuntimeCoords(this.runtimeAll);
                this.time2Dall = (CoordinateTime2D)this.time2DUnionizer.finish();
                this.unionCoords.add(this.time2Dall);
            }
            if (this.timeIntv2DUnionizer != null) {
                this.timeIntv2DUnionizer.setRuntimeCoords(this.runtimeAll);
                this.timeIntv2Dall = (CoordinateTime2D)this.timeIntv2DUnionizer.finish();
                this.unionCoords.add(this.timeIntv2Dall);
            }
        } else {
            this.unionCoords.addAll(this.runtimeSet);
            HashSet<CoordinateTime2D> coord2Dset = new HashSet<CoordinateTime2D>();
            for (Coordinate coord : this.time2DSet) {
                CoordinateTime2D coord2D = (CoordinateTime2D)coord;
                CoordinateTime2DUnionizer unionizer = new CoordinateTime2DUnionizer(coord2D.isTimeInterval(), coord2D.getTimeUnit(), coord2D.getCode(), true, this.logger);
                unionizer.addAll(coord2D);
                unionizer.finish();
                CoordinateTime2D result = (CoordinateTime2D)unionizer.getCoordinate();
                if (result.isOrthogonal() || result.isRegular()) {
                    if (!coord2Dset.contains(result)) {
                        this.unionCoords.add(result);
                        coord2Dset.add(result);
                    }
                    this.swap.put(coord2D, result);
                    continue;
                }
                this.unionCoords.add(coord2D);
                coord2Dset.add(coord2D);
            }
        }
        this.unionCoords.addAll(this.timeSet);
        this.unionCoords.addAll(this.timeIntvSet);
        this.unionCoords.addAll(this.vertSet);
        this.unionCoords.addAll(this.ensSet);
        this.coordMap = new HashMap<Coordinate, Integer>();
        for (int i = 0; i < this.unionCoords.size(); ++i) {
            this.coordMap.put(this.unionCoords.get(i), i);
        }
    }

    public List<Coordinate> getUnionCoords() {
        return this.unionCoords;
    }

    public CoordinateND<T> reindexCoordND(CoordinateND<T> prev) {
        boolean needReindex = false;
        for (Coordinate coord : prev.getCoordinates()) {
            if (this.isRuntimeUnion && coord.getType() == Coordinate.Type.runtime && !coord.equals(this.runtimeAll)) {
                needReindex = true;
            }
            if (null == this.swap.get(coord)) continue;
            needReindex = true;
        }
        if (!needReindex) {
            return prev;
        }
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (Coordinate prevCoord : prev.getCoordinates()) {
            if (this.isRuntimeUnion) {
                if (prevCoord.getType() == Coordinate.Type.runtime) {
                    coords.add(this.runtimeAll);
                    continue;
                }
                if (prevCoord.getType() == Coordinate.Type.time2D) {
                    CoordinateTime2D time2D = (CoordinateTime2D)prevCoord;
                    if (time2D.isTimeInterval()) {
                        coords.add(this.timeIntv2Dall);
                        continue;
                    }
                    coords.add(this.time2Dall);
                    continue;
                }
                coords.add(prevCoord);
                continue;
            }
            Coordinate newCoord = this.swap.get(prevCoord);
            if (newCoord != null) {
                coords.add(newCoord);
                continue;
            }
            coords.add(prevCoord);
        }
        return new CoordinateND.Builder<T>().reindex(coords, prev);
    }

    public List<Integer> reindex2shared(List<Coordinate> prev) {
        ArrayList<Integer> result = new ArrayList<Integer>(prev.size());
        for (Coordinate coord : prev) {
            Integer idx;
            Coordinate swapCoord = this.swap.get(coord);
            if (swapCoord != null) {
                coord = swapCoord;
            }
            if ((idx = this.getIndexIntoShared(coord)) == null) {
                Formatter f = new Formatter();
                this.showInfo(f);
                f.format("%nprev:%n", new Object[0]);
                for (Coordinate c : prev) {
                    f.format(" %d == (%s) %s%n", c.hashCode(), c, c.getName());
                }
                this.logger.error("CoordinateSharer cant find coordinate %s (%s)", new Object[]{coord.getName(), f, new Throwable()});
                continue;
            }
            result.add(idx);
        }
        return result;
    }

    private Integer getIndexIntoShared(Coordinate prev) {
        if (this.isRuntimeUnion) {
            switch (prev.getType()) {
                case runtime: {
                    return this.coordMap.get(this.runtimeAll);
                }
                case time2D: {
                    CoordinateTime2D time2D = (CoordinateTime2D)prev;
                    if (time2D.isTimeInterval()) {
                        return this.coordMap.get(this.timeIntv2Dall);
                    }
                    return this.coordMap.get(this.time2Dall);
                }
            }
            return this.coordMap.get(prev);
        }
        return this.coordMap.get(prev);
    }

    public void showInfo(Formatter sb) {
        sb.format("unionCoords:%n", new Object[0]);
        for (Coordinate coordinate : this.unionCoords) {
            sb.format(" %d == (%s) %s%n", coordinate.hashCode(), coordinate, coordinate.getName());
        }
        sb.format("%ncoordMap:%n", new Object[0]);
        for (Coordinate coordinate : this.coordMap.keySet()) {
            sb.format(" %d == (%s) %s%n", coordinate.hashCode(), coordinate, coordinate.getName());
        }
        sb.format("%ntime2DBuilders:%n", new Object[0]);
        for (Coordinate coordinate : this.time2DSet) {
            sb.format(" %d == (%s) %s%n", coordinate.hashCode(), coordinate, coordinate.getName());
        }
        sb.format("%nswap:%n", new Object[0]);
        for (Map.Entry entry : this.swap.entrySet()) {
            sb.format(" %d (%s) %s -> %d (%s) %s%n", ((Coordinate)entry.getKey()).hashCode(), entry.getKey(), ((Coordinate)entry.getKey()).getName(), ((CoordinateTime2D)entry.getValue()).hashCode(), entry.getValue(), ((CoordinateTime2D)entry.getValue()).getName());
        }
    }

    private static class RuntimeSmoosher {
        private CoordinateRuntime runtime;
        private Set<Long> coordSet = new HashSet<Long>();
        private boolean combined;

        RuntimeSmoosher(CoordinateRuntime runtime) {
            this.runtime = runtime;
            for (int i = 0; i < runtime.getNCoords(); ++i) {
                this.coordSet.add(runtime.getRuntime(i));
            }
        }

        public boolean nearlyEquals(RuntimeSmoosher that) {
            Sets.SetView common = Sets.intersection(this.coordSet, that.coordSet);
            int total = Math.min(this.runtime.getSize(), that.runtime.getSize());
            double nptsP = (double)common.size() / (double)total;
            return nptsP < 0.1;
        }
    }
}

