/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.TimeUnitConverter;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.coord.VertCoordType;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.AfwaTables;
import ucar.nc2.grib.grib1.tables.FnmocTables;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.grib.grib1.tables.Grib1WmoTimeType;
import ucar.nc2.grib.grib1.tables.JmaTables;
import ucar.nc2.grib.grib1.tables.NcarTables;
import ucar.nc2.grib.grib1.tables.NcepRfcTables;
import ucar.nc2.grib.grib1.tables.NcepTables;
import ucar.nc2.wmo.CommonCodeTable;

public class Grib1Customizer
implements GribTables {
    private static final Logger logger = LoggerFactory.getLogger(Grib1Customizer.class);
    private final int center;
    private final Grib1ParamTables tables;
    private TimeUnitConverter timeUnitConverter;
    private static Map<Integer, VertCoordType> wmoTable3;

    public static Grib1Customizer factory(Grib1Record proto, Grib1ParamTables tables) {
        int center = proto.getPDSsection().getCenter();
        int subcenter = proto.getPDSsection().getSubCenter();
        int version = proto.getPDSsection().getTableVersion();
        return Grib1Customizer.factory(center, subcenter, version, tables);
    }

    public static Grib1Customizer factory(int center, int subcenter, int version, Grib1ParamTables tables) {
        switch (center) {
            case 7: {
                return new NcepTables(tables);
            }
            case 9: {
                return new NcepRfcTables(tables);
            }
            case 34: {
                return new JmaTables(tables);
            }
            case 57: {
                return new AfwaTables(tables);
            }
            case 58: {
                return new FnmocTables(tables);
            }
            case 60: {
                return new NcarTables(tables);
            }
        }
        return new Grib1Customizer(center, tables);
    }

    public static String getSubCenterNameStatic(int center, int subcenter) {
        Grib1Customizer cust = Grib1Customizer.factory(center, subcenter, 0, null);
        return cust.getSubCenterName(subcenter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Grib1Customizer(int center, Grib1ParamTables tables) {
        this.center = center;
        this.tables = tables == null ? new Grib1ParamTables() : tables;
        Class<Grib1Customizer> clazz = Grib1Customizer.class;
        synchronized (Grib1Customizer.class) {
            if (wmoTable3 == null) {
                wmoTable3 = this.readTable3("resources/grib1/wmoTable3.xml");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public int getCenter() {
        return this.center;
    }

    public Grib1Parameter getParameter(int center, int subcenter, int tableVersion, int param_number) {
        return this.tables.getParameter(center, subcenter, tableVersion, param_number);
    }

    @Override
    @Nullable
    public String getGeneratingProcessName(int genProcess) {
        return null;
    }

    @Override
    public String getGeneratingProcessTypeName(int genProcess) {
        return null;
    }

    @Nullable
    public String getSubCenterName(int subcenter) {
        return CommonCodeTable.getSubCenterName((int)this.center, (int)subcenter);
    }

    @Override
    @Nullable
    public String getSubCenterName(int center, int subcenter) {
        return CommonCodeTable.getSubCenterName((int)center, (int)subcenter);
    }

    public Grib1ParamTime getParamTime(Grib1SectionProductDefinition pds) {
        return new Grib1ParamTime(this, pds);
    }

    public String getTimeTypeName(int timeRangeIndicator) {
        return Grib1ParamTime.getTimeTypeName(timeRangeIndicator);
    }

    @Override
    @Nullable
    public GribStatType getStatType(int timeRangeIndicator) {
        return Grib1WmoTimeType.getStatType(timeRangeIndicator);
    }

    public Grib1ParamLevel getParamLevel(Grib1SectionProductDefinition pds) {
        return new Grib1ParamLevel(this, pds);
    }

    @Override
    public VertCoordType getVertUnit(int code) {
        return this.makeVertUnit(code);
    }

    public boolean isVerticalCoordinate(int levelType) {
        return this.getLevelUnits(levelType) != null;
    }

    protected VertCoordType makeVertUnit(int code) {
        return this.getLevelType(code);
    }

    @Override
    public String getLevelNameShort(int levelType) {
        VertCoordType lt = this.getLevelType(levelType);
        String result = lt.getAbbrev();
        if (result == null) {
            result = "unknownLevel" + levelType;
        }
        return result;
    }

    public String getLevelDescription(int levelType) {
        VertCoordType lt = this.getLevelType(levelType);
        return lt.getDesc();
    }

    public boolean isLayer(int levelType) {
        VertCoordType lt = this.getLevelType(levelType);
        return lt.isLayer();
    }

    public boolean isPositiveUp(int levelType) {
        VertCoordType lt = this.getLevelType(levelType);
        return lt.isPositiveUp();
    }

    public String getLevelUnits(int levelType) {
        VertCoordType lt = this.getLevelType(levelType);
        return lt.getUnits();
    }

    public String getLevelDatum(int levelType) {
        VertCoordType lt = this.getLevelType(levelType);
        return lt.getDatum();
    }

    public void setTimeUnitConverter(TimeUnitConverter timeUnitConverter) {
        this.timeUnitConverter = timeUnitConverter;
    }

    public int convertTimeUnit(int timeUnit) {
        if (this.timeUnitConverter == null) {
            return timeUnit;
        }
        return this.timeUnitConverter.convertTimeUnit(timeUnit);
    }

    protected VertCoordType getLevelType(int code) {
        VertCoordType result = wmoTable3.get(code);
        if (result == null) {
            result = new VertCoordType(code, "unknownLayer" + code, null, "unknownLayer" + code, null, false, false);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected synchronized Map<Integer, VertCoordType> readTable3(String path) {
        try (InputStream is = GribResourceReader.getInputStream(path);){
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, VertCoordType> result = new HashMap<Integer, VertCoordType>(200);
            List params = root.getChildren("parameter");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getAttributeValue("code"));
                String desc = elem1.getChildText("description");
                String abbrev = elem1.getChildText("abbrev");
                String units = elem1.getChildText("units");
                String datum = elem1.getChildText("datum");
                boolean isLayer = elem1.getChild("isLayer") != null;
                boolean isPositiveUp = elem1.getChild("isPositiveUp") != null;
                VertCoordType lt = new VertCoordType(code, desc, abbrev, units, datum, isPositiveUp, isLayer);
                result.put(code, lt);
            }
            Map map = Collections.unmodifiableMap(result);
            return map;
        }
        catch (IOException | JDOMException e) {
            logger.error("Cant parse NcepLevelTypes = " + path, e);
            return null;
        }
    }

    public static void main(String[] args) {
        Grib1Customizer cust = new Grib1Customizer(0, null);
        String units = cust.getLevelUnits(110);
        assert (units != null);
    }
}

