/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.EccodesCodeTable;
import ucar.nc2.grib.grib2.table.EccodesLocalConcepts;
import ucar.nc2.grib.grib2.table.EccodesParamTable;
import ucar.nc2.grib.grib2.table.Grib2CodeTableInterface;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;
import ucar.nc2.grib.grib2.table.LocalTables;

public class EccodesLocalTables
extends LocalTables {
    private static final Logger logger = LoggerFactory.getLogger(EccodesLocalTables.class);
    private static final String RESOURCE_DIRECTORY = "resources/grib2/ecmwf/tables/21";
    private static final String MATCH = "4.2.";
    private static final boolean debugOpen = false;
    private static final boolean debug = true;
    private final Map<Integer, EccodesParamTable> tableMap = new HashMap<Integer, EccodesParamTable>(30);
    private ImmutableSet<String> whitelist = ImmutableSet.of((Object)"4.230", (Object)"4.233", (Object)"4.192", (Object)"5.40000", (Object)"5.50002");
    private Map<String, EccodesCodeTable> localTables = new HashMap<String, EccodesCodeTable>();
    EccodesLocalConcepts localConcepts;
    ImmutableListMultimap<Integer, Grib2Parameter> localConceptMultimap;

    EccodesLocalTables(Grib2TableConfig config) {
        super(config);
        this.initParams(config.getPath());
    }

    @Override
    @Nullable
    public String getCodeTableValue(String tableName, int code) {
        if (!this.whitelist.contains((Object)tableName)) {
            return super.getCodeTableValue(tableName, code);
        }
        if (this.localTables.containsKey(tableName)) {
            Grib2CodeTableInterface.Entry entry = this.localTables.get(tableName).getEntry(code);
            return entry == null ? null : entry.getName();
        }
        Iterator tokens = Splitter.on((char)'.').trimResults().omitEmptyStrings().split((CharSequence)tableName).iterator();
        int discipline = Integer.parseInt((String)tokens.next());
        int category = Integer.parseInt((String)tokens.next());
        EccodesCodeTable ecmwfCodeTable = EccodesCodeTable.factory(21, discipline, category);
        this.localTables.put(tableName, ecmwfCodeTable);
        Grib2CodeTableInterface.Entry entry = ecmwfCodeTable.getEntry(code);
        return entry == null ? null : entry.getName();
    }

    private void initParams(String path) {
        try {
            this.localConcepts = new EccodesLocalConcepts(path);
            this.localConceptMultimap = this.localConcepts.getLocalConceptMultimap();
            for (Map.Entry entry : this.localConceptMultimap.asMap().entrySet()) {
                if (!EccodesLocalTables.isLocal((Integer)entry.getKey())) continue;
                this.localParams.put(entry.getKey(), ((Collection)entry.getValue()).iterator().next());
            }
        }
        catch (IOException e) {
            logger.warn("EccodesLocalTables failed on %s", (Object)path, (Object)e);
        }
    }

    @Override
    public ImmutableList<GribTables.Parameter> getParameters() {
        return (ImmutableList)this.localConceptMultimap.values().stream().map(p -> p).sorted(new LocalTables.ParameterSort()).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void showDetails(Formatter f) {
        this.localConcepts.showDetails(f);
    }

    @Override
    public void showEntryDetails(Formatter f, List<GribTables.Parameter> params) {
        this.localConcepts.showEntryDetails(f, params);
    }
}

