/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.grib2.table.Grib2TablesId;
import ucar.nc2.grib.grib2.table.WmoCodeFlagTables;
import ucar.unidata.util.StringUtil2;

@Immutable
class Grib2TableConfig {
    private static final Logger logger = LoggerFactory.getLogger(Grib2TableConfig.class);
    private static final String tableMapPath = "resources/grib2/standardTableMap.txt";
    private static ImmutableList<Grib2TableConfig> tables = null;
    private static Grib2TableConfig standardTable = null;
    private final String name;
    private final Grib2TablesId.Type type;
    private final Grib2TablesId id;
    private String path;

    private static ImmutableList<Grib2TableConfig> init() {
        ArrayList<Grib2TableConfig> result = new ArrayList<Grib2TableConfig>();
        ClassLoader cl = Grib2TableConfig.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream(tableMapPath);){
            if (is == null) {
                throw new IllegalStateException("Cant find resources/grib2/standardTableMap.txt");
            }
            try (BufferedReader dataIS = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF8")));){
                String line;
                int count = 0;
                while ((line = dataIS.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    ++count;
                    String[] flds = line.split(";");
                    if (flds.length < 7) {
                        logger.warn("%d BAD format == %s%n", (Object)count, (Object)line);
                        continue;
                    }
                    int fldidx = 0;
                    try {
                        int center = Integer.parseInt(flds[fldidx++].trim());
                        int subcenter = Integer.parseInt(flds[fldidx++].trim());
                        int master = Integer.parseInt(flds[fldidx++].trim());
                        int local = Integer.parseInt(flds[fldidx++].trim());
                        int genProcess = Integer.parseInt(flds[fldidx++].trim());
                        String typeName = StringUtil2.remove((String)flds[fldidx++].trim(), (int)34);
                        String name = StringUtil2.remove((String)flds[fldidx++].trim(), (int)34);
                        String resource = flds.length > 7 ? StringUtil2.remove((String)flds[fldidx++].trim(), (int)34) : null;
                        Grib2TablesId.Type type = Grib2TablesId.Type.valueOf(typeName);
                        Grib2TableConfig table = new Grib2TableConfig(name, center, subcenter, master, local, genProcess, resource, type);
                        result.add(table);
                    }
                    catch (Exception e) {
                        logger.warn("%d %d BAD line == %s : %s%n", new Object[]{count, fldidx, line, e.getMessage()});
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        standardTable = new Grib2TableConfig("WMO", 0, -1, -1, -1, -1, WmoCodeFlagTables.standard.getResourceName(), Grib2TablesId.Type.wmo);
        result.add(standardTable);
        return ImmutableList.copyOf(result);
    }

    static Grib2TableConfig matchTable(Grib2TablesId id) {
        if (tables == null) {
            tables = Grib2TableConfig.init();
        }
        for (Grib2TableConfig table : tables) {
            if (!table.id.match(id)) continue;
            return table;
        }
        return standardTable;
    }

    static ImmutableList<Grib2TableConfig> getTables() {
        if (tables == null) {
            tables = Grib2TableConfig.init();
        }
        return tables;
    }

    private Grib2TableConfig(String name, int center, int subCenter, int masterVersion, int localVersion, int genProcessId, String path, Grib2TablesId.Type type) {
        this.name = name;
        this.path = path;
        this.type = type;
        this.id = new Grib2TablesId(center, subCenter, masterVersion, localVersion, genProcessId);
    }

    String getPath() {
        return this.path;
    }

    String getName() {
        return this.name;
    }

    Grib2TablesId.Type getType() {
        return this.type;
    }

    Grib2TablesId getConfigId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib2TableConfig that = (Grib2TableConfig)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }
}

