/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.writer;

import java.io.Closeable;
import java.io.IOException;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.unidata.io.RandomAccessFile;

public class GribToNetcdfWriter
implements Closeable {
    String fileIn;
    NetcdfFileWriter writer;
    private static final int allOnes = -1;
    private static final int mask23 = -1;
    private static final int mask19 = -16;
    private static final int mask15 = -256;
    private static final int mask11 = -4096;
    private static final int mask07 = -65536;
    private static final int mask03 = -1048576;
    private static final int mask00 = -8388608;

    public GribToNetcdfWriter(String fileIn, String fileOut) throws IOException {
        this.fileIn = fileIn;
        Nc4Chunking chunker = Nc4ChunkingStrategy.factory((Nc4Chunking.Strategy)Nc4Chunking.Strategy.grib, (int)9, (boolean)true);
        this.writer = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf4, (String)fileOut, (Nc4Chunking)chunker);
    }

    public void write() throws IOException {
        try (RandomAccessFile raf = RandomAccessFile.acquire((String)this.fileIn);){
            Grib2RecordScanner scanner = new Grib2RecordScanner(raf);
            while (scanner.hasNext()) {
                Grib2Record gr = scanner.next();
                float[] data = gr.readData(raf);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = GribToNetcdfWriter.bitShave(data[i], -4096);
                }
            }
        }
    }

    public static int getBitMask(int bitN) {
        if (bitN >= 23) {
            return -1;
        }
        return -1 << 23 - bitN;
    }

    public static float bitShave(float value, int bitMask) {
        if (Float.isNaN(value)) {
            return value;
        }
        int bits = Float.floatToRawIntBits(value);
        int shave = bits & bitMask;
        return Float.intBitsToFloat(shave);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public static void main(String[] args) {
        String fileIn = args.length > 0 ? args[0] : "Q:/cdmUnitTest/formats/grib2/LMPEF_CLM_050518_1200.grb";
        String fileOut = args.length > 1 ? args[1] : "C:/tmp/ds.mint.bi";
        try (GribToNetcdfWriter writer = new GribToNetcdfWriter(fileIn, fileOut);){
            writer.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

