/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Parameter;

class NcepLocalParams {
    private static final Logger logger = LoggerFactory.getLogger(NcepLocalParams.class);
    private static final String MATCH = "Table4.2.";
    private static final boolean debugOpen = false;
    private static final boolean debug = false;
    private final Map<Integer, Table> tableMap = new HashMap<Integer, Table>(30);
    private final String resourcePath;

    NcepLocalParams(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Nullable
    public Grib2Parameter getParameter(int discipline, int category, int number) {
        int key = (discipline << 8) + category;
        Table params = this.tableMap.get(key);
        if (params == null) {
            params = this.factory(discipline, category);
            if (params == null) {
                return null;
            }
            this.tableMap.put(key, params);
        }
        return params.getParameter(number);
    }

    @Nullable
    public String getCategory(int discipline, int category) {
        int key = (discipline << 8) + category;
        Table params = this.tableMap.get(key);
        return params == null ? null : params.title;
    }

    @Nullable
    ImmutableList<GribTables.Parameter> getParameters(String path) {
        Table table = new Table();
        if (!table.readParameterTableXml(path)) {
            return null;
        }
        return table.getParameters();
    }

    @Nullable
    private Table factory(int discipline, int category) {
        Table params = new Table();
        if (!params.readParameterTableFromResource(this.getTablePath(discipline, category))) {
            return null;
        }
        return params;
    }

    String getTablePath(int discipline, int category) {
        return this.resourcePath + MATCH + discipline + "." + category + ".xml";
    }

    static class Table {
        private String title;
        private String source;
        private String tableName;
        private int discipline;
        private int category;
        private Map<Integer, Grib2Parameter> paramMap;

        Table() {
        }

        private ImmutableList<GribTables.Parameter> getParameters() {
            return (ImmutableList)this.paramMap.values().stream().sorted().collect(ImmutableList.toImmutableList());
        }

        @Nullable
        public Grib2Parameter getParameter(int code) {
            return this.paramMap.get(code);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean readParameterTableXml(String path) {
            try (InputStream is = GribResourceReader.getInputStream(path);){
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                Element root = doc.getRootElement();
                this.paramMap = this.parseXml(root);
                boolean bl = true;
                return bl;
            }
            catch (IOException | JDOMException ioe) {
                ioe.printStackTrace();
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean readParameterTableFromResource(String resource) {
            ClassLoader cl = this.getClass().getClassLoader();
            try (InputStream is = cl.getResourceAsStream(resource);){
                if (is == null) {
                    logger.info("Cant read resource " + resource);
                    boolean bl2 = false;
                    return bl2;
                }
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                Element root = doc.getRootElement();
                this.paramMap = this.parseXml(root);
                boolean bl = true;
                return bl;
            }
            catch (IOException | JDOMException ioe) {
                ioe.printStackTrace();
                return false;
            }
        }

        HashMap<Integer, Grib2Parameter> parseXml(Element root) {
            this.tableName = root.getChildText("table");
            this.title = root.getChildText("title");
            this.source = root.getChildText("source");
            int pos = this.tableName.indexOf(NcepLocalParams.MATCH);
            String dc = this.tableName.substring(pos + NcepLocalParams.MATCH.length());
            String[] dcs = dc.split("\\.");
            this.discipline = Integer.parseInt(dcs[0]);
            this.category = Integer.parseInt(dcs[1]);
            HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>();
            List params = root.getChildren("parameter");
            for (Element elem : params) {
                String name;
                int code = Integer.parseInt(elem.getAttributeValue("code"));
                String abbrev = elem.getChildText("shortName");
                String desc = elem.getChildText("description");
                String units = elem.getChildText("units");
                if (units == null) {
                    units = "";
                }
                if (desc.length() > 80 && abbrev != null && !abbrev.equalsIgnoreCase("Validation")) {
                    name = abbrev;
                } else {
                    name = desc;
                    desc = null;
                }
                Grib2Parameter parameter = new Grib2Parameter(this.discipline, this.category, code, name, units, abbrev, desc);
                result.put(parameter.getNumber(), parameter);
            }
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("title", (Object)this.title).add("source", (Object)this.source).add("tableName", (Object)this.tableName).add("discipline", this.discipline).add("category", this.category).toString();
        }
    }
}

