/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateEns;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.coord.CoordinateVert;
import ucar.nc2.grib.coord.EnsCoordValue;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.grib.coord.VertCoordType;
import ucar.nc2.grib.coord.VertCoordValue;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.util.Parameter;

class GribIospBuilder {
    private final GribIosp iosp;
    private final boolean isGrib1;
    private final Logger logger;
    private final GribCollectionImmutable gribCollection;
    private final GribTables gribTable;

    GribIospBuilder(GribIosp iosp, boolean isGrib1, Logger logger, GribCollectionImmutable gribCollection, GribTables gribTable) {
        this.iosp = iosp;
        this.isGrib1 = isGrib1;
        this.logger = logger;
        this.gribCollection = gribCollection;
        this.gribTable = gribTable;
    }

    void addGroup(Group.Builder parent, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype, boolean useGroups) {
        Group.Builder g;
        if (useGroups) {
            if (parent.findGroup(group.getId()).isPresent()) {
                this.logger.warn("Duplicate Group - skipping");
                return;
            }
            g = Group.builder((Group.Builder)parent);
            g.setName(group.getId());
            g.addAttribute(new Attribute("long_name", group.getDescription()));
        } else {
            g = parent;
        }
        this.makeGroup(g, group, gctype);
    }

    private void makeGroup(Group.Builder g, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype) {
        String horizDims;
        Variable.Builder hcsV;
        boolean isLatLon;
        GdsHorizCoordSys hcs = group.getGdsHorizCoordSys();
        String grid_mapping = hcs.getName() + "_Projection";
        boolean isRotatedLatLon = !this.isGrib1 && hcs.proj instanceof RotatedPole;
        boolean isLatLon2D = !this.isGrib1 && Grib2Utils.isCurvilinearOrthogonal(hcs.template, this.gribCollection.getCenter());
        boolean bl = isLatLon = this.isGrib1 ? hcs.isLatLon() : Grib2Utils.isLatLon(hcs.template, this.gribCollection.getCenter());
        if (isRotatedLatLon) {
            hcsV = Variable.builder().setName(grid_mapping).setDataType(DataType.INT);
            g.addVariable(hcsV);
            hcsV.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[0], (Object)new int[]{0}), false);
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "rlat rlon";
            g.addDimension(new Dimension("rlat", hcs.ny));
            g.addDimension(new Dimension("rlon", hcs.nx));
            Variable.Builder rlat = Variable.builder().setName("rlat").setDataType(DataType.FLOAT).setDimensionsByName("rlat");
            g.addVariable(rlat);
            rlat.addAttribute(new Attribute("standard_name", "grid_latitude"));
            rlat.addAttribute(new Attribute("units", "degrees"));
            rlat.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.ny, (double)hcs.starty, (double)hcs.dy), false);
            Variable.Builder rlon = Variable.builder().setName("rlon").setDataType(DataType.FLOAT).setDimensionsByName("rlon");
            g.addVariable(rlon);
            rlon.addAttribute(new Attribute("standard_name", "grid_longitude"));
            rlon.addAttribute(new Attribute("units", "degrees"));
            rlon.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.nx, (double)hcs.startx, (double)hcs.dx), false);
        } else if (isLatLon2D) {
            horizDims = "lat lon";
            g.addDimension(new Dimension("lon", hcs.nx));
            g.addDimension(new Dimension("lat", hcs.ny));
        } else if (isLatLon) {
            hcsV = Variable.builder().setName(grid_mapping).setDataType(DataType.INT);
            g.addVariable(hcsV);
            hcsV.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[0], (Object)new int[]{0}), false);
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "lat lon";
            g.addDimension(new Dimension("lon", hcs.nx));
            g.addDimension(new Dimension("lat", hcs.ny));
            Variable.Builder lat = Variable.builder().setName("lat").setDataType(DataType.FLOAT).setDimensionsByName("lat");
            g.addVariable(lat);
            lat.addAttribute(new Attribute("units", "degrees_north"));
            if (hcs.getGaussianLats() != null) {
                lat.setCachedData(hcs.getGaussianLats(), false);
                lat.addAttribute(new Attribute("gaussian_lats", "true"));
            } else {
                lat.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.ny, (double)hcs.starty, (double)hcs.dy), false);
            }
            Variable.Builder lon = Variable.builder().setName("lon").setDataType(DataType.FLOAT).setDimensionsByName("lon");
            g.addVariable(lon);
            lon.addAttribute(new Attribute("units", "degrees_east"));
            lon.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.nx, (double)hcs.startx, (double)hcs.dx), false);
        } else {
            hcsV = Variable.builder().setName(grid_mapping).setDataType(DataType.INT);
            g.addVariable(hcsV);
            hcsV.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[0], (Object)new int[]{0}), false);
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "y x";
            g.addDimension(new Dimension("x", hcs.nx));
            g.addDimension(new Dimension("y", hcs.ny));
            Variable.Builder xcv = Variable.builder().setName("x").setDataType(DataType.FLOAT).setDimensionsByName("x");
            g.addVariable(xcv);
            xcv.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            xcv.addAttribute(new Attribute("units", "km"));
            xcv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.nx, (double)hcs.startx, (double)hcs.dx), false);
            Variable.Builder ycv = Variable.builder().setName("y").setDataType(DataType.FLOAT).setDimensionsByName("y");
            g.addVariable(ycv);
            ycv.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            ycv.addAttribute(new Attribute("units", "km"));
            ycv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.ny, (double)hcs.starty, (double)hcs.dy), false);
        }
        boolean singleRuntimeWasMade = false;
        for (Coordinate coord : group.coords) {
            Coordinate.Type ctype = coord.getType();
            switch (ctype) {
                case runtime: {
                    if (!gctype.isTwoD() && coord.getNCoords() != 1) break;
                    this.makeRuntimeCoordinate(g, (CoordinateRuntime)coord);
                    break;
                }
                case timeIntv: {
                    this.makeTimeCoordinate1D(g, (CoordinateTimeIntv)coord);
                    break;
                }
                case time: {
                    this.makeTimeCoordinate1D(g, (CoordinateTime)coord);
                    break;
                }
                case vert: {
                    this.makeVerticalCoordinate(g, (CoordinateVert)coord);
                    break;
                }
                case ens: {
                    this.makeEnsembleCoordinate(g, (CoordinateEns)coord);
                    break;
                }
                case time2D: {
                    if (gctype.isUniqueTime()) {
                        this.makeUniqueTimeCoordinate2D(g, (CoordinateTime2D)coord);
                        break;
                    }
                    this.makeTimeCoordinate2D(g, (CoordinateTime2D)coord, gctype);
                }
            }
        }
        for (GribCollectionImmutable.VariableIndex vindex : group.variList) {
            Formatter dimNames = new Formatter();
            Throwable throwable = null;
            try {
                Formatter coordinateAtt = new Formatter();
                Throwable throwable2 = null;
                try {
                    Coordinate run = vindex.getCoordinate(Coordinate.Type.runtime);
                    CoordinateTimeAbstract time = vindex.getCoordinateTime();
                    if (time == null) {
                        throw new IllegalStateException("No time coordinate = " + vindex);
                    }
                    boolean isRunScaler = run != null && run.getSize() == 1;
                    switch (gctype) {
                        case SRC: {
                            assert (isRunScaler);
                            dimNames.format("%s ", time.getName());
                            coordinateAtt.format("%s %s ", run.getName(), time.getName());
                            break;
                        }
                        case MRUTP: 
                        case MRUTC: {
                            dimNames.format("%s ", time.getName());
                            coordinateAtt.format("ref%s %s ", time.getName(), time.getName());
                            break;
                        }
                        case MRC: 
                        case TwoD: {
                            assert (run != null) : "GRIB MRC or TWOD does not have run coordinate";
                            if (isRunScaler) {
                                dimNames.format("%s ", time.getName());
                            } else {
                                dimNames.format("%s %s ", run.getName(), time.getName());
                            }
                            coordinateAtt.format("%s %s ", run.getName(), time.getName());
                            break;
                        }
                        case Best: 
                        case BestComplete: {
                            dimNames.format("%s ", time.getName());
                            coordinateAtt.format("ref%s %s ", time.getName(), time.getName());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Uknown GribCollection TYpe = " + (Object)((Object)gctype));
                        }
                    }
                    for (Coordinate coord : vindex.getCoordinates()) {
                        if (coord instanceof CoordinateTimeAbstract || coord instanceof CoordinateRuntime) continue;
                        String name = coord.getName().toLowerCase();
                        dimNames.format("%s ", name);
                        coordinateAtt.format("%s ", name);
                    }
                    dimNames.format("%s", horizDims);
                    coordinateAtt.format("%s ", horizDims);
                    String vname = this.iosp.makeVariableName(vindex);
                    Variable.Builder v = Variable.builder().setName(vname).setDataType(DataType.FLOAT).setDimensionsByName(dimNames.toString());
                    g.addVariable(v);
                    String desc = this.iosp.makeVariableLongName(vindex);
                    v.addAttribute(new Attribute("long_name", desc));
                    v.addAttribute(new Attribute("units", this.iosp.makeVariableUnits(vindex)));
                    GribTables.Parameter gp = this.iosp.getParameter(vindex);
                    if (gp != null) {
                        if (gp.getDescription() != null) {
                            v.addAttribute(new Attribute("description", gp.getDescription()));
                        }
                        if (gp.getAbbrev() != null) {
                            v.addAttribute(new Attribute("abbreviation", gp.getAbbrev()));
                        }
                        v.addAttribute(new Attribute("missing_value", (Number)gp.getMissing()));
                        if (gp.getFill() != null) {
                            v.addAttribute(new Attribute("_FillValue", (Number)gp.getFill()));
                        }
                    } else {
                        v.addAttribute(new Attribute("missing_value", (Number)Float.valueOf(Float.NaN)));
                    }
                    if (isLatLon2D) {
                        String s = this.iosp.searchCoord(Grib2Utils.getLatLon2DcoordType(desc), group.variList);
                        if (s == null) {
                            v.setDimensionsByName(horizDims);
                            String units = desc.contains("Latitude of") ? "degrees_north" : "degrees_east";
                            v.addAttribute(new Attribute("units", units));
                        } else {
                            coordinateAtt.format("%s ", s);
                        }
                    } else {
                        v.addAttribute(new Attribute("grid_mapping", grid_mapping));
                    }
                    v.addAttribute(new Attribute("coordinates", coordinateAtt.toString()));
                    if (vindex.getIntvType() >= 0) {
                        GribStatType statType = this.gribTable.getStatType(vindex.getIntvType());
                        if (statType != null) {
                            v.addAttribute(new Attribute("Grib_Statistical_Interval_Type", statType.toString()));
                            CF.CellMethods cm = GribStatType.getCFCellMethod(statType);
                            Coordinate timeCoord = vindex.getCoordinate(Coordinate.Type.timeIntv);
                            if (cm != null && timeCoord != null) {
                                v.addAttribute(new Attribute("cell_methods", timeCoord.getName() + ": " + cm));
                            }
                        } else {
                            v.addAttribute(new Attribute("Grib_Statistical_Interval_Type", (Number)vindex.getIntvType()));
                        }
                    }
                    this.gribCollection.addVariableAttributes((AttributeContainer)v.getAttributeContainer(), vindex);
                    v.setSPobject((Object)vindex);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (coordinateAtt == null) continue;
                    if (throwable2 != null) {
                        try {
                            coordinateAtt.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    coordinateAtt.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (dimNames == null) continue;
                if (throwable != null) {
                    try {
                        dimNames.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                dimNames.close();
            }
        }
    }

    private void makeRuntimeCoordinate(Group.Builder g, CoordinateRuntime rtc) {
        String dims;
        int n = rtc.getSize();
        boolean isScalar = n == 1;
        String tcName = rtc.getName();
        String string = dims = isScalar ? null : rtc.getName();
        if (!isScalar) {
            g.addDimension(new Dimension(tcName, n));
        }
        Variable.Builder v = Variable.builder().setName(tcName).setDataType(DataType.DOUBLE).setDimensionsByName(dims);
        g.addVariable(v);
        v.addAttribute(new Attribute("units", rtc.getUnit()));
        v.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        v.addAttribute(new Attribute("long_name", "GRIB reference time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        v.setSPobject((Object)new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.reftime, null, rtc));
    }

    private void makeUniqueTimeCoordinate2D(Group.Builder g, CoordinateTime2D time2D) {
        String refName;
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int countU = 0;
        for (int run = 0; run < time2D.getNruns(); ++run) {
            CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
            countU += timeCoord.getSize();
        }
        int ntimes = countU;
        String tcName = time2D.getName();
        g.addDimension(new Dimension(tcName, ntimes));
        Variable.Builder v = Variable.builder().setName(tcName).setDataType(DataType.DOUBLE).setDimensionsByName(tcName);
        g.addVariable(v);
        String units = runtime.getUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!time2D.isTimeInterval()) {
            v.setSPobject((Object)new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.offU, time2D, null));
        } else {
            v.setSPobject((Object)new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.intvU, time2D, null));
            String bounds_name = tcName + "_bounds";
            Variable.Builder bounds = Variable.builder().setName(bounds_name).setDataType(DataType.DOUBLE).setDimensionsByName(tcName + " 2");
            g.addVariable(bounds);
            v.addAttribute(new Attribute("bounds", bounds_name));
            bounds.addAttribute(new Attribute("units", units));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            bounds.setSPobject((Object)new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.boundsU, time2D, null));
        }
        if (runtime.getNCoords() != 1 && !g.findVariable(refName = "ref" + tcName).isPresent()) {
            Variable.Builder vref = Variable.builder().setName(refName).setDataType(DataType.DOUBLE).setDimensionsByName(tcName);
            g.addVariable(vref);
            vref.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
            vref.addAttribute(new Attribute("long_name", "GRIB reference time"));
            vref.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
            vref.addAttribute(new Attribute("units", units));
            vref.setSPobject((Object)new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.isUniqueRuntime, time2D, null));
        }
    }

    private void makeTimeCoordinate2D(Group.Builder g, CoordinateTime2D time2D, GribCollectionImmutable.Type gctype) {
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int ntimes = time2D.getNtimes();
        String tcName = time2D.getName();
        String dims = runtime.getName() + " " + tcName;
        int dimLength = ntimes;
        g.addDimension(new Dimension(tcName, dimLength));
        Variable.Builder v = Variable.builder().setName(tcName).setDataType(DataType.DOUBLE).setDimensionsByName(dims);
        g.addVariable(v);
        String units = runtime.getUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!time2D.isTimeInterval()) {
            v.setSPobject((Object)new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.off, time2D, null));
        } else {
            v.setSPobject((Object)new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.intv, time2D, null));
            String bounds_name = tcName + "_bounds";
            Variable.Builder bounds = Variable.builder().setName(bounds_name).setDataType(DataType.DOUBLE).setDimensionsByName(dims + " 2");
            g.addVariable(bounds);
            v.addAttribute(new Attribute("bounds", bounds_name));
            bounds.addAttribute(new Attribute("units", units));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            bounds.setSPobject((Object)new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.bounds, time2D, null));
        }
    }

    private Array makeLazyCoordinateData(Variable v2, GribIosp.Time2Dinfo info) {
        if (info.time2D != null) {
            return this.makeLazyTime2Darray(v2, info);
        }
        return this.makeLazyTime1Darray(v2, info);
    }

    private Array makeLazyTime1Darray(Variable v2, GribIosp.Time2Dinfo info) {
        int length = info.time1D.getSize();
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case reftime: {
                CoordinateRuntime rtc = (CoordinateRuntime)info.time1D;
                int count = 0;
                for (double val : rtc.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                return Array.factory((DataType)DataType.DOUBLE, (int[])v2.getShape(), (Object)data);
            }
            case timeAuxRef: {
                CoordinateTimeAbstract time = (CoordinateTimeAbstract)info.time1D;
                int count = 0;
                List<Double> masterOffsets = this.gribCollection.getMasterRuntime().getOffsetsInTimeUnits();
                for (int masterIdx : time.getTime2runtime()) {
                    data[count++] = masterOffsets.get(masterIdx - 1);
                }
                return Array.factory((DataType)DataType.DOUBLE, (int[])v2.getShape(), (Object)data);
            }
        }
        throw new IllegalStateException("makeLazyTime1Darray must be reftime or timeAuxRef");
    }

    private Array makeLazyTime2Darray(Variable coord, GribIosp.Time2Dinfo info) {
        CoordinateTime2D time2D = info.time2D;
        CalendarPeriod timeUnit = time2D.getTimeUnit();
        int nruns = time2D.getNruns();
        int ntimes = time2D.getNtimes();
        int length = (int)coord.getSize();
        if (info.which == GribIosp.Time2DinfoType.bounds) {
            length *= 2;
        }
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case off: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (int val : coordTime.getOffsetSorted()) {
                        data[runIdx * ntimes + timeIdx] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case offU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    for (int val : coordTime.getOffsetSorted()) {
                        data[count++] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case intv: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes + timeIdx] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case intvU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case is1Dtime: {
                CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
                int count = 0;
                for (double val : runtime.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                break;
            }
            case isUniqueRuntime: {
                CoordinateRuntime runtimeU = time2D.getRuntimeCoordinate();
                List<Double> runOffsets = runtimeU.getOffsetsInTimeUnits();
                int count = 0;
                for (int run = 0; run < time2D.getNruns(); ++run) {
                    CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
                    for (int time = 0; time < timeCoord.getNCoords(); ++time) {
                        data[count++] = runOffsets.get(run);
                    }
                }
                break;
            }
            case bounds: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes * 2 + timeIdx] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[runIdx * ntimes * 2 + timeIdx + 1] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                        timeIdx += 2;
                    }
                }
                break;
            }
            case boundsU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Array.factory((DataType)DataType.DOUBLE, (int[])coord.getShape(), (Object)data);
    }

    private void makeTimeCoordinate1D(Group.Builder g, CoordinateTime coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        g.addDimension(new Dimension(tcName, ntimes));
        Variable.Builder v = Variable.builder().setName(tcName).setDataType(DataType.DOUBLE).setDimensionsByName(dims);
        g.addVariable(v);
        String units = coordTime.getTimeUdUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (int val : coordTime.getOffsetSorted()) {
            data[count++] = val;
        }
        v.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ntimes}, (Object)data), false);
        this.makeTimeAuxReference(g, tcName, units, coordTime);
    }

    private void makeTimeAuxReference(Group.Builder g, String timeName, String units, CoordinateTimeAbstract time) {
        if (time.getTime2runtime() == null) {
            return;
        }
        String tcName = "ref" + timeName;
        Variable.Builder v = Variable.builder().setName(tcName).setDataType(DataType.DOUBLE).setDimensionsByName(timeName);
        g.addVariable(v);
        v.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        v.addAttribute(new Attribute("long_name", "GRIB reference time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        v.addAttribute(new Attribute("units", units));
        v.setSPobject((Object)new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.timeAuxRef, null, time));
    }

    private void makeTimeCoordinate1D(Group.Builder g, CoordinateTimeIntv coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        g.addDimension(new Dimension(tcName, ntimes));
        Variable.Builder v = Variable.builder().setName(tcName).setDataType(DataType.DOUBLE).setDimensionsByName(dims);
        g.addVariable(v);
        String units = coordTime.getTimeUdUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (TimeCoordIntvValue tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds2();
        }
        v.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ntimes}, (Object)data), false);
        String bounds_name = tcName + "_bounds";
        Variable.Builder bounds = Variable.builder().setName(bounds_name).setDataType(DataType.DOUBLE).setDimensionsByName(dims + " 2");
        g.addVariable(bounds);
        v.addAttribute(new Attribute("bounds", bounds_name));
        bounds.addAttribute(new Attribute("units", units));
        bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
        data = new double[ntimes * 2];
        count = 0;
        for (TimeCoordIntvValue tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds1();
            data[count++] = tinv.getBounds2();
        }
        bounds.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ntimes, 2}, (Object)data), false);
        this.makeTimeAuxReference(g, tcName, units, coordTime);
    }

    private void makeVerticalCoordinate(Group.Builder g, CoordinateVert vc) {
        int n = vc.getSize();
        String vcName = vc.getName().toLowerCase();
        g.addDimension(new Dimension(vcName, n));
        Variable.Builder v = Variable.builder().setName(vcName).setDataType(DataType.FLOAT).setDimensionsByName(vcName);
        g.addVariable(v);
        if (vc.getUnit() != null) {
            v.addAttribute(new Attribute("units", vc.getUnit()));
            String desc = this.iosp.getVerticalCoordDesc(vc.getCode());
            if (desc != null) {
                v.addAttribute(new Attribute("long_name", desc));
            }
            v.addAttribute(new Attribute("positive", vc.isPositiveUp() ? "up" : "down"));
        }
        v.addAttribute(new Attribute("Grib_level_type", (Number)vc.getCode()));
        VertCoordType vu = vc.getVertUnit();
        if (vu != null && vu.getDatum() != null) {
            v.addAttribute(new Attribute("datum", vu.getDatum()));
        }
        if (vc.isLayer()) {
            float[] data = new float[n];
            int count = 0;
            for (VertCoordValue val : vc.getLevelSorted()) {
                data[count++] = (float)(val.getValue1() + val.getValue2()) / 2.0f;
            }
            v.setCachedData(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n}, (Object)data), false);
            Variable.Builder bounds = Variable.builder().setName(vcName + "_bounds").setDataType(DataType.FLOAT).setDimensionsByName(vcName + " 2");
            g.addVariable(bounds);
            v.addAttribute(new Attribute("bounds", vcName + "_bounds"));
            String vcUnit = vc.getUnit();
            if (vcUnit != null) {
                bounds.addAttribute(new Attribute("units", vcUnit));
            }
            bounds.addAttribute(new Attribute("long_name", "bounds for " + vcName));
            data = new float[2 * n];
            count = 0;
            for (VertCoordValue level : vc.getLevelSorted()) {
                data[count++] = (float)level.getValue1();
                data[count++] = (float)level.getValue2();
            }
            bounds.setCachedData(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n, 2}, (Object)data), false);
        } else {
            float[] data = new float[n];
            int count = 0;
            for (VertCoordValue val : vc.getLevelSorted()) {
                data[count++] = (float)val.getValue1();
            }
            v.setCachedData(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n}, (Object)data), false);
        }
    }

    private void makeEnsembleCoordinate(Group.Builder g, CoordinateEns ec) {
        int n = ec.getSize();
        String ecName = ec.getName().toLowerCase();
        g.addDimension(new Dimension(ecName, n));
        Variable.Builder v = Variable.builder().setName(ecName).setDataType(DataType.INT).setDimensionsByName(ecName);
        g.addVariable(v);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
        int[] data = new int[n];
        int count = 0;
        for (EnsCoordValue ecc : ec.getEnsSorted()) {
            data[count++] = ecc.getEnsMember();
        }
        v.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[]{n}, (Object)data), false);
    }
}

