/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateBuilderImpl;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.Counters;
import ucar.nc2.util.Indent;

@Immutable
public class CoordinateRuntime
implements Coordinate {
    private final long[] runtimes;
    final CalendarDate firstDate;
    final CalendarPeriod timeUnit;
    final String periodName;
    private String name = "reftime";

    public CoordinateRuntime(List<Long> runtimeSorted, CalendarPeriod timeUnit) {
        this.runtimes = new long[runtimeSorted.size()];
        int idx = 0;
        for (long val : runtimeSorted) {
            this.runtimes[idx++] = val;
        }
        this.firstDate = CalendarDate.of((long)runtimeSorted.get(0));
        this.timeUnit = timeUnit == null ? CalendarPeriod.Hour : timeUnit;
        CalendarPeriod.Field cf = this.timeUnit.getField();
        this.periodName = cf == CalendarPeriod.Field.Month || cf == CalendarPeriod.Field.Year ? "calendar " + cf : cf.toString();
    }

    public CalendarPeriod getTimeUnits() {
        return this.timeUnit;
    }

    public CalendarDate getRuntimeDate(int idx) {
        return CalendarDate.of((long)this.runtimes[idx]);
    }

    public long getRuntime(int idx) {
        return this.runtimes[idx];
    }

    public String getPeriodName() {
        return this.periodName;
    }

    public List<Double> getOffsetsInTimeUnits() {
        double start = this.firstDate.getMillis();
        ArrayList<Double> result = new ArrayList<Double>(this.runtimes.length);
        for (int idx = 0; idx < this.runtimes.length; ++idx) {
            double runtime = this.getRuntime(idx);
            double msecs = runtime - start;
            result.add(msecs / this.timeUnit.getValueInMillisecs());
        }
        return result;
    }

    public double getOffsetInTimeUnits(CalendarDate start) {
        return this.timeUnit.getOffset(start, this.getFirstDate());
    }

    @Override
    public int getSize() {
        return this.runtimes.length;
    }

    @Override
    public int getNCoords() {
        return this.getSize();
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.runtime;
    }

    @Override
    public int estMemorySize() {
        return 616 + this.getSize() * 48;
    }

    @Override
    public String getUnit() {
        return this.periodName + " since " + this.firstDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.name.equals("reftime")) {
            throw new IllegalStateException("Cant modify");
        }
        this.name = name;
    }

    @Override
    public int getCode() {
        return 0;
    }

    public CalendarDate getFirstDate() {
        return this.firstDate;
    }

    public CalendarDate getLastDate() {
        return this.getRuntimeDate(this.getSize() - 1);
    }

    @Override
    public List<?> getValues() {
        ArrayList<Long> result = new ArrayList<Long>(this.runtimes.length);
        for (long val : this.runtimes) {
            result.add(val);
        }
        return result;
    }

    @Override
    public int getIndex(Object val) {
        long want;
        if (val instanceof CalendarDate) {
            want = ((CalendarDate)val).getMillis();
        } else if (val instanceof Number) {
            want = ((Number)val).longValue();
        } else {
            throw new IllegalArgumentException(val.getClass().getName());
        }
        return Arrays.binarySearch(this.runtimes, want);
    }

    @Override
    public Object getValue(int idx) {
        return this.runtimes[idx];
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s%s:", new Object[]{indent, this.getType()});
        for (int idx = 0; idx < this.getSize(); ++idx) {
            info.format(" %s,", this.getRuntimeDate(idx));
        }
        info.format(" (%d) %n", this.runtimes.length);
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("Run Times: %s (%s)%n", this.getName(), this.getUnit());
        List<Double> udunits = this.getOffsetsInTimeUnits();
        int count = 0;
        for (int idx = 0; idx < this.getSize(); ++idx) {
            info.format("   %s (%f)%n", this.getRuntimeDate(idx), udunits.get(count++));
        }
    }

    @Override
    public Counters calcDistributions() {
        Counters counters = new Counters();
        counters.add("resol");
        List<Double> offsets = this.getOffsetsInTimeUnits();
        for (int i = 0; i < offsets.size() - 1; ++i) {
            Double diff = offsets.get(i + 1) - offsets.get(i);
            counters.count("resol", (Comparable)diff);
        }
        return counters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateRuntime that = (CoordinateRuntime)o;
        if (!this.periodName.equals(that.periodName)) {
            return false;
        }
        return Arrays.equals(this.runtimes, that.runtimes);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.runtimes);
        result = 31 * result + this.periodName.hashCode();
        return result;
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record> {
        CalendarPeriod timeUnit;

        public Builder1(CalendarPeriod timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public Object extract(Grib1Record gr) {
            return gr.getReferenceDate().getMillis();
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<Long> runtimeSorted = new ArrayList<Long>(values.size());
            for (Object val : values) {
                runtimeSorted.add((Long)val);
            }
            Collections.sort(runtimeSorted);
            return new CoordinateRuntime(runtimeSorted, this.timeUnit);
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record> {
        CalendarPeriod timeUnit;

        public Builder2(CalendarPeriod timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public Object extract(Grib2Record gr) {
            return gr.getReferenceDate().getMillis();
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<Long> runtimeSorted = new ArrayList<Long>(values.size());
            for (Object val : values) {
                runtimeSorted.add((Long)val);
            }
            Collections.sort(runtimeSorted);
            return new CoordinateRuntime(runtimeSorted, this.timeUnit);
        }
    }
}

