/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;

public class Grib1Variable {
    private final Grib1Customizer cust;
    private final Grib1SectionProductDefinition pds;
    private final Grib1Gds gds;
    private final int gdsHash;
    private final boolean useTableVersion;
    private final boolean intvMerge;
    private final boolean useCenter;

    public static int cdmVariableHash(Grib1Customizer cust, Grib1Record gr, int gdsHashOverride, boolean useTableVersion, boolean intvMerge, boolean useCenter) {
        Grib1Variable gv = new Grib1Variable(cust, gr, gdsHashOverride, useTableVersion, intvMerge, useCenter);
        return gv.hashCode();
    }

    public Grib1Variable(Grib1Customizer cust, Grib1Record gr, int gdsHashOverride, boolean useTableVersion, boolean intvMerge, boolean useCenter) {
        this.cust = cust;
        this.pds = gr.getPDSsection();
        this.gds = gr.getGDS();
        this.gdsHash = gdsHashOverride != 0 ? gdsHashOverride : gr.getGDS().hashCode();
        this.useTableVersion = useTableVersion;
        this.intvMerge = intvMerge;
        this.useCenter = useCenter;
    }

    public Grib1Variable(Grib1Customizer cust, Grib1SectionProductDefinition pds, Grib1Gds gds, boolean useTableVersion, boolean intvMerge, boolean useCenter) {
        this.cust = cust;
        this.pds = pds;
        this.gds = gds;
        this.gdsHash = gds.hashCode();
        this.useTableVersion = useTableVersion;
        this.intvMerge = intvMerge;
        this.useCenter = useCenter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib1Variable var2 = (Grib1Variable)o;
        if (this.gdsHash != var2.gdsHash) {
            return false;
        }
        if (!this.gds.equals(var2.gds)) {
            return false;
        }
        Grib1SectionProductDefinition pds2 = var2.pds;
        if (this.pds.getParameterNumber() != pds2.getParameterNumber()) {
            return false;
        }
        if (this.pds.getLevelType() != pds2.getLevelType()) {
            return false;
        }
        if (this.useTableVersion && this.pds.getTableVersion() != pds2.getTableVersion()) {
            return false;
        }
        Grib1ParamTime ptime = this.cust.getParamTime(this.pds);
        Grib1ParamTime ptime2 = this.cust.getParamTime(pds2);
        if (ptime.isInterval() != ptime2.isInterval()) {
            return false;
        }
        if (ptime.isInterval()) {
            if (!this.intvMerge && ptime.getIntervalSize() != ptime2.getIntervalSize()) {
                return false;
            }
            if (ptime.getStatType() != ptime2.getStatType()) {
                return false;
            }
        }
        if (this.useCenter && this.pds.getParameterNumber() > 127) {
            if (this.pds.getCenter() != pds2.getCenter()) {
                return false;
            }
            return this.pds.getSubCenter() == pds2.getSubCenter();
        }
        return true;
    }

    public int hashCode() {
        Grib1ParamTime ptime;
        int result = 17;
        result += result * 31 + this.pds.getParameterNumber();
        result += result * 31 + this.gdsHash;
        result += result * 31 + this.pds.getLevelType();
        if (this.useTableVersion) {
            result += result * 31 + this.pds.getTableVersion();
        }
        if ((ptime = this.cust.getParamTime(this.pds)).isInterval()) {
            if (!this.intvMerge) {
                result += result * 31 + ptime.getIntervalSize();
            }
            if (ptime.getStatType() != null) {
                result += result * 31 + ptime.getStatType().ordinal();
            }
        }
        if (this.useCenter && this.pds.getParameterNumber() > 127) {
            result += result * 31 + this.pds.getCenter();
            if (this.pds.getSubCenter() > 0) {
                result += result * 31 + this.pds.getSubCenter();
            }
        }
        return result;
    }

    public String makeVariableName(FeatureCollectionConfig.GribConfig gribConfig) {
        return Grib1Iosp.makeVariableName(this.cust, gribConfig, this.pds);
    }
}

