/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.Formatter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EnsCoordValue
implements Comparable<EnsCoordValue> {
    private final int code;
    private final int ensMember;
    private final int ensNumber;

    public EnsCoordValue(int code, int ensMember) {
        this(code, ensMember, 0);
    }

    public EnsCoordValue(int code, int ensMember, int ensNumber) {
        this.code = code;
        this.ensMember = ensMember;
        this.ensNumber = ensNumber;
    }

    public int getCode() {
        return this.code;
    }

    public int getEnsMember() {
        return this.ensMember;
    }

    public int getEnsNumber() {
        return this.ensNumber;
    }

    @Override
    public int compareTo(@Nonnull EnsCoordValue o) {
        int r = Integer.compare(this.code, o.code);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.ensNumber, o.ensNumber);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.ensMember, o.ensMember);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnsCoordValue that = (EnsCoordValue)o;
        return this.code == that.code && this.ensMember == that.ensMember && this.ensNumber == that.ensNumber;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.ensMember;
        result += 31 * this.code;
        return result += 31 * this.ensNumber;
    }

    public String toString() {
        try (Formatter out = new Formatter();){
            out.format("(%d %d %d)", this.code, this.ensMember, this.ensNumber);
            String string = out.toString();
            return string;
        }
    }
}

