/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.coord.CalendarDateFactory;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public abstract class CoordinateTimeAbstract
implements Coordinate {
    public static final String MIXED_INTERVALS = "Mixed_intervals";
    public static CalendarDateFactory cdf;
    final String periodName;
    protected final int code;
    protected final CalendarPeriod timeUnit;
    protected final CalendarDate refDate;
    protected final int[] time2runtime;
    protected String name = "time";

    CoordinateTimeAbstract(int code, CalendarPeriod timeUnit, CalendarDate refDate, int[] time2runtime) {
        this.code = code;
        this.timeUnit = timeUnit;
        this.refDate = cdf == null ? refDate : cdf.get(refDate);
        this.time2runtime = time2runtime;
        CalendarPeriod.Field cf = timeUnit.getField();
        this.periodName = cf == CalendarPeriod.Field.Month || cf == CalendarPeriod.Field.Year ? "calendar " + cf : cf.toString();
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getUnit() {
        return this.periodName;
    }

    public String getTimeUdUnit() {
        return this.periodName + " since " + this.refDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.name.equals("time")) {
            throw new IllegalStateException("Cant modify");
        }
        this.name = name;
    }

    public CalendarDate getRefDate() {
        return this.refDate;
    }

    public CalendarPeriod getTimeUnit() {
        return this.timeUnit;
    }

    public int[] getTime2runtime() {
        return this.time2runtime;
    }

    public int getMasterRuntimeIndex(int timeIdx) {
        if (this.time2runtime == null) {
            return -1;
        }
        if (timeIdx < 0 || timeIdx >= this.time2runtime.length) {
            return -1;
        }
        return this.time2runtime[timeIdx];
    }

    @Override
    public int getNCoords() {
        return this.getSize();
    }

    public double getOffsetInTimeUnits(CalendarDate start) {
        return this.timeUnit.getOffset(start, this.getRefDate());
    }

    public String toString() {
        return this.name;
    }

    public CoordinateTimeAbstract makeBestFromComplete() {
        int[] best = new int[this.time2runtime.length];
        int last = -1;
        int count = 0;
        for (int i = 0; i < this.time2runtime.length; ++i) {
            int time = this.time2runtime[i];
            if (time >= last) {
                last = time;
                best[i] = time;
                ++count;
                continue;
            }
            best[i] = -1;
        }
        return this.makeBestFromComplete(best, count);
    }

    protected abstract CoordinateTimeAbstract makeBestFromComplete(int[] var1, int var2);

    public abstract CalendarDateRange makeCalendarDateRange(Calendar var1);
}

