/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFile;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.coverage.GribCoverageDataset;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Collection
extends GribCollectionImmutable {
    Grib1Collection(GribCollectionMutable gc) {
        super(gc);
    }

    @Override
    @Nullable
    public NetcdfDataset getNetcdfDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
            RandomAccessFile raf = (RandomAccessFile)iosp.sendIospMessage("RandomAccessFile");
            NetcdfFile ncfile = NetcdfFiles.build((IOServiceProvider)iosp, (RandomAccessFile)raf, (String)this.getLocation(), null);
            return NetcdfDatasets.enhance((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollectionImmutable gc = GribCdmIndex.openGribCollectionFromDataFile(true, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib1Iosp iosp = new Grib1Iosp(gc);
            RandomAccessFile raf = (RandomAccessFile)iosp.sendIospMessage("RandomAccessFile");
            NetcdfFile ncfile = NetcdfFiles.build((IOServiceProvider)iosp, (RandomAccessFile)raf, (String)this.getLocation(), null);
            return NetcdfDatasets.enhance((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
        }
        return null;
    }

    @Override
    @Nullable
    public GridDataset getGridDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
            RandomAccessFile raf = (RandomAccessFile)iosp.sendIospMessage("RandomAccessFile");
            NetcdfFile ncfile = NetcdfFiles.build((IOServiceProvider)iosp, (RandomAccessFile)raf, (String)(this.getLocation() + "#" + group.getId()), null);
            NetcdfDataset ncd = NetcdfDatasets.enhance((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
            return new GridDataset(ncd);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollectionImmutable gc = GribCdmIndex.openGribCollectionFromDataFile(true, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib1Iosp iosp = new Grib1Iosp(gc);
            RandomAccessFile raf = (RandomAccessFile)iosp.sendIospMessage("RandomAccessFile");
            NetcdfFile ncfile = NetcdfFiles.build((IOServiceProvider)iosp, (RandomAccessFile)raf, (String)this.getLocation(), null);
            NetcdfDataset ncd = NetcdfDatasets.enhance((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
            return new GridDataset(ncd);
        }
        return null;
    }

    @Override
    @Nullable
    public CoverageCollection getGridCoverage(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            GribCoverageDataset gribCov = new GribCoverageDataset(this, ds, group);
            return gribCov.createCoverageCollection();
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollectionImmutable gc = GribCdmIndex.openGribCollectionFromDataFile(true, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            GribCoverageDataset gribCov = new GribCoverageDataset(gc, null, null);
            return gribCov.createCoverageCollection();
        }
        return null;
    }

    @Override
    public void addGlobalAttributes(AttributeContainerMutable result) {
        String val = this.cust.getGeneratingProcessName(this.getGenProcessId());
        if (val != null) {
            result.addAttribute(new Attribute("Generating_process_or_model", val));
        }
        result.addAttribute(new Attribute("file_format", DataFormatType.GRIB1.getDescription()));
    }

    @Override
    public String makeVariableId(GribCollectionImmutable.VariableIndex v) {
        return Grib1Collection.makeVariableId(this.getCenter(), this.getSubcenter(), v.getTableVersion(), v.getParameter(), v.getLevelType(), v.isLayer(), v.getIntvType(), v.getIntvName());
    }

    static String makeVariableId(int center, int subcenter, int tableVersion, int paramNo, int levelType, boolean isLayer, int intvType, String intvName) {
        try (Formatter f = new Formatter();){
            f.format("VAR_%d-%d-%d-%d", center, subcenter, tableVersion, paramNo);
            if (levelType != -9999) {
                f.format("_L%d", levelType);
                if (isLayer) {
                    f.format("_layer", new Object[0]);
                }
            }
            if (intvType >= 0) {
                if (intvName != null) {
                    if (intvName.equals("Mixed_intervals")) {
                        f.format("_Imixed", new Object[0]);
                    } else {
                        f.format("_I%s", intvName);
                    }
                }
                f.format("_S%s", intvType);
            }
            String string = f.toString();
            return string;
        }
    }

    @Override
    public void addVariableAttributes(AttributeContainerMutable v, GribCollectionImmutable.VariableIndex vindex) {
        Grib1Collection.addVariableAttributes(v, vindex, this);
    }

    static void addVariableAttributes(AttributeContainerMutable v, GribCollectionImmutable.VariableIndex vindex, GribCollectionImmutable gc) {
        String timeTypeName;
        String ldesc;
        Grib1Customizer cust1 = (Grib1Customizer)gc.cust;
        v.addAttribute(new Attribute("Grib_Variable_Id", gc.makeVariableId(vindex)));
        v.addAttribute(new Attribute("Grib1_Center", (Number)gc.getCenter()));
        v.addAttribute(new Attribute("Grib1_Subcenter", (Number)gc.getSubcenter()));
        v.addAttribute(new Attribute("Grib1_TableVersion", (Number)vindex.getTableVersion()));
        v.addAttribute(new Attribute("Grib1_Parameter", (Number)vindex.getParameter()));
        Grib1Parameter param = cust1.getParameter(gc.getCenter(), gc.getSubcenter(), vindex.getTableVersion(), vindex.getParameter());
        if (param != null && param.getName() != null) {
            v.addAttribute(new Attribute("Grib1_Parameter_Name", param.getName()));
        }
        if (vindex.getLevelType() != 255) {
            v.addAttribute(new Attribute("Grib1_Level_Type", (Number)vindex.getLevelType()));
        }
        if ((ldesc = cust1.getLevelDescription(vindex.getLevelType())) != null) {
            v.addAttribute(new Attribute("Grib1_Level_Desc", ldesc));
        }
        if ((timeTypeName = cust1.getTimeTypeName(vindex.getIntvType())) != null && !timeTypeName.isEmpty()) {
            v.addAttribute(new Attribute("Grib1_Interval_Type", (Number)vindex.getIntvType()));
            v.addAttribute(new Attribute("Grib1_Interval_Name", timeTypeName));
        }
        if (vindex.getEnsDerivedType() >= 0) {
            v.addAttribute(new Attribute("Grib1_Ensemble_Derived_Type", (Number)vindex.getEnsDerivedType()));
        } else if (vindex.getProbabilityName() != null && !vindex.getProbabilityName().isEmpty()) {
            v.addAttribute(new Attribute("Grib1_Probability_Type", vindex.getProbabilityName()));
        }
    }
}

