/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.Set;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.grib.collection.Grib1Collection;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionMutable;
import ucar.nc2.grib.coverage.GribCoverageDataset;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Partition
extends PartitionCollectionImmutable {
    Grib1Partition(PartitionCollectionMutable pc) {
        super(pc);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
        RandomAccessFile raf = (RandomAccessFile)iosp.sendIospMessage("RandomAccessFile");
        NetcdfFile ncfile = NetcdfFiles.build((IOServiceProvider)iosp, (RandomAccessFile)raf, (String)this.getLocation(), null);
        return NetcdfDatasets.enhance((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
    }

    @Override
    public GridDataset getGridDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
        RandomAccessFile raf = (RandomAccessFile)iosp.sendIospMessage("RandomAccessFile");
        NetcdfFile ncfile = NetcdfFiles.build((IOServiceProvider)iosp, (RandomAccessFile)raf, (String)this.getLocation(), null);
        NetcdfDataset ncd = NetcdfDatasets.enhance((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
        return new GridDataset(ncd);
    }

    @Override
    public CoverageCollection getGridCoverage(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) {
        GribCoverageDataset gribCov = new GribCoverageDataset(this, ds, group);
        return gribCov.createCoverageCollection();
    }

    @Override
    public void addGlobalAttributes(AttributeContainerMutable result) {
        String val = this.cust.getGeneratingProcessName(this.getGenProcessId());
        if (val != null) {
            result.addAttribute(new Attribute("Generating_process_or_model", val));
        }
        result.addAttribute(new Attribute("file_format", DataFormatType.GRIB1.getDescription()));
    }

    @Override
    public void addVariableAttributes(AttributeContainerMutable v, GribCollectionImmutable.VariableIndex vindex) {
        Grib1Collection.addVariableAttributes(v, vindex, this);
    }

    @Override
    public String makeVariableId(GribCollectionImmutable.VariableIndex v) {
        return Grib1Collection.makeVariableId(this.getCenter(), this.getSubcenter(), v.getTableVersion(), v.getParameter(), v.getLevelType(), v.isLayer(), v.getIntvType(), v.getIntvName());
    }
}

