/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import org.jdom2.Element;
import org.slf4j.Logger;
import thredds.client.catalog.Catalog;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import ucar.array.Arrays;
import ucar.array.InvalidRangeException;
import ucar.ma2.Array;
import ucar.ma2.Section;
import ucar.ma2.SectionIterable;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GribArrayReader;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribDataReader;
import ucar.nc2.grib.collection.GribIospBuilder;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.grib.collection.Time2DLazyCoordinate;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public abstract class GribIosp
extends AbstractIOServiceProvider {
    public static int debugIndexOnlyCount;
    protected final FeatureCollectionConfig config = new FeatureCollectionConfig();
    protected final boolean isGrib1;
    protected final Logger logger;
    protected GribCollectionImmutable gribCollection;
    protected GribCollectionImmutable.GroupGC gHcs;
    protected GribCollectionImmutable.Type gtype;
    protected boolean isPartitioned;
    protected boolean owned;
    protected GribTables gribTable;

    public void setParamTable(Element paramTable) {
        this.config.gribConfig.paramTable = paramTable;
    }

    public void setLookupTablePath(String lookupTablePath) {
        this.config.gribConfig.lookupTablePath = lookupTablePath;
    }

    public void setParamTablePath(String paramTablePath) {
        this.config.gribConfig.paramTablePath = paramTablePath;
    }

    @Nullable
    public Object sendIospMessage(Object special) {
        if (special instanceof String) {
            int pos;
            String s = (String)special;
            if (s.startsWith("gribParameterTableLookup")) {
                int pos2 = s.indexOf("=");
                if (pos2 > 0) {
                    this.config.gribConfig.lookupTablePath = s.substring(pos2 + 1).trim();
                }
            } else if (s.startsWith("gribParameterTable") && (pos = s.indexOf("=")) > 0) {
                this.config.gribConfig.paramTablePath = s.substring(pos + 1).trim();
            }
            return null;
        }
        if (special instanceof Element) {
            Element root = (Element)special;
            this.config.gribConfig.configFromXml(root, Catalog.ncmlNS);
            return null;
        }
        return super.sendIospMessage(special);
    }

    public GribIosp(boolean isGrib1, Logger logger) {
        this.isGrib1 = isGrib1;
        this.logger = logger;
    }

    protected abstract GribTables createCustomizer() throws IOException;

    protected abstract String makeVariableName(GribCollectionImmutable.VariableIndex var1);

    protected abstract String makeVariableLongName(GribCollectionImmutable.VariableIndex var1);

    protected abstract String makeVariableUnits(GribCollectionImmutable.VariableIndex var1);

    protected abstract String getVerticalCoordDesc(int var1);

    protected abstract GribTables.Parameter getParameter(GribCollectionImmutable.VariableIndex var1);

    public void build(RandomAccessFile raf, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        GribIospBuilder helper;
        super.open(raf, rootGroup.getNcfile(), cancelTask);
        if (this.gHcs != null) {
            this.gribCollection = this.gHcs.getGribCollection();
            if (this.gribCollection instanceof PartitionCollectionImmutable) {
                this.isPartitioned = true;
            }
            this.gribTable = this.createCustomizer();
            helper = new GribIospBuilder(this, this.isGrib1, this.logger, this.gribCollection, this.gribTable);
            helper.addGroup(rootGroup, this.gHcs, this.gtype, false);
        } else if (this.gribCollection == null) {
            this.gribCollection = GribCdmIndex.openGribCollectionFromRaf(raf, this.config, CollectionUpdateType.testIndexOnly, this.logger);
            if (this.gribCollection == null) {
                throw new IllegalStateException("Not a GRIB data file or index file " + raf.getLocation());
            }
            this.isPartitioned = this.gribCollection instanceof PartitionCollectionImmutable;
            this.gribTable = this.createCustomizer();
            helper = new GribIospBuilder(this, this.isGrib1, this.logger, this.gribCollection, this.gribTable);
            boolean useDatasetGroup = this.gribCollection.getDatasets().size() > 1;
            for (GribCollectionImmutable.Dataset ds : this.gribCollection.getDatasets()) {
                Group.Builder topGroup;
                if (useDatasetGroup) {
                    topGroup = Group.builder().setName(ds.getType().toString());
                    rootGroup.addGroup(topGroup);
                } else {
                    topGroup = rootGroup;
                }
                Iterable<GribCollectionImmutable.GroupGC> groups = ds.getGroups();
                boolean useGroups = ds.getGroupsSize() > 1;
                for (GribCollectionImmutable.GroupGC g : groups) {
                    helper.addGroup(topGroup, g, ds.getType(), useGroups);
                }
            }
        }
        for (Attribute att : this.gribCollection.getGlobalAttributes()) {
            rootGroup.addAttribute(att);
        }
    }

    @Nullable
    String searchCoord(Grib2Utils.LatLonCoordType type, List<GribCollectionImmutable.VariableIndex> list) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case U: {
                GribCollectionImmutable.VariableIndex lat = this.findParameter(list, 198);
                GribCollectionImmutable.VariableIndex lon = this.findParameter(list, 199);
                return lat != null && lon != null ? this.makeVariableName(lat) + " " + this.makeVariableName(lon) : null;
            }
            case V: {
                GribCollectionImmutable.VariableIndex lat = this.findParameter(list, 200);
                GribCollectionImmutable.VariableIndex lon = this.findParameter(list, 201);
                return lat != null && lon != null ? this.makeVariableName(lat) + " " + this.makeVariableName(lon) : null;
            }
            case P: {
                GribCollectionImmutable.VariableIndex lat = this.findParameter(list, 202);
                GribCollectionImmutable.VariableIndex lon = this.findParameter(list, 203);
                return lat != null && lon != null ? this.makeVariableName(lat) + "  " + this.makeVariableName(lon) : null;
            }
        }
        return null;
    }

    @Nullable
    private GribCollectionImmutable.VariableIndex findParameter(List<GribCollectionImmutable.VariableIndex> list, int p) {
        for (GribCollectionImmutable.VariableIndex vindex : list) {
            if (vindex.getDiscipline() != 0 || vindex.getCategory() != 2 || vindex.getParameter() != p) continue;
            return vindex;
        }
        return null;
    }

    public void close() throws IOException {
        if (!this.owned && this.gribCollection != null) {
            this.gribCollection.close();
        }
        this.gribCollection = null;
        super.close();
    }

    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        if (this.gribCollection != null) {
            this.gribCollection.showIndex(f);
        }
        return f.toString();
    }

    public Array readData(Variable v2, Section section) throws IOException, ucar.ma2.InvalidRangeException {
        if (v2.getSPobject() instanceof Time2Dinfo) {
            Time2Dinfo info = (Time2Dinfo)v2.getSPobject();
            Array data = Time2DLazyCoordinate.makeLazyCoordinateData(v2, info, this.gribCollection);
            Section sectionFilled = Section.fill((Section)section, (int[])v2.getShape());
            return data.sectionNoReduce(sectionFilled.getRanges());
        }
        try {
            GribCollectionImmutable.VariableIndex vindex = (GribCollectionImmutable.VariableIndex)v2.getSPobject();
            GribDataReader dataReader = GribDataReader.factory(this.gribCollection, vindex);
            SectionIterable sectionIter = new SectionIterable(section, v2.getShape());
            Array result = dataReader.readData(sectionIter);
            return result;
        }
        catch (IOException ioe) {
            this.logger.error("Failed to readData ", (Throwable)ioe);
            throw ioe;
        }
    }

    public ucar.array.Array<?> readArrayData(Variable v2, ucar.array.Section section) throws IOException, InvalidRangeException {
        if (v2.getSPobject() instanceof Time2Dinfo) {
            Time2Dinfo info = (Time2Dinfo)v2.getSPobject();
            ucar.array.Array<?> data = Time2DLazyCoordinate.makeLazyCoordinateArray(v2, info, this.gribCollection);
            ucar.array.Section sectionFilled = ucar.array.Section.fill((ucar.array.Section)section, (int[])v2.getShape());
            return Arrays.section(data, (ucar.array.Section)sectionFilled);
        }
        try {
            GribCollectionImmutable.VariableIndex vindex = (GribCollectionImmutable.VariableIndex)v2.getSPobject();
            GribArrayReader dataReader = GribArrayReader.factory(this.gribCollection, vindex);
            ucar.array.SectionIterable sectionIter = new ucar.array.SectionIterable(section, v2.getShape());
            return dataReader.readData(sectionIter);
        }
        catch (IOException ioe) {
            this.logger.error("Failed to readData ", (Throwable)ioe);
            throw ioe;
        }
    }

    public abstract Object getLastRecordRead();

    public abstract void clearLastRecordRead();

    public abstract Object getGribCustomizer();

    static class Time2Dinfo {
        final Time2DinfoType which;
        final CoordinateTime2D time2D;
        final Coordinate time1D;

        Time2Dinfo(Time2DinfoType which, CoordinateTime2D time2D, Coordinate time1D) {
            this.which = which;
            this.time2D = time2D;
            this.time1D = time1D;
        }
    }

    static enum Time2DinfoType {
        off,
        offU,
        intv,
        intvU,
        bounds,
        boundsU,
        is1Dtime,
        isUniqueRuntime,
        reftime,
        timeAuxRef;

    }
}

