/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.util.List;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.ma2.DataType;
import ucar.nc2.Variable;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.time.CalendarPeriod;

class Time2DLazyCoordinate {
    Time2DLazyCoordinate() {
    }

    static Array<?> makeLazyCoordinateArray(Variable v2, GribIosp.Time2Dinfo info, GribCollectionImmutable gribCollection) {
        double[] data = info.time2D != null ? Time2DLazyCoordinate.makeLazyTime2Darray(v2, info) : Time2DLazyCoordinate.makeLazyTime1Darray(info, gribCollection);
        return Arrays.factory((ArrayType)ArrayType.DOUBLE, (int[])v2.getShape(), (Object)data);
    }

    static ucar.ma2.Array makeLazyCoordinateData(Variable v2, GribIosp.Time2Dinfo info, GribCollectionImmutable gribCollection) {
        double[] data = info.time2D != null ? Time2DLazyCoordinate.makeLazyTime2Darray(v2, info) : Time2DLazyCoordinate.makeLazyTime1Darray(info, gribCollection);
        return ucar.ma2.Array.factory((DataType)DataType.DOUBLE, (int[])v2.getShape(), (Object)data);
    }

    private static double[] makeLazyTime1Darray(GribIosp.Time2Dinfo info, GribCollectionImmutable gribCollection) {
        int length = info.time1D.getSize();
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case reftime: {
                CoordinateRuntime rtc = (CoordinateRuntime)info.time1D;
                int count = 0;
                for (double val : rtc.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                return data;
            }
            case timeAuxRef: {
                CoordinateTimeAbstract time = (CoordinateTimeAbstract)info.time1D;
                int count = 0;
                List<Double> masterOffsets = gribCollection.getMasterRuntime().getOffsetsInTimeUnits();
                for (int masterIdx : time.getTime2runtime()) {
                    data[count++] = masterOffsets.get(masterIdx - 1);
                }
                return data;
            }
        }
        throw new IllegalStateException("makeLazyTime1Darray must be reftime or timeAuxRef");
    }

    private static double[] makeLazyTime2Darray(Variable coord, GribIosp.Time2Dinfo info) {
        CoordinateTime2D time2D = info.time2D;
        CalendarPeriod timeUnit = time2D.getTimeUnit();
        int nruns = time2D.getNruns();
        int ntimes = time2D.getNtimes();
        int length = (int)coord.getSize();
        if (info.which == GribIosp.Time2DinfoType.bounds) {
            length *= 2;
        }
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case off: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (int val : coordTime.getOffsetSorted()) {
                        data[runIdx * ntimes + timeIdx] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case offU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    for (int val : coordTime.getOffsetSorted()) {
                        data[count++] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case intv: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes + timeIdx] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case intvU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case is1Dtime: {
                CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
                int count = 0;
                for (double val : runtime.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                break;
            }
            case isUniqueRuntime: {
                CoordinateRuntime runtimeU = time2D.getRuntimeCoordinate();
                List<Double> runOffsets = runtimeU.getOffsetsInTimeUnits();
                int count = 0;
                for (int run = 0; run < time2D.getNruns(); ++run) {
                    CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
                    for (int time = 0; time < timeCoord.getNCoords(); ++time) {
                        data[count++] = runOffsets.get(run);
                    }
                }
                break;
            }
            case bounds: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes * 2 + timeIdx] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[runIdx * ntimes * 2 + timeIdx + 1] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                        timeIdx += 2;
                    }
                }
                break;
            }
            case boundsU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return data;
    }
}

