/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.collection.Grib;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateBuilder;
import ucar.nc2.grib.coord.CoordinateBuilderImpl;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.internal.util.Counters;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.Indent;

@Immutable
public class CoordinateTime2D
extends CoordinateTimeAbstract
implements Coordinate {
    private static Logger logger = LoggerFactory.getLogger(CoordinateTime2D.class);
    private final CoordinateRuntime runtime;
    private final List<Coordinate> times;
    private final CoordinateTimeAbstract otime;
    private final SortedMap<Integer, CoordinateTimeAbstract> regTimes;
    private final int[] offset;
    private final boolean isRegular;
    private final boolean isOrthogonal;
    private final boolean isTimeInterval;
    private final int nruns;
    private final int ntimes;
    private final List<Time2D> vals;

    public CoordinateTime2D(int code, CalendarPeriod timeUnit, List<Time2D> vals, CoordinateRuntime runtime, List<Coordinate> times, int[] time2runtime) {
        super(code, timeUnit, runtime.getFirstDate(), time2runtime);
        this.runtime = runtime;
        this.times = Collections.unmodifiableList(times);
        this.otime = null;
        this.regTimes = null;
        this.isRegular = false;
        this.isOrthogonal = false;
        this.isTimeInterval = times.get(0) instanceof CoordinateTimeIntv;
        int nmax = 0;
        for (Coordinate time : times) {
            nmax = Math.max(nmax, time.getSize());
        }
        this.ntimes = nmax;
        this.nruns = runtime.getSize();
        assert (this.nruns == times.size());
        this.offset = this.makeOffsets(times);
        this.vals = vals == null ? null : Collections.unmodifiableList(vals);
    }

    public CoordinateTime2D(int code, CalendarPeriod timeUnit, List<Time2D> vals, CoordinateRuntime runtime, CoordinateTimeAbstract otime, List<Coordinate> times, int[] time2runtime) {
        super(code, timeUnit, runtime.getFirstDate(), time2runtime);
        this.runtime = runtime;
        this.times = times == null ? null : Collections.unmodifiableList(times);
        this.otime = otime;
        this.isOrthogonal = true;
        this.isRegular = false;
        this.regTimes = null;
        this.isTimeInterval = otime instanceof CoordinateTimeIntv;
        this.ntimes = otime.getSize();
        this.nruns = runtime.getSize();
        this.offset = this.makeOffsets(timeUnit);
        this.vals = vals == null ? null : Collections.unmodifiableList(vals);
    }

    public CoordinateTime2D(int code, CalendarPeriod timeUnit, List<Time2D> vals, CoordinateRuntime runtime, List<Coordinate> regList, List<Coordinate> times, int[] time2runtime) {
        super(code, timeUnit, runtime.getFirstDate(), time2runtime);
        this.runtime = runtime;
        this.nruns = runtime.getSize();
        this.times = times == null ? null : Collections.unmodifiableList(times);
        this.otime = null;
        this.isOrthogonal = false;
        this.isRegular = true;
        CoordinateTimeAbstract first = (CoordinateTimeAbstract)regList.get(0);
        this.isTimeInterval = first instanceof CoordinateTimeIntv;
        int nmax = 0;
        for (Coordinate time : regList) {
            nmax = Math.max(nmax, time.getSize());
        }
        this.ntimes = nmax;
        this.regTimes = new TreeMap<Integer, CoordinateTimeAbstract>();
        for (Coordinate coord : regList) {
            CoordinateTimeAbstract time = (CoordinateTimeAbstract)coord;
            CalendarDate ref = time.getRefDate();
            int hour = ref.getHourOfDay();
            this.regTimes.put(hour, time);
        }
        this.offset = this.makeOffsets(timeUnit);
        this.vals = vals == null ? null : Collections.unmodifiableList(vals);
    }

    private int[] makeOffsets(List<Coordinate> orgTimes) {
        CalendarDate firstDate = this.runtime.getFirstDate();
        int[] offsets = new int[this.nruns];
        for (int idx = 0; idx < this.nruns; ++idx) {
            CoordinateTimeAbstract coordTime = (CoordinateTimeAbstract)orgTimes.get(idx);
            CalendarPeriod period = coordTime.getTimeUnit();
            offsets[idx] = period.getOffset(firstDate, this.runtime.getRuntimeDate(idx));
        }
        return offsets;
    }

    private int[] makeOffsets(CalendarPeriod period) {
        CalendarDate firstDate = this.runtime.getFirstDate();
        int[] offsets = new int[this.nruns];
        for (int idx = 0; idx < this.nruns; ++idx) {
            offsets[idx] = period.getOffset(firstDate, this.runtime.getRuntimeDate(idx));
        }
        return offsets;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.isOrthogonal()) {
            this.otime.setName(name);
        } else if (this.isRegular()) {
            for (CoordinateTimeAbstract time : this.regTimes.values()) {
                time.setName(name);
            }
        } else {
            for (Coordinate time : this.times) {
                ((CoordinateTimeAbstract)time).setName(name);
            }
        }
    }

    public CoordinateRuntime getRuntimeCoordinate() {
        return this.runtime;
    }

    public boolean isTimeInterval() {
        return this.isTimeInterval;
    }

    public boolean isOrthogonal() {
        return this.isOrthogonal;
    }

    public boolean isRegular() {
        return this.isRegular;
    }

    public int getNtimes() {
        return this.ntimes;
    }

    public int getNruns() {
        return this.nruns;
    }

    public int getOffset(int runIndex) {
        return this.offset[runIndex];
    }

    public Iterable<Integer> getRegularHourOffsets() {
        if (!this.isRegular) {
            return null;
        }
        return this.regTimes.keySet();
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s%s:", new Object[]{indent, this.getType()});
        info.format(" %s runtime=%s nruns=%d ntimes=%d isOrthogonal=%s isRegular=%s%n", this.name, this.runtime.getName(), this.nruns, this.ntimes, this.isOrthogonal, this.isRegular);
        indent.incr();
        info.format("%sAll time values=", indent);
        List<?> timeValues = this.getOffsetsSorted();
        for (Object val : timeValues) {
            info.format(" %s,", val);
        }
        info.format(" (n=%d)%n", timeValues.size());
        if (this.isOrthogonal) {
            this.otime.showInfo(info, indent);
        } else if (this.isRegular) {
            Iterator<Object> iterator = this.regTimes.keySet().iterator();
            while (iterator.hasNext()) {
                int hour = (Integer)iterator.next();
                CoordinateTimeAbstract timeCoord = (CoordinateTimeAbstract)this.regTimes.get(hour);
                info.format("%shour %d: ", indent, hour);
                timeCoord.showInfo(info, new Indent(0));
            }
        } else {
            for (Coordinate time : this.times) {
                info.format("%s%s:", indent, ((CoordinateTimeAbstract)time).getRefDate());
                time.showInfo(info, new Indent(0));
            }
        }
        indent.decr();
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("%s runtime=%s nruns=%d ntimes=%d isOrthogonal=%s isRegular=%s%n", this.name, this.runtime.getName(), this.nruns, this.ntimes, this.isOrthogonal, this.isRegular);
        if (this.isOrthogonal) {
            this.otime.showCoords(info);
        } else if (this.isRegular) {
            for (int hour : this.regTimes.keySet()) {
                CoordinateTimeAbstract timeCoord = (CoordinateTimeAbstract)this.regTimes.get(hour);
                info.format("hour %d: ", hour);
                timeCoord.showInfo(info, new Indent(0));
            }
        } else {
            for (Coordinate time : this.times) {
                time.showCoords(info);
            }
        }
    }

    @Override
    public Counters calcDistributions() {
        Counters counters = new Counters();
        counters.add("resol");
        List<?> offsets = this.getOffsetsSorted();
        if (this.isTimeInterval()) {
            counters.add("intv");
            for (int i = 0; i < offsets.size(); ++i) {
                TimeCoordIntvValue tinv = (TimeCoordIntvValue)offsets.get(i);
                int intv = tinv.getBounds2() - tinv.getBounds1();
                counters.count("intv", (Comparable)Integer.valueOf(intv));
                if (i <= 0) continue;
                int resol = tinv.getBounds1() - ((TimeCoordIntvValue)offsets.get(i - 1)).getBounds1();
                counters.count("resol", (Comparable)Integer.valueOf(resol));
            }
        } else {
            for (int i = 0; i < offsets.size() - 1; ++i) {
                int diff = (Integer)offsets.get(i + 1) - (Integer)offsets.get(i);
                counters.count("resol", (Comparable)Integer.valueOf(diff));
            }
        }
        return counters;
    }

    @Override
    public List<?> getValues() {
        return this.vals;
    }

    @Override
    public Object getValue(int idx) {
        return this.vals.get(idx);
    }

    @Override
    public int getIndex(Object val) {
        return this.vals == null ? -1 : Collections.binarySearch(this.vals, (Time2D)val);
    }

    @Override
    public int getSize() {
        return this.vals == null ? 0 : this.vals.size();
    }

    @Override
    public int getNCoords() {
        return this.getOffsetsSorted().size();
    }

    @Override
    public int estMemorySize() {
        return 864 + this.nruns * 52 + this.ntimes * 24;
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.time2D;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateTime2D that = (CoordinateTime2D)o;
        if (this.isTimeInterval != that.isTimeInterval) {
            return false;
        }
        if (!this.runtime.equals(that.runtime)) {
            return false;
        }
        if (this.isOrthogonal != that.isOrthogonal) {
            return false;
        }
        if (this.isRegular != that.isRegular) {
            return false;
        }
        if (!Objects.equals(this.otime, that.otime)) {
            return false;
        }
        if (!Objects.equals(this.regTimes, that.regTimes)) {
            return false;
        }
        return Objects.equals(this.times, that.times);
    }

    public int hashCode() {
        int result = this.runtime.hashCode();
        result = 31 * result + (this.times != null ? this.times.hashCode() : 0);
        result = 31 * result + (this.otime != null ? this.otime.hashCode() : 0);
        result = 31 * result + (this.regTimes != null ? this.regTimes.hashCode() : 0);
        result = 31 * result + (this.isRegular ? 1 : 0);
        result = 31 * result + (this.isOrthogonal ? 1 : 0);
        result = 31 * result + (this.isTimeInterval ? 1 : 0);
        return result;
    }

    @Nullable
    public String getTimeIntervalName() {
        if (!this.isTimeInterval) {
            return null;
        }
        if (this.isOrthogonal) {
            return ((CoordinateTimeIntv)this.otime).getTimeIntervalName();
        }
        if (this.isRegular) {
            String firstValue = null;
            for (CoordinateTimeAbstract timeCoord : this.regTimes.values()) {
                CoordinateTimeIntv timeCoordi = (CoordinateTimeIntv)timeCoord;
                String value = timeCoordi.getTimeIntervalName();
                if (firstValue == null) {
                    firstValue = value;
                    continue;
                }
                if (!value.equals(firstValue)) {
                    return "Mixed_intervals";
                }
                if (!value.equals("Mixed_intervals")) continue;
                return "Mixed_intervals";
            }
            return firstValue;
        }
        String firstValue = null;
        for (Coordinate timeCoord : this.times) {
            if (this.times.isEmpty()) continue;
            CoordinateTimeIntv timeCoordi = (CoordinateTimeIntv)timeCoord;
            String value = timeCoordi.getTimeIntervalName();
            if (firstValue == null) {
                firstValue = value;
                continue;
            }
            if (!value.equals(firstValue)) {
                return "Mixed_intervals";
            }
            if (!value.equals("Mixed_intervals")) continue;
            return "Mixed_intervals";
        }
        return firstValue;
    }

    @Override
    public CalendarDateRange makeCalendarDateRange(Calendar cal) {
        CoordinateTimeAbstract firstCoord = this.getTimeCoordinate(0);
        CoordinateTimeAbstract lastCoord = this.getTimeCoordinate(this.nruns - 1);
        CalendarDateRange firstRange = firstCoord.makeCalendarDateRange(cal);
        CalendarDateRange lastRange = lastCoord.makeCalendarDateRange(cal);
        return CalendarDateRange.of((CalendarDate)firstRange.getStart(), (CalendarDate)lastRange.getEnd());
    }

    public CoordinateTimeAbstract getTimeCoordinate(int runIdx) {
        if (this.isOrthogonal) {
            return this.factory(this.otime, this.getRefDate(runIdx));
        }
        if (this.isRegular) {
            CalendarDate ref = this.getRefDate(runIdx);
            int hour = ref.getHourOfDay();
            return (CoordinateTimeAbstract)this.regTimes.get(hour);
        }
        return (CoordinateTimeAbstract)this.times.get(runIdx);
    }

    public CoordinateTimeAbstract getRegularTimeCoordinate(int hour) {
        return (CoordinateTimeAbstract)this.regTimes.get(hour);
    }

    public CalendarDate getRefDate(int runIdx) {
        return this.runtime.getRuntimeDate(runIdx);
    }

    public long getRuntime(int runIdx) {
        return this.runtime.getRuntime(runIdx);
    }

    private CoordinateTimeAbstract factory(CoordinateTimeAbstract org, CalendarDate refDate) {
        CoordinateTimeAbstract result = this.isTimeInterval ? new CoordinateTimeIntv((CoordinateTimeIntv)org, refDate) : new CoordinateTime((CoordinateTime)org, refDate);
        result.setName(org.getName());
        return result;
    }

    public Time2D getOrgValue(int runIdx, int timeIdx) {
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        CalendarDate runDate = this.runtime.getRuntimeDate(runIdx);
        if (this.isTimeInterval) {
            TimeCoordIntvValue valIntv = (TimeCoordIntvValue)time.getValue(timeIdx);
            if (valIntv == null) {
                throw new IllegalArgumentException();
            }
            return new Time2D(runDate, null, valIntv);
        }
        Integer val = (Integer)time.getValue(timeIdx);
        if (val == null) {
            throw new IllegalArgumentException();
        }
        return new Time2D(runDate, val, null);
    }

    public boolean getIndex(Time2D want, int[] wholeIndex) {
        int runIdx = this.runtime.getIndex(want.refDate);
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        wholeIndex[0] = runIdx;
        wholeIndex[1] = this.isTimeInterval ? time.getIndex(want.tinv) : time.getIndex(want.time);
        return wholeIndex[0] >= 0 && wholeIndex[1] >= 0;
    }

    public int matchTimeCoordinate(int runIdx, Time2D value) {
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        int offset = this.timeUnit.getOffset(this.getRefDate(runIdx), value.getRefDate());
        Comparable<TimeCoordIntvValue> valueWithOffset = this.isTimeInterval ? value.tinv.offset(offset) : Integer.valueOf(value.time + offset);
        int result = time.getIndex(valueWithOffset);
        if (Grib.debugRead) {
            logger.debug(String.format("  matchTimeCoordinate value wanted = (%s) valueWithOffset=%s result=%d %n", value, valueWithOffset, result));
        }
        return result;
    }

    @Override
    protected CoordinateTimeAbstract makeBestFromComplete(int[] best, int n) {
        throw new UnsupportedOperationException();
    }

    public CoordinateTimeAbstract makeTime2Runtime(CoordinateRuntime master) {
        if (this.isTimeInterval) {
            return this.makeBestTimeIntv(master);
        }
        return this.makeBestTime(master);
    }

    public CoordinateTimeAbstract makeBestTimeCoordinate(CoordinateRuntime master) {
        if (this.isTimeInterval) {
            return this.makeBestTimeIntv(master);
        }
        return this.makeBestTime(master);
    }

    /*
     * WARNING - void declaration
     */
    private CoordinateTimeAbstract makeBestTime(CoordinateRuntime master) {
        HashSet<Integer> values = new HashSet<Integer>();
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTime timeCoord = this.times == null ? (CoordinateTime)this.getTimeCoordinate(runIdx) : (CoordinateTime)this.times.get(runIdx);
            for (Integer n : timeCoord.getOffsetSorted()) {
                values.add(n + this.getOffset(runIdx));
            }
        }
        ArrayList<Integer> offsetSorted = new ArrayList<Integer>(values.size());
        for (Object e : values) {
            offsetSorted.add((Integer)e);
        }
        Collections.sort(offsetSorted);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        boolean bl = false;
        for (Integer val : offsetSorted) {
            void var5_10;
            map.put(val, (int)(++var5_10));
        }
        int[] nArray = new int[this.nruns];
        int masterIdx = 0;
        for (int run2Didx = 0; run2Didx < this.nruns; ++run2Didx) {
            while (!master.getRuntimeDate(masterIdx).equals((Object)this.runtime.getRuntimeDate(run2Didx))) {
                ++masterIdx;
            }
            nArray[run2Didx] = masterIdx++;
        }
        assert (masterIdx >= this.nruns);
        int[] time2runtime = new int[offsetSorted.size()];
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTime timeCoord;
            CoordinateTime coordinateTime = timeCoord = this.times == null ? (CoordinateTime)this.getTimeCoordinate(runIdx) : (CoordinateTime)this.times.get(runIdx);
            assert (timeCoord != null);
            for (Integer offset : timeCoord.getOffsetSorted()) {
                Integer bestValIdx = (Integer)map.get(offset + this.getOffset(runIdx));
                if (bestValIdx == null) {
                    throw new IllegalStateException();
                }
                time2runtime[bestValIdx.intValue()] = nArray[runIdx] + 1;
            }
        }
        return new CoordinateTime(this.getCode(), this.getTimeUnit(), this.getRefDate(), offsetSorted, time2runtime);
    }

    public boolean hasUniqueTimes() {
        if (this.isTimeInterval) {
            HashSet<TimeCoordIntvValue> values = new HashSet<TimeCoordIntvValue>();
            for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
                CoordinateTimeIntv timeIntv = this.times == null ? (CoordinateTimeIntv)this.getTimeCoordinate(runIdx) : (CoordinateTimeIntv)this.times.get(runIdx);
                for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                    TimeCoordIntvValue tinvAbs = tinv.offset(this.getOffset(runIdx));
                    if (values.contains(tinvAbs)) {
                        return false;
                    }
                    values.add(tinvAbs);
                }
            }
        } else {
            HashSet<Integer> values = new HashSet<Integer>();
            for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
                CoordinateTime timeCoord;
                CoordinateTime coordinateTime = timeCoord = this.times == null ? (CoordinateTime)this.getTimeCoordinate(runIdx) : (CoordinateTime)this.times.get(runIdx);
                assert (timeCoord != null);
                for (Integer offset : timeCoord.getOffsetSorted()) {
                    int offsetAbs = offset + this.getOffset(runIdx);
                    if (values.contains(offsetAbs)) {
                        return false;
                    }
                    values.add(offsetAbs);
                }
            }
        }
        return true;
    }

    public int[] getTimeIndicesFromMrutp(int timeIdx) {
        int[] result = new int[2];
        if (this.isOrthogonal) {
            int nPerRun = this.otime.getNCoords();
            result[0] = timeIdx / nPerRun;
            result[1] = timeIdx % nPerRun;
            return result;
        }
        if (this.isRegular) {
            int nPerRun = 0;
            for (Map.Entry<Integer, CoordinateTimeAbstract> entry : this.regTimes.entrySet()) {
                nPerRun += entry.getValue().getNCoords();
            }
            if (nPerRun > 0) {
                result[0] = timeIdx / nPerRun;
                result[1] = timeIdx % nPerRun;
            }
            return result;
        }
        int runtime = 0;
        int count = 0;
        for (Coordinate time : this.times) {
            if (count + time.getNCoords() > timeIdx) {
                result[0] = runtime;
                result[1] = timeIdx - count;
                return result;
            }
            ++runtime;
            count += time.getNCoords();
        }
        throw new IllegalStateException("timeIdx = " + timeIdx);
    }

    /*
     * WARNING - void declaration
     */
    private CoordinateTimeAbstract makeBestTimeIntv(CoordinateRuntime master) {
        HashSet<TimeCoordIntvValue> values = new HashSet<TimeCoordIntvValue>();
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTimeIntv timeIntv = this.times == null ? (CoordinateTimeIntv)this.getTimeCoordinate(runIdx) : (CoordinateTimeIntv)this.times.get(runIdx);
            for (TimeCoordIntvValue timeCoordIntvValue : timeIntv.getTimeIntervals()) {
                values.add(timeCoordIntvValue.offset(this.getOffset(runIdx)));
            }
        }
        ArrayList<TimeCoordIntvValue> offsetSorted = new ArrayList<TimeCoordIntvValue>(values.size());
        for (Object e : values) {
            offsetSorted.add((TimeCoordIntvValue)e);
        }
        Collections.sort(offsetSorted);
        HashMap<TimeCoordIntvValue, Integer> map = new HashMap<TimeCoordIntvValue, Integer>();
        boolean bl = false;
        for (TimeCoordIntvValue val : offsetSorted) {
            void var5_10;
            map.put(val, (int)(++var5_10));
        }
        int[] nArray = new int[this.nruns];
        int masterIdx = 0;
        for (int run2Didx = 0; run2Didx < this.nruns; ++run2Didx) {
            while (!master.getRuntimeDate(masterIdx).equals((Object)this.runtime.getRuntimeDate(run2Didx))) {
                ++masterIdx;
            }
            nArray[run2Didx] = masterIdx++;
        }
        assert (masterIdx >= this.nruns);
        int[] time2runtime = new int[offsetSorted.size()];
        for (int runIdx = 0; runIdx < this.nruns; ++runIdx) {
            CoordinateTimeIntv timeIntv = this.times == null ? (CoordinateTimeIntv)this.getTimeCoordinate(runIdx) : (CoordinateTimeIntv)this.times.get(runIdx);
            for (TimeCoordIntvValue bestVal : timeIntv.getTimeIntervals()) {
                Integer bestValIdx = (Integer)map.get(bestVal.offset(this.getOffset(runIdx)));
                if (bestValIdx == null) {
                    throw new IllegalStateException();
                }
                time2runtime[bestValIdx.intValue()] = nArray[runIdx] + 1;
            }
        }
        return new CoordinateTimeIntv(this.getCode(), this.getTimeUnit(), this.getRefDate(), offsetSorted, time2runtime);
    }

    public List<? extends Coordinate> getTimesForSerialization() {
        if (this.isOrthogonal) {
            ArrayList<CoordinateTimeAbstract> list = new ArrayList<CoordinateTimeAbstract>(1);
            list.add(this.otime);
            return list;
        }
        if (this.isRegular) {
            return new ArrayList<CoordinateTimeAbstract>(this.regTimes.values());
        }
        return this.times;
    }

    public int findTimeIndexFromVal(int runIdx, Object val) {
        if (this.isOrthogonal) {
            return this.otime.getIndex(val);
        }
        CoordinateTimeAbstract time = this.getTimeCoordinate(runIdx);
        if (time.getNCoords() == 1) {
            return 0;
        }
        return time.getIndex(val);
    }

    public List<?> getOffsetsSorted() {
        List<Coordinate> coords;
        if (this.isOrthogonal) {
            return this.otime.getValues();
        }
        List<Coordinate> list = coords = this.isRegular ? new ArrayList<CoordinateTimeAbstract>(this.regTimes.values()) : this.times;
        if (this.isTimeInterval) {
            return this.getIntervalsSorted(coords);
        }
        return this.getIntegersSorted(coords);
    }

    private List<Integer> getIntegersSorted(List<? extends Coordinate> coords) {
        HashSet<Integer> set = new HashSet<Integer>(100);
        for (Coordinate coordinate : coords) {
            for (Object val : coordinate.getValues()) {
                set.add((Integer)val);
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>(set);
        Collections.sort(result);
        return result;
    }

    private List<TimeCoordIntvValue> getIntervalsSorted(List<? extends Coordinate> coords) {
        HashSet<TimeCoordIntvValue> set = new HashSet<TimeCoordIntvValue>(100);
        for (Coordinate coordinate : coords) {
            for (Object val : coordinate.getValues()) {
                set.add((TimeCoordIntvValue)val);
            }
        }
        ArrayList<TimeCoordIntvValue> result = new ArrayList<TimeCoordIntvValue>(set);
        Collections.sort(result);
        return result;
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record>
    implements CoordinateBuilder.TwoD<Grib1Record> {
        private final boolean isTimeInterval;
        private final Grib1Customizer cust;
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CoordinateRuntime.Builder1 runBuilder;
        private final Map<Object, CoordinateBuilderImpl<Grib1Record>> timeBuilders;

        public Builder1(boolean isTimeInterval, Grib1Customizer cust, CalendarPeriod timeUnit, int code) {
            this.isTimeInterval = isTimeInterval;
            this.cust = cust;
            this.timeUnit = timeUnit;
            this.code = code;
            this.runBuilder = new CoordinateRuntime.Builder1(timeUnit);
            this.timeBuilders = new HashMap<Object, CoordinateBuilderImpl<Grib1Record>>();
        }

        @Override
        public void addRecord(Grib1Record gr) {
            super.addRecord(gr);
            this.runBuilder.addRecord(gr);
            Time2D val = (Time2D)this.extract(gr);
            CoordinateBuilderImpl<Grib1Record> timeBuilder = this.timeBuilders.get(val.refDate);
            timeBuilder.addRecord(gr);
        }

        @Override
        public Object extract(Grib1Record gr) {
            Object time;
            Long run = (Long)this.runBuilder.extract(gr);
            CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(run);
            if (timeBuilder == null) {
                timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder1(this.cust, this.code, this.timeUnit, CalendarDate.of((long)run)) : new CoordinateTime.Builder1(this.cust, this.code, this.timeUnit, CalendarDate.of((long)run));
                this.timeBuilders.put(run, timeBuilder);
            }
            if ((time = timeBuilder.extract((Grib1Record)gr)) instanceof Integer) {
                return new Time2D(run, (Integer)time, null);
            }
            return new Time2D(run, null, (TimeCoordIntvValue)time);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            CoordinateRuntime runCoord = (CoordinateRuntime)this.runBuilder.finish();
            ArrayList<Coordinate> times = new ArrayList<Coordinate>(runCoord.getSize());
            for (int idx = 0; idx < runCoord.getSize(); ++idx) {
                Long runtime = runCoord.getRuntime(idx);
                CoordinateBuilderImpl<Grib1Record> timeBuilder = this.timeBuilders.get(runtime);
                times.add(timeBuilder.finish());
            }
            ArrayList<Time2D> vals = new ArrayList<Time2D>(values.size());
            for (Object val : values) {
                vals.add((Time2D)val);
            }
            Collections.sort(vals);
            return new CoordinateTime2D(this.code, this.timeUnit, vals, runCoord, times, null);
        }

        @Override
        public void addAll(Coordinate coord) {
            super.addAll(coord);
            for (Object val : coord.getValues()) {
                Time2D val2D = (Time2D)val;
                this.runBuilder.add(val2D.refDate);
                CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(val2D.refDate);
                if (timeBuilder == null) {
                    timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder1(this.cust, this.code, this.timeUnit, val2D.getRefDate()) : new CoordinateTime.Builder1(this.cust, this.code, this.timeUnit, val2D.getRefDate());
                    this.timeBuilders.put(val2D.refDate, timeBuilder);
                }
                timeBuilder.add(this.isTimeInterval ? val2D.tinv : val2D.time);
            }
        }

        @Override
        public int[] getCoordIndices(Grib1Record gr) {
            CoordinateTime2D coord2D = (CoordinateTime2D)this.coord;
            Long run = (Long)this.runBuilder.extract(gr);
            int runIdx = coord2D.runtime.getIndex(run);
            CoordinateTimeAbstract timeCoord = coord2D.getTimeCoordinate(runIdx);
            CoordinateBuilderImpl<Grib1Record> timeBuilder = this.timeBuilders.get(run);
            Object time = timeBuilder.extract(gr);
            int timeIdx = timeCoord.getIndex(time);
            return new int[]{runIdx, timeIdx};
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record>
    implements CoordinateBuilder.TwoD<Grib2Record> {
        private final boolean isTimeInterval;
        private final Grib2Tables cust;
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CoordinateRuntime.Builder2 runBuilder;
        private final Map<Object, CoordinateBuilderImpl<Grib2Record>> timeBuilders;

        public Builder2(boolean isTimeInterval, Grib2Tables cust, CalendarPeriod timeUnit, int code) {
            this.isTimeInterval = isTimeInterval;
            this.cust = cust;
            this.timeUnit = timeUnit;
            this.code = code;
            this.runBuilder = new CoordinateRuntime.Builder2(timeUnit);
            this.timeBuilders = new HashMap<Object, CoordinateBuilderImpl<Grib2Record>>();
        }

        @Override
        public void addRecord(Grib2Record gr) {
            super.addRecord(gr);
            this.runBuilder.addRecord(gr);
            Time2D val = (Time2D)this.extract(gr);
            CoordinateBuilderImpl<Grib2Record> timeBuilder = this.timeBuilders.get(val.refDate);
            timeBuilder.addRecord(gr);
        }

        @Override
        public Object extract(Grib2Record gr) {
            Object time;
            Long run = (Long)this.runBuilder.extract(gr);
            CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(run);
            if (timeBuilder == null) {
                timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder2(this.cust, this.code, this.timeUnit, CalendarDate.of((long)run)) : new CoordinateTime.Builder2(this.code, this.timeUnit, CalendarDate.of((long)run));
                this.timeBuilders.put(run, timeBuilder);
            }
            if ((time = timeBuilder.extract((Grib2Record)gr)) instanceof Integer) {
                return new Time2D(run, (Integer)time, null);
            }
            return new Time2D(run, null, (TimeCoordIntvValue)time);
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            CoordinateRuntime runCoord = (CoordinateRuntime)this.runBuilder.finish();
            ArrayList<Coordinate> times = new ArrayList<Coordinate>(runCoord.getSize());
            for (int idx = 0; idx < runCoord.getSize(); ++idx) {
                Long runtime = runCoord.getRuntime(idx);
                CoordinateBuilderImpl<Grib2Record> timeBuilder = this.timeBuilders.get(runtime);
                times.add(timeBuilder.finish());
            }
            ArrayList<Time2D> vals = new ArrayList<Time2D>(values.size());
            for (Object val : values) {
                vals.add((Time2D)val);
            }
            Collections.sort(vals);
            return new CoordinateTime2D(this.code, this.timeUnit, vals, runCoord, times, null);
        }

        @Override
        public void addAll(Coordinate coord) {
            super.addAll(coord);
            for (Object val : coord.getValues()) {
                Time2D val2D = (Time2D)val;
                this.runBuilder.add(val2D.refDate);
                CoordinateBuilderImpl timeBuilder = this.timeBuilders.get(val2D.refDate);
                if (timeBuilder == null) {
                    timeBuilder = this.isTimeInterval ? new CoordinateTimeIntv.Builder2(this.cust, this.code, this.timeUnit, val2D.getRefDate()) : new CoordinateTime.Builder2(this.code, this.timeUnit, val2D.getRefDate());
                    this.timeBuilders.put(val2D.refDate, timeBuilder);
                }
                timeBuilder.add(this.isTimeInterval ? val2D.tinv : val2D.time);
            }
        }

        @Override
        public int[] getCoordIndices(Grib2Record gr) {
            CoordinateTime2D coord2D = (CoordinateTime2D)this.coord;
            Long run = (Long)this.runBuilder.extract(gr);
            int runIdx = coord2D.runtime.getIndex(run);
            CoordinateTimeAbstract timeCoord = coord2D.getTimeCoordinate(runIdx);
            CoordinateBuilderImpl<Grib2Record> timeBuilder = this.timeBuilders.get(run);
            Object time = timeBuilder.extract(gr);
            int timeIdx = timeCoord.getIndex(time);
            return new int[]{runIdx, timeIdx};
        }
    }

    public static class Time2D
    implements Comparable<Time2D> {
        long refDate;
        Integer time;
        TimeCoordIntvValue tinv;

        public Time2D(CalendarDate refDate, Integer time, TimeCoordIntvValue tinv) {
            this.refDate = refDate.getMillis();
            this.time = time;
            this.tinv = tinv;
        }

        Time2D(long refDate, Integer time, TimeCoordIntvValue tinv) {
            this.refDate = refDate;
            this.time = time;
            this.tinv = tinv;
        }

        public CalendarDate getRefDate() {
            return CalendarDate.of((long)this.refDate);
        }

        public int getValue() {
            if (this.time != null) {
                return this.time;
            }
            return this.tinv.getBounds2();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Time2D time2D = (Time2D)o;
            if (this.refDate != time2D.refDate) {
                return false;
            }
            if (!Objects.equals(this.time, time2D.time)) {
                return false;
            }
            return Objects.equals(this.tinv, time2D.tinv);
        }

        public int hashCode() {
            int result = (int)(this.refDate ^ this.refDate >>> 32);
            result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
            result = 31 * result + (this.tinv != null ? this.tinv.hashCode() : 0);
            return result;
        }

        public String toString() {
            if (this.time != null) {
                return this.time.toString();
            }
            return this.tinv.toString();
        }

        @Override
        public int compareTo(@Nonnull Time2D o) {
            int r = Long.compare(this.refDate, o.refDate);
            if (r == 0) {
                r = this.time != null ? this.time.compareTo(o.time) : this.tinv.compareTo(o.tinv);
            }
            return r;
        }
    }
}

