/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.coord.TimeCoordIntvDateValue;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.util.StringUtil2;

class CfsrLocalTables
extends NcepLocalTables {
    CfsrLocalTables(Grib2TableConfig config) {
        super(config);
        this.initLocalTable();
    }

    @Override
    public ImmutableList<GribTables.Parameter> getParameters() {
        return this.getLocalParameters();
    }

    @Override
    public String getParamTablePathUsedFor(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return super.getParamTablePathUsedFor(discipline, category, number);
        }
        return this.config.getPath();
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        if (genProcess == 197) {
            return "CFSR";
        }
        return super.getGeneratingProcessName(genProcess);
    }

    @Override
    public int[] getForecastTimeIntervalOffset(Grib2Record gr) {
        int end;
        int start;
        Grib2Pds pds = gr.getPDS();
        if (!pds.isTimeInterval()) {
            return null;
        }
        int statType = pds.getOctet(47);
        int n = pds.getInt4StartingAtOctet(50);
        int p2 = pds.getInt4StartingAtOctet(55);
        int p2mp1 = pds.getInt4StartingAtOctet(62);
        int p1 = p2 - p2mp1;
        switch (statType) {
            case 193: {
                start = p1;
                end = p1 + n * p2;
                break;
            }
            case 194: {
                start = 0;
                end = n * p2;
                break;
            }
            case 195: 
            case 204: 
            case 205: {
                start = p1;
                end = p2;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown statType " + statType);
            }
        }
        return new int[]{start, end};
    }

    @Override
    public TimeCoordIntvDateValue getForecastTimeInterval(Grib2Record gr) {
        Grib2Pds pds = gr.getPDS();
        if (!pds.isTimeInterval()) {
            return null;
        }
        int[] intv = this.getForecastTimeIntervalOffset(gr);
        assert (intv != null);
        int intvLen = intv[1] - intv[0];
        int timeUnitOrg = pds.getTimeUnit();
        int timeUnitConvert = this.convertTimeUnit(timeUnitOrg);
        CalendarPeriod unitPeriod = Grib2Utils.getCalendarPeriod(timeUnitConvert);
        if (unitPeriod == null) {
            throw new IllegalArgumentException("unknown CalendarPeriod " + timeUnitConvert + " org=" + timeUnitOrg);
        }
        CalendarPeriod.Field fld = unitPeriod.getField();
        CalendarDate start = gr.getReferenceDate().add((double)intv[0], fld);
        CalendarPeriod period = CalendarPeriod.of((int)intvLen, (CalendarPeriod.Field)fld);
        return new TimeCoordIntvDateValue(start, period);
    }

    @Override
    public double getForecastTimeIntervalSizeInHours(Grib2Pds pds) {
        return 6.0;
    }

    private boolean isCfsr2(Grib2Pds pds) {
        int genType = pds.getGenProcessId();
        if (genType != 82 && genType != 89) {
            return false;
        }
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)pds);
        Grib2Pds.TimeInterval[] ti = pdsIntv.getTimeIntervals();
        return ti.length != 1;
    }

    @Override
    public void showSpecialPdsInfo(Grib2Record gr, Formatter f) {
        Grib2Pds pds = gr.getPDS();
        if (!pds.isTimeInterval()) {
            return;
        }
        if (pds.getRawLength() < 65) {
            return;
        }
        int statType = pds.getOctet(47);
        int statType2 = pds.getOctet(59);
        int ngrids = pds.getInt4StartingAtOctet(50);
        int p2 = pds.getInt4StartingAtOctet(55);
        int p2mp1 = pds.getInt4StartingAtOctet(62);
        f.format("%nCFSR MM special encoding (NCAR)%n", new Object[0]);
        f.format("  (47) Code Table 4.10 = %d%n", statType);
        f.format("  (50-53) N in avg     = %d%n", ngrids);
        f.format("  (55-58) Grib1 P2     = %d%n", p2);
        f.format("  (59) Code Table 4.10 = %d%n", statType2);
        f.format("  (62-65) P2 minus P1  = %d%n", p2mp1);
        f.format("                   P1  = %d%n", p2 - p2mp1);
        int[] intv = this.getForecastTimeIntervalOffset(gr);
        if (intv == null) {
            return;
        }
        f.format("ForecastTimeIntervalOffset  = (%d,%d)%n", intv[0], intv[1]);
        f.format("      ForecastTimeInterval  = %s%n", this.getForecastTimeInterval(gr));
    }

    private void initLocalTable() {
        String tableName = this.config.getPath();
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(tableName);){
            if (is == null) {
                throw new IllegalStateException("Cant find " + tableName);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    ImmutableList flds = StringUtil2.splitList((String)line);
                    int p1 = Integer.parseInt((String)flds.get(0));
                    int p2 = Integer.parseInt((String)flds.get(1));
                    int p3 = Integer.parseInt((String)flds.get(2));
                    StringBuilder b = new StringBuilder();
                    int count = 3;
                    while (count < flds.size() && !((String)flds.get(count)).equals(".")) {
                        b.append((String)flds.get(count++)).append(' ');
                    }
                    String abbrev = b.toString().trim();
                    b.setLength(0);
                    ++count;
                    while (count < flds.size() && !((String)flds.get(count)).equals(".")) {
                        b.append((String)flds.get(count++)).append(' ');
                    }
                    String name = b.toString().trim();
                    b.setLength(0);
                    ++count;
                    while (count < flds.size() && !((String)flds.get(count)).equals(".")) {
                        b.append((String)flds.get(count++)).append(' ');
                    }
                    String unit = b.toString().trim();
                    Grib2Parameter s = new Grib2Parameter(p1, p2, p3, name, unit, abbrev, null);
                    this.localParams.put(CfsrLocalTables.makeParamId(p1, p2, p3), s);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

