/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.grib.grib2.table.WmoParamTable;
import ucar.nc2.internal.wmo.Util;

public class WmoCodeFlagTables {
    private static final Logger logger = LoggerFactory.getLogger(WmoCodeFlagTables.class);
    public static final Version standard = Version.GRIB2_22_0_0;
    private static WmoCodeFlagTables instance;
    private ImmutableList<WmoTable> wmoTables;
    private ImmutableMap<String, WmoTable> wmoTableMap;

    public static WmoCodeFlagTables getInstance() {
        if (instance == null) {
            instance = new WmoCodeFlagTables();
            try {
                instance.readGribCodes(standard);
            }
            catch (IOException e) {
                logger.error("Cant read WMO Grib2 tables");
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public ImmutableList<WmoTable> getWmoTables() {
        return this.wmoTables;
    }

    @Nullable
    public TableType getTableType(String tableName) {
        WmoTable wmoTable = (WmoTable)this.wmoTableMap.get((Object)tableName);
        if (wmoTable == null) {
            return null;
        }
        return wmoTable.getType();
    }

    @Nullable
    public WmoCodeTable getCodeTable(String tableName) {
        WmoTable wmoTable = (WmoTable)this.wmoTableMap.get((Object)tableName);
        if (wmoTable == null) {
            return null;
        }
        return new WmoCodeTable(wmoTable);
    }

    @Nullable
    public WmoCodeTable getCodeTable(int m1, int m2) {
        String name = String.format("%d.%d", m1, m2);
        WmoTable wmoTable = (WmoTable)this.wmoTableMap.get((Object)name);
        if (wmoTable == null) {
            return null;
        }
        return new WmoCodeTable(wmoTable);
    }

    @Nullable
    public WmoParamTable getParamTable(int discipline, int category) {
        String name = String.format("4.2.%d.%d", discipline, category);
        WmoTable wmoTable = (WmoTable)this.wmoTableMap.get((Object)name);
        if (wmoTable == null) {
            return null;
        }
        return new WmoParamTable(wmoTable);
    }

    private void readGribCodes(Version version) throws IOException {
        String[] elems = version.getElemNames();
        if (elems == null) {
            throw new IllegalStateException("unknown version = " + (Object)((Object)version));
        }
        try (InputStream ios = WmoCodeFlagTables.class.getResourceAsStream(version.getResourceName());){
            Document doc;
            if (ios == null) {
                logger.error("cant open WmoCodeTable=" + version.getResourceName());
                throw new IOException("cant open WmoCodeTable=" + version.getResourceName());
            }
            try {
                SAXBuilder builder = new SAXBuilder();
                doc = builder.build(ios);
            }
            catch (JDOMException e) {
                throw new IOException(e.getMessage());
            }
            Element root = doc.getRootElement();
            HashMap<String, WmoTable> map = new HashMap<String, WmoTable>();
            List featList = root.getChildren(elems[0]);
            for (Element elem : featList) {
                TableType type;
                String line = elem.getChildTextNormalize("No");
                String tableName = elem.getChildTextNormalize(elems[1]);
                Element subtableElem = elem.getChild(elems[2]);
                if (tableName.startsWith("Code table 4.1 ")) {
                    type = TableType.cat;
                } else if (tableName.startsWith("Code table 4.2 ")) {
                    type = TableType.param;
                } else if (tableName.startsWith("Flag")) {
                    type = TableType.flag;
                } else if (tableName.startsWith("Code")) {
                    type = TableType.code;
                } else {
                    logger.warn("Unknown wmo table entry = '{}'", (Object)tableName);
                    continue;
                }
                if (subtableElem != null) {
                    tableName = subtableElem.getTextNormalize();
                }
                TableType finalType = type;
                WmoTable wmoTable = map.computeIfAbsent(tableName, name -> new WmoTable((String)name, finalType));
                String code = elem.getChildTextNormalize("CodeFlag");
                String value = elem.getChildTextNormalize("Value");
                String meaning = elem.getChildTextNormalize(elems[3]);
                Element unitElem = elem.getChild(elems[4]);
                String unit = unitElem == null ? null : unitElem.getTextNormalize();
                Element statusElem = elem.getChild("Status");
                String status = statusElem == null ? null : statusElem.getTextNormalize();
                wmoTable.addEntry(line, code, value, meaning, unit, status);
            }
            ios.close();
            this.wmoTables = (ImmutableList)map.values().stream().sorted().collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            map.values().forEach(t -> builder.put((Object)t.getId(), t));
            this.wmoTableMap = builder.build();
        }
    }

    public static class WmoTable
    implements Comparable<WmoTable> {
        private final String name;
        private final TableType type;
        private final List<WmoEntry> entries = new ArrayList<WmoEntry>();
        private final String id;
        private int m1 = -1;
        private int m2 = -1;
        private int discipline = -1;
        private int category = -1;

        private WmoTable(String name, TableType type) {
            this.name = name;
            this.type = type;
            if (type == TableType.cat) {
                this.m1 = 4;
                this.m2 = 1;
                String[] slist = name.split("[ :]+");
                for (int i = 0; i < slist.length; ++i) {
                    if (!slist[i].equalsIgnoreCase("discipline")) continue;
                    this.discipline = Integer.parseInt(slist[i + 1]);
                }
                if (this.discipline < 0) {
                    throw new IllegalArgumentException("Cant extract param id from table " + name);
                }
                this.id = String.format("%d.%d.%d", this.m1, this.m2, this.discipline);
            } else if (type == TableType.param) {
                this.m1 = 4;
                this.m2 = 2;
                String[] slist = name.split("[ :]+");
                for (int i = 0; i < slist.length; ++i) {
                    if (slist[i].equalsIgnoreCase("discipline")) {
                        this.discipline = Integer.parseInt(slist[i + 1]);
                    }
                    if (!slist[i].equalsIgnoreCase("category")) continue;
                    this.category = Integer.parseInt(slist[i + 1]);
                }
                if (this.discipline < 0 || this.category < 0) {
                    throw new IllegalArgumentException("Cant extract param id from table " + name);
                }
                this.id = String.format("%d.%d.%d.%d", this.m1, this.m2, this.discipline, this.category);
            } else {
                String[] s = name.split(" ");
                String id = s[2];
                String[] slist2 = id.split("\\.");
                if (slist2.length == 2) {
                    this.m1 = Integer.parseInt(slist2[0]);
                    this.m2 = Integer.parseInt(slist2[1]);
                } else {
                    logger.warn("WmoCodeTable bad= %s%n" + name);
                }
                if (this.m1 < 0 || this.m2 < 0) {
                    throw new IllegalArgumentException("Cant extract id from table " + name);
                }
                this.id = String.format("%d.%d", this.m1, this.m2);
            }
        }

        private WmoEntry addEntry(String line, String code, String value, String meaning, String unit, String status) {
            boolean isRange;
            WmoEntry entry = new WmoEntry(line, code, value, meaning, unit, status);
            boolean bl = isRange = entry.start != entry.stop;
            if (!isRange) {
                this.entries.add(entry);
            }
            return entry;
        }

        @Override
        public int compareTo(@Nonnull WmoTable o) {
            if (this.m1 != o.m1) {
                return this.m1 - o.m1;
            }
            if (this.m2 != o.m2) {
                return this.m2 - o.m2;
            }
            if (this.discipline != o.discipline) {
                return this.discipline - o.discipline;
            }
            return this.category - o.category;
        }

        public String getName() {
            return this.name;
        }

        public TableType getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public ImmutableList<WmoEntry> getEntries() {
            return ImmutableList.copyOf(this.entries);
        }

        public class WmoEntry {
            private final int start;
            private final int stop;
            private final int line;
            private final int number;
            private final int value;
            private final String code;
            private final String meaning;
            private final String name;
            private final String unit;
            private final String status;

            WmoEntry(String line, String code, String valueS, String meaning, String unit, String status) {
                int stopW;
                int startW;
                this.line = Integer.parseInt(line);
                this.code = code;
                this.meaning = meaning;
                this.status = status;
                this.name = meaning;
                String unitW = unit;
                int numberW = 0;
                try {
                    int pos = code.indexOf(45);
                    if (pos > 0) {
                        startW = Integer.parseInt(code.substring(0, pos));
                        String stops = code.substring(pos + 1);
                        stopW = Integer.parseInt(stops);
                    } else {
                        stopW = startW = Integer.parseInt(code);
                        numberW = startW;
                    }
                }
                catch (Exception e) {
                    startW = -1;
                    stopW = 0;
                }
                this.start = startW;
                this.stop = stopW;
                this.number = numberW;
                int valueW = -1;
                if (valueS != null) {
                    try {
                        valueW = Integer.parseInt(valueS);
                    }
                    catch (Exception e) {
                        valueW = -2;
                    }
                }
                this.value = valueW;
                if (WmoTable.this.type == TableType.param) {
                    unitW = unit != null ? Util.cleanUnit((String)unit) : "";
                }
                this.unit = unitW;
            }

            public int getLine() {
                return this.line;
            }

            public int getStart() {
                return this.start;
            }

            public int getStop() {
                return this.stop;
            }

            public int getNumber() {
                return this.number;
            }

            public int getValue() {
                return this.value;
            }

            public String getCode() {
                return this.code;
            }

            public String getMeaning() {
                return this.meaning;
            }

            public String getName() {
                return this.name;
            }

            public String getUnit() {
                return this.unit;
            }

            public String getStatus() {
                return this.status;
            }

            public String getId() {
                return WmoTable.this.getId() + "." + this.getNumber();
            }

            public int getCategory() {
                return WmoTable.this.category;
            }

            public int getDiscipline() {
                return WmoTable.this.discipline;
            }
        }
    }

    public static enum TableType {
        param,
        code,
        flag,
        cat;

    }

    public static enum Version {
        GRIB2_22_0_0;


        public String getResourceName() {
            return "/resources/grib2/wmo/" + this.name() + "_CodeFlag_exp_en.xml";
        }

        @Nullable
        String[] getElemNames() {
            if (this == GRIB2_22_0_0) {
                return new String[]{"GRIB2_22_0_0_CodeFlag_exp_en", "Title_en", "SubTitle_en", "MeaningParameterDescription_en", "UnitComments_en"};
            }
            return null;
        }
    }
}

