/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;

@Immutable
public class Grib1ParamTime {
    private final Grib1Customizer cust;
    private final int timeRangeIndicator;
    private final boolean isInterval;
    private final int start;
    private final int end;
    private final int forecastTime;

    public static String getTimeTypeName(int timeRangeIndicator) {
        String timeRange;
        switch (timeRangeIndicator) {
            case 0: {
                timeRange = "Uninitialized analysis / image product / forecast product valid for RT + P1";
                break;
            }
            case 1: {
                timeRange = "Initialized analysis product for reference time";
                break;
            }
            case 2: {
                timeRange = "product valid, interval = (RT + P1) to (RT + P2)";
                break;
            }
            case 3: {
                timeRange = "Average, interval = (RT + P1) to (RT + P2)";
                break;
            }
            case 4: {
                timeRange = "Accumulation, interval = (RT + P1) to (RT + P2)";
                break;
            }
            case 5: {
                timeRange = "Difference, interval = (RT + P2) - (RT + P1)";
                break;
            }
            case 6: {
                timeRange = "Average, interval = (RT - P1) to (RT - P2)";
                break;
            }
            case 7: {
                timeRange = "Average, interval = (RT - P1) to (RT + P2)";
                break;
            }
            case 10: {
                timeRange = "product valid at RT + P1";
                break;
            }
            case 51: {
                timeRange = "Climatological mean values from RT to (RT + P2)";
                break;
            }
            case 113: {
                timeRange = "Average of N forecasts, intervals = (refTime + i * P2, refTime + i * P2 + P1)";
                break;
            }
            case 114: {
                timeRange = "Accumulation of N forecasts, intervals = (refTime + i * P2, refTime + i * P2 + P1)";
                break;
            }
            case 115: {
                timeRange = "Average of N forecasts, intervals = (refTime, refTime + P1 + i * P2)";
                break;
            }
            case 116: {
                timeRange = "Accumulation of N forecasts, intervals = (refTime, refTime + P1 + i * P2)";
                break;
            }
            case 117: {
                timeRange = "Average of N forecasts, intervals = (refTime + i * P2, refTime + P1)";
                break;
            }
            case 118: {
                timeRange = "Temporal variance or covariance of N initialized analyses, timeCoord = (refTime + i * P2)";
                break;
            }
            case 119: {
                timeRange = "Standard Deviation of N forecasts, timeCoord = (refTime + P1 + i * P2)";
                break;
            }
            case 120: {
                timeRange = "Average of N Forecasts (ECMWF), accumulation from forecast P1 to P2, with reference times at intervals P2-P1";
                break;
            }
            case 123: {
                timeRange = "Average of N uninitialized analyses, intervals = (refTime, refTime + i * P2)";
                break;
            }
            case 124: {
                timeRange = "Accumulation of N uninitialized analyses, intervals = (refTime, refTime + i * P2)";
                break;
            }
            case 125: {
                timeRange = "Standard deviation of N forecasts, intervals = (refTime, refTime + P1 + i * P2)";
                break;
            }
            default: {
                timeRange = "Unknown Time Range Indicator " + timeRangeIndicator;
            }
        }
        return timeRange;
    }

    public Grib1ParamTime(Grib1Customizer cust, int timeRangeIndicator, boolean isInterval, int start, int end, int forecastTime) {
        this.cust = cust;
        this.timeRangeIndicator = timeRangeIndicator;
        this.isInterval = isInterval;
        this.start = start;
        this.end = end;
        this.forecastTime = forecastTime;
    }

    public Grib1ParamTime(Grib1Customizer cust, Grib1SectionProductDefinition pds) {
        this.cust = cust;
        int p1 = pds.getTimeValue1();
        int p2 = pds.getTimeValue2();
        int timeRangeIndicatorLocal = pds.getTimeRangeIndicator();
        int n = pds.getNincluded();
        int startLocal = 0;
        int endLocal = 0;
        int forecastTimeLocal = 0;
        boolean isIntervalLocal = false;
        switch (timeRangeIndicatorLocal) {
            case 0: {
                forecastTimeLocal = p1;
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                startLocal = p1;
                endLocal = p2;
                isIntervalLocal = true;
                break;
            }
            case 6: {
                startLocal = -p1;
                endLocal = -p2;
                isIntervalLocal = true;
                break;
            }
            case 7: {
                startLocal = -p1;
                endLocal = p2;
                isIntervalLocal = true;
                break;
            }
            case 10: {
                forecastTimeLocal = GribNumbers.int2(p1, p2);
                break;
            }
            case 51: {
                forecastTimeLocal = p2;
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                forecastTimeLocal = p1;
                startLocal = p1;
                endLocal = n > 0 ? p1 + (n - 1) * p2 : p1;
                isIntervalLocal = n > 0;
                break;
            }
            case 117: {
                endLocal = p1;
                isIntervalLocal = true;
                break;
            }
            case 118: {
                endLocal = n * p2;
                isIntervalLocal = true;
                break;
            }
            case 119: {
                startLocal = p1;
                endLocal = p1 + n * p2;
                isIntervalLocal = true;
                break;
            }
            case 120: {
                startLocal = p1;
                endLocal = p2;
                isIntervalLocal = true;
                break;
            }
            case 123: {
                endLocal = n * p2;
                isIntervalLocal = true;
                break;
            }
            case 124: {
                endLocal = n * p2;
                isIntervalLocal = true;
                break;
            }
            case 125: {
                endLocal = p1 + n * p2;
                isIntervalLocal = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("PDS: Unknown Time Range Indicator " + timeRangeIndicatorLocal);
            }
        }
        this.timeRangeIndicator = timeRangeIndicatorLocal;
        this.isInterval = isIntervalLocal;
        this.start = startLocal;
        this.end = endLocal;
        this.forecastTime = forecastTimeLocal;
    }

    public int[] getInterval() {
        int[] nArray;
        if (this.isInterval) {
            int[] nArray2 = new int[2];
            nArray2[0] = this.start;
            nArray = nArray2;
            nArray2[1] = this.end;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public int getIntervalSize() {
        return this.isInterval ? this.end - this.start : 0;
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public int getForecastTime() {
        return this.forecastTime;
    }

    public String getTimeTypeName() {
        return this.cust.getTimeTypeName(this.timeRangeIndicator);
    }

    public GribStatType getStatType() {
        return this.cust.getStatType(this.timeRangeIndicator);
    }

    public String getTimeCoord() {
        if (this.isInterval()) {
            int[] intv = this.getInterval();
            return intv[0] + "-" + intv[1];
        }
        return Integer.toString(this.getForecastTime());
    }
}

