/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public abstract class HTTPUtil {
    public static byte[] readbinaryfile(InputStream stream) throws IOException {
        int cnt;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        while ((cnt = stream.read(tmp)) > 0) {
            bytes.write(tmp, 0, cnt);
        }
        return bytes.toByteArray();
    }

    public static class InterceptRequest
    extends InterceptCommon
    implements HttpRequestInterceptor {
        HttpRequest request = null;

        public synchronized void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            this.request = request;
            this.context = context;
            if (this.printheaders) {
                this.printHeaders();
            } else if (this.request != null) {
                Header[] hdrs = this.request.getAllHeaders();
                for (int i = 0; i < hdrs.length; ++i) {
                    this.headers.add(hdrs[i]);
                }
            }
        }
    }

    public static class InterceptResponse
    extends InterceptCommon
    implements HttpResponseInterceptor {
        public synchronized void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            this.response = response;
            this.context = context;
            if (this.printheaders) {
                this.printHeaders();
            } else if (this.response != null) {
                Header[] hdrs = this.response.getAllHeaders();
                for (int i = 0; i < hdrs.length; ++i) {
                    this.headers.add(hdrs[i]);
                }
            }
        }
    }

    public static abstract class InterceptCommon {
        protected HttpContext context = null;
        protected List<Header> headers = new ArrayList<Header>();
        protected HttpRequest request = null;
        protected HttpResponse response = null;
        protected boolean printheaders = false;

        public void setPrint(boolean tf) {
            this.printheaders = tf;
        }

        public void clear() {
            this.context = null;
            this.headers.clear();
            this.request = null;
            this.response = null;
        }

        public synchronized HttpResponse getRequest() {
            return this.response;
        }

        public synchronized HttpResponse getResponse() {
            return this.response;
        }

        public synchronized HttpContext getContext() {
            return this.context;
        }

        public synchronized List<Header> getHeaders(String key) {
            ArrayList<Header> keyh = new ArrayList<Header>();
            for (Header h : this.headers) {
                if (!h.getName().equalsIgnoreCase(key.trim())) continue;
                keyh.add(h);
            }
            return keyh;
        }

        public synchronized List<Header> getHeaders() {
            return this.headers;
        }

        public void printHeaders() {
            Header[] hdrs;
            if (this.request != null) {
                hdrs = this.request.getAllHeaders();
                if (hdrs == null) {
                    hdrs = new Header[]{};
                }
                System.err.println("Request Headers:");
                for (Header h : hdrs) {
                    System.err.println(h.toString());
                }
            }
            if (this.response != null) {
                hdrs = this.response.getAllHeaders();
                if (hdrs == null) {
                    hdrs = new Header[]{};
                }
                System.err.println("Response Headers:");
                for (Header h : hdrs) {
                    System.err.println(h.toString());
                }
            }
            System.err.flush();
        }
    }
}

