/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.AuthScope;
import org.apache.http.util.LangUtils;
import ucar.httpservices.HTTPException;

@Immutable
public abstract class HTTPAuthScope {
    public static final String ANY_PRINCIPAL = null;
    public static final AuthScope ANY = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);

    static URI decompose(String suri) throws HTTPException {
        try {
            URI uri = new URI(suri);
            return uri;
        }
        catch (URISyntaxException use) {
            throw new HTTPException("HTTPAuthScope: illegal url: " + suri);
        }
    }

    public static boolean equivalent(AuthScope a1, AuthScope a2) {
        if (a1 == null || a2 == null) {
            throw new NullPointerException();
        }
        if (a1.getScheme() != AuthScope.ANY_SCHEME && a2.getScheme() != AuthScope.ANY_SCHEME && !a1.getScheme().equals(a2.getScheme())) {
            return false;
        }
        if (a1.getHost() != AuthScope.ANY_HOST && a2.getHost() != AuthScope.ANY_HOST && !a1.getHost().equals(a2.getHost())) {
            return false;
        }
        if (a1.getPort() != -1 && a2.getPort() != -1 && a1.getPort() != a2.getPort()) {
            return false;
        }
        return a1.getRealm() == AuthScope.ANY_REALM || a2.getRealm() == AuthScope.ANY_REALM || a1.getRealm().equals(a2.getRealm());
    }

    public static boolean identical(AuthScope a1, AuthScope a2) {
        if (a2 == null ^ a1 == null) {
            return false;
        }
        boolean b1 = LangUtils.equals((Object)a1.getHost(), (Object)a2.getHost());
        int aport = a2.getPort();
        boolean b2 = a1.getPort() == aport || a1.getPort() == -1 || aport == -1;
        boolean b3 = LangUtils.equals((Object)a1.getRealm(), (Object)a2.getRealm());
        boolean b4 = LangUtils.equals((Object)a1.getScheme(), (Object)a2.getScheme());
        return b1 && b2 && b3 && b4;
    }

    static boolean subsumes(AuthScope as, AuthScope has) {
        return HTTPAuthScope.equivalent(as, has);
    }

    public static AuthScope urlToScope(String authscheme, String surl, String[] principalp) throws HTTPException {
        URI uri = HTTPAuthScope.decompose(surl);
        AuthScope scope = new AuthScope(uri.getHost(), uri.getPort(), AuthScope.ANY_REALM, authscheme);
        if (principalp != null) {
            principalp[0] = uri.getUserInfo();
        }
        return scope;
    }

    public static boolean wildcardMatch(String p1, String p2) {
        if (p1 == null ^ p2 == null) {
            return true;
        }
        return p1.equals(p2);
    }

    public static void serializeScope(AuthScope scope, ObjectOutputStream oos) throws IOException {
        oos.writeObject(scope.getHost());
        oos.writeInt(scope.getPort());
        oos.writeObject(scope.getRealm());
        oos.writeObject(scope.getScheme());
    }

    public static AuthScope deserializeScope(ObjectInputStream oos) throws IOException, ClassNotFoundException {
        String host = (String)oos.readObject();
        int port = oos.readInt();
        String realm = (String)oos.readObject();
        String scheme = (String)oos.readObject();
        return new AuthScope(host, port, realm, scheme);
    }
}

