/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import ucar.httpservices.HTTPAuthScope;
import ucar.httpservices.HTTPCachingProvider;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethodStream;
import ucar.httpservices.HTTPSession;

public class HTTPMethod
implements AutoCloseable {
    protected HTTPSession session = null;
    protected boolean localsession = false;
    protected String legalurl = null;
    protected List<Header> headers = new ArrayList<Header>();
    protected HttpEntity content = null;
    protected HTTPSession.Methods methodclass = null;
    protected HTTPMethodStream methodstream = null;
    protected boolean closed = false;
    protected HttpRequestBase request = null;
    protected HttpResponse response = null;

    public HTTPMethod(HTTPSession.Methods m) throws HTTPException {
        this(m, null, null);
    }

    public HTTPMethod(HTTPSession.Methods m, String url) throws HTTPException {
        this(m, null, url);
    }

    public HTTPMethod(HTTPSession.Methods m, HTTPSession session, String url) throws HTTPException {
        if (url == null && session != null) {
            url = session.getURL();
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException mue) {
            throw new HTTPException("Malformed URL: " + url, mue);
        }
        if (session == null) {
            session = HTTPFactory.newSession(url);
            this.localsession = true;
        }
        this.session = session;
        this.legalurl = url = HTTPSession.removeprincipal(url);
        this.session.addMethod(this);
        this.methodclass = m;
    }

    protected HttpRequestBase createRequest() throws HTTPException {
        HttpPut method = null;
        if (this.legalurl == null) {
            throw new HTTPException("Malformed url: " + this.legalurl);
        }
        switch (this.methodclass) {
            case Put: {
                method = new HttpPut(this.legalurl);
                break;
            }
            case Post: {
                method = new HttpPost(this.legalurl);
                break;
            }
            case Get: {
                method = new HttpGet(this.legalurl);
                break;
            }
            case Head: {
                method = new HttpHead(this.legalurl);
                break;
            }
            case Options: {
                method = new HttpOptions(this.legalurl);
                break;
            }
        }
        return method;
    }

    protected void setcontent(HttpRequestBase request) {
        switch (this.methodclass) {
            case Put: {
                if (this.content == null) break;
                ((HttpPut)request).setEntity(this.content);
                break;
            }
            case Post: {
                if (this.content == null) break;
                ((HttpPost)request).setEntity(this.content);
                break;
            }
        }
        this.content = null;
    }

    public int execute() throws HTTPException {
        if (this.closed) {
            throw new HTTPException("HTTPMethod: attempt to execute closed method");
        }
        if (this.legalurl == null) {
            throw new HTTPException("HTTPMethod: no url specified");
        }
        if (!this.localsession && !this.sessionCompatible(this.legalurl)) {
            throw new HTTPException("HTTPMethod: session incompatible url: " + this.legalurl);
        }
        if (this.request != null) {
            this.request.releaseConnection();
        }
        this.request = this.createRequest();
        try {
            if (this.headers.size() > 0) {
                for (Header h : this.headers) {
                    this.request.addHeader(h);
                }
            }
            this.configure(this.request);
            this.setcontent(this.request);
            AuthScope scope = this.setAuthentication();
            this.response = this.session.execute(this.request);
            int code = this.response.getStatusLine().getStatusCode();
            if (code == 401 || code == 407) {
                HTTPCachingProvider.invalidate(scope);
            }
            return code;
        }
        catch (Exception ie) {
            throw new HTTPException(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(HttpRequestBase request) throws HTTPException {
        HTTPSession.Settings merge = new HTTPSession.Settings();
        HTTPMethod hTTPMethod = this;
        synchronized (hTTPMethod) {
            HTTPMethod hTTPMethod2 = this;
            HTTPSession.Settings s = hTTPMethod2.session.getGlobalSettings();
            for (String key : s.getNames()) {
                merge.setParameter(key, s.getParameter(key));
            }
            s = this.session.getSettings();
            for (String key : s.getNames()) {
                merge.setParameter(key, s.getParameter(key));
            }
        }
        for (String key : merge.getNames()) {
            Object value = merge.getParameter(key);
            HttpParams hmp = request.getParams();
            if (key.equals("http.protocol.allow-circular-redirects")) {
                hmp.setParameter("http.protocol.allow-circular-redirects", (Object)((Boolean)value));
                continue;
            }
            if (key.equals("http.protocol.handle-redirects")) {
                hmp.setParameter("http.protocol.handle-redirects", (Object)((Boolean)value));
                continue;
            }
            if (key.equals("http.protocol.handle-authentication")) {
                hmp.setParameter("http.protocol.handle-authentication", (Object)((Boolean)value));
                continue;
            }
            if (key.equals("http.protocol.max-redirects")) {
                hmp.setParameter("http.protocol.max-redirects", (Object)((Integer)value));
                continue;
            }
            if (key.equals("http.socket.timeout")) {
                hmp.setParameter("http.socket.timeout", (Object)((Integer)value));
                continue;
            }
            if (key.equals("http.connection.timeout")) {
                hmp.setParameter("http.connection.timeout", (Object)((Integer)value));
                continue;
            }
            if (key.equals("http.useragent")) {
                request.setHeader("User-Agent", value.toString());
                continue;
            }
            if (key.equals("COMPRESSION")) {
                request.setHeader("Accept-Encoding", value.toString());
                continue;
            }
            if (key.equals("http.route.default-proxy")) {
                HTTPSession.Proxy proxy = (HTTPSession.Proxy)value;
                if (this.session.sessionClient == null || proxy == null || proxy.host == null) continue;
                HttpHost httpproxy = new HttpHost(proxy.host, proxy.port);
                this.session.sessionClient.getParams().setParameter("http.route.default-proxy", (Object)httpproxy);
                continue;
            }
            throw new HTTPException("Unexpected setting name: " + key);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.methodstream != null) {
            try {
                this.methodstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.methodstream = null;
        }
        if (this.request != null) {
            this.request.releaseConnection();
            this.request = null;
        }
        if (this.session != null) {
            this.session.removeMethod(this);
            if (this.localsession) {
                this.session.close();
                this.session = null;
            }
        }
    }

    public int getStatusCode() {
        return this.response == null ? 0 : this.response.getStatusLine().getStatusCode();
    }

    public String getStatusLine() {
        return this.response == null ? null : this.response.getStatusLine().toString();
    }

    public String getRequestLine() {
        throw new UnsupportedOperationException("getrequestline not implemented");
    }

    public String getPath() {
        return this.request == null ? null : this.request.getURI().toString();
    }

    public boolean canHoldContent() {
        if (this.request == null) {
            return false;
        }
        return !(this.request instanceof HttpHead);
    }

    public InputStream getResponseBodyAsStream() {
        return this.getResponseAsStream();
    }

    public InputStream getResponseAsStream() {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        if (this.methodstream != null) {
            HTTPSession.log.warn("HTTPRequest.getResponseBodyAsStream: Getting method stream multiple times");
        } else {
            HTTPMethodStream stream = null;
            try {
                if (this.response == null) {
                    return null;
                }
                stream = new HTTPMethodStream(this.response.getEntity().getContent(), this);
            }
            catch (Exception e) {
                stream = null;
            }
            this.methodstream = stream;
        }
        return this.methodstream;
    }

    public byte[] getResponseAsBytes(int maxbytes) {
        byte[] contents = this.getResponseAsBytes();
        if (contents != null && contents.length > maxbytes) {
            byte[] result = new byte[maxbytes];
            System.arraycopy(contents, 0, result, 0, maxbytes);
            contents = result;
        }
        return contents;
    }

    public byte[] getResponseAsBytes() {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        byte[] content = null;
        if (this.response != null) {
            try {
                content = EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return content;
    }

    public String getResponseAsString(String charset) {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        String content = null;
        if (this.response != null) {
            try {
                Charset cset = Charset.forName(charset);
                content = EntityUtils.toString((HttpEntity)this.response.getEntity(), (Charset)cset);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.close();
        return content;
    }

    public String getResponseAsString() {
        return this.getResponseAsString("UTF-8");
    }

    public void setMethodHeaders(List<Header> headers) throws HTTPException {
        try {
            for (Header h : headers) {
                this.headers.add(h);
            }
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    public void setRequestHeader(String name, String value) throws HTTPException {
        this.setRequestHeader((Header)new BasicHeader(name, value));
    }

    public void setRequestHeader(Header h) throws HTTPException {
        try {
            this.headers.add(h);
        }
        catch (Exception e) {
            throw new HTTPException("cause", e);
        }
    }

    public Header getRequestHeader(String name) {
        if (this.request == null) {
            return null;
        }
        try {
            return this.request.getFirstHeader(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getRequestHeaders() {
        if (this.request == null) {
            return null;
        }
        try {
            Header[] hs = this.request.getAllHeaders();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header getResponseHeader(String name) {
        try {
            return this.response.getFirstHeader(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getResponseHeaders() {
        try {
            Header[] hs = this.response.getAllHeaders();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setRequestContent(HttpEntity content) {
        this.content = content;
    }

    public String getCharSet() {
        return "UTF-8";
    }

    public String getName() {
        return this.request == null ? null : this.request.getMethod();
    }

    public String getURL() {
        return this.request == null ? null : this.request.getURI().toString();
    }

    public String getProtocolVersion() {
        String ver = null;
        if (this.request != null) {
            ver = this.request.getProtocolVersion().toString();
        }
        return ver;
    }

    public String getSoTimeout() {
        return this.request == null ? null : "" + this.request.getParams().getParameter("http.socket.timeout");
    }

    public String getStatusText() {
        return this.getStatusLine();
    }

    public static Set<String> getAllowedMethods() {
        BasicHttpResponse rs = new BasicHttpResponse(new ProtocolVersion("http", 1, 1), 0, "");
        Set set = new HttpOptions().getAllowedMethods((HttpResponse)rs);
        return set;
    }

    public void setFollowRedirects(boolean tf) {
    }

    public String getResponseCharSet() {
        return "UTF-8";
    }

    public HTTPSession getSession() {
        return this.session;
    }

    public boolean isSessionLocal() {
        return this.localsession;
    }

    public boolean hasStreamOpen() {
        return this.methodstream != null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected boolean sessionCompatible(String other) {
        String sessionurl = HTTPSession.getCanonicalURL(this.session.getURL());
        if (sessionurl == null) {
            return true;
        }
        other = HTTPSession.getCanonicalURL(other);
        return HTTPMethod.compatibleURL(sessionurl, other);
    }

    protected synchronized AuthScope setAuthentication() throws HTTPException {
        String surl = this.session.getURL();
        String[] principalp = new String[1];
        AuthScope scope = surl == null ? HTTPAuthScope.ANY : HTTPAuthScope.urlToScope("Basic", surl, principalp);
        HTTPCachingProvider hap = new HTTPCachingProvider(this.session.getAuthStore(), scope, principalp[0]);
        this.session.setAuthentication(hap);
        return scope;
    }

    protected static boolean compatibleURL(String u1, String u2) {
        URI uu2;
        URI uu1;
        if (u1 == u2) {
            return true;
        }
        if (u1 == null) {
            return false;
        }
        if (u2 == null) {
            return false;
        }
        if (u1.equals(u2) || u1.startsWith(u2) || u2.startsWith(u1)) {
            return true;
        }
        try {
            uu1 = new URI(u1);
        }
        catch (URISyntaxException use) {
            return false;
        }
        try {
            uu2 = new URI(u2);
        }
        catch (URISyntaxException use) {
            return false;
        }
        String s1 = uu1.getScheme();
        String s2 = uu2.getScheme();
        if (!(s1 == null && s2 == null || s1 == null || s2 == null || s1.equals(s2))) {
            return false;
        }
        s1 = uu1.getUserInfo();
        s2 = uu2.getUserInfo();
        if (!(s1 == null || s2 != null && s1.equals(s2))) {
            return false;
        }
        s1 = uu1.getHost();
        s2 = uu2.getHost();
        if (!(s1 == null && s2 == null || s1 == null || s2 == null || s1.equals(s2))) {
            return false;
        }
        if (uu1.getPort() != uu2.getPort()) {
            return false;
        }
        s1 = uu1.getRawPath();
        s2 = uu2.getRawPath();
        return s1 == null && s2 == null || s1 == null || s2 == null || s1.startsWith(s2) || s2.startsWith(s1);
    }

    public HttpMessage debugRequest() {
        return this.request;
    }

    public HttpResponse debugResponse() {
        return this.response;
    }
}

