/*
 * Decompiled with CFR 0.152.
 */
package opendap.dts;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dts.test_ServerFactory;
import opendap.servers.CEEvaluator;
import opendap.servers.ServerDDS;
import opendap.servers.ServerMethods;
import opendap.util.Getopts;
import opendap.util.InvalidSwitch;

/*
 * Exception performing whole class analysis ignored.
 */
public class SDTest {
    public static boolean Debug = false;
    public static String DDSFile;
    public static String ConstraintExpression;

    public static void print_SDDS(ServerDDS sdds, boolean constrained) {
        System.out.println("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
        System.out.println("ServerDDS:");
        Enumeration e = sdds.getVariables();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            ServerMethods s = (ServerMethods)o;
            BaseType bt = (BaseType)o;
            System.out.println(bt.getTypeName() + " " + bt.getEncodedName() + ":");
            System.out.println("Constrained DDS:");
            bt.printDecl((OutputStream)System.out, "    ", true, constrained);
            System.out.println("Declaration and Value:");
            if (s.isRead()) {
                bt.printVal((OutputStream)System.out, "    ", true);
            } else {
                bt.printDecl((OutputStream)System.out, "    ");
            }
            System.out.print(" isProj: " + s.isProject());
            System.out.print("    isRead: " + s.isRead());
            System.out.println("    isSynth: " + s.isSynthesized());
            if (!e.hasMoreElements()) continue;
            System.out.println("- - - - - - - - - - - - - - - - - -");
        }
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    public static void parse_options(String[] args) {
        Getopts g = new Getopts("SDTest", args, "f:c:");
        Getopts opts = null;
        String arg = null;
        try {
            opts = new Getopts("f:c:", args);
            if (opts.getSwitch((Character)new Character((char)'f')).set) {
                arg = opts.getSwitch((Character)new Character((char)'f')).val;
                if (Debug) {
                    DDSFile = arg;
                }
            }
            if (opts.getSwitch((Character)new Character((char)'c')).set) {
                arg = g.getOptarg();
                if (Debug) {
                    ConstraintExpression = arg;
                }
            }
        }
        catch (InvalidSwitch e) {
            System.err.println("Invalid Switch: " + (Object)((Object)e));
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            Throwable throwable;
            System.out.println("-------------------------------------------");
            System.out.println("Debugging Display: " + (Debug ? "ON" : "OFF"));
            SDTest.parse_options((String[])args);
            System.out.println("...........................................");
            ServerDDS myDDS = null;
            File fin = new File(DDSFile);
            try (FileInputStream fp_in = new FileInputStream(fin);){
                throwable = null;
                try (DataInputStream dds_source = new DataInputStream(fp_in);){
                    test_ServerFactory sfactory = new test_ServerFactory();
                    myDDS = new ServerDDS("bogus", (BaseTypeFactory)sfactory);
                    if (Debug) {
                        System.out.println("Parsing DDS...");
                    }
                    myDDS.parse((InputStream)dds_source);
                }
                catch (Throwable sfactory) {
                    throwable = sfactory;
                    throw sfactory;
                }
            }
            if (Debug) {
                System.out.println("Printing DDS...");
            }
            myDDS.print((OutputStream)System.out);
            if (Debug) {
                System.out.println("Constructing CEEvaluator...");
            }
            CEEvaluator ce = new CEEvaluator(myDDS);
            File fout = new File("a.out");
            throwable = null;
            try (FileOutputStream fp_out = new FileOutputStream(fout);
                 DataOutputStream sink = new DataOutputStream(fp_out);){
                if (Debug) {
                    System.out.println("Parsing Constraint Expression: " + ConstraintExpression);
                }
                ce.parseConstraint(ConstraintExpression, null);
                if (Debug) {
                    System.out.println("Attempting to send data...");
                }
                ce.send(myDDS.getEncodedName(), (OutputStream)sink, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            myDDS.printConstrained((OutputStream)System.out);
            System.out.println("-------------------------------------------");
        }
        catch (DAP2Exception e) {
            System.out.println("\n\nERROR of Type: " + ((Object)((Object)e)).getClass().getName() + "\n");
            System.out.println("Message:\n" + e.getMessage() + "\n");
            System.out.println("Stack Trace: ");
            e.printStackTrace(System.out);
            System.out.println("\n\n");
        }
        System.exit(0);
    }
}

