/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.List;
import ucar.ma2.ArrayInt;
import ucar.ma2.StructureData;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.RecordDatasetHelper;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Station;

public class NdbcDataset
extends StationObsDatasetImpl
implements TypedDatasetFactoryIF {
    private ArrayInt.D1 dates;
    private RecordDatasetHelper recordHelper;
    private StationImpl station;

    public static boolean isValidFile(NetcdfFile ds) {
        if (!ds.findAttValueIgnoreCase(null, "Conventions", "").equalsIgnoreCase("COARDS")) {
            return false;
        }
        if (!ds.findAttValueIgnoreCase(null, "data_provider", "").equalsIgnoreCase("National Data Buoy Center")) {
            return false;
        }
        if (null == ds.findAttValueIgnoreCase(null, "station", null)) {
            return false;
        }
        if (null == ds.findAttValueIgnoreCase(null, "location", null)) {
            return false;
        }
        if (ds.findVariable("lat") == null) {
            return false;
        }
        if (ds.findVariable("lon") == null) {
            return false;
        }
        return ds.hasUnlimitedDimension();
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return NdbcDataset.isValidFile((NetcdfFile)ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new NdbcDataset(ncd);
    }

    public NdbcDataset() {
    }

    public NdbcDataset(NetcdfDataset ds) throws IOException {
        super(ds);
        this.recordHelper = new RecordDatasetHelper(ds, "time", null, this.dataVariables);
        this.removeDataVariable("time");
        this.timeUnit = this.recordHelper.timeUnit;
        Variable latVar = ds.findVariable("lat");
        double lat = latVar.readScalarDouble();
        Variable lonVar = ds.findVariable("lon");
        double lon = lonVar.readScalarDouble();
        Variable dateVar = ds.findVariable("time");
        this.dates = (ArrayInt.D1)dateVar.read();
        int count = (int)this.dates.getSize();
        int firstDate = this.dates.get(0);
        int lastDate = this.dates.get(count - 1);
        this.startDate = this.timeUnit.makeDate((double)firstDate);
        this.endDate = this.timeUnit.makeDate((double)lastDate);
        String name = ds.findAttValueIgnoreCase(null, "station", null);
        String stationDesc = ds.findAttValueIgnoreCase(null, "description", null);
        this.station = new StationImpl(name, stationDesc, lat, lon, Double.NaN, count);
        this.stations.add(this.station);
        this.title = ds.findAttValueIgnoreCase(null, "data_provider", null) + " Station " + name;
        this.desc = this.title + "\n" + ds.findAttValueIgnoreCase(null, "data_quality", null);
        this.setBoundingBox();
    }

    @Override
    protected void setTimeUnits() {
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    protected void setBoundingBox() {
        this.boundingBox = this.stationHelper.getBoundingBox();
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        return this.getData((Station)this.station, cancel);
    }

    @Override
    public int getDataCount() {
        Dimension unlimitedDim = this.netcdfDataset.getUnlimitedDimension();
        return unlimitedDim.getLength();
    }

    @Override
    public List getData(Station s, CancelTask cancel) throws IOException {
        StationImpl si = (StationImpl)s;
        int count = this.getDataCount();
        if (null == si.getObservations()) {
            for (int recno = 0; recno < count; ++recno) {
                double time = this.dates.get(recno);
                RecordDatasetHelper recordDatasetHelper = this.recordHelper;
                recordDatasetHelper.getClass();
                si.addObs(new RecordDatasetHelper.RecordStationObs(recordDatasetHelper, s, time, time, recno));
                if (cancel == null || !cancel.isCancel()) continue;
                return null;
            }
        }
        return si.getObservations();
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new NdbcDatatypeIterator((Structure)this.recordHelper.recordVar, bufferSize);
    }

    private class NdbcDatatypeIterator
    extends DatatypeIterator {
        @Override
        protected Object makeDatatypeWithData(int recnum, StructureData sdata) {
            RecordDatasetHelper recordDatasetHelper = NdbcDataset.this.recordHelper;
            recordDatasetHelper.getClass();
            return new RecordDatasetHelper.RecordStationObs(recordDatasetHelper, (Station)NdbcDataset.this.station, sdata);
        }

        NdbcDatatypeIterator(Structure struct, int bufferSize) {
            super(struct, bufferSize);
        }
    }
}

