/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;

public class StructurePseudo
extends Structure {
    private static boolean debugRecord = false;
    private List<Variable> orgVariables = new ArrayList<Variable>();

    public StructurePseudo(NetcdfFile ncfile, Group group, String shortName, Dimension dim) {
        super(ncfile, group, null, shortName);
        this.setDataType(DataType.STRUCTURE);
        this.setDimensions(dim.getShortName());
        if (group == null) {
            group = ncfile.getRootGroup();
        }
        List vars = group.getVariables();
        for (Variable orgV : vars) {
            Dimension dim0 = orgV.getDimension(0);
            if (dim0 == null || !dim0.equals((Object)dim)) continue;
            Variable memberV = new Variable(ncfile, group, (Structure)this, orgV.getShortName());
            memberV.setDataType(orgV.getDataType());
            memberV.setSPobject(orgV.getSPobject());
            memberV.attributes.addAll((Iterable)orgV.getAttributes());
            ArrayList dims = new ArrayList(orgV.dimensions);
            dims.remove(0);
            memberV.setDimensions(dims);
            this.addMemberVariable(memberV);
            this.orgVariables.add(orgV);
        }
        this.calcElementSize();
    }

    public StructurePseudo(NetcdfFile ncfile, Group group, String shortName, List<String> varNames, Dimension dim) {
        super(ncfile, group, null, shortName);
        this.setDataType(DataType.STRUCTURE);
        this.setDimensions(dim.getShortName());
        if (group == null) {
            group = ncfile.getRootGroup();
        }
        for (String name : varNames) {
            Variable orgV = group.findVariable(name);
            if (orgV == null) {
                log.warn("StructurePseudo cannot find variable " + name);
                continue;
            }
            Dimension dim0 = orgV.getDimension(0);
            if (!dim0.equals((Object)dim)) {
                throw new IllegalArgumentException("Variable " + orgV.getNameAndDimensions() + " must have outermost dimension=" + dim);
            }
            Variable memberV = new Variable(ncfile, group, (Structure)this, orgV.getShortName());
            memberV.setDataType(orgV.getDataType());
            memberV.setSPobject(orgV.getSPobject());
            memberV.attributes.addAll((Iterable)orgV.getAttributes());
            ArrayList dims = new ArrayList(orgV.dimensions);
            dims.remove(0);
            memberV.setDimensions(dims);
            this.addMemberVariable(memberV);
            this.orgVariables.add(orgV);
        }
        this.calcElementSize();
    }

    public boolean removeMemberVariable(Variable v) {
        if (super.removeMemberVariable(v)) {
            Iterator<Variable> iter = this.orgVariables.iterator();
            while (iter.hasNext()) {
                Variable mv = iter.next();
                if (!mv.getShortName().equals(v.getShortName())) continue;
                iter.remove();
                return true;
            }
        }
        return false;
    }

    public Array reallyRead(Variable mainv, CancelTask cancelTask) throws IOException {
        if (debugRecord) {
            System.out.println(" read all psuedo records ");
        }
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, this.getShape());
        for (Variable v : this.orgVariables) {
            Array data = v.read();
            StructureMembers.Member m = smembers.findMember(v.getShortName());
            m.setDataArray(data);
        }
        return asma;
    }

    public Array reallyRead(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        String err;
        if (null == section) {
            return this._read();
        }
        if (debugRecord) {
            System.out.println(" read psuedo records " + section.getRange(0));
        }
        if ((err = section.checkInRange(this.getShape())) != null) {
            throw new InvalidRangeException(err);
        }
        Range r = section.getRange(0);
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, section.getShape());
        for (Variable v : this.orgVariables) {
            ArrayList<Range> vsection = new ArrayList<Range>(v.getRanges());
            vsection.set(0, r);
            Array data = v.read(vsection);
            StructureMembers.Member m = smembers.findMember(v.getShortName());
            m.setDataArray(data);
        }
        return asma;
    }
}

