/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.dl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.XMLEntityResolver;
import thredds.catalog.crawl.CatalogCrawler;
import thredds.catalog.dl.Grib1toDIF;
import thredds.catalog.dl.Grib2toDIF;
import thredds.catalog.dl.VocabTranslator;
import ucar.nc2.constants.CDM;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.util.StringUtil2;

public class DIFWriter {
    private static Logger log = LoggerFactory.getLogger(DIFWriter.class);
    private static final Namespace defNS = Namespace.getNamespace((String)"http://gcmd.gsfc.nasa.gov/Aboutus/xml/dif/");
    private static String schemaLocation = "http://gcmd.nasa.gov/Aboutus/xml/dif/dif.xsd";
    private String fileDir;
    private StringBuilder messBuffer;
    private boolean debug = false;

    public void writeDatasetEntries(InvCatalogImpl cat, String fileDir, StringBuilder mess) {
        this.fileDir = fileDir;
        this.messBuffer = mess;
        File dir = new File(fileDir);
        if (!dir.exists()) {
            boolean ret = dir.mkdirs();
            assert (ret);
        }
        CatalogCrawler.Listener listener = new CatalogCrawler.Listener(){

            @Override
            public void getDataset(InvDataset ds, Object context) {
                DIFWriter.this.doOneDataset(ds);
            }

            @Override
            public boolean getCatalogRef(InvCatalogRef dd, Object context) {
                return true;
            }
        };
        ByteArrayOutputStream bis = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)bis, CDM.utf8Charset));
        CatalogCrawler crawler = new CatalogCrawler(0, true, listener);
        crawler.crawl(cat, null, pw, null);
        mess.append("\n*********************\n");
        mess.append(new String(bis.toByteArray(), CDM.utf8Charset));
    }

    public void doOneDataset(InvDataset ds) {
        if (this.debug) {
            System.out.println("doDataset " + ds.getName());
        }
        if (this.isDatasetUseable(ds, this.messBuffer)) {
            String id = StringUtil2.replace((String)ds.getID(), (String)"/", (String)"-");
            String fileOutName = this.fileDir + "/" + id + ".dif.xml";
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileOutName));
                this.writeOneEntry(ds, out, this.messBuffer);
                ((OutputStream)out).close();
                this.messBuffer.append(" OK on Write\n");
            }
            catch (IOException ioe) {
                this.messBuffer.append("DIFWriter failed on write " + ioe.getMessage() + "\n");
                log.error("DIFWriter failed on write " + ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    public void doOneDataset(InvDataset ds, String fileDir, StringBuilder mess) {
        if (this.debug) {
            System.out.println("doDataset " + ds.getName());
        }
        if (this.isDatasetUseable(ds, mess)) {
            String id = StringUtil2.replace((String)ds.getID(), (String)"/", (String)"-");
            String fileOutName = fileDir + "/" + id + ".dif.xml";
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileOutName));
                this.writeOneEntry(ds, out, mess);
                ((OutputStream)out).close();
                mess.append(" OK on Write\n");
            }
            catch (IOException ioe) {
                mess.append("DIFWriter failed on write " + ioe.getMessage() + "\n");
                log.error("DIFWriter failed on write " + ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    public boolean isDatasetUseable(InvDataset ds, StringBuilder sbuff) {
        String summary;
        List<ThreddsMetadata.Source> list;
        ThreddsMetadata.Variables vs;
        boolean ok = true;
        sbuff.append("Dataset " + ds.getName() + " id = " + ds.getID() + ": ");
        if (!ds.isHarvest()) {
            ok = false;
            sbuff.append("Dataset " + ds.getName() + " id = " + ds.getID() + " has harvest = false\n");
        }
        if (ds.getName() == null) {
            ok = false;
            sbuff.append(" missing Name field\n");
        }
        if (ds.getUniqueID() == null) {
            ok = false;
            sbuff.append(" missing ID field\n");
        }
        if ((vs = ds.getVariables("DIF")) == null || vs.getVariableList().size() == 0) {
            vs = ds.getVariables("GRIB-1");
        }
        if (vs == null || vs.getVariableList().size() == 0) {
            vs = ds.getVariables("GRIB-2");
        }
        if (vs == null || vs.getVariableList().size() == 0) {
            ok = false;
            sbuff.append(" missing Variables with DIF or GRIB compatible vocabulary\n");
        }
        if ((list = ds.getPublishers()) == null || list.size() == 0) {
            ok = false;
            sbuff.append(" must have publisher element that defines the data center\n");
        }
        if ((summary = ds.getDocumentation("summary")) == null) {
            ok = false;
            sbuff.append(" must have documentation element of type summary\n");
        }
        sbuff.append(" useable= " + ok + "\n");
        return ok;
    }

    private void writeOneEntry(InvDataset ds, OutputStream out, StringBuilder mess) throws IOException {
        Element rootElem = new Element("DIF", defNS);
        Document doc = new Document(rootElem);
        this.writeDataset(ds, rootElem, mess);
        rootElem.addNamespaceDeclaration(defNS);
        rootElem.addNamespaceDeclaration(XMLEntityResolver.xsiNS);
        rootElem.setAttribute("schemaLocation", defNS.getURI() + " " + schemaLocation, XMLEntityResolver.xsiNS);
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, out);
    }

    private Iterator translateGribVocabulary(ThreddsMetadata.Variables vs, boolean isGrib1, StringBuilder mess) {
        VocabTranslator vt;
        if (vs == null) {
            return null;
        }
        try {
            vt = isGrib1 ? Grib1toDIF.getInstance() : Grib2toDIF.getInstance();
        }
        catch (IOException e) {
            log.error("DIFWriter failed opening GribtoDIF VocabTranslator ", (Throwable)e);
            return null;
        }
        HashMap<String, ThreddsMetadata.Variable> hash = new HashMap<String, ThreddsMetadata.Variable>(100);
        for (ThreddsMetadata.Variable v : vs.getVariableList()) {
            String fromVocabId = v.getVocabularyId();
            if (fromVocabId == null) {
                mess.append("** no id for " + v.getName() + "\n");
                continue;
            }
            String toVocabName = vt.translate(fromVocabId);
            if (toVocabName == null) {
                mess.append("** no translation for " + fromVocabId + " == " + v.getVocabularyName() + "\n");
                continue;
            }
            if (hash.get(toVocabName) != null) continue;
            ThreddsMetadata.Variable transV = new ThreddsMetadata.Variable(v.getName(), v.getDescription(), toVocabName, v.getUnits(), fromVocabId);
            hash.put(toVocabName, transV);
        }
        return hash.values().iterator();
    }

    private void writeDataset(InvDataset ds, Element rootElem, StringBuilder mess) {
        String href;
        URI uri;
        String summary;
        List<ThreddsMetadata.Source> plist;
        String rights;
        ThreddsMetadata.GeospatialCoverage geo;
        TimeDuration duration;
        double ndays;
        DateType end;
        DateRange tm;
        List<ThreddsMetadata.Vocab> list;
        boolean hasVocab;
        String entryId = StringUtil2.allow((String)ds.getUniqueID(), (String)"_-.", (char)'-');
        rootElem.addContent((Content)new Element("Entry_ID", defNS).addContent(entryId));
        rootElem.addContent((Content)new Element("Entry_Title", defNS).addContent(ds.getFullName()));
        ThreddsMetadata.Variables vs = ds.getVariables("DIF");
        boolean bl = hasVocab = vs != null && vs.getVariableList().size() != 0;
        if (hasVocab) {
            for (ThreddsMetadata.Variable v : vs.getVariableList()) {
                this.writeVariable(rootElem, v);
            }
        } else {
            Iterator iter;
            ThreddsMetadata.Variable v;
            vs = ds.getVariables("GRIB-1");
            if (vs != null && vs.getVariableList().size() != 0) {
                iter = this.translateGribVocabulary(vs, true, mess);
                while (iter.hasNext()) {
                    v = (ThreddsMetadata.Variable)iter.next();
                    this.writeVariable(rootElem, v);
                }
            } else {
                vs = ds.getVariables("GRIB-2");
                if (vs != null && vs.getVariableList().size() != 0) {
                    iter = this.translateGribVocabulary(vs, false, mess);
                    while (iter != null && iter.hasNext()) {
                        v = (ThreddsMetadata.Variable)iter.next();
                        this.writeVariable(rootElem, v);
                    }
                }
            }
        }
        if ((list = ds.getKeywords()).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ThreddsMetadata.Vocab k = list.get(i);
                rootElem.addContent((Content)new Element("Keyword", defNS).addContent(k.getText()));
            }
        }
        if ((tm = ds.getTimeCoverage()) != null && (end = tm.getEnd()).isPresent() && (ndays = (duration = tm.getDuration()).getValue("days")) > 0.0) {
            String reletiveTime = "RELATIVE_START_DATE: " + (int)(-ndays);
            rootElem.addContent((Content)new Element("Keyword", defNS).addContent(reletiveTime));
        }
        Element platform = new Element("Source_Name", defNS);
        rootElem.addContent((Content)platform);
        platform.addContent((Content)new Element("Short_Name", defNS).addContent("MODELS"));
        if (tm != null) {
            Element tmElem = new Element("Temporal_Coverage", defNS);
            rootElem.addContent((Content)tmElem);
            tmElem.addContent((Content)new Element("Start_Date", defNS).addContent(tm.getStart().toString()));
            tmElem.addContent((Content)new Element("Stop_Date", defNS).addContent(tm.getEnd().toString()));
        }
        if ((geo = ds.getGeospatialCoverage()) != null) {
            Element geoElem = new Element("Spatial_Coverage", defNS);
            rootElem.addContent((Content)geoElem);
            double eastNormal = LatLonPointImpl.lonNormal((double)geo.getLonEast());
            double westNormal = LatLonPointImpl.lonNormal((double)geo.getLonWest());
            geoElem.addContent((Content)new Element("Southernmost_Latitude", defNS).addContent(Double.toString(geo.getLatSouth())));
            geoElem.addContent((Content)new Element("Northernmost_Latitude", defNS).addContent(Double.toString(geo.getLatNorth())));
            geoElem.addContent((Content)new Element("Westernmost_Longitude", defNS).addContent(Double.toString(westNormal)));
            geoElem.addContent((Content)new Element("Easternmost_Longitude", defNS).addContent(Double.toString(eastNormal)));
        }
        if ((rights = ds.getDocumentation("rights")) != null) {
            rootElem.addContent((Content)new Element("Use_Constraints", defNS).addContent(rights));
        }
        if ((plist = ds.getPublishers()).size() > 0) {
            for (ThreddsMetadata.Source p : plist) {
                if (!p.getNameVocab().getVocabulary().equalsIgnoreCase("DIF")) continue;
                Element dataCenter = new Element("Data_Center", defNS);
                rootElem.addContent((Content)dataCenter);
                this.writeDataCenter(p, dataCenter);
                break;
            }
        }
        if ((summary = ds.getDocumentation("summary")) != null) {
            String summaryLines = StringUtil2.breakTextAtWords((String)summary, (String)"\n", (int)80);
            rootElem.addContent((Content)new Element("Summary", defNS).addContent(summaryLines));
        }
        if (ds instanceof InvCatalogRef) {
            InvCatalogRef catref = (InvCatalogRef)ds;
            uri = catref.getURI();
            href = uri.toString();
            int pos = href.lastIndexOf(46);
            href = href.substring(0, pos) + ".html";
        } else {
            InvCatalogImpl cat = (InvCatalogImpl)ds.getParentCatalog();
            uri = cat.getBaseURI();
            String catURL = uri.toString();
            int pos = catURL.lastIndexOf(46);
            href = catURL.substring(0, pos) + ".html";
            if (ds.hasAccess()) {
                href = href + "?dataset=" + ds.getID();
            }
        }
        rootElem.addContent((Content)this.makeRelatedURL("GET DATA", "THREDDS CATALOG", uri.toString()));
        rootElem.addContent((Content)this.makeRelatedURL("GET DATA", "THREDDS DIRECTORY", href));
        InvAccess access = ds.getAccess(ServiceType.OPENDAP);
        if (null != access) {
            rootElem.addContent((Content)this.makeRelatedURL("GET DATA", "OPENDAP DATA", access.getStandardUrlName()));
        }
        if (null != (access = ds.getAccess(ServiceType.DAP4))) {
            rootElem.addContent((Content)this.makeRelatedURL("GET DATA", "DAP4 DATA", access.getStandardUrlName()));
        }
        rootElem.addContent((Content)new Element("Metadata_Name", defNS).addContent("CEOS IDN DIF"));
        rootElem.addContent((Content)new Element("Metadata_Version", defNS).addContent("9.4"));
        DateType today = new DateType(false, new Date());
        rootElem.addContent((Content)new Element("DIF_Creation_Date", defNS).addContent(today.toDateTimeStringISO()));
    }

    private Element makeRelatedURL(String type, String subtype, String url) {
        Element elem = new Element("Related_URL", defNS);
        Element uctElem = new Element("URL_Content_Type", defNS);
        elem.addContent((Content)uctElem);
        uctElem.addContent((Content)new Element("Type", defNS).addContent(type));
        uctElem.addContent((Content)new Element("Subtype", defNS).addContent(subtype));
        elem.addContent((Content)new Element("URL", defNS).addContent(url));
        return elem;
    }

    private void writeDataCenter(ThreddsMetadata.Source p, Element dataCenter) {
        Element name = new Element("Data_Center_Name", defNS);
        dataCenter.addContent((Content)name);
        StringTokenizer stoker = new StringTokenizer(p.getName(), ">");
        int n = stoker.countTokens();
        if (n == 2) {
            name.addContent((Content)new Element("Short_Name", defNS).addContent(stoker.nextToken().trim()));
            name.addContent((Content)new Element("Long_Name", defNS).addContent(stoker.nextToken().trim()));
        } else {
            name.addContent((Content)new Element("Short_Name", defNS).addContent(p.getName()));
        }
        if (p.getUrl() != null && p.getUrl().length() > 0) {
            dataCenter.addContent((Content)new Element("Data_Center_URL", defNS).addContent(p.getUrl()));
        }
        Element person = new Element("Personnel", defNS);
        dataCenter.addContent((Content)person);
        person.addContent((Content)new Element("Role", defNS).addContent("DATA CENTER CONTACT"));
        person.addContent((Content)new Element("Last_Name", defNS).addContent("Any"));
        person.addContent((Content)new Element("Email", defNS).addContent(p.getEmail()));
    }

    private void writeVariable(Element rootElem, ThreddsMetadata.Variable v) {
        String vname = v.getVocabularyName();
        StringTokenizer stoker = new StringTokenizer(vname, ">");
        int n = stoker.countTokens();
        if (n < 3) {
            return;
        }
        Element param = new Element("Parameters", defNS);
        rootElem.addContent((Content)param);
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Category", defNS).addContent(stoker.nextToken().trim()));
        }
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Topic", defNS).addContent(stoker.nextToken().trim()));
        }
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Term", defNS).addContent(stoker.nextToken().trim()));
        }
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Variable", defNS).addContent(stoker.nextToken().trim()));
        }
        if (stoker.hasMoreTokens()) {
            param.addContent((Content)new Element("Detailed_Variable", defNS).addContent(stoker.nextToken().trim()));
        }
    }

    private static void doCatalog(InvCatalogFactory fac, String url) {
        System.out.println("***read " + url);
        try {
            InvCatalogImpl cat = fac.readXML(url);
            StringBuilder buff = new StringBuilder();
            boolean isValid = cat.check(buff, false);
            System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            System.out.println(" validation output=\n" + buff);
            System.out.println(" catalog=\n" + fac.writeXML(cat));
            DIFWriter w = new DIFWriter();
            StringBuilder sbuff = new StringBuilder();
            w.writeDatasetEntries(cat, "C:/temp/dif2", sbuff);
            System.out.println(" messages=\n" + sbuff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        DIFWriter.doCatalog(catFactory, "http://thredds.ucar.edu:9080/thredds/idd/models.xml");
    }
}

