/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.trajectory.TrajectoryObsDatasetImpl;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class COSMICTrajectoryObsDataset
extends TrajectoryObsDatasetImpl
implements TypedDatasetFactoryIF {
    private static String dimName = "MSL_alt";
    private static String dimVarName = "MSL_alt";
    private static String latVarName = "Lat";
    private static String lonVarName = "Lon";
    private static String elevVarName = "MSL_alt";
    private static String trajId = "trajectory data";
    NetcdfDataset localNCD;

    public static boolean isValidFile(NetcdfDataset ncd) {
        return COSMICTrajectoryObsDataset.buildConfig(ncd) != null;
    }

    private static TrajectoryObsDatasetImpl.Config buildConfig(NetcdfDataset ncd) {
        List list = ncd.getRootGroup().getDimensions();
        if (list.size() != 1) {
            return null;
        }
        Dimension d = (Dimension)list.get(0);
        if (!d.getShortName().equals(dimName)) {
            return null;
        }
        TrajectoryObsDatasetImpl.Config trajConfig = new TrajectoryObsDatasetImpl.Config();
        trajConfig.setTrajectoryDim(d);
        Variable var = ncd.getRootGroup().findVariable(dimVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals(dimName)) {
            return null;
        }
        String units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible((String)units, (String)"km")) {
            return null;
        }
        trajConfig.setDimensionVar(var);
        var = ncd.getRootGroup().findVariable(latVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals(dimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible((String)units, (String)"deg")) {
            return null;
        }
        trajConfig.setLatVar(var);
        var = ncd.getRootGroup().findVariable(lonVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals(dimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible((String)units, (String)"deg")) {
            return null;
        }
        trajConfig.setLonVar(var);
        var = ncd.getRootGroup().findVariable(elevVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals(dimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible((String)units, (String)"km")) {
            return null;
        }
        trajConfig.setElevVar(var);
        trajConfig.setTrajectoryId(trajId);
        return trajConfig;
    }

    @Override
    public Date getStartDate() {
        Calendar cal = Calendar.getInstance();
        double timeValue = this.localNCD.findGlobalAttribute("start_time").getNumericValue().doubleValue();
        cal.setTimeInMillis((long)timeValue * 1000L);
        Date dd = this.getTime(this.localNCD);
        return dd;
    }

    @Override
    public Date getEndDate() {
        Calendar cal = Calendar.getInstance();
        double timeValue = this.localNCD.findGlobalAttribute("stop_time").getNumericValue().doubleValue() - this.localNCD.findGlobalAttribute("start_time").getNumericValue().doubleValue();
        Date dd = this.getTime(this.localNCD);
        long dl = dd.getTime() + (long)timeValue;
        cal.setTimeInMillis(dl);
        return cal.getTime();
    }

    Date getTime(NetcdfDataset ds) {
        int year = ds.readAttributeInteger(null, "year", 0);
        int month = ds.readAttributeInteger(null, "month", 0);
        int dayOfMonth = ds.readAttributeInteger(null, "day", 0);
        int hourOfDay = ds.readAttributeInteger(null, "hour", 0);
        int minute = ds.readAttributeInteger(null, "minute", 0);
        int second = ds.readAttributeInteger(null, "second", 0);
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(year, month - 1, dayOfMonth, hourOfDay, minute, second);
        return cal.getTime();
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return COSMICTrajectoryObsDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new COSMICTrajectoryObsDataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.TRAJECTORY;
    }

    public COSMICTrajectoryObsDataset() {
    }

    public COSMICTrajectoryObsDataset(NetcdfDataset ncd) throws IOException {
        super(ncd);
        this.localNCD = ncd;
        TrajectoryObsDatasetImpl.Config trajConfig = COSMICTrajectoryObsDataset.buildConfig(ncd);
        this.setTrajectoryInfo(trajConfig);
    }
}

