/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonRect;

public abstract class TypedDatasetImpl
implements TypedDataset {
    protected NetcdfDataset netcdfDataset;
    protected String title;
    protected String desc;
    protected String location;
    protected Date startDate;
    protected Date endDate;
    protected LatLonRect boundingBox;
    protected List<VariableSimpleIF> dataVariables = new ArrayList<VariableSimpleIF>();
    protected StringBuffer parseInfo = new StringBuffer();

    public TypedDatasetImpl() {
    }

    public TypedDatasetImpl(String title, String description, String location) {
        this.title = title;
        this.desc = description;
        this.location = location;
    }

    public TypedDatasetImpl(NetcdfDataset netcdfDataset) {
        this.netcdfDataset = netcdfDataset;
        this.location = netcdfDataset.getLocation();
        this.title = netcdfDataset.getTitle();
        if (this.title == null) {
            this.title = netcdfDataset.findAttValueIgnoreCase(null, "title", null);
        }
        if (this.desc == null) {
            this.desc = netcdfDataset.findAttValueIgnoreCase(null, "description", null);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setLocationURI(String location) {
        this.location = location;
    }

    protected abstract void setStartDate();

    protected abstract void setEndDate();

    protected abstract void setBoundingBox();

    protected void removeDataVariable(String varName) {
        Iterator<VariableSimpleIF> iter = this.dataVariables.iterator();
        while (iter.hasNext()) {
            VariableSimpleIF v = iter.next();
            if (!v.getShortName().equals(varName)) continue;
            iter.remove();
        }
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.netcdfDataset;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getLocationURI() {
        return this.location;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        if (this.netcdfDataset == null) {
            return new ArrayList<Attribute>();
        }
        return this.netcdfDataset.getGlobalAttributes();
    }

    @Override
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        if (this.netcdfDataset == null) {
            return null;
        }
        return this.netcdfDataset.findGlobalAttributeIgnoreCase(name);
    }

    @Override
    public void close() throws IOException {
        if (this.netcdfDataset != null) {
            this.netcdfDataset.close();
        }
    }

    @Override
    public String getDetailInfo() {
        DateFormatter formatter = new DateFormatter();
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("  location= ").append(this.getLocation()).append("\n");
        sbuff.append("  title= ").append(this.getTitle()).append("\n");
        sbuff.append("  desc= ").append(this.getDescription()).append("\n");
        sbuff.append("  start= ").append(formatter.toDateTimeString(this.getStartDate())).append("\n");
        sbuff.append("  end  = ").append(formatter.toDateTimeString(this.getEndDate())).append("\n");
        sbuff.append("  bb   = ").append(this.getBoundingBox()).append("\n");
        if (this.getBoundingBox() != null) {
            sbuff.append("  bb   = ").append(this.getBoundingBox().toString2()).append("\n");
        }
        sbuff.append("  has netcdf = ").append(this.getNetcdfFile() != null).append("\n");
        List<Attribute> ga = this.getGlobalAttributes();
        if (ga.size() > 0) {
            sbuff.append("  Attributes\n");
            for (Attribute a : ga) {
                sbuff.append("    ").append(a).append("\n");
            }
        }
        List<VariableSimpleIF> vars = this.getDataVariables();
        sbuff.append("  Variables (").append(vars.size()).append(")\n");
        for (VariableSimpleIF v : vars) {
            sbuff.append("    name='").append(v.getShortName()).append("' desc='").append(v.getDescription()).append("' units='").append(v.getUnitsString()).append("' type=").append(v.getDataType()).append("\n");
        }
        sbuff.append("\nparseInfo=\n");
        sbuff.append(this.parseInfo);
        sbuff.append("\n");
        return sbuff.toString();
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public LatLonRect getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public List<VariableSimpleIF> getDataVariables() {
        return this.dataVariables;
    }

    @Override
    public VariableSimpleIF getDataVariable(String shortName) {
        for (VariableSimpleIF s : this.dataVariables) {
            String ss = s.getShortName();
            if (!shortName.equals(ss)) continue;
            return s;
        }
        return null;
    }
}

