/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.PointObsDatasetImpl;
import ucar.nc2.dt.point.RecordDatasetHelper;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonRect;

public class OldUnidataPointObsDataset
extends PointObsDatasetImpl
implements TypedDatasetFactoryIF {
    private static String latName = "lat";
    private static String lonName = "lon";
    private static String altName = "Depth";
    private static String timeName = "timeObs";
    private RecordDatasetHelper recordHelper;
    private ArrayList records;

    public static boolean isValidFile(NetcdfFile ds) {
        if (!ds.hasUnlimitedDimension()) {
            return false;
        }
        if (ds.findVariable(latName) == null) {
            return false;
        }
        if (ds.findVariable(lonName) == null) {
            return false;
        }
        if (ds.findVariable(altName) == null) {
            return false;
        }
        return ds.findVariable(timeName) != null;
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return OldUnidataPointObsDataset.isValidFile((NetcdfFile)ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new OldUnidataPointObsDataset(ncd);
    }

    public OldUnidataPointObsDataset() {
    }

    public OldUnidataPointObsDataset(NetcdfDataset ds) throws IOException {
        super(ds);
        this.recordHelper = new RecordDatasetHelper(ds, timeName, timeName, this.dataVariables);
        this.recordHelper.setLocationInfo(latName, lonName, altName);
        this.records = this.recordHelper.readAllCreateObs(null);
        this.removeDataVariable(timeName);
        this.removeDataVariable(latName);
        this.removeDataVariable(lonName);
        this.removeDataVariable(altName);
        this.setTimeUnits();
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
    }

    @Override
    protected void setTimeUnits() {
        this.timeUnit = this.recordHelper.timeUnit;
    }

    @Override
    protected void setStartDate() {
        this.startDate = this.timeUnit.makeDate(this.recordHelper.minDate);
    }

    @Override
    protected void setEndDate() {
        this.endDate = this.timeUnit.makeDate(this.recordHelper.maxDate);
    }

    @Override
    protected void setBoundingBox() {
        this.boundingBox = this.recordHelper.boundingBox;
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        return this.records;
    }

    @Override
    public int getDataCount() {
        return this.records.size();
    }

    @Override
    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return this.recordHelper.getData(this.records, boundingBox, cancel);
    }

    @Override
    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.recordHelper.getData(this.records, boundingBox, startTime, endTime, cancel);
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new PointDatatypeIterator((Structure)this.recordHelper.recordVar, bufferSize);
    }

    private class PointDatatypeIterator
    extends DatatypeIterator {
        @Override
        protected Object makeDatatypeWithData(int recnum, StructureData sdata) {
            RecordDatasetHelper recordDatasetHelper = OldUnidataPointObsDataset.this.recordHelper;
            recordDatasetHelper.getClass();
            return new RecordDatasetHelper.RecordPointObs(recordDatasetHelper, recnum, sdata);
        }

        PointDatatypeIterator(Structure struct, int bufferSize) {
            super(struct, bufferSize);
        }
    }
}

