/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.trajectory.SingleTrajectoryObsDataset;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class RafTrajectoryObsDataset
extends SingleTrajectoryObsDataset
implements TypedDatasetFactoryIF {
    private String timeDimName;
    private String timeVarName;
    private String latVarName;
    private String lonVarName;
    private String elevVarName;

    public static boolean isValidFile(NetcdfDataset ds) {
        Attribute conventionsAtt = ds.findGlobalAttribute("Conventions");
        if (conventionsAtt == null) {
            conventionsAtt = ds.findGlobalAttributeIgnoreCase("Conventions");
        }
        if (conventionsAtt == null) {
            return false;
        }
        if (!conventionsAtt.isString()) {
            return false;
        }
        if (!conventionsAtt.getStringValue().equals("NCAR-RAF/nimbus")) {
            return false;
        }
        Attribute versionAtt = ds.findGlobalAttributeIgnoreCase("Version");
        if (versionAtt == null) {
            versionAtt = new Attribute("Version", "1.3");
            ds.addAttribute(null, versionAtt);
            ds.finish();
            return true;
        }
        if (!versionAtt.isString()) {
            return false;
        }
        if (versionAtt.getStringValue().equals("1.2")) {
            return true;
        }
        return versionAtt.getStringValue().equals("1.3");
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return RafTrajectoryObsDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new RafTrajectoryObsDataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.TRAJECTORY;
    }

    public RafTrajectoryObsDataset() {
    }

    public RafTrajectoryObsDataset(NetcdfDataset ncf) throws IOException {
        super(ncf);
        Attribute conventionsAtt = ncf.findGlobalAttribute("Conventions");
        if (conventionsAtt == null) {
            conventionsAtt = ncf.findGlobalAttributeIgnoreCase("Conventions");
        }
        if (conventionsAtt == null) {
            throw new IllegalArgumentException("File <" + ncf.getId() + "> not a \"NCAR-RAF/nimbus\" convention file.");
        }
        if (!conventionsAtt.getStringValue().equals("NCAR-RAF/nimbus")) {
            throw new IllegalArgumentException("File <" + ncf.getId() + "> not a \"NCAR-RAF/nimbus\" convention file.");
        }
        Attribute versionAtt = ncf.findGlobalAttributeIgnoreCase("Version");
        if (versionAtt.getStringValue().equals("1.2")) {
            Date baseTimeDate;
            this.timeDimName = "Time";
            this.timeVarName = "time_offset";
            this.latVarName = "LAT";
            this.lonVarName = "LON";
            this.elevVarName = "ALT";
            String baseTimeVarName = "base_time";
            Variable baseTimeVar = this.netcdfDataset.findVariable(baseTimeVarName);
            int baseTime = baseTimeVar.readScalarInt();
            if (baseTime != 0) {
                String baseTimeString = baseTime + " seconds since 1970-01-01T00:00:00";
                baseTimeDate = DateUnit.getStandardDate((String)baseTimeString);
            } else {
                Array tmpTimeArray;
                Array secondArray;
                Array minuteArray;
                Array hourArray;
                Array dayArray;
                Array monthArray;
                Array yearArray;
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
                try {
                    yearArray = ncf.findVariable("YEAR").read("0");
                    monthArray = ncf.findVariable("MONTH").read("0");
                    dayArray = ncf.findVariable("DAY").read("0");
                    hourArray = ncf.findVariable("HOUR").read("0");
                    minuteArray = ncf.findVariable("MINUTE").read("0");
                    secondArray = ncf.findVariable("SECOND").read("0");
                    tmpTimeArray = ncf.findVariable(this.timeVarName).read("0");
                }
                catch (InvalidRangeException e) {
                    throw new IOException("Failed while reading first value of YEAR, MONTH, DAY, HOUR, MINUTE, SECOND, or time_offset: " + e.getMessage());
                }
                calendar.clear();
                calendar.set(1, (int)yearArray.getFloat(yearArray.getIndex()));
                calendar.set(2, (int)monthArray.getFloat(monthArray.getIndex()));
                calendar.set(5, (int)dayArray.getFloat(dayArray.getIndex()));
                calendar.set(11, (int)hourArray.getFloat(hourArray.getIndex()));
                calendar.set(12, (int)minuteArray.getFloat(minuteArray.getIndex()));
                calendar.set(13, (int)secondArray.getFloat(secondArray.getIndex()));
                calendar.set(14, 0);
                calendar.add(13, -((int)tmpTimeArray.getFloat(tmpTimeArray.getIndex())));
                baseTimeDate = calendar.getTime();
            }
            DateFormatter formatter = new DateFormatter();
            String timeUnitsString = "seconds since " + formatter.toDateTimeStringISO(baseTimeDate);
            this.netcdfDataset.findVariable(this.timeVarName).addAttribute(new Attribute("units", timeUnitsString));
            String elevVarUnitsString = this.netcdfDataset.findVariable(this.elevVarName).findAttribute("units").getStringValue();
            if (!SimpleUnit.isCompatible((String)elevVarUnitsString, (String)"meters") && elevVarUnitsString.equals("M")) {
                this.netcdfDataset.findVariable(this.elevVarName).addAttribute(new Attribute("units", "meters"));
            }
        } else if (versionAtt.getStringValue().equals("1.3")) {
            String varUnitsString;
            String coordsAttribValue;
            this.timeDimName = "Time";
            this.timeVarName = "Time";
            this.latVarName = "LAT";
            this.lonVarName = "LON";
            this.elevVarName = "ALT";
            Attribute coordsAttrib = this.netcdfDataset.findGlobalAttribute("coordinates");
            if (coordsAttrib != null && (coordsAttribValue = coordsAttrib.getStringValue()) != null) {
                String[] varNames = coordsAttribValue.split(" ");
                this.latVarName = varNames[1];
                this.lonVarName = varNames[0];
                this.elevVarName = varNames[2];
                this.timeDimName = this.timeVarName = varNames[3];
            }
            if (this.timeVarAllZeros()) {
                this.timeVarName = "time_offset";
            }
            if (!SimpleUnit.isCompatible((String)(varUnitsString = this.netcdfDataset.findVariable(this.latVarName).findAttributeIgnoreCase("units").getStringValue()), (String)"degrees_north")) {
                throw new IllegalStateException("Latitude variable <" + this.latVarName + "> units not udunits compatible w/ \"degrees_north\".");
            }
            varUnitsString = this.netcdfDataset.findVariable(this.lonVarName).findAttributeIgnoreCase("units").getStringValue();
            if (!SimpleUnit.isCompatible((String)varUnitsString, (String)"degrees_east")) {
                throw new IllegalStateException("Longitude variable <" + this.lonVarName + "> units not udunits compatible w/ \"degrees_east\".");
            }
            varUnitsString = this.netcdfDataset.findVariable(this.elevVarName).findAttributeIgnoreCase("units").getStringValue();
            if (!SimpleUnit.isCompatible((String)varUnitsString, (String)"meters")) {
                throw new IllegalStateException("Elevation variable <" + this.elevVarName + "> units not udunits compatible w/ \"m\".");
            }
            String timeUnitsString = this.netcdfDataset.findVariable(this.timeVarName).findAttributeIgnoreCase("units").getStringValue();
            if (!SimpleUnit.isCompatible((String)timeUnitsString, (String)"seconds since 1970-01-01 00:00:00")) {
                throw new IllegalStateException("Time variable units <" + timeUnitsString + "> not udunits compatible w/ \"seconds since 1970-01-01 00:00:00\".");
            }
        } else {
            throw new IllegalArgumentException("File <" + ncf.getId() + "> not a version 1.2 or 1.3 \"NCAR-RAF/nimbus\" convention file.");
        }
        SingleTrajectoryObsDataset.Config trajConfig = new SingleTrajectoryObsDataset.Config("1Hz data", ncf.getRootGroup().findDimension(this.timeDimName), ncf.getRootGroup().findVariable(this.timeVarName), ncf.getRootGroup().findVariable(this.latVarName), ncf.getRootGroup().findVariable(this.lonVarName), ncf.getRootGroup().findVariable(this.elevVarName));
        this.setTrajectoryInfo(trajConfig);
    }

    private boolean timeVarAllZeros() throws IOException {
        Variable curTimeVar = this.netcdfDataset.getRootGroup().findVariable(this.timeVarName);
        ArrayList<Range> section = new ArrayList<Range>(1);
        Array a = null;
        try {
            section.add(new Range(0, 2));
            a = curTimeVar.read(section);
        }
        catch (InvalidRangeException e) {
            throw new IOException("Invalid range (0,2): " + e.getMessage());
        }
        IndexIterator it = a.getIndexIterator();
        while (it.hasNext()) {
            if (it.getDoubleNext() == 0.0) continue;
            return false;
        }
        return true;
    }
}

