/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ucar.nc2.util.IO;

public class XMLEntityResolver
implements EntityResolver {
    private static final Logger logger = LoggerFactory.getLogger(XMLEntityResolver.class);
    private static Map<String, String> entityHash = new HashMap<String, String>();
    public static final String CATALOG_NAMESPACE_10 = "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0";
    public static final String DQC_NAMESPACE_04 = "http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.4";
    public static final String NJ22_NAMESPACE = "http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2";
    public static final Namespace ncmlNS = Namespace.getNamespace((String)"xlink", (String)"http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
    public static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    public static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    public static final Namespace xsiNS = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static boolean hasXerces;
    private static String externalSchemas;
    private SAXBuilder saxBuilder;
    private StringBuilder warnMessages = new StringBuilder();
    private StringBuilder errMessages = new StringBuilder();
    private StringBuilder fatalMessages = new StringBuilder();

    public static String getExternalSchemas() {
        if (externalSchemas == null) {
            externalSchemas = "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0 http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.1.0.7.xsd http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2 http://www.unidata.ucar.edu/schemas/netcdf/ncml-2.2.xsd http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.4 http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.4.xsd ";
        }
        return externalSchemas;
    }

    public static void initEntity(String entityName, String resourceName, String urlName) {
        String entity = null;
        try (InputStream is = IO.getFileResource((String)resourceName);){
            ByteArrayOutputStream sbuff = new ByteArrayOutputStream(3000);
            if (is != null) {
                IO.copy((InputStream)is, (OutputStream)sbuff);
                entity = new String(sbuff.toByteArray(), StandardCharsets.UTF_8);
                logger.debug(" *** entity " + entityName + " mapped to local resource at " + resourceName);
            } else if (urlName != null) {
                entity = IO.readURLcontentsWithException((String)urlName);
                logger.debug(" *** entity " + entityName + " mapped to remote URL at " + urlName);
            }
        }
        catch (IOException e) {
            System.out.println(" *** FAILED to map entity " + entityName + " locally at " + resourceName + " or remotely at " + urlName);
        }
        entityHash.put(entityName, entity);
        entityHash.put(urlName, entity);
    }

    public static String getDocumentBuilderFactoryVersion() {
        try {
            Class<?> version = Class.forName("org.apache.xerces.impl.Version");
            Method m = version.getMethod("getVersion", null);
            return (String)m.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            return "Error= " + e.getMessage();
        }
    }

    private static void showFactoryInfo(DocumentBuilderFactory factory) {
        System.out.println("------------------------");
        System.out.println("DocumentBuilderFactory class= " + factory.getClass().getName());
        try {
            Class<?> version = Class.forName("org.apache.xerces.impl.Version");
            Method m = version.getMethod("getVersion", null);
            System.out.println(" org.apache.xerces.impl.Version.version()=" + m.invoke(null, (Object[])null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
        System.out.println(" factory.isValidating()=" + factory.isValidating());
        System.out.println(" factory.isNamespaceAware()=" + factory.isNamespaceAware());
        System.out.println(" factory.isIgnoringElementContentWhitespace()=" + factory.isIgnoringElementContentWhitespace());
        System.out.println(" factory.isExpandEntityReferences()=" + factory.isExpandEntityReferences());
        System.out.println(" factory.isIgnoringComments()=" + factory.isIgnoringComments());
        System.out.println(" factory.isCoalescing()=" + factory.isCoalescing());
    }

    private static void showBuilderInfo(DocumentBuilder builder) {
        System.out.println("-----------------------");
        System.out.println(" builder.isValidating()=" + builder.isValidating());
        System.out.println(" builder.isNamespaceAware()=" + builder.isNamespaceAware());
        System.out.println("DocumentBuilder class= " + builder.getClass().getName());
    }

    public XMLEntityResolver(boolean validate) {
        this.saxBuilder = hasXerces ? new SAXBuilder(validate) : new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        this.saxBuilder.setErrorHandler((ErrorHandler)new MyErrorHandler());
        if (validate) {
            this.saxBuilder.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.saxBuilder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)XMLEntityResolver.getExternalSchemas());
        }
        this.saxBuilder.setEntityResolver((EntityResolver)this);
        this.saxBuilder.setExpandEntities(false);
    }

    public SAXBuilder getSAXBuilder() {
        return this.saxBuilder;
    }

    public StringBuilder getWarningMessages() {
        return this.warnMessages;
    }

    public StringBuilder getErrorMessages() {
        return this.errMessages;
    }

    public StringBuilder getFatalMessages() {
        return this.fatalMessages;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        logger.debug("  publicId=" + publicId + " systemId=" + systemId);
        String entity = entityHash.get(systemId);
        if (entity != null) {
            logger.debug(" *** resolved  with local copy");
            return new MyInputSource(entity);
        }
        if (systemId.contains("InvCatalog.0.6.dtd") && (entity = entityHash.get("http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.0.6.dtd")) != null) {
            logger.debug(" *** resolved2 with local copy");
            return new MyInputSource(entity);
        }
        logger.debug(" *** not resolved");
        return null;
    }

    static {
        XMLEntityResolver.initEntity(CATALOG_NAMESPACE_10, "/resources/thredds/schemas/InvCatalog.1.2.xsd", "http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.1.2.xsd");
        XMLEntityResolver.initEntity(DQC_NAMESPACE_04, "/resources/thredds/schemas/queryCapability.0.4.xsd", "http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.4.xsd");
        XMLEntityResolver.initEntity(NJ22_NAMESPACE, "/resources/nj22/schemas/ncml-2.2.xsd", "http://www.unidata.ucar.edu/schemas/netcdf/ncml-2.2.xsd");
        XMLEntityResolver.initEntity(XLINK_NAMESPACE, "/resources/thredds/schemas/xlink.xsd", "http://www.unidata.ucar.edu/schemas/other/xlink.xsd");
        hasXerces = true;
    }

    private static class MyInputSource
    extends InputSource {
        MyInputSource(String entity) {
            this.setCharacterStream(new StringReader(entity));
        }
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            XMLEntityResolver.this.warnMessages.append("*** XML parser warning ").append(this.showError(e)).append("\n");
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            XMLEntityResolver.this.errMessages.append("*** XML parser error ").append(this.showError(e)).append("\n");
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            XMLEntityResolver.this.fatalMessages.append("*** XML parser fatalError ").append(this.showError(e)).append("\n");
        }

        private String showError(SAXParseException e) {
            return "(" + e.getLineNumber() + ":" + e.getColumnNumber() + ")= " + e.getMessage();
        }
    }
}

