/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import thredds.catalog.InvAccess;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.point.MadisStationObsDataset;
import ucar.nc2.dt.point.NdbcDataset;
import ucar.nc2.dt.point.OldUnidataPointObsDataset;
import ucar.nc2.dt.point.OldUnidataStationObsDataset;
import ucar.nc2.dt.point.UnidataPointObsDataset;
import ucar.nc2.dt.point.UnidataStationObsDataset;
import ucar.nc2.dt.point.UnidataStationObsDataset2;
import ucar.nc2.util.CancelTask;

public class PointObsDatasetFactory {
    public static PointObsDataset open(InvAccess access, StringBuffer logMessages) throws IOException {
        return PointObsDatasetFactory.open(access, null, logMessages);
    }

    public static PointObsDataset open(InvAccess access, CancelTask task, StringBuffer logMessages) throws IOException {
        return PointObsDatasetFactory.open(access.getStandardUrlName(), task, logMessages);
    }

    public static PointObsDataset open(String location) throws IOException {
        return PointObsDatasetFactory.open(location, null, null);
    }

    public static PointObsDataset open(String location, StringBuffer log) throws IOException {
        return PointObsDatasetFactory.open(location, null, log);
    }

    public static PointObsDataset open(String location, CancelTask task, StringBuffer log) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl((String)location);
        NetcdfDataset ncfile = NetcdfDataset.acquireDataset((DatasetUrl)durl, (boolean)true, (CancelTask)task);
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        if (UnidataStationObsDataset.isValidFile((NetcdfFile)ncfile)) {
            return new UnidataStationObsDataset(ncfile);
        }
        if (UnidataPointObsDataset.isValidFile((NetcdfFile)ncfile)) {
            return new UnidataPointObsDataset(ncfile);
        }
        if (UnidataStationObsDataset2.isValidFile((NetcdfFile)ncfile)) {
            return new UnidataStationObsDataset2(ncfile);
        }
        if (NdbcDataset.isValidFile((NetcdfFile)ncfile)) {
            return new NdbcDataset(ncfile);
        }
        if (MadisStationObsDataset.isValidFile((NetcdfFile)ncfile)) {
            return new MadisStationObsDataset(ncfile);
        }
        if (OldUnidataStationObsDataset.isValidFile((NetcdfFile)ncfile)) {
            return new OldUnidataStationObsDataset(ncfile);
        }
        if (OldUnidataPointObsDataset.isValidFile((NetcdfFile)ncfile)) {
            return new OldUnidataPointObsDataset(ncfile);
        }
        if (null != log) {
            log.append("Cant find a Point/Station adapter for ").append(location);
        }
        ncfile.close();
        return null;
    }
}

