/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Durability;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class EnvironmentMutableConfig
implements Cloneable {
    private boolean txnNoSync = false;
    private boolean txnWriteNoSync = false;
    protected long cacheSize;
    protected Properties props;
    private boolean loadPropertyFile = true;
    boolean validateParams = true;
    private ExceptionListener exceptionListener = null;

    public EnvironmentMutableConfig() {
        this.props = new Properties();
    }

    EnvironmentMutableConfig(Properties properties) throws IllegalArgumentException {
        DbConfigManager.validateProperties(properties, false, this.getClass().getName());
        this.props = new Properties();
        this.props.putAll((Map<?, ?>)properties);
    }

    public void setTxnNoSync(boolean noSync) {
        TransactionConfig.checkMixedMode(false, noSync, this.txnWriteNoSync, this.getDurability());
        this.txnNoSync = noSync;
    }

    public boolean getTxnNoSync() {
        return this.txnNoSync;
    }

    public void setTxnWriteNoSync(boolean writeNoSync) {
        TransactionConfig.checkMixedMode(false, this.txnNoSync, writeNoSync, this.getDurability());
        this.txnWriteNoSync = writeNoSync;
    }

    public boolean getTxnWriteNoSync() {
        return this.txnWriteNoSync;
    }

    public EnvironmentMutableConfig setDurability(Durability durability) {
        TransactionConfig.checkMixedMode(false, this.txnNoSync, this.txnWriteNoSync, durability);
        if (durability == null) {
            this.props.remove(EnvironmentParams.JE_DURABILITY);
            return this;
        }
        DbConfigManager.setVal(this.props, EnvironmentParams.JE_DURABILITY, durability.toString(), this.validateParams);
        return this;
    }

    public Durability getDurability() {
        String value = DbConfigManager.getVal(this.props, EnvironmentParams.JE_DURABILITY);
        return Durability.parse(value);
    }

    public EnvironmentMutableConfig setCacheSize(long totalBytes) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, EnvironmentParams.MAX_MEMORY, Long.toString(totalBytes), this.validateParams);
        return this;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public EnvironmentMutableConfig setCachePercent(int percent) throws IllegalArgumentException {
        DbConfigManager.setIntVal(this.props, EnvironmentParams.MAX_MEMORY_PERCENT, percent, this.validateParams);
        return this;
    }

    public int getCachePercent() {
        return DbConfigManager.getIntVal(this.props, EnvironmentParams.MAX_MEMORY_PERCENT);
    }

    public EnvironmentMutableConfig setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
        return this;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public EnvironmentMutableConfig setConfigParam(String paramName, String value) throws IllegalArgumentException {
        DbConfigManager.setConfigParam(this.props, paramName, value, true, this.validateParams, false, true);
        return this;
    }

    public String getConfigParam(String paramName) throws IllegalArgumentException {
        return DbConfigManager.getConfigParam(this.props, paramName);
    }

    public boolean isConfigParamSet(String paramName) {
        return this.props.containsKey(paramName);
    }

    void setValidateParams(boolean validateParams) {
        this.validateParams = validateParams;
    }

    void checkImmutablePropsForEquality(Properties handleConfigProps) throws IllegalArgumentException {
        for (String paramName : EnvironmentParams.SUPPORTED_PARAMS.keySet()) {
            ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            assert (param != null);
            if (param.isMutable() || param.isForReplication()) continue;
            String paramVal = this.props.getProperty(paramName);
            String useParamVal = handleConfigProps.getProperty(paramName);
            if (!(paramVal != null ? !paramVal.equals(useParamVal) : useParamVal != null)) continue;
            throw new IllegalArgumentException(paramName + " is set to " + useParamVal + " in the config parameter" + " which is incompatible" + " with the value of " + paramVal + " in the" + " underlying environment");
        }
    }

    protected EnvironmentMutableConfig clone() {
        try {
            EnvironmentMutableConfig copy = (EnvironmentMutableConfig)super.clone();
            copy.props = (Properties)this.props.clone();
            return copy;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    EnvironmentMutableConfig cloneMutableConfig() {
        EnvironmentMutableConfig copy = this.clone();
        copy.clearImmutableProps();
        return copy;
    }

    void copyHandlePropsTo(EnvironmentMutableConfig other) {
        other.txnNoSync = this.txnNoSync;
        other.txnWriteNoSync = this.txnWriteNoSync;
        other.setDurability(this.getDurability());
    }

    void copyMutablePropsTo(EnvironmentMutableConfig toConfig) {
        Properties toProps = toConfig.props;
        Enumeration<?> propNames = this.props.propertyNames();
        while (propNames.hasMoreElements()) {
            String paramName = (String)propNames.nextElement();
            ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            assert (param != null);
            if (!param.isMutable()) continue;
            String newVal = this.props.getProperty(paramName);
            toProps.setProperty(paramName, newVal);
        }
        toConfig.exceptionListener = this.exceptionListener;
    }

    void fillInEnvironmentGeneratedProps(EnvironmentImpl envImpl) {
        this.cacheSize = envImpl.getMemoryBudget().getMaxMemory();
    }

    private void clearImmutableProps() {
        Enumeration<?> propNames = this.props.propertyNames();
        while (propNames.hasMoreElements()) {
            String paramName = (String)propNames.nextElement();
            ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            assert (param != null);
            if (param.isMutable()) continue;
            this.props.remove(paramName);
        }
    }

    Properties getProps() {
        return this.props;
    }

    void setLoadPropertyFile(boolean loadPropertyFile) {
        this.loadPropertyFile = loadPropertyFile;
    }

    boolean getLoadPropertyFile() {
        return this.loadPropertyFile;
    }

    public int getNumExplicitlySetParams() {
        return this.props.size();
    }

    public String toString() {
        return "cacheSize=" + this.cacheSize + "\n" + "txnNoSync=" + this.txnNoSync + "\n" + "txnWriteNoSync=" + this.txnWriteNoSync + "\n" + this.props.toString() + "\n";
    }
}

