/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.nc2.thredds.MetadataExtractor;
import ucar.unidata.util.StringUtil2;

public class InvDatasetFcPoint
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcPoint.class);
    private static final String FC = "fc.cdmr";
    private static final InvService collectionService = new InvService("collectionService", ServiceType.COMPOUND.toString(), "", "", "");
    private static final InvService fileService = new InvService("fileService", ServiceType.COMPOUND.toString(), "", "", "");
    private final FeatureDatasetPoint fd;
    private final Set<FeatureCollectionConfig.PointDatasetType> wantDatasets;

    public InvDatasetFcPoint(InvDatasetImpl parent, String name, String path, FeatureCollectionType fcType, FeatureCollectionConfig config) {
        super(parent, name, path, fcType, config);
        Formatter errlog = new Formatter();
        try {
            this.fd = (FeatureDatasetPoint)CompositeDatasetFactory.factory(name, fcType.getFeatureType(), this.dcm, errlog);
        }
        catch (Exception e) {
            throw new RuntimeException("InvDatasetFcPoint", e);
        }
        this.wantDatasets = config.pointConfig.datasets;
    }

    @Override
    public FeatureDatasetPoint getFeatureDatasetPoint() {
        return this.fd;
    }

    @Override
    public void update(CollectionManager.Force force) {
        ((UpdateableCollection)((Object)this.fd)).update();
    }

    @Override
    public void updateProto() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InvDatasetFeatureCollection.State checkState() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == null) {
                this.firstInit();
            } else if (!this.dcm.scanIfNeeded()) {
                return this.state;
            }
            InvDatasetFeatureCollection.State localState = new InvDatasetFeatureCollection.State(this, this.state);
            this.makeDatasets(localState);
            this.update(CollectionManager.Force.test);
            if (null != this.fd) {
                localState.vars = MetadataExtractor.extractVariables(this.fd);
                localState.gc = MetadataExtractor.extractGeospatial(this.fd);
                localState.dateRange = MetadataExtractor.extractCalendarDateRange(this.fd);
            }
            this.state = localState;
            return this.state;
        }
    }

    @Override
    public InvCatalogImpl makeCatalog(String match, String orgPath, URI catURI) {
        logger.debug("FcPoint make catalog for " + match + " " + catURI);
        InvDatasetFeatureCollection.State localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", e);
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                InvCatalogImpl main = this.makeCatalogTop(catURI, localState);
                main.addService(collectionService);
                main.getDataset().getLocalMetadataInheritable().setServiceName(collectionService.getName());
                main.finish();
                return main;
            }
            if (match.startsWith("files") && this.wantDatasets.contains((Object)FeatureCollectionConfig.PointDatasetType.Files)) {
                return this.makeCatalogFiles(catURI, localState, this.dcm.getFilenames(), true);
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, e);
        }
        return null;
    }

    private void makeDatasets(InvDatasetFeatureCollection.State localState) {
        ArrayList<InvDataset> datasets = new ArrayList<InvDataset>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.PointDatasetType.cdmrFeature)) {
            InvDatasetImpl ds = new InvDatasetImpl(this, "Feature Collection");
            String name = this.getName() + "_" + FC;
            name = StringUtil2.replace(name, ' ', "_");
            ds.setUrlPath(this.path + "/" + name);
            ds.setID(id + "/" + name);
            ThreddsMetadata tm = ds.getLocalMetadata();
            tm.addDocumentation("summary", "Feature Collection. 'Nuff said");
            ds.getLocalMetadataInheritable().setServiceName(collectionService.getName());
            ds.finish();
            datasets.add(ds);
        }
        if (this.wantDatasets.contains((Object)FeatureCollectionConfig.PointDatasetType.Files) && this.topDirectory != null) {
            InvCatalogRef filesCat = new InvCatalogRef(this, "files", this.getCatalogHref("files"));
            filesCat.finish();
            datasets.add(filesCat);
        }
        localState.datasets = datasets;
        this.datasets = datasets;
        this.finish();
    }

    static {
        collectionService.addService(InvService.cdmrfeature);
        fileService.addService(InvService.cdmremote);
        fileService.addService(InvService.fileServer);
        fileService.addService(InvService.opendap);
    }
}

