/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.jni.netcdf.Nc4Chunking;
import ucar.nc2.jni.netcdf.Nc4ChunkingStrategyImpl;
import ucar.nc2.util.DebugFlags;

public class FileWriter2 {
    private static final Logger log = LoggerFactory.getLogger(FileWriter2.class);
    private static final long maxSize = 50000000L;
    private static boolean debug = false;
    private static boolean debugWrite = false;
    private static boolean debugChunk = false;
    private final NetcdfFile fileIn;
    private final NetcdfFileWriter writer;
    private final NetcdfFileWriter.Version version;
    private List<FileWriterProgressListener> progressListeners;
    private final Map<Variable, Variable> varMap = new HashMap<Variable, Variable>();
    private final List<Variable> varList = new ArrayList<Variable>();
    private final Map<String, Dimension> gdimHash = new HashMap<String, Dimension>();
    private Nc4Chunking chunker = new Nc4ChunkingStrategyImpl();

    public static void setDebugFlags(DebugFlags debugFlags) {
        debug = debugFlags.isSet("ncfileWriter2/debug");
        debugWrite = debugFlags.isSet("ncfileWriter2/debugWrite");
        debugChunk = debugFlags.isSet("ncfileWriter2/debugChunk");
    }

    public FileWriter2(NetcdfFile fileIn, String fileOutName, NetcdfFileWriter.Version version, Nc4Chunking chunker) throws IOException {
        this.fileIn = fileIn;
        this.writer = NetcdfFileWriter.createNew(version, fileOutName, chunker);
        this.version = version;
    }

    public void addProgressListener(FileWriterProgressListener listener) {
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList<FileWriterProgressListener>();
        }
        this.progressListeners.add(listener);
    }

    public NetcdfFileWriter getNetcdfFileWriter() {
        return this.writer;
    }

    public FileWriter2(NetcdfFileWriter fileWriter) throws IOException {
        this.fileIn = null;
        this.writer = fileWriter;
        this.version = fileWriter.getVersion();
    }

    public Variable addVariable(Variable oldVar) {
        List<Dimension> newDims = this.getNewDimensions(oldVar);
        Variable newVar = null;
        newVar = oldVar.getDataType().equals((Object)DataType.STRING) && !this.version.isNetdf4format() ? this.writer.addStringVariable(null, oldVar, newDims) : this.writer.addVariable(null, oldVar.getShortName(), oldVar.getDataType(), newDims);
        this.varMap.put(oldVar, newVar);
        this.varList.add(oldVar);
        for (Attribute att : oldVar.getAttributes()) {
            this.writer.addVariableAttribute(newVar, att);
        }
        return newVar;
    }

    private List<Dimension> getNewDimensions(Variable oldVar) {
        ArrayList<Dimension> result = new ArrayList<Dimension>(oldVar.getRank());
        for (Dimension oldD : oldVar.getDimensions()) {
            Dimension newD = this.gdimHash.get(oldD.getShortName());
            if (newD == null) {
                newD = this.writer.addDimension(null, oldD.getShortName(), oldD.isUnlimited() ? 0 : oldD.getLength(), oldD.isShared(), oldD.isUnlimited(), oldD.isVariableLength());
                this.gdimHash.put(oldD.getShortName(), newD);
                if (debug) {
                    System.out.println("add dim= " + newD);
                }
            }
            result.add(newD);
        }
        return result;
    }

    public NetcdfFile write() throws IOException {
        if (this.version.isNetdf4format()) {
            this.addGroup4(null, this.fileIn.getRootGroup());
        } else {
            this.addNetcdf3();
        }
        if (debugWrite) {
            System.out.printf("About to write = %n%s%n", this.writer.getNetcdfFile());
        }
        this.writer.create();
        if (debug) {
            System.out.printf("File Out= %n%s%n", this.writer.getNetcdfFile());
        }
        double total = this.copyVarData(this.varList, null);
        this.writer.flush();
        if (debug) {
            System.out.println("FileWriter done total bytes = " + total);
        }
        return this.writer.getNetcdfFile();
    }

    private void addNetcdf3() throws IOException {
        if (this.fileIn.getRootGroup().getGroups().size() != 0) {
            throw new IllegalStateException("Input file has nested groups: cannot write to netcdf-3 format");
        }
        for (Attribute att : this.fileIn.getGlobalAttributes()) {
            this.writer.addGroupAttribute(null, att);
            if (!debug) continue;
            System.out.println("add gatt= " + att);
        }
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (Dimension oldD : this.fileIn.getDimensions()) {
            Dimension newD = this.writer.addDimension(null, oldD.getShortName(), oldD.isUnlimited() ? 0 : oldD.getLength(), oldD.isShared(), oldD.isUnlimited(), oldD.isVariableLength());
            dimHash.put(oldD.getShortName(), newD);
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        int anonCount = 0;
        for (Variable oldVar : this.fileIn.getVariables()) {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            for (Dimension oldD : oldVar.getDimensions()) {
                if (!oldD.isShared()) {
                    String anonName = "anon" + anonCount;
                    ++anonCount;
                    Dimension newD = this.writer.addDimension(null, anonName, oldD.getLength());
                    dims.add(newD);
                    continue;
                }
                Dimension dim = (Dimension)dimHash.get(oldD.getShortName());
                if (dim != null) {
                    dims.add(dim);
                    continue;
                }
                throw new IllegalStateException("Unknown dimension= " + oldD.getShortName());
            }
            DataType newType = oldVar.getDataType();
            if (oldVar.getDataType() == DataType.STRING) {
                Array data = oldVar.read();
                IndexIterator ii = data.getIndexIterator();
                int max_len = 0;
                while (ii.hasNext()) {
                    String s = (String)ii.getObjectNext();
                    max_len = Math.max(max_len, s.length());
                }
                String useName = oldVar.getShortName() + "_strlen";
                Dimension newD = this.writer.addDimension(null, useName, max_len);
                dims.add(newD);
                newType = DataType.CHAR;
            }
            Variable v = this.writer.addVariable(null, oldVar.getShortName(), newType, dims);
            if (debug) {
                System.out.println("add var= " + v.getNameAndDimensions());
            }
            this.varMap.put(oldVar, v);
            this.varList.add(oldVar);
            for (Attribute att : oldVar.getAttributes()) {
                this.writer.addVariableAttribute(v, att);
            }
        }
    }

    private void addGroup4(Group newParent, Group oldGroup) throws IOException {
        Group newGroup = this.writer.addGroup(newParent, oldGroup.getShortName());
        for (Attribute att : oldGroup.getAttributes()) {
            this.writer.addGroupAttribute(newGroup, att);
            if (!debug) continue;
            System.out.println("add gatt= " + att);
        }
        for (EnumTypedef td : oldGroup.getEnumTypedefs()) {
            this.writer.addTypedef(newGroup, td);
            if (!debug) continue;
            System.out.println("add td= " + td);
        }
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (Dimension oldD : oldGroup.getDimensions()) {
            Dimension newD = this.writer.addDimension(newGroup, oldD.getShortName(), oldD.isUnlimited() ? 0 : oldD.getLength(), oldD.isShared(), oldD.isUnlimited(), oldD.isVariableLength());
            dimHash.put(oldD.getShortName(), newD);
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        for (Variable oldVar : oldGroup.getVariables()) {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            for (Dimension oldD : oldVar.getDimensions()) {
                Dimension newD;
                Dimension dimension = newD = oldD.isShared() ? (Dimension)dimHash.get(oldD.getShortName()) : oldD;
                if (newD == null) {
                    newD = newParent.findDimension(oldD.getShortName());
                }
                if (newD == null) {
                    throw new IllegalStateException("Cant find dimension " + oldD.getShortName());
                }
                dims.add(newD);
            }
            DataType newType = oldVar.getDataType();
            Variable v = this.writer.addVariable(newGroup, oldVar.getShortName(), newType, dims);
            this.varMap.put(oldVar, v);
            this.varList.add(oldVar);
            if (debug) {
                System.out.println("add var= " + v);
            }
            if (this.chunker.isChunked(oldVar)) {
                long[] chunk = this.chunker.computeChunking(oldVar);
                if (debugChunk) {
                    System.out.printf("%s is Chunked = (", v.getFullName());
                    for (long c : chunk) {
                        System.out.printf("%d,", c);
                    }
                    System.out.printf(")%n", new Object[0]);
                }
            } else if (debugChunk) {
                System.out.printf("%s is not Chunked, size = %d bytes%n", v.getFullName(), v.getSize() * (long)v.getElementSize());
            }
            for (Attribute att : oldVar.getAttributes()) {
                this.writer.addVariableAttribute(v, att);
            }
        }
        for (Group nested : oldGroup.getGroups()) {
            this.addGroup4(newGroup, nested);
        }
    }

    public double copyVarData(List<Variable> varlist, Structure recordVar) throws IOException {
        boolean useRecordDimension = recordVar != null;
        double total = 0.0;
        for (Variable oldVar : varlist) {
            if (useRecordDimension && oldVar.isUnlimited() || oldVar == recordVar) continue;
            if (debug) {
                System.out.println("write var= " + oldVar.getShortName() + " size = " + oldVar.getSize() + " type=" + (Object)((Object)oldVar.getDataType()));
            }
            long size = oldVar.getSize() * (long)oldVar.getElementSize();
            total += (double)size;
            if (size <= 50000000L) {
                this.copyAll(oldVar, this.varMap.get(oldVar));
                continue;
            }
            this.copySome(oldVar, this.varMap.get(oldVar), 50000000L);
        }
        if (useRecordDimension) {
            int[] origin = new int[]{0};
            int[] size = new int[]{1};
            int nrecs = (int)recordVar.getSize();
            int sdataSize = recordVar.getElementSize();
            Variable recordVarNew = this.varMap.get(recordVar);
            double totalRecordBytes = 0.0;
            for (int count = 0; count < nrecs; ++count) {
                block8: {
                    origin[0] = count;
                    try {
                        Array recordData = recordVar.read(origin, size);
                        this.writer.write(recordVarNew, origin, recordData);
                        if (!debug || count != 0) break block8;
                        System.out.println("write record size = " + sdataSize);
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                totalRecordBytes += (double)sdataSize;
            }
            total += totalRecordBytes;
            totalRecordBytes /= 1000000.0;
            if (debug) {
                System.out.println("write record var; total = " + totalRecordBytes + " Mbytes # recs=" + nrecs);
            }
        }
        return total;
    }

    private void copyAll(Variable oldVar, Variable newVar) throws IOException {
        Array data = oldVar.read();
        try {
            if (!this.version.isNetdf4format() && oldVar.getDataType() == DataType.STRING) {
                data = this.convertToChar(newVar, data);
            }
            if (data.getSize() > 0L) {
                this.writer.write(newVar, data);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage() + " for Variable " + oldVar.getFullName());
        }
    }

    private void copySome(Variable oldVar, Variable newVar, long maxChunkSize) throws IOException {
        long maxChunkElems = maxChunkSize / (long)oldVar.getElementSize();
        long byteWriteTotal = 0L;
        FileWriterProgressEvent writeProgressEvent = new FileWriterProgressEvent();
        writeProgressEvent.setStatus("Variable: " + oldVar.getShortName());
        if (this.progressListeners != null) {
            for (FileWriterProgressListener listener : this.progressListeners) {
                listener.writeStatus(writeProgressEvent);
            }
        }
        ChunkingIndex index = new ChunkingIndex(oldVar.getShape());
        while ((long)index.currentElement() < index.getSize()) {
            try {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                writeProgressEvent.setWriteStatus("Reading chunk from variable: " + oldVar.getShortName());
                if (this.progressListeners != null) {
                    for (FileWriterProgressListener listener : this.progressListeners) {
                        listener.writeProgress(writeProgressEvent);
                    }
                }
                Array data = oldVar.read(chunkOrigin, chunkShape);
                if (!this.version.isNetdf4format() && oldVar.getDataType() == DataType.STRING) {
                    data = this.convertToChar(newVar, data);
                }
                if (data.getSize() > 0L) {
                    writeProgressEvent.setWriteStatus("Writing chunk of variable: " + oldVar.getShortName());
                    writeProgressEvent.setBytesToWrite(data.getSize());
                    if (this.progressListeners != null) {
                        for (FileWriterProgressListener listener : this.progressListeners) {
                            listener.writeProgress(writeProgressEvent);
                        }
                    }
                    this.writer.write(newVar, chunkOrigin, data);
                    if (debugWrite) {
                        System.out.println(" write " + data.getSize() + " bytes at " + new Section(chunkOrigin, chunkShape));
                    }
                    writeProgressEvent.setBytesWritten(byteWriteTotal += data.getSize());
                    writeProgressEvent.setProgressPercent(100.0 * (double)byteWriteTotal / (double)oldVar.getSize());
                    if (this.progressListeners != null) {
                        for (FileWriterProgressListener listener : this.progressListeners) {
                            listener.writeProgress(writeProgressEvent);
                        }
                    }
                }
                index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    private Array convertToChar(Variable newVar, Array oldData) {
        ArrayChar newData = (ArrayChar)Array.factory(DataType.CHAR, newVar.getShape());
        Index ima = newData.getIndex();
        IndexIterator ii = oldData.getIndexIterator();
        while (ii.hasNext()) {
            String s = (String)ii.getObjectNext();
            int[] c = ii.getCurrentCounter();
            for (int i = 0; i < c.length; ++i) {
                ima.setDim(i, c[i]);
            }
            newData.setString(ima, s);
        }
        return newData;
    }

    private boolean hasRecordStructure(NetcdfFile file) {
        Variable v = file.findVariable("record");
        return v != null && v.getDataType() == DataType.STRUCTURE;
    }

    private static void usage() {
        System.out.println("usage: ucar.nc2.FileWriter2 -in <fileIn> -out <fileOut> [-netcdf4]");
    }

    public static void main(String[] arg) throws IOException {
        if (arg.length < 4) {
            FileWriter2.usage();
            System.exit(0);
        }
        String datasetIn = null;
        String datasetOut = null;
        NetcdfFileWriter.Version version = NetcdfFileWriter.Version.netcdf3;
        for (int i = 0; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equalsIgnoreCase("-in")) {
                datasetIn = arg[i + 1];
            }
            if (s.equalsIgnoreCase("-out")) {
                datasetOut = arg[i + 1];
            }
            if (!s.equalsIgnoreCase("-netcdf4")) continue;
            version = NetcdfFileWriter.Version.netcdf4;
        }
        if (datasetIn == null || datasetOut == null) {
            FileWriter2.usage();
            System.exit(0);
        }
        System.out.printf("copy %s to%s%n", datasetIn, datasetOut);
        NetcdfFile ncfileIn = NetcdfFile.open(datasetIn, null);
        FileWriter2 writer2 = new FileWriter2(ncfileIn, datasetOut, version, null);
        NetcdfFile ncfileOut = writer2.write();
        ncfileIn.close();
        ncfileOut.close();
    }

    public static interface FileWriterProgressListener {
        public void writeProgress(FileWriterProgressEvent var1);

        public void writeStatus(FileWriterProgressEvent var1);
    }

    public static class FileWriterProgressEvent {
        private double progressPercent;
        private long bytesWritten;
        private long bytesToWrite;
        private String status;
        private String writeStatus;

        public void setProgressPercent(double progressPercent) {
            this.progressPercent = progressPercent;
        }

        public double getProgressPercent() {
            return this.progressPercent;
        }

        public void setBytesWritten(long bytesWritten) {
            this.bytesWritten = bytesWritten;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public void setBytesToWrite(long bytesToWrite) {
            this.bytesToWrite = bytesToWrite;
        }

        public long getBytesToWrite() {
            return this.bytesToWrite;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setWriteStatus(String writeStatus) {
            this.writeStatus = writeStatus;
        }

        public String getWriteStatus() {
            return this.writeStatus;
        }
    }

    public static class ChunkingIndex
    extends Index {
        public ChunkingIndex(int[] shape) {
            super(shape);
        }

        public int[] computeChunkShape(long maxChunkElems) {
            int[] chunkShape = new int[this.rank];
            for (int iDim = 0; iDim < this.rank; ++iDim) {
                int size = (int)(maxChunkElems / (long)this.stride[iDim]);
                size = size == 0 ? 1 : size;
                chunkShape[iDim] = size = Math.min(size, this.shape[iDim] - this.current[iDim]);
            }
            return chunkShape;
        }
    }
}

