/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthEllipsoid;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.proj4.LambertConformalConicEllipse;
import ucar.unidata.geoloc.projection.proj4.StereographicAzimuthalProjection;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;
import ucar.unidata.util.GaussianLatitudes;

public abstract class Grib2Gds {
    private static final Logger log = LoggerFactory.getLogger(Grib2Gds.class);
    private static final float scale3 = 0.001f;
    private static final float scale6 = 1.0E-6f;
    protected final byte[] data;
    public int template;
    public float earthRadius;
    public float majorAxis;
    public float minorAxis;
    public int earthShape;
    public int nx;
    public int ny;
    public int scanMode;
    protected int hashCode = 0;

    public static Grib2Gds factory(int template, byte[] data) {
        switch (template) {
            case 0: {
                return new LatLon(data);
            }
            case 1: {
                return new RotatedLatLon(data);
            }
            case 10: {
                return new Mercator(data);
            }
            case 20: {
                return new PolarStereographic(data);
            }
            case 30: {
                return new LambertConformal(data);
            }
            case 40: {
                return new GaussLatLon(data);
            }
            case 90: {
                return new SpaceViewPerspective(data);
            }
            case 204: {
                return new CurvilinearOrthogonal(data);
            }
        }
        throw new UnsupportedOperationException("Unsupported GDS type = " + template);
    }

    public Grib2Gds(byte[] data, int template) {
        this.data = data;
        this.template = template;
        this.earthShape = this.getOctet(15);
        this.earthRadius = this.getScaledValue(16);
        this.majorAxis = this.getScaledValue(21);
        this.minorAxis = this.getScaledValue(26);
        this.nx = this.getOctet4(31);
        this.ny = this.getOctet4(35);
    }

    public byte[] getRawBytes() {
        return this.data;
    }

    protected int getOctet(int index) {
        return this.data[index - 1] & 0xFF;
    }

    protected int getOctetSigned(int index) {
        return GribNumbers.convertSignedByte(this.data[index - 1]);
    }

    protected int getOctet4(int start) {
        return GribNumbers.int4(this.getOctet(start), this.getOctet(start + 1), this.getOctet(start + 2), this.getOctet(start + 3));
    }

    protected float getScaledValue(int start) {
        int scaleFactor = this.getOctetSigned(start);
        int scaleValue = this.getOctet4(start + 1);
        if (scaleFactor != 0) {
            return (float)((double)scaleValue / Math.pow(10.0, scaleFactor));
        }
        return scaleValue;
    }

    public boolean isLatLon() {
        return false;
    }

    public abstract GdsHorizCoordSys makeHorizCoordSys();

    public abstract void testHorizCoordSys(Formatter var1);

    public String getNameShort() {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf("$");
        return className.substring(pos + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib2Gds grib2Gds = (Grib2Gds)o;
        if (this.nx != grib2Gds.nx) {
            return false;
        }
        if (this.ny != grib2Gds.ny) {
            return false;
        }
        return this.template == grib2Gds.template;
    }

    public int hashCode() {
        int result = this.template;
        result = 31 * result + this.nx;
        result = 31 * result + this.ny;
        return result;
    }

    protected Earth getEarth() {
        switch (this.earthShape) {
            case 0: {
                return new Earth(6367470.0);
            }
            case 1: {
                if (this.earthRadius < 6000000.0f) {
                    this.majorAxis = (float)((double)this.majorAxis * 1000.0);
                }
                return new Earth(this.earthRadius);
            }
            case 2: {
                return EarthEllipsoid.IAU;
            }
            case 3: {
                if (this.majorAxis < 6000000.0f) {
                    this.majorAxis = (float)((double)this.majorAxis * 1000.0);
                }
                if (this.minorAxis < 6000000.0f) {
                    this.minorAxis = (float)((double)this.minorAxis * 1000.0);
                }
                return new EarthEllipsoid("Grib2 Type 3", -1, this.majorAxis, this.minorAxis, 0.0);
            }
            case 4: {
                return EarthEllipsoid.IAG_GRS80;
            }
            case 5: {
                return EarthEllipsoid.WGS84;
            }
            case 6: {
                return new Earth(6371229.0);
            }
            case 7: {
                if (this.majorAxis < 6000000.0f) {
                    this.majorAxis = (float)((double)this.majorAxis * 1000.0);
                }
                if (this.minorAxis < 6000000.0f) {
                    this.minorAxis = (float)((double)this.minorAxis * 1000.0);
                }
                return new EarthEllipsoid("Grib2 Type 37", -1, this.majorAxis * 1000.0f, this.minorAxis * 1000.0f, 0.0);
            }
            case 8: {
                return new Earth(6371200.0);
            }
        }
        return new Earth();
    }

    static void check(int a, int b) {
        System.out.printf("%d, %d : ", a, b);
        a = (a + 5) / 10;
        b = (b + 5) / 10;
        System.out.printf("%d, %d = %s%n", a, b, a == b);
    }

    public static void main(String[] args) {
        double lad = 60.0;
        double ladr = Math.toRadians(lad);
        double lads = Math.sin(ladr);
        double scale = (1.0 + Math.sin(Math.toRadians(lad))) / 2.0;
        double scale2 = (1.0 + lads) / 2.0;
        System.out.println("HEY");
    }

    public static class CurvilinearOrthogonal
    extends Grib2Gds {
        public int flags = this.getOctet(55);

        CurvilinearOrthogonal(byte[] data) {
            super(data, 204);
            this.scanMode = this.getOctet(72);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CurvilinearOrthogonal that = (CurvilinearOrthogonal)o;
            return this.flags == that.flags;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                this.hashCode = result = 31 * result + this.flags;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            LatLonProjection proj = new LatLonProjection();
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, 0.0, 1.0, 0.0, 1.0, this.nx, this.ny);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
        }
    }

    public static class SpaceViewPerspective
    extends Grib2Gds {
        public float LaP = (float)this.getOctet4(39) * 1.0E-6f;
        public float LoP = (float)this.getOctet4(43) * 1.0E-6f;
        public float dX;
        public float dY;
        public float Xp;
        public float Yp;
        public float orient;
        public float Nr;
        public float Xo;
        public float Yo;
        public int flags = this.getOctet(47);

        SpaceViewPerspective(byte[] data) {
            super(data, 90);
            this.dX = this.getOctet4(48);
            this.dY = this.getOctet4(52);
            this.Xp = (float)this.getOctet4(56) * 0.001f;
            this.Yp = (float)this.getOctet4(60) * 0.001f;
            this.scanMode = this.getOctet(64);
            this.orient = (float)this.getOctet4(65) * 1.0E-6f;
            this.Nr = (float)this.getOctet4(69) * 1.0E-6f;
            this.Xo = (float)this.getOctet4(73) * 1.0E-6f;
            this.Yo = (float)this.getOctet4(77) * 1.0E-6f;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SpaceViewPerspective that = (SpaceViewPerspective)o;
            if (Float.compare(that.LaP, this.LaP) != 0) {
                return false;
            }
            if (Float.compare(that.LoP, this.LoP) != 0) {
                return false;
            }
            if (Float.compare(that.Nr, this.Nr) != 0) {
                return false;
            }
            if (Float.compare(that.Xo, this.Xo) != 0) {
                return false;
            }
            if (Float.compare(that.Xp, this.Xp) != 0) {
                return false;
            }
            if (Float.compare(that.Yo, this.Yo) != 0) {
                return false;
            }
            if (Float.compare(that.Yp, this.Yp) != 0) {
                return false;
            }
            if (Float.compare(that.dX, this.dX) != 0) {
                return false;
            }
            if (Float.compare(that.dY, this.dY) != 0) {
                return false;
            }
            return this.flags == that.flags;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                result = 31 * result + (this.LaP != 0.0f ? Float.floatToIntBits(this.LaP) : 0);
                result = 31 * result + (this.LoP != 0.0f ? Float.floatToIntBits(this.LoP) : 0);
                result = 31 * result + (this.dX != 0.0f ? Float.floatToIntBits(this.dX) : 0);
                result = 31 * result + (this.dY != 0.0f ? Float.floatToIntBits(this.dY) : 0);
                result = 31 * result + (this.Xp != 0.0f ? Float.floatToIntBits(this.Xp) : 0);
                result = 31 * result + (this.Yp != 0.0f ? Float.floatToIntBits(this.Yp) : 0);
                result = 31 * result + (this.Nr != 0.0f ? Float.floatToIntBits(this.Nr) : 0);
                result = 31 * result + (this.Xo != 0.0f ? Float.floatToIntBits(this.Xo) : 0);
                result = 31 * result + (this.Yo != 0.0f ? Float.floatToIntBits(this.Yo) : 0);
                this.hashCode = result = 31 * result + this.flags;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            double scale_factor;
            if (this.dY < 2100.0f) {
                this.dX = 1207.0f;
                this.dY = 1203.0f;
            } else {
                this.dX = 3622.0f;
                this.dY = 3610.0f;
            }
            double as = 2.0 * Math.asin(1.0 / (double)this.Nr);
            double cfac = (double)this.dX / as;
            double lfac = (double)this.dY / as;
            this.getEarth();
            double scale_x = scale_factor = (double)((this.Nr - 1.0f) * this.majorAxis / 1000.0f);
            double scale_y = -scale_factor;
            double startx = scale_factor * (double)(1.0f - this.Xp) / cfac;
            double starty = scale_factor * (double)(this.Yp - (float)this.ny) / lfac;
            double incrx = scale_factor / cfac;
            double incry = scale_factor / lfac;
            MSGnavigation proj = new MSGnavigation(this.LaP, this.LoP, this.majorAxis, this.minorAxis, this.Nr * this.majorAxis, scale_x, scale_y);
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, startx, incrx, starty, incry, this.nx, this.ny);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            f.format("%s testProjection%n", this.getClass().getName());
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            double endx = cs.startx + (double)(this.nx - 1) * cs.dx;
            double endy = cs.starty + (double)(this.ny - 1) * cs.dy;
            ProjectionPointImpl endPP = new ProjectionPointImpl(endx, endy);
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            LatLonPointImpl startLL = new LatLonPointImpl(this.LaP, this.LoP);
            LatLonPoint endLL = cs.proj.projToLatLon(endPP, new LatLonPointImpl());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
        }
    }

    public static class GaussLatLon
    extends LatLon {
        public int Nparellels;

        GaussLatLon(byte[] data) {
            super(data);
            this.template = 40;
            this.Nparellels = this.getOctet4(68);
            this.deltaLon = (this.lo2 - this.lo1) / (float)(this.nx - 1);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GaussLatLon that = (GaussLatLon)o;
            return this.Nparellels == that.Nparellels;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                this.hashCode = result = 31 * result + this.Nparellels;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            int nlats = 2 * this.Nparellels;
            GaussianLatitudes gaussLats = new GaussianLatitudes(nlats);
            int bestStartIndex = 0;
            int bestEndIndex = 0;
            double bestStartDiff = Double.MAX_VALUE;
            double bestEndDiff = Double.MAX_VALUE;
            for (int i = 0; i < nlats; ++i) {
                double diff = Math.abs(gaussLats.latd[i] - (double)this.la1);
                if (diff < bestStartDiff) {
                    bestStartDiff = diff;
                    bestStartIndex = i;
                }
                if (!((diff = Math.abs(gaussLats.latd[i] - (double)this.la2)) < bestEndDiff)) continue;
                bestEndDiff = diff;
                bestEndIndex = i;
            }
            if (Math.abs(bestEndIndex - bestStartIndex + 1) != this.ny) {
                log.warn("GRIB gaussian lats: NP != NY, use NY");
                nlats = this.ny;
                gaussLats = new GaussianLatitudes(nlats);
                bestStartIndex = 0;
                bestEndIndex = this.ny - 1;
            }
            boolean goesUp = bestEndIndex > bestStartIndex;
            int useIndex = bestStartIndex;
            float[] data = new float[this.ny];
            float[] gaussw = new float[this.ny];
            for (int i = 0; i < this.ny; ++i) {
                data[i] = (float)gaussLats.latd[useIndex];
                gaussw[i] = (float)gaussLats.gaussw[useIndex];
                if (goesUp) {
                    ++useIndex;
                    continue;
                }
                --useIndex;
            }
            GdsHorizCoordSys coordSys = new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, new LatLonProjection(), this.lo1, this.deltaLon, 0.0, 0.0, this.nx, this.ny);
            coordSys.gaussLats = Array.factory(DataType.FLOAT, new int[]{this.ny}, (Object)data);
            coordSys.gaussw = Array.factory(DataType.FLOAT, new int[]{this.ny}, (Object)gaussw);
            return coordSys;
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            f.format("%s testProjection %s%n", this.getClass().getName(), cs.proj.getClass().getName());
        }
    }

    public static class LambertConformal
    extends Grib2Gds {
        public float la1;
        public float lo1;
        public float lov;
        public float lad;
        public float dX;
        public float dY;
        public float latin1;
        public float latin2;
        public float latSouthPole;
        public float lonSouthPole;
        public int flags;
        public int projCenterFlag;
        private int hla1 = LambertConformal.round(this.getOctet4(39));
        private int hlo1 = LambertConformal.round(this.getOctet4(43));
        private int hlov;
        private int hlad = LambertConformal.round(this.getOctet4(48));
        private int hdX;
        private int hdY;
        private int hlatin1;
        private int hlatin2;

        LambertConformal(byte[] data) {
            super(data, 20);
            this.hlov = LambertConformal.round(this.getOctet4(52));
            this.hdX = LambertConformal.round(this.getOctet4(56));
            this.hdY = LambertConformal.round(this.getOctet4(60));
            this.hlatin1 = LambertConformal.round(this.getOctet4(66));
            this.hlatin2 = LambertConformal.round(this.getOctet4(70));
            this.la1 = (float)this.getOctet4(39) * 1.0E-6f;
            this.lo1 = (float)this.getOctet4(43) * 1.0E-6f;
            this.flags = this.getOctet(47);
            this.lad = (float)this.getOctet4(48) * 1.0E-6f;
            this.lov = (float)this.getOctet4(52) * 1.0E-6f;
            this.dX = (float)this.getOctet4(56) * 1.0E-6f;
            this.dY = (float)this.getOctet4(60) * 1.0E-6f;
            this.projCenterFlag = this.getOctet(64);
            this.scanMode = this.getOctet(65);
            this.latin1 = (float)this.getOctet4(66) * 1.0E-6f;
            this.latin2 = (float)this.getOctet4(70) * 1.0E-6f;
            this.latSouthPole = (float)this.getOctet4(74) * 1.0E-6f;
            this.lonSouthPole = (float)this.getOctet4(78) * 1.0E-6f;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambertConformal that = (LambertConformal)o;
            if (this.hdX != that.hdX) {
                return false;
            }
            if (this.hdY != that.hdY) {
                return false;
            }
            if (this.hla1 != that.hla1) {
                return false;
            }
            if (this.hlad != that.hlad) {
                return false;
            }
            if (this.hlatin1 != that.hlatin1) {
                return false;
            }
            if (this.hlatin2 != that.hlatin2) {
                return false;
            }
            if (this.hlo1 != that.hlo1) {
                return false;
            }
            return this.hlov == that.hlov;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                result = 31 * result + this.hla1;
                result = 31 * result + this.hlo1;
                result = 31 * result + this.hlov;
                result = 31 * result + this.hlad;
                result = 31 * result + this.hdX;
                result = 31 * result + this.hdY;
                result = 31 * result + this.hlatin1;
                this.hashCode = result = 31 * result + this.hlatin2;
            }
            return this.hashCode;
        }

        private static int round(int a) {
            return (a + 5) / 10;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            ProjectionImpl proj = null;
            Earth earth = this.getEarth();
            proj = earth.isSpherical() ? new ucar.unidata.geoloc.projection.LambertConformal(this.latin1, this.lov, this.latin1, this.latin2, 0.0, 0.0, earth.getEquatorRadius() * 0.001) : new LambertConformalConicEllipse(this.latin1, this.lov, this.latin1, this.latin2, 0.0, 0.0, earth);
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj(startLL);
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, start.getX(), this.dX, start.getY(), this.dY, this.nx, this.ny);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            f.format("%s testProjection %s%n", this.getClass().getName(), cs.proj.getClass().getName());
            double endx = cs.startx + (double)(this.nx - 1) * cs.dx;
            double endy = cs.starty + (double)(this.ny - 1) * cs.dy;
            ProjectionPointImpl endPP = new ProjectionPointImpl(endx, endy);
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            LatLonPoint endLL = cs.proj.projToLatLon(endPP, new LatLonPointImpl());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
        }
    }

    public static class PolarStereographic
    extends Grib2Gds {
        public float la1 = (float)this.getOctet4(39) * 1.0E-6f;
        public float lo1 = (float)this.getOctet4(43) * 1.0E-6f;
        public float lov;
        public float lad;
        public float dX;
        public float dY;
        public int flags = this.getOctet(47);
        public int projCenterFlag;

        PolarStereographic(byte[] data) {
            super(data, 20);
            this.lad = (float)this.getOctet4(48) * 1.0E-6f;
            this.lov = (float)this.getOctet4(52) * 1.0E-6f;
            this.dX = (float)this.getOctet4(56) * 1.0E-6f;
            this.dY = (float)this.getOctet4(60) * 1.0E-6f;
            this.projCenterFlag = this.getOctet(64);
            this.scanMode = this.getOctet(65);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PolarStereographic that = (PolarStereographic)o;
            if (Float.compare(that.dX, this.dX) != 0) {
                return false;
            }
            if (Float.compare(that.dY, this.dY) != 0) {
                return false;
            }
            if (Float.compare(that.la1, this.la1) != 0) {
                return false;
            }
            if (Float.compare(that.lad, this.lad) != 0) {
                return false;
            }
            if (Float.compare(that.lo1, this.lo1) != 0) {
                return false;
            }
            if (Float.compare(that.lov, this.lov) != 0) {
                return false;
            }
            return this.projCenterFlag == that.projCenterFlag;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                result = 31 * result + (this.la1 != 0.0f ? Float.floatToIntBits(this.la1) : 0);
                result = 31 * result + (this.lo1 != 0.0f ? Float.floatToIntBits(this.lo1) : 0);
                result = 31 * result + (this.lov != 0.0f ? Float.floatToIntBits(this.lov) : 0);
                result = 31 * result + (this.lad != 0.0f ? Float.floatToIntBits(this.lad) : 0);
                result = 31 * result + (this.dX != 0.0f ? Float.floatToIntBits(this.dX) : 0);
                result = 31 * result + (this.dY != 0.0f ? Float.floatToIntBits(this.dY) : 0);
                this.hashCode = result = 31 * result + this.projCenterFlag;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            boolean northPole = (this.projCenterFlag & 0x80) == 0;
            double latOrigin = northPole ? 90.0 : -90.0;
            double scale = Double.isNaN(this.lad) ? 0.9330127018922193 : (1.0 + Math.sin(Math.toRadians(Math.abs(Math.abs(this.lad))))) / 2.0;
            ProjectionImpl proj = null;
            Earth earth = this.getEarth();
            proj = earth.isSpherical() ? new Stereographic(latOrigin, this.lov, scale) : new StereographicAzimuthalProjection(latOrigin, this.lov, scale, this.lad, 0.0, 0.0, earth);
            ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj(new LatLonPointImpl(this.la1, this.lo1));
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, start.getX(), this.dX, start.getY(), this.dY, this.nx, this.ny);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            f.format("%s testProjection %s%n", this.getClass().getName(), cs.proj.getClass().getName());
            double endx = cs.startx + (double)(this.nx - 1) * cs.dx;
            double endy = cs.starty + (double)(this.ny - 1) * cs.dy;
            ProjectionPointImpl endPP = new ProjectionPointImpl(endx, endy);
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            LatLonPoint endLL = cs.proj.projToLatLon(endPP, new LatLonPointImpl());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
        }
    }

    public static class Mercator
    extends Grib2Gds {
        public float la1 = (float)this.getOctet4(39) * 1.0E-6f;
        public float lo1 = (float)this.getOctet4(43) * 1.0E-6f;
        public float la2;
        public float lo2;
        public float lad;
        public float orient;
        public float dX;
        public float dY;
        public int flags = this.getOctet(47);
        protected int lastOctet;

        Mercator(byte[] data) {
            super(data, 10);
            this.lad = (float)this.getOctet4(48) * 1.0E-6f;
            this.la2 = (float)this.getOctet4(52) * 1.0E-6f;
            this.lo2 = (float)this.getOctet4(56) * 1.0E-6f;
            this.scanMode = this.getOctet(60);
            this.orient = (float)this.getOctet4(61) * 1.0E-6f;
            this.dX = (float)this.getOctet4(65) * 1.0E-6f;
            this.dY = (float)this.getOctet4(69) * 1.0E-6f;
            this.lastOctet = 73;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Mercator mercator = (Mercator)o;
            if (Float.compare(mercator.dX, this.dX) != 0) {
                return false;
            }
            if (Float.compare(mercator.dY, this.dY) != 0) {
                return false;
            }
            if (Float.compare(mercator.la1, this.la1) != 0) {
                return false;
            }
            if (Float.compare(mercator.lad, this.lad) != 0) {
                return false;
            }
            return Float.compare(mercator.lo1, this.lo1) == 0;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                result = 31 * result + (this.la1 != 0.0f ? Float.floatToIntBits(this.la1) : 0);
                result = 31 * result + (this.lo1 != 0.0f ? Float.floatToIntBits(this.lo1) : 0);
                result = 31 * result + (this.lad != 0.0f ? Float.floatToIntBits(this.lad) : 0);
                result = 31 * result + (this.dX != 0.0f ? Float.floatToIntBits(this.dX) : 0);
                this.hashCode = result = 31 * result + (this.dY != 0.0f ? Float.floatToIntBits(this.dY) : 0);
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            Earth earth = this.getEarth();
            ucar.unidata.geoloc.projection.Mercator proj = new ucar.unidata.geoloc.projection.Mercator(this.lo1, this.lad, 0.0, 0.0, earth.getEquatorRadius() * 0.001);
            ProjectionPoint startP = proj.latLonToProj(new LatLonPointImpl(this.la1, this.lo1));
            double startx = startP.getX();
            double starty = startP.getY();
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, startx, this.dX, starty, this.dY, this.nx, this.ny);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            double Lo2 = this.lo2;
            if (Lo2 < (double)this.lo1) {
                Lo2 += 360.0;
            }
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            LatLonPointImpl endLL = new LatLonPointImpl(this.la2, this.lo2);
            f.format("%s testProjection%n", this.getClass().getName());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)cs.proj.latLonToProj(endLL, new ProjectionPointImpl());
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            double endx = cs.startx + (double)(this.nx - 1) * cs.dx;
            double endy = cs.starty + (double)(this.ny - 1) * cs.dy;
            f.format("   should end at x= (%f,%f)%n", endx, endy);
        }
    }

    public static class RotatedLatLon
    extends LatLon {
        public float latSouthPole;
        public float lonSouthPole;
        public float angleRotation;

        RotatedLatLon(byte[] data) {
            super(data);
            this.template = 1;
            float scale = this.getScale();
            this.latSouthPole = (float)this.getOctet4(73) * scale;
            this.lonSouthPole = (float)this.getOctet4(77) * scale;
            this.angleRotation = (float)this.getOctet4(81) * scale;
            this.lastOctet = 85;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RotatedLatLon other = (RotatedLatLon)o;
            return Misc.closeEnough(this.angleRotation, other.angleRotation);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                this.hashCode = result = 31 * result + (this.angleRotation != 0.0f ? Float.floatToIntBits(this.angleRotation) : 0);
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            ucar.unidata.geoloc.projection.RotatedLatLon proj = new ucar.unidata.geoloc.projection.RotatedLatLon(this.latSouthPole, this.lonSouthPole, this.angleRotation);
            return new GdsHorizCoordSys(this.getNameShort(), this.template, 0, this.scanMode, proj, this.lo1, this.deltaLon, this.la1, this.deltaLat, this.nx, this.ny);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            LatLonPoint startLL = cs.proj.projToLatLon(new ProjectionPointImpl(this.lo1, this.la1));
            LatLonPoint endLL = cs.proj.projToLatLon(new ProjectionPointImpl(this.lo2, this.la2));
            f.format("%s testProjection%n", this.getClass().getName());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)cs.proj.latLonToProj(endLL, new ProjectionPointImpl());
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            double endx = cs.startx + (double)(this.nx - 1) * cs.dx;
            double endy = cs.starty + (double)(this.ny - 1) * cs.dy;
            f.format("   should end at x= (%f,%f)%n", endx, endy);
        }
    }

    public static class LatLon
    extends Grib2Gds {
        public float la1;
        public float lo1;
        public float la2;
        public float lo2;
        public float deltaLon;
        public float deltaLat;
        public int basicAngle = this.getOctet4(39);
        public int basicAngleSubdivisions = this.getOctet4(43);
        public int flags;
        protected int lastOctet;

        LatLon(byte[] data) {
            super(data, 0);
            float scale = this.getScale();
            this.la1 = (float)this.getOctet4(47) * scale;
            this.lo1 = (float)this.getOctet4(51) * scale;
            this.flags = this.getOctet(55);
            this.la2 = (float)this.getOctet4(56) * scale;
            this.lo2 = (float)this.getOctet4(60) * scale;
            if (this.lo2 < this.lo1) {
                this.lo2 += 360.0f;
            }
            if (Misc.closeEnough(this.lo1, this.lo2)) {
                this.lo1 -= 360.0f;
            }
            this.deltaLon = (float)this.getOctet4(64) * scale;
            float calcDelta = (this.lo2 - this.lo1) / (float)(this.nx - 1);
            if (!Misc.closeEnough(this.deltaLon, calcDelta)) {
                log.debug("deltaLon {} != calcDeltaLon {}", Float.valueOf(this.deltaLon), (Object)Float.valueOf(calcDelta));
                this.deltaLon = calcDelta;
            }
            this.deltaLat = (float)this.getOctet4(68) * scale;
            if (this.la2 < this.la1) {
                this.deltaLat = -this.deltaLat;
            }
            if (!Misc.closeEnough(this.deltaLat, calcDelta = (this.la2 - this.la1) / (float)(this.ny - 1))) {
                log.debug("deltaLat {} != calcDeltaLat {}", Float.valueOf(this.deltaLat), (Object)Float.valueOf(calcDelta));
                this.deltaLat = calcDelta;
            }
            this.scanMode = this.getOctet(72);
            this.lastOctet = 73;
        }

        @Override
        public boolean isLatLon() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LatLon other = (LatLon)o;
            if (!Misc.closeEnough(this.la1, other.la1)) {
                return false;
            }
            if (!Misc.closeEnough(this.lo1, other.lo1)) {
                return false;
            }
            if (!Misc.closeEnough(this.deltaLat, other.deltaLat)) {
                return false;
            }
            return Misc.closeEnough(this.deltaLon, other.deltaLon);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                result = 31 * result + (this.la1 != 0.0f ? Float.floatToIntBits(this.la1) : 0);
                result = 31 * result + (this.lo1 != 0.0f ? Float.floatToIntBits(this.lo1) : 0);
                result = 31 * result + (this.deltaLon != 0.0f ? Float.floatToIntBits(this.deltaLon) : 0);
                this.hashCode = result = 31 * result + (this.deltaLat != 0.0f ? Float.floatToIntBits(this.deltaLat) : 0);
            }
            return this.hashCode;
        }

        protected float getScale() {
            if (this.basicAngle == 0 || this.basicAngle == -9999 || this.basicAngleSubdivisions == -9999) {
                return 1.0E-6f;
            }
            return (float)this.basicAngle / (float)this.basicAngleSubdivisions;
        }

        public int[] getOptionalPoints() {
            int[] optionalPoints = null;
            int n = this.getOctet(11);
            if (n > 0) {
                optionalPoints = new int[n / 4];
                for (int i = 0; i < optionalPoints.length; ++i) {
                    optionalPoints[i] = this.getOctet4(this.lastOctet + 4 * n);
                }
            }
            return optionalPoints;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            LatLonProjection proj = new LatLonProjection();
            ProjectionPoint startP = proj.latLonToProj(new LatLonPointImpl(this.la1, this.lo1));
            double startx = startP.getX();
            double starty = startP.getY();
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, startx, this.deltaLon, starty, this.deltaLat, this.nx, this.ny);
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            double Lo2 = this.lo2;
            if (Lo2 < (double)this.lo1) {
                Lo2 += 360.0;
            }
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            LatLonPointImpl endLL = new LatLonPointImpl(this.la2, this.lo2);
            f.format("%s testProjection%n", this.getClass().getName());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)cs.proj.latLonToProj(endLL, new ProjectionPointImpl());
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            double endx = cs.startx + (double)(this.nx - 1) * cs.dx;
            double endy = cs.starty + (double)(this.ny - 1) * cs.dy;
            f.format("   should end at x= (%f,%f)%n", endx, endy);
        }
    }
}

