/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.tables.CodeFlagTables;

public class TableA {
    private static Logger log = LoggerFactory.getLogger(TableA.class);
    private static Map<Integer, String> tableA = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        String filename = "/resources/bufrTables/wmo/BUFR_16_0_0_TableA_E.xml";
        InputStream is = CodeFlagTables.class.getResourceAsStream(filename);
        HashMap<Integer, String> map = new HashMap<Integer, String>(100);
        try {
            SAXBuilder builder = new SAXBuilder();
            Document tdoc = builder.build(is);
            Element root = tdoc.getRootElement();
            List elems = root.getChildren("Exp_BUFRTableA_E");
            for (Element elem : elems) {
                String line = elem.getChildText("No");
                String codeS = elem.getChildText("CodeFigure");
                String desc = elem.getChildText("Meaning_E");
                try {
                    int code = Integer.parseInt(codeS);
                    map.put(code, desc);
                }
                catch (NumberFormatException e) {
                    log.debug("NumberFormatException on line " + line + " in " + codeS);
                }
            }
            tableA = map;
        }
        catch (Exception e) {
            log.error("Can't read BUFR code table " + filename, e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getDataCategory(int cat) {
        String result;
        if (tableA == null) {
            TableA.init();
        }
        return (result = tableA.get(cat)) != null ? result : "Unknown category=" + cat;
    }
}

